/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TCPSAddress
extends Address {
    public static String TCPS_PROTOCOL = "TCPS";

    protected TCPSAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(TCPS_PROTOCOL)) {
            throw new CreateAddressException("TCPS: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(TCPS_PROTOCOL);
        String host = Address._getParameter(nvp, "HOST");
        if (host == null) {
            throw new CreateAddressException("TCPS: The value for the HOST is missing.");
        }
        this.setHost(host);
        String sport = Address._getParameter(nvp, "PORT");
        if (sport == null) {
            throw new CreateAddressException("TCPS: The value for PORT is missing.");
        }
        try {
            this.setPort(Integer.valueOf(sport));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("TCPS: The value for PORT (" + sport + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String sport = this._getParameter("PORT");
        return Integer.valueOf(sport);
    }

    public void setHost(String host) {
        TCPSAddress._validateHost(host);
        this._setParameter("HOST", host);
    }

    public void setPort(int port) {
        TCPSAddress._validatePort(port);
        this._setParameter("PORT", String.valueOf(port));
    }

    private static void _validateHost(String host) {
    }

    private static void _validatePort(int port) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        TCPSAddress TCPSaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        TCPSAddress._print("Verifying constructor TCPSAddress(nvp)");
        TCPSAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=TCPS)(HOST=WINTER)(PORT=1521))";
            TCPSAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      Result: " + TCPSaddr.toNVString());
            addr = "(Address = (Host = summer) (Port = 1526) (Protocol = TCPS))";
            TCPSAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      Result: " + TCPSaddr.toNVString());
            addr = "(address = (protocol = TCPS) (port = 5000) (host = spring))";
            TCPSAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      Result: " + TCPSaddr.toNVString());
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        TCPSAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (host=winter)(port=1521))";
            TCPSAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx)(service = winter_lsnr))";
            TCPSAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=TCPS)(port=1521))";
            TCPSAddress._print("    Case 3: Missing host: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=TCPS)(host=summer))";
            TCPSAddress._print("    Case 4: Missing port: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=TCPS)(host=summer)(port=1521)";
            TCPSAddress._print("    Case 5: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=TCPS)(host=summer)(port=foo))";
            TCPSAddress._print("    Case 6: Invalid port: " + addr);
            nvp = factory.createNVPair(addr);
            TCPSaddr = new TCPSAddress(nvp);
            TCPSAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPSAddress._print("      Exception Received: " + e.getMessage());
        }
    }
}

