/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import java.util.Vector;
import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.AddressFactory;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.AttributeException;
import oracle.net.asst.addrbook.AttributeList;
import oracle.net.nl.NVPair;

public final class AddressList {
    private Vector addrVector;
    private Vector addrListVector;
    private AddressFactory addressFactory;
    private NVPair originalNVP;
    private String nestLevel;
    private boolean dLevelSOURCE_ROUTE;
    private boolean backCompat;
    private int aCount;
    private int aListCount;
    private AttributeList attribList;

    public AddressList(NVPair nvp) throws CreateAddressException {
        this(nvp, "TOP");
    }

    private AddressList(NVPair nvp, String nestLevel) throws CreateAddressException {
        try {
            int i;
            this.originalNVP = nvp;
            this.nestLevel = nestLevel;
            this.attribList = new AttributeList();
            this.addrVector = new Vector(5, 5);
            this.addrListVector = new Vector(5, 5);
            this.addressFactory = AddressFactory.getFactory();
            this.validatePair(nvp);
            NVPair pair = null;
            String paramName = null;
            if (nestLevel.equalsIgnoreCase("TOP")) {
                i = 0;
                while (i < nvp.getListSize()) {
                    pair = nvp.getListElement(i);
                    paramName = pair.getName().toUpperCase();
                    if (paramName.equals("ADDRESS")) {
                        ++this.aCount;
                    } else if (paramName.equals("ADDRESS_LIST")) {
                        ++this.aListCount;
                    }
                    ++i;
                }
                if (this.aListCount == 1 && this.aCount == 0) {
                    this.dLevelSOURCE_ROUTE = this.attribList.findPair(nvp, "SOURCE_ROUTE") != null;
                    if (this.attribList.findPair(nvp = this.attribList.findPair(nvp, "ADDRESS_LIST"), "SOURCE_ROUTE") != null) {
                        this.dLevelSOURCE_ROUTE = false;
                    }
                }
            }
            i = 0;
            while (i < nvp.getListSize()) {
                pair = nvp.getListElement(i);
                paramName = pair.getName().toUpperCase();
                if (paramName.equals("ADDRESS")) {
                    this.addrVector.addElement(this.addressFactory.createAddress(pair));
                } else if (paramName.equals("ADDRESS_LIST")) {
                    this.addrListVector.addElement(new AddressList(pair, "NESTED"));
                }
                ++i;
            }
            NVPair findpair = this.attribList.findPair(nvp, "FAILOVER");
            if (findpair != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "LOAD_BALANCE")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.dLevelSOURCE_ROUTE ? this.attribList.findPair(this.originalNVP, "SOURCE_ROUTE") : this.attribList.findPair(nvp, "SOURCE_ROUTE")) != null) {
                this.attribList.addAttrib(findpair);
            }
            findpair = null;
            this.backCompat = this.checkBackCompat();
        }
        catch (AttributeException e) {
            throw new CreateAddressException("AddressList.<init>: Unable to create addressList." + e);
        }
    }

    public String toNVString() {
        StringBuffer buf = new StringBuffer();
        Object tmpFO = null;
        Object tmpLB = null;
        if (this.isBackCompat()) {
            try {
                if (this.isSupported() && this.nestLevel.equals("TOP") && this.attribList.contains("SOURCE_ROUTE")) {
                    buf.append(this.attribList.toNVString("SOURCE_ROUTE"));
                }
                buf.append("(ADDRESS_LIST=");
                int i = this.addrVector.size() - 1;
                while (i >= 0) {
                    buf.append(((Address)this.addrVector.elementAt(i)).toNVString());
                    --i;
                }
                buf.append(")");
            }
            catch (AttributeException e) {
                System.err.println(e);
            }
        } else {
            buf.append("(ADDRESS_LIST=");
            try {
                if (this.attribList.contains("SOURCE_ROUTE")) {
                    buf.append(this.attribList.toNVString("SOURCE_ROUTE"));
                }
                if (this.attribList.contains("LOAD_BALANCE")) {
                    buf.append(this.attribList.toNVString("LOAD_BALANCE"));
                }
                if (this.attribList.contains("FAILOVER")) {
                    buf.append(this.attribList.toNVString("FAILOVER"));
                }
            }
            catch (AttributeException e) {
                System.err.println(e);
            }
            int i = this.addrVector.size() - 1;
            while (i >= 0) {
                buf.append(((Address)this.addrVector.elementAt(i)).toNVString());
                --i;
            }
            int i2 = this.addrListVector.size() - 1;
            while (i2 >= 0) {
                buf.append(((AddressList)this.addrListVector.elementAt(i2)).toNVString());
                --i2;
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public boolean isBackCompat() {
        return this.backCompat;
    }

    public void setBackCompat(boolean bc) {
        this.backCompat = bc;
        int i = this.addrListVector.size() - 1;
        while (i >= 0) {
            ((AddressList)this.addrListVector.elementAt(i)).setBackCompat(bc);
            --i;
        }
    }

    public void setSOURCE_ROUTE(String val) throws AttributeException {
        if (this.attribList.contains("SOURCE_ROUTE")) {
            this.attribList.setValue("SOURCE_ROUTE", val);
        } else {
            this.attribList.addAttrib("SOURCE_ROUTE", val);
        }
    }

    public String getSOURCE_ROUTE() {
        try {
            return this.attribList.getValue("SOURCE_ROUTE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setLOAD_BALANCE(String val) throws AttributeException {
        if (this.attribList.contains("LOAD_BALANCE")) {
            this.attribList.setValue("LOAD_BALANCE", val);
        } else {
            this.attribList.addAttrib("LOAD_BALANCE", val);
        }
    }

    public String getLOAD_BALANCE() {
        try {
            return this.attribList.getValue("LOAD_BALANCE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setFAILOVER(String val) throws AttributeException {
        if (this.attribList.contains("FAILOVER")) {
            this.attribList.setValue("FAILOVER", val);
        } else {
            this.attribList.addAttrib("FAILOVER", val);
        }
    }

    public String getFAILOVER() {
        try {
            return this.attribList.getValue("FAILOVER");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public boolean isSupported() {
        if (this.addrVector.size() > 0 && this.addrListVector.size() == 0) {
            return true;
        }
        if (this.addrListVector.size() == 1 && this.addrVector.size() == 0) {
            return ((AddressList)this.addrListVector.elementAt(0)).isSupported();
        }
        return false;
    }

    public int getNumAddresses() {
        return this.addrVector.size();
    }

    public int getNumAddressLists() {
        return this.addrListVector.size();
    }

    public Address getAddressAt(int pos) {
        if (pos > this.addrVector.size() - 1 || pos < 0) {
            throw new IllegalArgumentException("AddressList.getAddressAt(): pos (" + pos + ") is out of range.");
        }
        return (Address)this.addrVector.elementAt(pos);
    }

    public AddressList getAddressListAt(int pos) {
        if (pos > this.addrListVector.size() - 1 || pos < 0) {
            throw new IllegalArgumentException("AddressList.getAdddressAT(): pos (" + pos + ") is out of range.");
        }
        return (AddressList)this.addrListVector.elementAt(pos);
    }

    public void insertAddressListAt(AddressList addrList, int index) {
        if (addrList == null) {
            throw new IllegalArgumentException("AddressList.insertAddressListAt(): addrList to be added is null.");
        }
        this.addrListVector.insertElementAt(addrList, index);
    }

    public void insertAddressAt(Address addr, int index) {
        if (addr == null) {
            throw new IllegalArgumentException("AddressList.insertAddressAt(): addr to be added is null.");
        }
        this.addrVector.insertElementAt(addr, index);
    }

    public void addAddressList(AddressList addrList) {
        if (addrList == null) {
            throw new IllegalArgumentException("AddressList.addAddressList(): addrList to be added is null.");
        }
        this.addrListVector.addElement(addrList);
    }

    public void addAddress(Address addr) {
        if (addr == null) {
            throw new IllegalArgumentException("AddressList.addAddress(): addr to be added is null.");
        }
        this.addrVector.addElement(addr);
    }

    public void removeAddress(Address addr) {
        if (this.addrVector.contains(addr)) {
            this.addrVector.removeElement(addr);
        }
    }

    public void removeAddressList(AddressList addrList) {
        if (this.addrListVector.contains(addrList)) {
            this.addrListVector.removeElement(addrList);
        }
    }

    public void removeAddressAt(int pos) {
        if (pos > this.addrVector.size() - 1 || pos < 0) {
            throw new IllegalArgumentException("AddressList.removeAddressAt(): pos (" + pos + ") is out of range.");
        }
        this.addrVector.removeElementAt(pos);
    }

    public void removeAddressListAt(int pos) {
        if (pos > this.addrListVector.size() - 1 || pos < 0) {
            throw new IllegalArgumentException("AddressList.removeAddressListAt(): pos (" + pos + ") is out of range.");
        }
        this.addrListVector.removeElementAt(pos);
    }

    public void removeAllAddresses() {
        this.addrVector.removeAllElements();
    }

    public void removeAllAddressLists() {
        this.addrListVector.removeAllElements();
    }

    public void removeAllAttributes() {
        this.attribList.removeAllAttribs();
    }

    private boolean checkBackCompat() {
        if (!this.isSupported()) {
            return false;
        }
        if (this.attribList.contains("FAILOVER") || this.attribList.contains("LOAD_BALANCE")) {
            return false;
        }
        return this.dLevelSOURCE_ROUTE || !this.attribList.contains("SOURCE_ROUTE");
    }

    private void validatePair(NVPair nvp) throws CreateAddressException {
        if (this.attribList.findPair(nvp, "ADDRESS") == null && this.attribList.findPair(nvp, "ADDRESS_LIST") == null) {
            throw new CreateAddressException("AddressList.validatePair(): No ADDRESS information found.");
        }
    }
}

