/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.net.asst.addrbook.AttributeException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AttributeList {
    private NVNavigator nvnavigator = new NVNavigator();
    private NVFactory nvfactory = new NVFactory();
    private Hashtable table;

    public AttributeList() {
        this.nvnavigator = new NVNavigator();
        this.table = new Hashtable(10, 0.75f);
    }

    public boolean contains(String name) {
        return this.table.containsKey(name.toUpperCase());
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return this.table.size();
    }

    public Enumeration enumerate() {
        return this.table.keys();
    }

    public void addAttrib(String name, String val) throws AttributeException {
        if (name.equals("") || name == null || val == null) {
            throw new AttributeException("AttributeList.addAttrib: Null name or value");
        }
        try {
            this.table.put(name.toUpperCase(), val);
        }
        catch (Exception exception) {}
    }

    public void addAttrib(NVPair pair) throws AttributeException {
        try {
            this.addAttrib(pair.getName().toUpperCase(), pair.getAtom());
        }
        catch (Exception e) {
            throw new AttributeException("AttributeList.addAttrib(nvpair): invalid pair." + e);
        }
    }

    public void removeAttrib(String name) {
        this.table.remove(name.toUpperCase());
    }

    public void removeAllAttribs() {
        this.table.clear();
    }

    public void setValue(String name, String val) throws AttributeException {
        if (!this.table.containsKey(name.toUpperCase())) {
            throw new AttributeException("AttributeList.setValue(): attrib not found.");
        }
        this.table.put(name.toUpperCase(), val);
    }

    public String getValue(String name) throws AttributeException {
        Object val = this.table.get(name.toUpperCase());
        if (val == null) {
            throw new AttributeException("AttributeList.getValue(): attrib not found.");
        }
        return (String)val;
    }

    public String toString() {
        return "AttributeList: " + this.table.toString();
    }

    public String toNVString(String name) throws AttributeException {
        return "(" + name.toUpperCase() + "=" + this.getValue(name) + ")";
    }

    public NVPair findPair(NVPair parent, String name) {
        try {
            return this.nvnavigator.findNVPair(parent, name);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

