/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.AttributeException;
import oracle.net.asst.addrbook.AttributeList;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class ConnectData {
    private String cdataRemainder;
    private boolean supported = true;
    private boolean backCompat = false;
    private AttributeList attribList = new AttributeList();
    private NVNavigator nvnavigator = new NVNavigator();

    public ConnectData(NVPair nvp) throws CreateAddressException {
        nvp = this.attribList.findPair(nvp, "CONNECT_DATA");
        if (nvp == null) {
            throw new CreateAddressException("ConnectData.ConnectData(): No Connect_Data information found.");
        }
        this.validatePair(nvp);
        try {
            NVPair findpair = this.attribList.findPair(nvp, "INSTANCE_NAME");
            if (findpair != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "HANDLER_NAME")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "RDB_DATABASE")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "ORACLE_HOME")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "GLOBAL_NAME")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "SRVR")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "SDU")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "SERVICE_NAME")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "SID")) != null) {
                this.attribList.addAttrib(findpair);
            }
        }
        catch (AttributeException e) {
            throw new CreateAddressException("AddressList.<init>: Unable to create addressList." + e);
        }
        this.cdataRemainder = this.readAdditionalConnectData(nvp);
        this.backCompat = this.checkBackCompat();
    }

    public boolean isBackCompat() {
        return this.backCompat;
    }

    public void setBackCompat(boolean bc) {
        this.backCompat = bc;
    }

    public String toNVString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(CONNECT_DATA=");
        try {
            if (this.backCompat || !this.isSupported()) {
                if (this.attribList.contains("SID")) {
                    buf.append(this.attribList.toNVString("SID"));
                }
            } else {
                if (this.attribList.contains("SERVICE_NAME")) {
                    buf.append(this.attribList.toNVString("SERVICE_NAME"));
                }
                if (this.attribList.contains("HANDLER_NAME")) {
                    buf.append(this.attribList.toNVString("HANDLER_NAME"));
                }
                if (this.attribList.contains("INSTANCE_NAME")) {
                    buf.append(this.attribList.toNVString("INSTANCE_NAME"));
                }
            }
            if (this.attribList.contains("GLOBAL_NAME")) {
                buf.append(this.attribList.toNVString("GLOBAL_NAME"));
            }
            if (this.attribList.contains("ORACLE_HOME")) {
                buf.append(this.attribList.toNVString("ORACLE_HOME"));
            }
            if (this.attribList.contains("RDB_DATABASE")) {
                buf.append(this.attribList.toNVString("RDB_DATABASE"));
            }
            if (this.attribList.contains("SRVR")) {
                buf.append(this.attribList.toNVString("SRVR"));
            }
            if (this.attribList.contains("SDU")) {
                buf.append(this.attribList.toNVString("SDU"));
            }
        }
        catch (AttributeException e) {
            System.err.println(e);
        }
        buf.append(this.cdataRemainder);
        buf.append(")");
        return buf.toString();
    }

    public void setSID(String val) throws AttributeException {
        if (this.attribList.contains("SID")) {
            this.attribList.setValue("SID", val);
        } else {
            this.attribList.addAttrib("SID", val);
        }
    }

    public String getSID() {
        try {
            return this.attribList.getValue("SID");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setSDU(String val) throws AttributeException {
        if (this.attribList.contains("SDU")) {
            this.attribList.setValue("SDU", val);
        } else {
            this.attribList.addAttrib("SDU", val);
        }
    }

    public String getSDU() {
        try {
            return this.attribList.getValue("SDU");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setSRVR(String val) throws AttributeException {
        if (this.attribList.contains("SRVR")) {
            this.attribList.setValue("SRVR", val);
        } else {
            this.attribList.addAttrib("SRVR", val);
        }
    }

    public String getSRVR() {
        try {
            return this.attribList.getValue("SRVR");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setSERVICE_NAME(String val) throws AttributeException {
        if (this.attribList.contains("SERVICE_NAME")) {
            this.attribList.setValue("SERVICE_NAME", val);
        } else {
            this.attribList.addAttrib("SERVICE_NAME", val);
        }
    }

    public String getSERVICE_NAME() {
        try {
            return this.attribList.getValue("SERVICE_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setINSTANCE_NAME(String val) throws AttributeException {
        if (this.attribList.contains("INSTANCE_NAME")) {
            this.attribList.setValue("INSTANCE_NAME", val);
        } else {
            this.attribList.addAttrib("INSTANCE_NAME", val);
        }
    }

    public String getINSTANCE_NAME() {
        try {
            return this.attribList.getValue("INSTANCE_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setHANDLER_NAME(String val) throws AttributeException {
        if (this.attribList.contains("HANDLER_NAME")) {
            this.attribList.setValue("HANDLER_NAME", val);
        } else {
            this.attribList.addAttrib("HANDLER_NAME", val);
        }
    }

    public String getHANDLER_NAME() {
        try {
            return this.attribList.getValue("HANDLER_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setRDB_DATABASE(String val) throws AttributeException {
        if (this.attribList.contains("RDB_DATABASE")) {
            this.attribList.setValue("RDB_DATABASE", val);
        } else {
            this.attribList.addAttrib("RDB_DATABASE", val);
        }
    }

    public String getRDB_DATABASE() {
        try {
            return this.attribList.getValue("RDB_DATABASE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setORACLE_HOME(String val) throws AttributeException {
        if (this.attribList.contains("ORACLE_HOME")) {
            this.attribList.setValue("ORACLE_HOME", val);
        } else {
            this.attribList.addAttrib("ORACLE_HOME", val);
        }
    }

    public String getORACLE_HOME() {
        try {
            return this.attribList.getValue("ORACLE_HOME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setGLOBAL_NAME(String val) throws AttributeException {
        if (this.attribList.contains("GLOBAL_NAME")) {
            this.attribList.setValue("GLOBAL_NAME", val);
        } else {
            this.attribList.addAttrib("GLOBAL_NAME", val);
        }
    }

    public String getGLOBAL_NAME() {
        try {
            return this.attribList.getValue("GLOBAL_NAME");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    private boolean checkBackCompat() {
        if (this.attribList.contains("SID")) {
            if (this.attribList.contains("SERVICE_NAME")) {
                this.supported = false;
                return false;
            }
            return true;
        }
        return false;
    }

    private void validatePair(NVPair nvp) throws CreateAddressException {
        if (this.attribList.findPair(nvp, "SID") == null && this.attribList.findPair(nvp, "SERVICE_NAME") == null) {
            throw new CreateAddressException("ConnectData.validatePair(): No SID or SERVICE_NAME information in CONNECT_DATA");
        }
    }

    private String readAdditionalConnectData(NVPair nvp) {
        String _cdata = "";
        int i = 0;
        while (i < nvp.getListSize()) {
            NVPair cdata_param = nvp.getListElement(i);
            String paramName = cdata_param.getName().toUpperCase();
            if (!(paramName.equals("SID") || paramName.equals("SERVICE_NAME") || paramName.equals("HANDLER_NAME") || paramName.equals("INSTANCE_NAME") || paramName.equals("GLOBAL_NAME") || paramName.equals("ORACLE_HOME") || paramName.equals("RDB_DATABASE") || paramName.equals("SRVR") || paramName.equals("SDU"))) {
                _cdata = String.valueOf(_cdata) + cdata_param.toString();
            }
            ++i;
        }
        return _cdata;
    }
}

