/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import java.util.Vector;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.Description;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class DList {
    private NVNavigator nvnavigator = new NVNavigator();
    private Vector descVector = new Vector(2, 2);

    public DList(NVPair nvp) throws CreateAddressException {
        this.validatePair(nvp);
        NVPair nvp_dlist = this.nvnavigator.findNVPair(nvp, "Description_List");
        if (nvp_dlist == null) {
            nvp_dlist = nvp;
        }
        boolean desc_found = false;
        int len = nvp_dlist.getListSize();
        int i = 0;
        while (i < len) {
            NVPair nvp_desc = nvp_dlist.getListElement(i);
            if (nvp_desc.getName().equalsIgnoreCase("DESCRIPTION")) {
                this.descVector.addElement(new Description(nvp_desc));
                desc_found = true;
            }
            ++i;
        }
        if (!desc_found) {
            throw new CreateAddressException("DList.DList(): No DESCRIPTION in TNSAddress");
        }
    }

    public int getListSize() {
        return this.descVector.size();
    }

    public Description getElementAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.getListSize() || index < 0) {
            throw new IndexOutOfBoundsException("DList.getElementAt: Invalid index.");
        }
        return (Description)this.descVector.elementAt(index);
    }

    public void removeListElement(Description element) {
        if (this.descVector.contains(element)) {
            this.descVector.removeElement(element);
        }
    }

    public void addListElement(Description element) {
        if (!this.descVector.contains(element)) {
            this.descVector.addElement(element);
        }
    }

    public boolean isSupported() {
        boolean supported = true;
        int len = this.descVector.size();
        if (len > 1) {
            supported = false;
        } else {
            int i = 0;
            while (i < len) {
                if (!((Description)this.descVector.elementAt(i)).isSupported()) {
                    supported = false;
                }
                ++i;
            }
        }
        return supported;
    }

    public String toNVString() {
        StringBuffer buf = new StringBuffer();
        int len = this.descVector.size();
        int i = 0;
        while (i < len) {
            buf.append(((Description)this.descVector.elementAt(i)).toNVString());
            ++i;
        }
        if (this.getListSize() > 1) {
            buf.insert(0, "(DESCRIPTION_LIST=");
            buf.append(")");
        }
        return buf.toString();
    }

    protected void validatePair(NVPair nvp) {
    }
}

