/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.AddressList;
import oracle.net.asst.addrbook.AttributeException;
import oracle.net.asst.addrbook.AttributeList;
import oracle.net.asst.addrbook.ConnectData;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public final class Description {
    private AddressList addressList;
    private ConnectData connectData;
    private NVNavigator nvnavigator = new NVNavigator();
    private AttributeList attribList = new AttributeList();

    public Description(NVPair nvp) throws CreateAddressException {
        this.validatePair(nvp);
        this.addressList = new AddressList(nvp);
        this.connectData = new ConnectData(nvp);
        try {
            NVPair findpair = this.attribList.findPair(nvp, "TYPE_OF_SERVICE");
            if (findpair != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "TDU")) != null) {
                this.attribList.addAttrib(findpair);
            }
            if ((findpair = this.attribList.findPair(nvp, "HS")) != null) {
                this.attribList.addAttrib(findpair);
                this.attribList.setValue("HS", "OK");
            }
        }
        catch (AttributeException e) {
            throw new CreateAddressException("AddressList.<init>: Unable to create addressList." + e);
        }
    }

    public boolean isBackCompat() {
        return true;
    }

    public boolean isSupported() {
        return this.addressList.isSupported() && this.connectData.isSupported();
    }

    public void setAddressList(AddressList al) {
        this.addressList = al;
    }

    public AddressList getAddressList() {
        return this.addressList;
    }

    public void setConnectData(ConnectData cd) {
        this.connectData = cd;
    }

    public ConnectData getConnectData() {
        return this.connectData;
    }

    public void setTDU(String val) throws AttributeException {
        if (this.attribList.contains("TDU")) {
            this.attribList.setValue("TDU", val);
        } else {
            this.attribList.addAttrib("TDU", val);
        }
    }

    public String getTDU() {
        try {
            return this.attribList.getValue("TDU");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setHService(String val) throws AttributeException {
        if (this.attribList.contains("HS")) {
            this.attribList.setValue("HS", val);
        } else {
            this.attribList.addAttrib("HS", val);
        }
    }

    public String getHService() {
        try {
            return this.attribList.getValue("HS");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public void setTYPE_OF_SERVICE(String val) throws AttributeException {
        if (this.attribList.contains("TYPE_OF_SERVICE")) {
            this.attribList.setValue("TYPE_OF_SERVICE", val);
        } else {
            this.attribList.addAttrib("TYPE_OF_SERVICE", val);
        }
    }

    public String getTYPE_OF_SERVICE() {
        try {
            return this.attribList.getValue("TYPE_OF_SERVICE");
        }
        catch (AttributeException attributeException) {
            return null;
        }
    }

    public String toNVString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(DESCRIPTION=");
        try {
            if (this.attribList.contains("TDU")) {
                buf.append(this.attribList.toNVString("TDU"));
            }
            if (this.attribList.contains("HS")) {
                buf.append(this.attribList.toNVString("HS"));
            }
            if (this.attribList.contains("TYPE_OF_SERVICE")) {
                buf.append(this.attribList.toNVString("TYPE_OF_SERVICE"));
            }
        }
        catch (AttributeException e) {
            System.err.println(e);
        }
        buf.append(this.addressList.toNVString());
        buf.append(this.connectData.toNVString());
        buf.append(")");
        return buf.toString();
    }

    private void validatePair(NVPair nvp) throws CreateAddressException {
        if (this.attribList.findPair(nvp, "Address") == null && this.attribList.findPair(nvp, "Address_List") == null) {
            throw new CreateAddressException("Description.Description(): No Address information in Description");
        }
        if (this.attribList.findPair(nvp, "Connect_Data") == null) {
            throw new CreateAddressException("Description.Description(): No Connect_Data information in Description");
        }
    }
}

