/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.DList;
import oracle.net.asst.addrbook.Description;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TNSAddress {
    protected NVFactory nvfactory = new NVFactory();
    protected NVPair nvp;
    protected DList dList;

    public TNSAddress(String nvString) throws CreateAddressException {
        this.nvp = this.nvfactory.createNVPair(nvString);
        if (this.nvp == null) {
            throw new IllegalArgumentException("TNSAddress.TNSAddress(): NVPair nvp is null. NVString: " + nvString);
        }
        if (this.nvp.getRHSType() != NVPair.RHS_LIST) {
            throw new CreateAddressException("The TNSAddress is missing the DESCRIPTION or DESCRIPTION_LIST section.");
        }
        this.dList = new DList(this.nvp);
    }

    public TNSAddress(String name, String sidOrService, Address addr, boolean backCompat) throws CreateAddressException {
        this("(" + name + "=" + "(DESCRIPTION=" + "(ADDRESS_LIST=" + addr.toString() + ")" + "(CONNECT_DATA=(" + (backCompat ? "SID=" : "SERVICE_NAME=") + sidOrService + ")" + ")" + ")" + ")");
    }

    public boolean isSupported() {
        return this.dList.isSupported();
    }

    public String getName() {
        return this.nvp.getName();
    }

    public void setName(String name) {
        this.nvp.setName(name);
    }

    public Description getDescription() {
        if (this.dList.getListSize() != 0) {
            try {
                return this.dList.getElementAt(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public String toFormattedString() {
        return this.nvfactory.createNVPair(this.toNVString()).toString(0, true);
    }

    public String toNVString() {
        return "(" + this.getName() + "=" + this.dList.toNVString() + ")";
    }

    public String toString() {
        return this.getName();
    }
}

