/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addrbook;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.TNSAddress;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TNSAddressBook {
    private static boolean DEBUG;
    private String _filename;
    private Vector _addrlist = new Vector(5, 5);
    private NLParamParser nlpa;

    public TNSAddressBook(String tns_filename) {
        this._filename = tns_filename;
    }

    public void readFile() throws FileNotFoundException, IOException {
        this.readFile(this._filename);
    }

    public void readFile(String tns_filename) throws FileNotFoundException, IOException {
        this._addrlist.removeAllElements();
        try {
            this.nlpa = new NLParamParser(tns_filename);
        }
        catch (IOException excep) {
            System.out.println("Check IO Exception: " + excep);
        }
        catch (NLException excep) {
            System.out.println("Check NL Exception: " + excep);
        }
        String[] nvstrings = this.nlpa.getNLPAllElements();
        int i = 0;
        while (i < nvstrings.length) {
            block6: {
                try {
                    this.addListElement(nvstrings[i]);
                }
                catch (CreateAddressException e) {
                    if (!DEBUG) break block6;
                    System.out.println("Exception : " + e + "\nFor NVString: " + nvstrings[i] + "\n");
                }
            }
            ++i;
        }
    }

    public boolean Comp_file_has_Comments() {
        return this.nlpa.fileHasComments();
    }

    public void writeFile() throws FileNotFoundException, IOException {
        this.writeFile(this._filename);
    }

    public void writeFile(String tns_filename) throws FileNotFoundException, IOException {
        int i = 0;
        while (i < this.getListSize()) {
            TNSAddress addr = this.getListElement(i);
            String stringified_addr = addr.toNVString();
            try {
                this.nlpa.addNLPListElement(stringified_addr);
            }
            catch (NLException excep) {
                System.out.println("Error in NV String: " + excep);
            }
            ++i;
        }
        this.nlpa.saveNLParams(tns_filename);
    }

    public String getFilename() {
        return this._filename;
    }

    public int getListSize() {
        return this._addrlist.size();
    }

    public TNSAddress getAddress(String name) {
        boolean found = false;
        int len = this.getListSize();
        int i = 0;
        while (i < len) {
            if (name.equalsIgnoreCase(this.getListElement(i).getName())) {
                found = true;
                return this.getListElement(i);
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("TNSAddressBook.getAddress(name): TNSAddress " + name + " not found in address book.");
        }
        return null;
    }

    public void removeAddress(String name) {
        int len = this.getListSize();
        int i = 0;
        while (i < len) {
            if (name.equalsIgnoreCase(this.getListElement(i).getName())) {
                this.removeListElement(i);
                break;
            }
            ++i;
        }
    }

    public boolean contains(String name) {
        int len = this.getListSize();
        int i = 0;
        while (i < len) {
            if (name.equalsIgnoreCase(this.getListElement(i).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TNSAddress getListElement(int pos) {
        if (pos >= this.getListSize() || pos < 0) {
            throw new IllegalArgumentException("TNSAddressBook.get: pos index (" + pos + ") is out of bounds.");
        }
        return (TNSAddress)this._addrlist.elementAt(pos);
    }

    public void addListElement(TNSAddress tnsaddr) {
        if (tnsaddr != null) {
            this._addrlist.addElement(tnsaddr);
        }
    }

    public void addListElement(String nvString) throws CreateAddressException {
        if (DEBUG) {
            System.out.println("Trying to add the NV String: " + nvString);
        }
        TNSAddress taddr = new TNSAddress(nvString);
        this.addListElement(taddr);
    }

    public void removeListElement(int pos) {
        if (pos >= this.getListSize() || pos < 0) {
            throw new IllegalArgumentException("TNSAddressBook.remove: pos index (" + pos + ") is out of bounds.");
        }
        NVFactory nvf = new NVFactory();
        String addr = ((TNSAddress)this._addrlist.elementAt(pos)).toNVString();
        NVPair nvp = nvf.createNVPair(addr);
        String Name = nvp.getName();
        if (this.nlpa.removeNLPListElement(Name) == null && DEBUG) {
            System.out.println("Could not remove the TNS Address for " + Name);
        }
        this._addrlist.removeElementAt(pos);
    }

    public void UpdateAddressBook(TNSAddressBook ab) {
        this._addrlist.removeAllElements();
        int i = 0;
        while (i < ab.getListSize()) {
            this.addListElement(ab.getListElement(i));
            ++i;
        }
    }

    public String toString() {
        String out = "";
        try {
            this.readFile(this._filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        try {
            this.writeFile("tnsnames.new");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        int i = 0;
        while (i < this._addrlist.size()) {
            out = String.valueOf(out) + (TNSAddress)this._addrlist.elementAt(i) + "\n";
            ++i;
        }
        return out;
    }

    public void println() {
        System.out.println(this.toString());
        System.exit(1);
    }

    public static void main(String[] args) {
        TNSAddressBook ab = new TNSAddressBook("tnsnames.ora");
        ab.println();
    }
}

