/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.component;

import oracle.net.asst.component.NetObjectNode;

public class NetObjectIterator {
    NetObjectNode firstNode = null;
    NetObjectNode nextNode = null;
    NetObjectNode lastNode = null;

    public Object getFirstObject() {
        if (this.firstNode == null) {
            throw new NullPointerException("Empty List");
        }
        this.nextNode = this.firstNode;
        return this.nextNode.getObject().toString();
    }

    public Object getNextObject() {
        if (this.nextNode == null) {
            throw new NullPointerException("End of List");
        }
        this.nextNode = this.nextNode.next;
        if (this.nextNode != null) {
            return this.nextNode.getObject().toString();
        }
        throw new NullPointerException("End of List");
    }

    public Object findObjectByName(String objName) {
        if (this.firstNode == null) {
            return null;
        }
        this.nextNode = null;
        NetObjectNode tmpNode = this.firstNode;
        while (tmpNode != null) {
            if (objName.equals(tmpNode.getObject().toString())) {
                return tmpNode.getObject();
            }
            tmpNode = (NetObjectNode)tmpNode.getNext();
        }
        return null;
    }

    public boolean addObject(Object object) {
        this.nextNode = null;
        NetObjectNode tmpNode = this.firstNode;
        while (tmpNode != null) {
            if (object.toString().equals(tmpNode.getObject().toString())) {
                return false;
            }
            tmpNode = (NetObjectNode)tmpNode.getNext();
        }
        NetObjectNode newNode = new NetObjectNode(object);
        if (this.lastNode != null) {
            this.lastNode.setNext(newNode);
        }
        this.lastNode = newNode;
        if (this.firstNode == null) {
            this.firstNode = newNode;
        }
        return true;
    }

    public boolean removeObject(Object object) {
        if (this.firstNode == null) {
            return false;
        }
        this.nextNode = null;
        NetObjectNode prevNode = null;
        NetObjectNode tmpNode = this.firstNode;
        while (tmpNode != null) {
            if (object.toString().equals(tmpNode.getObject().toString())) {
                if (prevNode != null) {
                    prevNode.setNext((NetObjectNode)tmpNode.getNext());
                }
                if (tmpNode == this.lastNode) {
                    this.lastNode = prevNode;
                }
                if (tmpNode == this.firstNode) {
                    this.firstNode = null;
                }
                return true;
            }
            prevNode = tmpNode;
            tmpNode = (NetObjectNode)tmpNode.getNext();
        }
        return false;
    }

    public static void main(String[] args) {
        NetObjectIterator list = new NetObjectIterator();
        list.addObject("Hello");
        list.addObject("World!");
        list.addObject("Testing");
        list.addObject("Iteration");
        String str = (String)list.getFirstObject();
        System.out.println(str);
        while ((str = (String)list.getNextObject()) != null) {
            System.out.println(str);
        }
        str = (String)list.findObjectByName("World!");
        System.out.println("Searching for World!, found - " + str);
        list.removeObject("Testing");
        System.out.println("Removed Object Testing");
        str = (String)list.getFirstObject();
        System.out.println(str);
        while ((str = (String)list.getNextObject()) != null) {
            System.out.println(str);
        }
    }
}

