/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.event.Cancelable;
import oracle.ewt.graphics.frame.LoweredFramePainter;
import oracle.ewt.hTree.HTree;
import oracle.ewt.hTree.HTreeEvent;
import oracle.ewt.hTree.HTreeExtendedItem;
import oracle.ewt.hTree.HTreeItem;
import oracle.ewt.hTree.HTreeSelectionListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarMouseListener;
import oracle.ewt.toolBar.ToolBarSeparator;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.CommandLine;
import oracle.net.asst.container.NetAboutDialog;
import oracle.net.asst.container.NetCommentWarningDialog;
import oracle.net.asst.container.NetDeleteDialog;
import oracle.net.asst.container.NetDiscardDialog;
import oracle.net.asst.container.NetObjectComponent;
import oracle.net.asst.container.NetOpenSaveDialog;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetSaveDialog;
import oracle.net.asst.container.NetSaveError;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.listener.ListenerComponent;
import oracle.net.asst.names.NamesComponent;
import oracle.net.asst.profile.NetProfileComponent;
import oracle.net.asst.servicename.ServiceName;
import oracle.net.asst.servicewizard.ServiceWizard;
import oracle.net.common.NetGetEnv;
import oracle.sysman.emSDK.client.appContainer.Displayable;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandListener;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ToolBarCommandButton;

public class NetContainer
extends EwtContainer
implements Displayable,
CommandListener,
ToolBarMouseListener,
HTreeSelectionListener {
    private static final char SEP = File.separatorChar;
    WebApplication myContainer;
    EwtContainer twoFrame;
    HTree tree;
    ScrollBox sB;
    NetPanel rootPanel;
    NetProfileComponent profileComp;
    ListenerComponent lsnrComp;
    ServiceName serviceComp;
    NamesComponent namesComp;
    ToolBar toolBar;
    NetVector controlToolbar;
    ToolBarItem createTItem;
    ToolBarItem deleteTItem;
    LWMenu[] myMenus;
    NetVector controlMenus;
    LWMenuItem createMenuItem;
    LWMenuItem deleteMenuItem;
    NetVector compVector;
    NetComponent activeComponent;
    Object activeObject;
    EwtContainer activePanel;
    Image folder;
    Image openFolder;
    Image profileImage;
    Image svcImage;
    Image namesImage;
    Image listenerImage;
    Image create;
    Locale loc;
    private final NetStrings netStrings;
    private String fileString;
    private String openString;
    private String saveString;
    private String saveAsString;
    private String saveCompString;
    private String discardString;
    private String exitString;
    private String editString;
    private String createString;
    private String deleteString;
    private String toolsString;
    private String helpString;
    private String helpTopicsString;
    private String helpSearchString;
    private String helpAboutString;
    private String introString;
    private String installerCreateString;
    private String treeRoot;
    private String saveTitleString;
    private String cancelString;
    private String yesString;
    private String noString;
    private String startMode;
    private String servNameString;
    private String adminDirString;
    private String imageDirString;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private Toolkit tk;
    private CommandAdapter commandAdapter;
    private final NetProperties netProps;
    private boolean isMSWindows;

    public NetContainer(WebApplication w, String mode) {
        File dir;
        this.myContainer = w;
        this.startMode = mode;
        this.activeComponent = null;
        this.activeObject = null;
        this.tk = Toolkit.getDefaultToolkit();
        try {
            this.netProps = new NetProperties();
        }
        catch (IOException iOException) {
            System.err.println("Error initializing NetProperties file");
            this.netProps = null;
        }
        this.netStrings = new NetStrings();
        this.fileString = this.netStrings.getString("CNTFile");
        this.openString = this.netStrings.getString("CNTFileOpen");
        this.saveString = this.netStrings.getString("CNTFileSave");
        this.saveAsString = this.netStrings.getString("CNTFileSaveAs");
        this.discardString = this.netStrings.getString("CNTFileDiscard");
        this.exitString = this.netStrings.getString("CNTExit");
        this.editString = this.netStrings.getString("CNTEdit");
        this.createString = this.netStrings.getString("CNTCreate");
        this.deleteString = this.netStrings.getString("CNTDelete");
        this.toolsString = this.netStrings.getString("CNTTools");
        this.helpString = this.netStrings.getString("CNTHelp");
        this.helpTopicsString = this.netStrings.getString("CNTHelpTopics");
        this.helpSearchString = this.netStrings.getString("CNTHelpSearch");
        this.helpAboutString = this.netStrings.getString("CNTHelpAbout");
        this.treeRoot = this.netStrings.getString("CNTNetwork");
        this.saveTitleString = this.netStrings.getString("CNTSavePromptTitle");
        this.cancelString = this.netStrings.getString("CNTCancel");
        this.yesString = this.netStrings.getString("CNTYes");
        this.noString = this.netStrings.getString("CNTNo");
        this.servNameString = this.netStrings.getString("CNTServiceNameWizard");
        this.introString = this.netStrings.getString("CNTIntroMessage");
        this.installerCreateString = this.netStrings.getString("SNWSrvPanMsgInstallCreate");
        String os = System.getProperty("os.name");
        this.isMSWindows = os.equals("Windows NT") || os.equals("Windows 95") || os.equals("Windows 98");
        this.adminDirString = this.formatDirectoryString(NetGetEnv.getNetworkDir());
        this.imageDirString = NetUtils.getImageDirectory();
        while (!(dir = new File(this.adminDirString)).isDirectory()) {
            BufferedFrame myFrame = (BufferedFrame)this.myContainer.getFrame();
            NetOpenSaveDialog fileDialog = new NetOpenSaveDialog(myFrame, this.loc, "CNTOpenConfTitle", this.adminDirString, true);
            this.centerDialog(myFrame, fileDialog);
            ((Component)((Object)fileDialog)).setVisible(true);
            if (this.isMSWindows) {
                myFrame.toFront();
            }
            if (fileDialog.getDirectory() == null) {
                System.exit(1);
            }
            this.adminDirString = this.formatDirectoryString(fileDialog.getDirectory());
        }
        Object[] parm = new Object[]{this.adminDirString};
        this.myContainer.getFrame().setTitle(this.netStrings.getString("CNTApplication", parm));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.twoFrame = new EwtContainer();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.twoFrame.setLayout(this.gbl);
        ((Container)((Object)this)).add((Component)this.twoFrame, "Center");
        this.loadComponents();
        this.tree = this.generateTree();
        this.tree.addSelectionListener((HTreeSelectionListener)this);
        this.sB = new ScrollBox((Component)this.tree);
        this.sB.validate();
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 10.0;
        this.gbc.gridheight = 0;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbl.setConstraints((Component)this.sB, this.gbc);
        this.twoFrame.add((Component)this.sB);
        this.controlMenus = new NetVector();
        this.controlToolbar = new NetVector();
        this.rootPanel = new NetPanel(w, "NA_placebo.gif", this.introString);
        ((Container)((Object)this.rootPanel)).setLayout(new GridLayout(1, 1));
        this.activePanel = this.rootPanel;
        this.addComponentDisplay(this.activePanel);
    }

    public void init() {
        this.commandAdapter = new CommandAdapter(this.myContainer);
        this.myMenus = this.generateMenus();
        this.commandAdapter.addMenus(this.myMenus);
        this.toolBar = this.generateToolBar();
        this.commandAdapter.addToolBar(this.toolBar);
        this.commandAdapter.addCommandListener((CommandListener)this);
        if (this.startMode.equalsIgnoreCase("wizard")) {
            BufferedFrame frame = (BufferedFrame)this.myContainer.getFrame();
            ServiceWizard wiz = null;
            boolean createMode = false;
            try {
                CommandLine cmdLine = new CommandLine(this.myContainer.getCommandLineArgs());
                if (cmdLine.contains("createonly")) {
                    createMode = true;
                }
                if (cmdLine.contains("instprtcl")) {
                    String selectedProt = "TCP";
                    Vector<String> installedProts = new Vector<String>(5, 3);
                    StringTokenizer tokens = new StringTokenizer(cmdLine.get("instprtcl"), ",");
                    while (tokens.hasMoreTokens()) {
                        installedProts.addElement(tokens.nextToken());
                    }
                    Vector<String> preferredProts = new Vector<String>(5, 3);
                    if (this.netProps != null) {
                        String prop = null;
                        prop = this.netProps.getProperty("p3");
                        if (prop != null) {
                            preferredProts.insertElementAt(prop, 0);
                        } else {
                            prop = this.netProps.getProperty("P3");
                            if (prop != null) {
                                preferredProts.insertElementAt(prop, 0);
                            }
                        }
                        prop = this.netProps.getProperty("p2");
                        if (prop != null) {
                            preferredProts.insertElementAt(prop, 0);
                        } else {
                            prop = this.netProps.getProperty("P2");
                            if (prop != null) {
                                preferredProts.insertElementAt(prop, 0);
                            }
                        }
                        prop = this.netProps.getProperty("p1");
                        if (prop != null) {
                            preferredProts.insertElementAt(prop, 0);
                        } else {
                            prop = this.netProps.getProperty("P1");
                            if (prop != null) {
                                preferredProts.insertElementAt(prop, 0);
                            }
                        }
                        int numPref = preferredProts.size();
                        int numInst = installedProts.size();
                        String currentPref = null;
                        int i = 0;
                        block3: while (i < numPref) {
                            currentPref = (String)preferredProts.elementAt(i);
                            int j = 0;
                            while (j < numInst) {
                                if (currentPref.equalsIgnoreCase((String)installedProts.elementAt(j))) {
                                    selectedProt = currentPref.toUpperCase();
                                    break block3;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    wiz = new ServiceWizard(frame, this.adminDirString, null, createMode, this.profileComp.getDefaultDomain(), true, selectedProt, this.installerCreateString);
                } else {
                    wiz = new ServiceWizard(frame, this.adminDirString, null, createMode, this.profileComp.getDefaultDomain(), true);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println("Exception in NetContainer.init(): " + e);
                System.err.println("Ignoring command line arguments...");
                wiz = new ServiceWizard(frame, this.adminDirString, null, createMode, this.profileComp.getDefaultDomain(), true);
            }
            wiz.go();
            System.exit(0);
        }
    }

    public Component getDisplay() {
        return this;
    }

    public void discard() {
        Enumeration en = this.compVector.elements();
        while (en.hasMoreElements()) {
            NetObjectComponent compObject = (NetObjectComponent)en.nextElement();
            NetComponent component = compObject.getComponent();
            component.discardObjects();
        }
        this.twoFrame.remove((Component)this.sB);
        this.twoFrame.remove((Component)this.activePanel);
        this.tree = this.generateTree();
        this.tree.addSelectionListener((HTreeSelectionListener)this);
        this.sB = new ScrollBox((Component)this.tree);
        this.activeComponent = null;
        this.activeObject = null;
        this.activePanel = this.rootPanel;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 10.0;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.twoFrame.add((Component)this.sB, this.gbc);
        this.addComponentDisplay(this.activePanel);
    }

    public void destroy() {
    }

    public boolean isExitAllowed() {
        return this.saveChanges(false, false, true);
    }

    public NetComponent getListenerComponent() {
        return this.lsnrComp;
    }

    public NetComponent getProfileComponent() {
        return this.profileComp;
    }

    public NetComponent getNamesComponent() {
        return this.namesComp;
    }

    public NetComponent getNetServiceNamesComponent() {
        return this.serviceComp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commandIssued(CommandEvent e) {
        Object source;
        block37: {
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        block38: {
                                            String cmd = e.getCommand();
                                            source = e.getSource();
                                            try {
                                                if (source instanceof ToolBarCommandButton) {
                                                    ((ToolBarCommandButton)source).setEnabled(false);
                                                }
                                                if (cmd.equals(this.deleteString)) {
                                                    if (this.activeObject == null) break block37;
                                                    if (this.activeObject == this.activeComponent) {
                                                        Object var6_4 = null;
                                                        break block38;
                                                    }
                                                    if (this.tree.getSelectedItemCount() == 0) {
                                                        break block39;
                                                    }
                                                    HTreeItem selected = this.tree.getSelectedItems()[0];
                                                    if (selected.getChildCount() != 0) break block37;
                                                    BufferedFrame fr = (BufferedFrame)this.myContainer.getFrame();
                                                    NetDeleteDialog deleteDialog = new NetDeleteDialog(fr, this.loc, this.activeObject.toString());
                                                    this.centerDialog(fr, deleteDialog);
                                                    ((Dialog)((Object)deleteDialog)).setModal(true);
                                                    ((Component)((Object)deleteDialog)).setVisible(true);
                                                    if (this.isMSWindows) {
                                                        fr.toFront();
                                                    }
                                                    if (deleteDialog.getSelection().equals(this.noString)) {
                                                        break block40;
                                                    }
                                                    if (!this.activeComponent.deleteObject(this.activeObject)) break block37;
                                                    this.activeObject = null;
                                                    HTreeItem nextItem = selected.getNext();
                                                    if (nextItem == null) {
                                                        nextItem = selected.getPrevious();
                                                    }
                                                    HTreeItem parent = selected.getParent();
                                                    this.tree.removeItem(selected);
                                                    if (nextItem != null) {
                                                        HTreeItem[] newItem = new HTreeItem[]{nextItem};
                                                        this.tree.setSelectedItems(newItem, 1, true);
                                                        break block37;
                                                    } else {
                                                        this.setActiveComponent(parent);
                                                        parent.setExpanded(false);
                                                    }
                                                    break block37;
                                                }
                                                if (cmd.equals(this.createString)) {
                                                    Object newObject;
                                                    if (this.activeComponent == null) {
                                                        break block41;
                                                    }
                                                    if (this.tree.getSelectedItemCount() == 0) {
                                                        break block42;
                                                    }
                                                    HTreeItem pItem = this.tree.getSelectedItems()[0];
                                                    if (!pItem.getParent().getLabel().equals(this.treeRoot)) {
                                                        pItem = pItem.getParent();
                                                    }
                                                    if ((newObject = this.activeComponent.toString().equals(this.serviceComp.toString()) ? this.serviceComp.createObject(null, this.profileComp.getDefaultDomain()) : (this.activeComponent.toString().equals(this.lsnrComp.toString()) ? this.lsnrComp.createObject(null, this.profileComp.getDefaultDomain()) : this.activeComponent.createObject(null))) != null) {
                                                        NetObjectComponent compObject = (NetObjectComponent)this.compVector.findObjectByName(this.activeComponent.toString());
                                                        NetVector objs = compObject.getObjects();
                                                        objs.addElement(newObject);
                                                        HTreeItem treeItem = this.activeComponent.toString().equals(this.serviceComp.toString()) ? new HTreeItem(newObject.toString(), this.svcImage) : (this.activeComponent.toString().equals(this.namesComp.toString()) ? new HTreeItem(newObject.toString(), this.namesImage) : new HTreeItem(newObject.toString(), this.listenerImage));
                                                        this.tree.addItem(pItem, treeItem);
                                                        HTreeItem[] newItem = new HTreeItem[]{treeItem};
                                                        this.tree.setSelectedItems(newItem, 1, true);
                                                        treeItem.getParent().setExpanded(true);
                                                    }
                                                    break block37;
                                                }
                                                if (cmd.equals(this.discardString)) {
                                                    this.discardChanges();
                                                    break block37;
                                                }
                                                if (cmd.equals(this.openString)) {
                                                    if (!this.saveChanges(false, false, true)) {
                                                        break block43;
                                                    }
                                                    BufferedFrame myFrame = (BufferedFrame)this.myContainer.getFrame();
                                                    NetOpenSaveDialog fileDialog = new NetOpenSaveDialog(myFrame, this.loc, "CNTOpenConfTitle", this.adminDirString, true);
                                                    this.centerDialog(myFrame, fileDialog);
                                                    ((Component)((Object)fileDialog)).setVisible(true);
                                                    if (this.isMSWindows) {
                                                        myFrame.toFront();
                                                    }
                                                    if (fileDialog.getDirectory() != null) {
                                                        this.adminDirString = this.formatDirectoryString(fileDialog.getDirectory());
                                                        Object[] parm = new Object[]{this.adminDirString};
                                                        this.myContainer.getFrame().setTitle(this.netStrings.getString("CNTApplication", parm));
                                                        Rectangle sbBounds = this.sB.getBounds();
                                                        Rectangle pBounds = this.activePanel.getBounds();
                                                        this.twoFrame.remove((Component)this.sB);
                                                        this.twoFrame.remove((Component)this.activePanel);
                                                        this.tree = this.generateTree();
                                                        this.tree.addSelectionListener((HTreeSelectionListener)this);
                                                        this.sB = new ScrollBox((Component)this.tree);
                                                        this.activeComponent = null;
                                                        this.activeObject = null;
                                                        this.activePanel = this.rootPanel;
                                                        this.gbc.gridx = 0;
                                                        this.gbc.gridy = 0;
                                                        this.gbc.gridheight = 1;
                                                        this.gbc.gridwidth = 1;
                                                        this.gbc.weightx = 0.25;
                                                        this.gbc.weighty = 10.0;
                                                        this.gbc.fill = 1;
                                                        this.gbc.anchor = 18;
                                                        this.twoFrame.add((Component)this.sB, this.gbc);
                                                        this.addComponentDisplay(this.activePanel);
                                                        if (this.getPeer() != null) {
                                                            ((Container)((Object)this)).getLayout().layoutContainer((Container)((Object)this));
                                                        }
                                                        ((Container)((Object)this)).validate();
                                                    }
                                                    break block37;
                                                }
                                                if (cmd.equals(this.saveString)) {
                                                    this.saveChanges(false, true, true);
                                                    break block37;
                                                }
                                                if (cmd.equals(this.saveAsString)) {
                                                    this.saveChanges(true, true, true);
                                                    break block37;
                                                }
                                                if (cmd.equals(this.exitString)) {
                                                    if (this.saveChanges(false, false, true)) {
                                                        System.exit(0);
                                                    }
                                                    break block37;
                                                }
                                                if (cmd.equals(this.servNameString)) {
                                                    BufferedFrame frame = (BufferedFrame)this.myContainer.getFrame();
                                                    ServiceWizard w = new ServiceWizard(frame, this.adminDirString, null, false, this.profileComp.getDefaultDomain(), true);
                                                    w.go();
                                                    break block37;
                                                }
                                                if (cmd.equals(this.helpTopicsString)) {
                                                    NetUtils.getHelpContext().showContents();
                                                    break block37;
                                                }
                                                if (cmd.equals(this.helpSearchString)) {
                                                    NetUtils.getHelpContext().showSearch();
                                                    break block37;
                                                }
                                                if (cmd.equals(this.helpAboutString)) {
                                                    BufferedFrame frame = (BufferedFrame)this.myContainer.getFrame();
                                                    Image img = this.tk.getImage(String.valueOf(this.imageDirString) + "naicon.gif");
                                                    NetAboutDialog about = new NetAboutDialog(frame, this.loc, img);
                                                    this.centerDialog(frame, about);
                                                    ((Dialog)((Object)about)).setModal(true);
                                                    ((Component)((Object)about)).setVisible(true);
                                                    if (this.isMSWindows) {
                                                        frame.toFront();
                                                    }
                                                    break block37;
                                                }
                                                try {
                                                    NetVector menuVector = this.activeComponent.getComponentMenus();
                                                    Enumeration en = menuVector.elements();
                                                    while (en.hasMoreElements()) {
                                                        NetObjectMenu menuObject = (NetObjectMenu)en.nextElement();
                                                        if (!cmd.equals(menuObject.toString())) continue;
                                                        this.activeComponent.executeComponentMenu(menuObject.toString());
                                                        break block44;
                                                    }
                                                }
                                                catch (NullPointerException nullPointerException) {}
                                                try {
                                                    NetVector toolbarVector = this.activeComponent.getComponentToolbar();
                                                    Enumeration en = toolbarVector.elements();
                                                    while (en.hasMoreElements()) {
                                                        NetObjectToolbar toolbarObject = (NetObjectToolbar)en.nextElement();
                                                        if (!cmd.equals(toolbarObject.toString())) continue;
                                                        this.activeComponent.executeComponentToolbar(toolbarObject.toString());
                                                        break block45;
                                                    }
                                                    break block37;
                                                }
                                                catch (NullPointerException nullPointerException) {
                                                    break block37;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var6_13 = null;
                                                if (!(source instanceof ToolBarCommandButton)) throw throwable;
                                                ((ToolBarCommandButton)source).setEnabled(true);
                                                throw throwable;
                                            }
                                        }
                                        if (!(source instanceof ToolBarCommandButton)) return;
                                        ((ToolBarCommandButton)source).setEnabled(true);
                                        return;
                                    }
                                    Object var6_5 = null;
                                    if (!(source instanceof ToolBarCommandButton)) return;
                                    ((ToolBarCommandButton)source).setEnabled(true);
                                    return;
                                }
                                Object var6_6 = null;
                                if (!(source instanceof ToolBarCommandButton)) return;
                                ((ToolBarCommandButton)source).setEnabled(true);
                                return;
                            }
                            Object var6_7 = null;
                            if (!(source instanceof ToolBarCommandButton)) return;
                            ((ToolBarCommandButton)source).setEnabled(true);
                            return;
                        }
                        Object var6_8 = null;
                        if (!(source instanceof ToolBarCommandButton)) return;
                        ((ToolBarCommandButton)source).setEnabled(true);
                        return;
                    }
                    Object var6_9 = null;
                    if (!(source instanceof ToolBarCommandButton)) return;
                    ((ToolBarCommandButton)source).setEnabled(true);
                    return;
                }
                Object var6_10 = null;
                if (!(source instanceof ToolBarCommandButton)) return;
                ((ToolBarCommandButton)source).setEnabled(true);
                return;
            }
            Object var6_11 = null;
            if (!(source instanceof ToolBarCommandButton)) return;
            ((ToolBarCommandButton)source).setEnabled(true);
            return;
        }
        Object var6_12 = null;
        if (!(source instanceof ToolBarCommandButton)) return;
        ((ToolBarCommandButton)source).setEnabled(true);
    }

    public void hTreeSelectionChanged(HTreeEvent e) {
        if (e.getID() != 2006) {
            return;
        }
        this.myContainer.showStatus("");
        try {
            if (this.tree.getSelectedItemCount() == 0) {
                return;
            }
            HTreeItem selected = this.tree.getSelectedItems()[0];
            this.setActiveComponent(selected);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void hTreeSelectionChanging(HTreeEvent e) {
        boolean deactivated;
        if (e.getID() != 2005) {
            return;
        }
        if (this.activeComponent != null && this.activeObject != null && !(deactivated = this.activeComponent == this.activeObject ? this.activeComponent.deactivateObject(null) : this.activeComponent.deactivateObject(this.activeObject))) {
            ((Cancelable)e).cancel();
        }
    }

    public void toolBarItemMouseEntered(ToolBarEvent e) {
        ToolBarItem item = e.getItem();
        if (item instanceof ToolBarCommandButton) {
            this.myContainer.showStatus(((ToolBarCommandButton)item).getCommand());
        }
    }

    public void toolBarItemMouseExited(ToolBarEvent e) {
        this.myContainer.showStatus("");
    }

    private void addComponentDisplay(EwtContainer panel) {
        this.gbc.gridx = 1;
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 10.0;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 0;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.twoFrame.add((Component)panel, this.gbc);
        if (this.twoFrame.getPeer() != null) {
            this.gbl.layoutContainer((Container)this.twoFrame);
        }
        this.twoFrame.validate();
        panel.validate();
    }

    private void setActiveComponent(HTreeItem item) {
        if (item.getLabel().equals(this.treeRoot)) {
            if (this.activeObject != null) {
                this.setMenuToolbarStatus(this.activeComponent, false);
                this.twoFrame.remove((Component)this.activePanel);
                this.activePanel = this.rootPanel;
                this.addComponentDisplay(this.activePanel);
            }
            this.activeComponent = null;
            this.activeObject = null;
            this.createMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
            this.createTItem.setEnabled(false);
            this.deleteTItem.setEnabled(false);
            return;
        }
        if (item.getParent().getLabel().equals(this.treeRoot)) {
            if (this.activeComponent != null && this.activeComponent.equals(item.getLabel())) {
                return;
            }
            NetObjectComponent compObject = (NetObjectComponent)this.compVector.findObjectByName(item.getLabel());
            NetComponent newComponent = compObject.getComponent();
            if (this.activeComponent != null && this.activeComponent != newComponent) {
                this.setMenuToolbarStatus(this.activeComponent, false);
            }
            this.createMenuItem.setEnabled(true);
            this.deleteMenuItem.setEnabled(false);
            this.createTItem.setEnabled(true);
            this.deleteTItem.setEnabled(false);
            this.activeComponent = newComponent;
            this.activeObject = this.activeComponent;
            EwtContainer newPanel = this.activeComponent.activateObject(null);
            this.setMenuToolbarStatus(newComponent, true);
            if (newPanel != this.activePanel) {
                this.twoFrame.remove((Component)this.activePanel);
                this.activePanel = newPanel;
                this.addComponentDisplay(this.activePanel);
            }
            return;
        }
        NetObjectComponent compObject = (NetObjectComponent)this.compVector.findObjectByName(item.getParent().getLabel());
        NetComponent newComponent = compObject.getComponent();
        Object newObject = compObject.getObjects().findObjectByName(item.getLabel());
        if (newObject == this.activeObject) {
            return;
        }
        if (this.activeComponent != null && this.activeComponent != newComponent) {
            this.setMenuToolbarStatus(this.activeComponent, false);
        }
        this.createMenuItem.setEnabled(true);
        this.deleteMenuItem.setEnabled(true);
        this.createTItem.setEnabled(true);
        this.deleteTItem.setEnabled(true);
        this.activeComponent = newComponent;
        this.activeObject = newObject;
        EwtContainer newPanel = this.activeComponent.activateObject(newObject);
        this.setMenuToolbarStatus(newComponent, true);
        if (newPanel != this.activePanel) {
            this.twoFrame.remove((Component)this.activePanel);
            this.activePanel = newPanel;
            this.addComponentDisplay(this.activePanel);
        }
    }

    private void setMenuToolbarStatus(NetComponent component, boolean enable) {
        ToolBarItem tItem;
        Enumeration es;
        LWMenuItem menuItem;
        Enumeration es2;
        NetVector menus = component.getComponentMenus();
        try {
            es2 = menus.elements();
            while (es2.hasMoreElements()) {
                NetObjectMenu menuObject = (NetObjectMenu)es2.nextElement();
                menuItem = menuObject.getMenuItem();
                menuItem.setEnabled(enable && menuObject.isEnabled());
            }
            NetVector toolbar = component.getComponentToolbar();
            es = toolbar.elements();
            while (es.hasMoreElements()) {
                NetObjectToolbar tObject = (NetObjectToolbar)es.nextElement();
                tItem = tObject.getToolbarItem();
                tItem.setEnabled(enable && tObject.isEnabled());
            }
        }
        catch (NullPointerException nullPointerException) {}
        if (!enable) {
            es2 = this.controlMenus.elements();
            while (es2.hasMoreElements()) {
                menuItem = (LWMenuItem)es2.nextElement();
                menuItem.setEnabled(true);
            }
            es = this.controlToolbar.elements();
            while (es.hasMoreElements()) {
                tItem = (ToolBarItem)es.nextElement();
                tItem.setEnabled(true);
            }
        }
    }

    private boolean wantCommentWarning() {
        String commentWarning = null;
        if (this.netProps != null) {
            commentWarning = this.netProps.getProperty("CommentWarning");
        }
        return commentWarning == null || commentWarning.equalsIgnoreCase("YES");
    }

    private void showCommentWarning() {
        block5: {
            BufferedFrame frame = (BufferedFrame)this.myContainer.getFrame();
            NetCommentWarningDialog cw = new NetCommentWarningDialog(frame, true);
            this.centerDialog(frame, cw);
            ((Component)((Object)cw)).setVisible(true);
            if (this.isMSWindows) {
                frame.toFront();
            }
            if (cw.getSelection().equals(this.noString)) {
                System.exit(1);
            }
            if (this.netProps == null) break block5;
            try {
                if (!cw.wantWarning()) {
                    this.netProps.putProperty("CommentWarning", "NO");
                    this.netProps.save();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error saving CommentWarning to NetProperties");
            }
        }
    }

    private void centerDialog(BufferedFrame fr, BufferedDialog dlg) {
        Rectangle parent = fr.getBounds();
        Dimension mySize = dlg.getSize();
        dlg.setLocation(parent.x + (parent.width - mySize.width) / 2, parent.y + (parent.height - mySize.height) / 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveChanges(boolean saveAs, boolean forceSave, boolean all) {
        BufferedFrame fr;
        boolean changed = false;
        if (!forceSave) {
            NetSaveDialog saveDialog;
            block16: {
                boolean bl;
                block17: {
                    boolean bl2;
                    block15: {
                        Enumeration en = this.compVector.elements();
                        while (en.hasMoreElements()) {
                            NetObjectComponent compObject = (NetObjectComponent)en.nextElement();
                            NetComponent component = compObject.getComponent();
                            if (!component.isChanged()) continue;
                            changed = true;
                            break;
                        }
                        if (!changed) {
                            return true;
                        }
                        fr = (BufferedFrame)this.myContainer.getFrame();
                        saveDialog = new NetSaveDialog(fr, this.loc);
                        this.centerDialog(fr, saveDialog);
                        ((Dialog)((Object)saveDialog)).setModal(true);
                        ((Component)((Object)saveDialog)).setVisible(true);
                        if (this.isMSWindows) {
                            fr.toFront();
                        }
                        String dString = this.netStrings.getString("CNTDiscard");
                        try {
                            try {
                                if (saveDialog.getSelection().equals(this.cancelString)) {
                                    bl2 = false;
                                    Object var13_15 = null;
                                    if (saveDialog == null) return bl2;
                                    break block15;
                                }
                                if (!saveDialog.getSelection().equals(dString)) break block16;
                                this.discard();
                                bl = true;
                                break block17;
                            }
                            catch (NullPointerException nullPointerException) {
                                boolean bl3 = false;
                                Object var13_17 = null;
                                if (saveDialog == null) return bl3;
                                saveDialog.dispose();
                                return bl3;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_19 = null;
                            if (saveDialog != null) {
                                saveDialog.dispose();
                            }
                            throw throwable;
                        }
                    }
                    saveDialog.dispose();
                    return bl2;
                }
                Object var13_16 = null;
                if (saveDialog == null) return bl;
                saveDialog.dispose();
                return bl;
            }
            Object var13_18 = null;
            if (saveDialog != null) {
                saveDialog.dispose();
            }
        }
        while (true) {
            try {
                return this.saveConfiguration(saveAs);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                fr = (BufferedFrame)this.myContainer.getFrame();
                NetSaveError errDialog = new NetSaveError(fr, this.loc);
                this.centerDialog(fr, errDialog);
                ((Dialog)((Object)errDialog)).setModal(true);
                ((Component)((Object)errDialog)).setVisible(true);
                if (!this.isMSWindows) continue;
                fr.toFront();
                if (!errDialog.getSelection().equals(this.cancelString)) continue;
                errDialog.dispose();
                return false;
            }
            break;
        }
    }

    private boolean saveConfiguration(boolean saveAs) throws FileNotFoundException, IOException {
        if (saveAs) {
            BufferedFrame myFrame = (BufferedFrame)this.myContainer.getFrame();
            NetOpenSaveDialog saveAsDialog = new NetOpenSaveDialog(myFrame, this.loc, "CNTSaveConfTitle", this.adminDirString, true);
            this.centerDialog(myFrame, saveAsDialog);
            ((Component)((Object)saveAsDialog)).setVisible(true);
            if (this.isMSWindows) {
                myFrame.toFront();
            }
            if (saveAsDialog.getDirectory() == null) {
                return false;
            }
            this.adminDirString = this.formatDirectoryString(saveAsDialog.getDirectory());
            Object[] parm = new Object[]{this.adminDirString};
            this.myContainer.getFrame().setTitle(this.netStrings.getString("CNTApplication", parm));
        }
        boolean saved = true;
        Enumeration en = this.compVector.elements();
        while (en.hasMoreElements()) {
            NetObjectComponent compObject = (NetObjectComponent)en.nextElement();
            NetComponent component = compObject.getComponent();
            saved = component.saveObjects(this.adminDirString);
            if (!saved) break;
        }
        return saved;
    }

    private void discardChanges() {
        boolean changed = false;
        Enumeration en = this.compVector.elements();
        while (en.hasMoreElements()) {
            NetObjectComponent compObject = (NetObjectComponent)en.nextElement();
            NetComponent component = compObject.getComponent();
            if (!component.isChanged()) continue;
            changed = true;
            break;
        }
        if (changed) {
            BufferedFrame fr = (BufferedFrame)this.myContainer.getFrame();
            NetDiscardDialog discardDialog = new NetDiscardDialog(fr, this.loc);
            this.centerDialog(fr, discardDialog);
            ((Dialog)((Object)discardDialog)).setModal(true);
            ((Component)((Object)discardDialog)).setVisible(true);
            if (this.isMSWindows) {
                fr.toFront();
            }
            try {
                if (discardDialog.getSelection().equals(this.yesString)) {
                    this.discard();
                }
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }
    }

    private void loadComponents() {
        this.compVector = new NetVector();
        this.profileComp = new NetProfileComponent(this.myContainer);
        NetObjectComponent compObject = new NetObjectComponent(this.profileComp);
        this.compVector.addElement(compObject);
        this.serviceComp = new ServiceName(this.myContainer);
        compObject = new NetObjectComponent(this.serviceComp);
        this.compVector.addElement(compObject);
        this.lsnrComp = new ListenerComponent(this.myContainer);
        compObject = new NetObjectComponent(this.lsnrComp);
        this.compVector.addElement(compObject);
        if (this.startMode.equalsIgnoreCase("application")) {
            String loadNames = null;
            if (this.netProps != null) {
                this.netProps.getProperty("Names");
            }
            if (loadNames == null || loadNames.equalsIgnoreCase("yes")) {
                this.namesComp = new NamesComponent(this.myContainer);
                compObject = new NetObjectComponent(this.namesComp);
                this.compVector.addElement(compObject);
            }
        }
    }

    private HTree generateTree() {
        1 t = new 1();
        boolean foundComment = false;
        t.setLineStyle(1);
        t.setMultipleMode(false);
        t.setBorder((Border)new FrameBorder(5, LoweredFramePainter.getFramePainter()));
        this.folder = this.tk.getImage(String.valueOf(this.imageDirString) + "folder.gif");
        this.openFolder = this.tk.getImage(String.valueOf(this.imageDirString) + "openfolder.gif");
        this.profileImage = this.tk.getImage(String.valueOf(this.imageDirString) + "profile.gif");
        this.svcImage = this.tk.getImage(String.valueOf(this.imageDirString) + "servname.gif");
        this.namesImage = this.tk.getImage(String.valueOf(this.imageDirString) + "nameserv.gif");
        this.listenerImage = this.tk.getImage(String.valueOf(this.imageDirString) + "listener.gif");
        HTreeExtendedItem top = new HTreeExtendedItem(this.treeRoot, this.folder, this.openFolder, 1);
        t.addItem(null, (HTreeItem)top);
        Enumeration e = this.compVector.elements();
        while (e.hasMoreElements()) {
            HTreeExtendedItem service = null;
            NetObjectComponent compObject = (NetObjectComponent)e.nextElement();
            NetComponent component = compObject.getComponent();
            NetVector servVector = component.getObjects(this.adminDirString);
            compObject.setObjects(servVector);
            if (component.toString().equals(this.profileComp.toString())) {
                if (this.wantCommentWarning() && !foundComment) {
                    foundComment = this.profileComp.Comp_file_has_Comments();
                }
                t.addItem((HTreeItem)top, new HTreeItem(this.profileComp.toString(), this.profileImage));
            } else {
                service = new HTreeExtendedItem(new String(component.toString()), this.folder, this.openFolder, 1);
                if (this.wantCommentWarning() && !foundComment) {
                    foundComment = this.serviceComp.Comp_file_has_Comments();
                }
                t.addItem((HTreeItem)top, (HTreeItem)service);
            }
            try {
                Enumeration es = servVector.elements();
                while (es.hasMoreElements()) {
                    Object servObject = es.nextElement();
                    if (component.toString().equals(this.serviceComp.toString())) {
                        t.addItem((HTreeItem)service, new HTreeItem(new String(servObject.toString()), this.svcImage));
                        continue;
                    }
                    if (component.toString().equals(this.namesComp.toString())) {
                        t.addItem((HTreeItem)service, new HTreeItem(new String(servObject.toString()), this.namesImage));
                        continue;
                    }
                    if (this.wantCommentWarning() && !foundComment) {
                        foundComment = this.lsnrComp.Comp_file_has_Comments();
                    }
                    t.addItem((HTreeItem)service, new HTreeItem(new String(servObject.toString()), this.listenerImage));
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        top.setExpanded(true, false, true);
        t.setBackground(Color.white);
        t.setForeground(Color.black);
        if (foundComment) {
            this.showCommentWarning();
        }
        return t;
    }

    private LWMenu[] generateMenus() {
        int NUM_MENUS = 4;
        int FILE_MENU_INDEX = 0;
        int EDIT_MENU_INDEX = 1;
        int TOOLS_MENU_INDEX = 2;
        int HELP_MENU_INDEX = 3;
        LWMenu[] array = new LWMenu[NUM_MENUS];
        array[EDIT_MENU_INDEX] = new LWMenu(this.editString, new LWPopupMenu());
        array[TOOLS_MENU_INDEX] = new LWMenu(this.toolsString, new LWPopupMenu());
        this.createMenuItem = new MenuCommandItem(this.createString, this.createString);
        array[EDIT_MENU_INDEX].getSubMenu().add((Component)this.createMenuItem);
        this.createMenuItem.setEnabled(false);
        this.deleteMenuItem = new MenuCommandItem(this.deleteString, this.deleteString);
        array[EDIT_MENU_INDEX].getSubMenu().add((Component)this.deleteMenuItem);
        this.deleteMenuItem.setEnabled(false);
        this.controlMenus.addElement(this.createMenuItem);
        this.controlMenus.addElement(this.deleteMenuItem);
        Enumeration e = this.compVector.elements();
        while (e.hasMoreElements()) {
            NetObjectComponent compObject = (NetObjectComponent)e.nextElement();
            NetComponent component = compObject.getComponent();
            NetVector menuVector = component.getComponentMenus();
            if (menuVector == null) continue;
            Enumeration es = menuVector.elements();
            while (es.hasMoreElements()) {
                NetObjectMenu menuObject = (NetObjectMenu)es.nextElement();
                MenuCommandItem menuItem = new MenuCommandItem(new String(menuObject.toString()), new String(menuObject.toString()));
                if (menuObject.getMenuName().equals(this.editString)) {
                    if (menuObject.toString().equals(this.createString)) {
                        menuObject.setMenuItem(this.createMenuItem);
                        continue;
                    }
                    if (menuObject.toString().equals(this.deleteString)) {
                        menuObject.setMenuItem(this.deleteMenuItem);
                        continue;
                    }
                    array[EDIT_MENU_INDEX].getSubMenu().add((Component)menuItem);
                    menuObject.setMenuItem((LWMenuItem)menuItem);
                    menuItem.setEnabled(false);
                    continue;
                }
                if (!menuObject.getMenuName().equals(this.toolsString)) continue;
                array[TOOLS_MENU_INDEX].getSubMenu().add((Component)menuItem);
                menuObject.setMenuItem((LWMenuItem)menuItem);
                menuItem.setEnabled(false);
            }
        }
        array[FILE_MENU_INDEX] = new LWMenu(this.fileString, new LWPopupMenu());
        MenuCommandItem aNewMenuItem = new MenuCommandItem(this.openString, this.openString);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        aNewMenuItem = new MenuCommandItem(this.saveString, this.saveString);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        aNewMenuItem = new MenuCommandItem(this.saveAsString, this.saveAsString);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)new LWMenuSeparator());
        aNewMenuItem = new MenuCommandItem(this.discardString, this.discardString);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        aNewMenuItem = new MenuCommandItem(this.exitString, this.exitString);
        array[FILE_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        array[HELP_MENU_INDEX] = new LWMenu(this.helpString, new LWPopupMenu());
        aNewMenuItem = new MenuCommandItem(this.helpTopicsString, this.helpTopicsString);
        array[HELP_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        aNewMenuItem = new MenuCommandItem(this.helpSearchString, this.helpSearchString);
        array[HELP_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        array[HELP_MENU_INDEX].getSubMenu().add((Component)new LWMenuSeparator());
        aNewMenuItem = new MenuCommandItem(this.helpAboutString, this.helpAboutString);
        array[HELP_MENU_INDEX].getSubMenu().add((Component)aNewMenuItem);
        return array;
    }

    private ToolBar generateToolBar() {
        ToolBar t = new ToolBar();
        this.createTItem = new ToolBarCommandButton(this.createString, this.tk.getImage(String.valueOf(this.imageDirString) + "create.gif"));
        t.addItem(this.createTItem);
        this.createTItem.setEnabled(false);
        this.deleteTItem = new ToolBarCommandButton(this.deleteString, this.tk.getImage(String.valueOf(this.imageDirString) + "delete.gif"));
        t.addItem(this.deleteTItem);
        this.deleteTItem.setEnabled(false);
        t.addItem((ToolBarItem)new ToolBarSeparator());
        this.controlToolbar.addElement(this.createTItem);
        this.controlToolbar.addElement(this.deleteTItem);
        Enumeration e = this.compVector.elements();
        while (e.hasMoreElements()) {
            NetObjectComponent compObject = (NetObjectComponent)e.nextElement();
            NetComponent component = compObject.getComponent();
            NetVector toolVector = component.getComponentToolbar();
            if (toolVector == null) continue;
            Enumeration es = toolVector.elements();
            while (es.hasMoreElements()) {
                NetObjectToolbar toolObject = (NetObjectToolbar)es.nextElement();
                if (toolObject.toString().equals(this.createString)) {
                    toolObject.setToolbarItem(this.createTItem);
                    continue;
                }
                if (toolObject.toString().equals(this.deleteString)) {
                    toolObject.setToolbarItem(this.deleteTItem);
                    continue;
                }
                ToolBarCommandButton newItem = new ToolBarCommandButton(new String(toolObject.toString()), toolObject.getImage());
                toolObject.setToolbarItem((ToolBarItem)newItem);
                t.addItem((ToolBarItem)newItem);
                newItem.setEnabled(false);
            }
            t.addItem((ToolBarItem)new ToolBarSeparator());
        }
        t.addItem((ToolBarItem)new ToolBarCommandButton(this.helpTopicsString, this.tk.getImage(String.valueOf(this.imageDirString) + "help.gif")));
        t.addToolBarMouseListener((ToolBarMouseListener)this);
        return t;
    }

    private String formatDirectoryString(String dir) {
        int i = dir.length() - 1;
        while (i >= 0) {
            if (dir.charAt(i) != SEP) break;
            --i;
        }
        return String.valueOf(dir.substring(0, i + 1)) + SEP;
    }

    private final class 1
    extends HTree {
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        /* synthetic */ 1() {
        }
    }
}

