/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.asst.container.NetStrings;
import oracle.net.common.help.HelpSystem;
import oracle.net.common.help.KomodoHelp;

public class NetHelp {
    private final String helpTitleString;
    private final String helpNotInitializedString;
    private static final String SEP = File.separator;
    private final BufferedFrame parentFrame;
    private final Dimension TOPIC_DIM = new Dimension(500, 500);
    private final Point TOPIC_LOC;
    private final HelpSystem help;
    private Alert alert;
    private static Hashtable dict = new Hashtable();

    public NetHelp(BufferedFrame caller) {
        this.parentFrame = caller;
        NetStrings ns = new NetStrings();
        this.helpTitleString = ns.getString("CNThelpTitle");
        this.helpNotInitializedString = ns.getString("CNThelpNotInitializedError");
        this.TOPIC_LOC = new Point(caller.getToolkit().getScreenSize().width - this.TOPIC_DIM.width, 0);
        String FILENAME = "n8ahelp";
        String helpHome = String.valueOf(SEP) + "help" + SEP + "asst" + SEP + "help";
        URL dirURL = ClassLoader.getSystemResource(String.valueOf(helpHome) + "_" + Locale.getDefault() + SEP);
        if (dirURL == null) {
            dirURL = ClassLoader.getSystemResource(String.valueOf(helpHome) + "_" + Locale.getDefault().getLanguage() + SEP);
        }
        if (dirURL == null) {
            dirURL = ClassLoader.getSystemResource(String.valueOf(helpHome) + SEP);
        }
        try {
            this.help = new KomodoHelp((Frame)caller, dirURL.toString(), FILENAME, null, this.helpTitleString, this.TOPIC_DIM, this.TOPIC_LOC);
        }
        catch (Exception exception) {
            System.err.println("Exception during help initialization");
            this.help = null;
        }
    }

    public void show(String section) {
        this.showTopic(section);
    }

    public void showTopic(String section) {
        if (this.help == null) {
            this.helpNotInitializedError();
            return;
        }
        String topic = (String)dict.get(section);
        if (topic == null) {
            topic = (String)dict.get("TOPICdefault");
        }
        this.help.showTopic(topic);
    }

    public void showIndex() {
        if (this.help == null) {
            this.helpNotInitializedError();
            return;
        }
        this.help.showIndex();
    }

    public void showContents() {
        if (this.help == null) {
            this.helpNotInitializedError();
            return;
        }
        this.help.showContents();
    }

    public void showSearch() {
        if (this.help == null) {
            this.helpNotInitializedError();
            return;
        }
        this.help.showSearch();
    }

    private void helpNotInitializedError() {
        if (this.alert == null) {
            this.alert = new Alert((Frame)this.parentFrame, this.helpNotInitializedString, 1, 1);
            this.alert.setTitle("Error");
        }
        this.alert.runAlert();
    }

    static {
        dict.put("TOPICdefault", "welcome_page");
        dict.put("TOPICsn", "netservice_address");
        dict.put("TOPICsnAdvancedAList", "netservice_options");
        dict.put("TOPICsnAdvanced", "netservice_advanced");
        dict.put("TOPIClsnrPrespawnServers", "listener_prespawn");
        dict.put("TOPIClsnrDatabaseServices", "listener_services");
        dict.put("TOPIClsnrGeneralParam", "listener_gen");
        dict.put("TOPIClsnrLoggingTracing", "listener_log");
        dict.put("TOPIClsnrAuth", "listener_authentication");
        dict.put("TOPIClsnrLsnrLocations", "listener_loc");
        dict.put("TOPIClsnrNaming", "listener_name");
        dict.put("TOPIClsnrOtherServices", "listener_oservices");
        dict.put("TOPICnamesMonitor", "names_monitor");
        dict.put("TOPICnamesControl", "names_control");
        dict.put("TOPICnamesTuning", "names_tuning");
        dict.put("TOPICnamesLogTrace", "names_logging");
        dict.put("TOPICnamesCache", "names_cache");
        dict.put("TOPICnamesAdvancedTuning", "names_mngsrvadvanced");
        dict.put("TOPICnamesService", "names_netsnames");
        dict.put("TOPICnamesAliases", "names_aliases");
        dict.put("TOPICnamesDBLinks", "names_dblinks");
        dict.put("TOPICnamesTopo", "names_topology");
        dict.put("TOPICnamesAdvancedRecords", "names_mngdataadvanced");
        dict.put("TOPICnamesConfigGeneral", "names_general");
        dict.put("TOPICnamesConfigAddress", "names_address");
        dict.put("TOPICnamesConfigDomain", "domains");
        dict.put("TOPICnamesConfigRegionDB", "names_database");
        dict.put("TOPICnamesConfigAdvanced", "names_advoptions");
        dict.put("TOPICprofNamingMethods", "profile_methods");
        dict.put("TOPICprofNamingONames", "profile_onames");
        dict.put("TOPICprofNamingNative", "profile_external");
        dict.put("TOPICprofGeneralTracing", "profile_tracing");
        dict.put("TOPICprofGeneralLogging", "profile_logging");
        dict.put("TOPICprofGeneralRouting", "profile_routing");
        dict.put("TOPICprofGeneralAdvanced", "profile_advanced");
        dict.put("TOPICprofPrefONamesServer", "profile_preferred");
        dict.put("TOPICanoAuthentication", "profile_authentication");
        dict.put("TOPICanoAuthParam", "profile_otherparams");
        dict.put("TOPICanoIntegrity", "profile_integrity");
        dict.put("TOPICanoEncryption", "profile_encryption");
        dict.put("TOPICanoSSL", "profile_ssl");
        dict.put("TOPICprofPStack", "listener_loc");
    }
}

