/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.net.asst.container.NetOKDialog;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.uniword.UniWordWrapper;

public class NetOpenSaveDialog
extends BufferedDialog
implements ActionListener {
    private static final int DLG_WIDTH = 400;
    private static final int DLG_HEIGHT = 250;
    private LWButton cancelButton;
    private LWButton browseButton;
    private LWButton openButton;
    private LWTextField dirField;
    BufferedFrame myOwner;
    private String cancelString;
    private String browseString;
    private String openString;
    private String dirString;
    private boolean saving = false;
    private Locale locale;

    public NetOpenSaveDialog(BufferedFrame fr, Locale loc, String titleId, String dir, boolean modalFlag) {
        super((Frame)fr, modalFlag);
        String msgdirString;
        String msgString;
        this.myOwner = fr;
        this.locale = loc;
        NetStrings netStrings = new NetStrings();
        this.dirString = dir;
        if (titleId.equals("CNTSaveConfTitle")) {
            this.saving = true;
            msgString = netStrings.getString("CNTSaveConfMsg");
            msgdirString = netStrings.getString("CNTSaveDirMsg");
            this.openString = netStrings.getString("CNTSave");
        } else {
            msgString = netStrings.getString("CNTOpenConfMsg");
            msgdirString = netStrings.getString("CNTOpenDirMsg");
            this.openString = netStrings.getString("CNTOpen");
        }
        String titleString = netStrings.getString(titleId);
        this.cancelString = netStrings.getString("CNTCancel");
        this.browseString = netStrings.getString("CNTBrowse");
        ((Dialog)((Object)this)).setTitle(titleString);
        TextWrapper wordwrap = UniWordWrapper.getTextWrapper();
        MultiLineLabel mainmsg = new MultiLineLabel(wordwrap, msgString);
        mainmsg.setAlignment(1);
        mainmsg.setPreferredAspectRatio(6.0f);
        LWLabel msgdirLabel = new LWLabel(msgdirString);
        this.dirField = new LWTextField(this.dirString);
        this.browseButton = new LWButton(this.browseString);
        this.browseButton.addActionListener((ActionListener)this);
        this.openButton = new LWButton(this.openString);
        this.openButton.addActionListener((ActionListener)this);
        this.openButton.setLeftmost(true);
        this.cancelButton = new LWButton(this.cancelString);
        this.cancelButton.addActionListener((ActionListener)this);
        this.cancelButton.setRightmost(true);
        EwtContainer topPanel = new EwtContainer();
        topPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        topPanel.add((Component)mainmsg, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets.top = 20;
        topPanel.add((Component)msgdirLabel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets.top = 2;
        topPanel.add((Component)this.dirField, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 3;
        topPanel.add((Component)this.browseButton, gbc);
        EwtContainer buttonPanel = new EwtContainer();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add((Component)this.openButton);
        buttonPanel.add((Component)this.cancelButton);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 14;
        gbc.weighty = 1.0;
        gbc.insets.top = 20;
        topPanel.add((Component)buttonPanel, gbc);
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)topPanel, "Center");
        ((Dialog)((Object)this)).setResizable(false);
        ((Component)((Object)this)).setSize(400, 250);
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(this.browseString)) {
            FileDialog fileDialog = this.saving ? new FileDialog((Frame)this.myOwner, "", 1) : new FileDialog((Frame)this.myOwner, "", 0);
            fileDialog.setModal(true);
            fileDialog.setDirectory(this.dirString);
            fileDialog.setFile("sqlnet.ora");
            fileDialog.show();
            if (fileDialog.getFile() == null) {
                return;
            }
            String newDir = fileDialog.getDirectory();
            this.dirField.setText(newDir);
            return;
        }
        if (cmd.equals(this.cancelString)) {
            this.dirString = null;
        } else {
            this.dirString = this.dirField.getText();
            File dir = new File(this.dirString);
            if (!dir.isDirectory()) {
                Object[] parms = new Object[]{this.dirString};
                NetOKDialog dlg = new NetOKDialog(this.myOwner, this.locale, "CNTOpenFailTitle", "CNTOpenFailMsg", parms);
                Toolkit toolkit = this.myOwner.getToolkit();
                Dimension dim = toolkit.getScreenSize();
                Dimension dim1 = ((Component)((Object)dlg)).getSize();
                ((Component)((Object)dlg)).setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
                ((Dialog)((Object)dlg)).setModal(true);
                ((Dialog)((Object)dlg)).show();
                String os = System.getProperty("os.name");
                if (os.equals("Windows NT") || os.equals("Windows 95")) {
                    this.myOwner.toFront();
                }
                return;
            }
            String filesep = System.getProperty("file.separator");
            if (this.dirString.charAt(this.dirString.length() - 1) != filesep.charAt(0)) {
                this.dirString = this.dirString.concat(filesep);
            }
        }
        this.dispose();
        this.myOwner.requestFocus();
    }

    public String getDirectory() {
        return this.dirString;
    }
}

