/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.net.asst.container.NetUtils;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetPanel
extends EwtContainer {
    private final int IWIDTH = 100;
    private final int IHEIGHT = 100;
    private final int MARGIN = 20;
    private Image m_image;
    private LWLabel message;
    private boolean fontInitialized = false;
    private static String imageDir = NetUtils.getImageDirectory();

    public NetPanel(Image i, String messageText) {
        this.m_image = i;
        if (messageText != null) {
            ((Container)((Object)this)).setLayout(null);
            this.message = new LWLabel(messageText, 1);
            ((Container)((Object)this)).add((Component)this.message);
        }
    }

    public NetPanel(Image i) {
        this(i, null);
    }

    public NetPanel(WebApplication w, String imgString) {
        this(w, String.valueOf(imageDir) + imgString, null);
    }

    public NetPanel(WebApplication w, String imgString, String messageText) {
        this(Toolkit.getDefaultToolkit().getImage(String.valueOf(imageDir) + imgString), messageText);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.fontInitialized && this.message != null) {
            Font f = this.message.getFont();
            this.message.setFont(new Font(f.getName(), f.getStyle(), f.getSize()));
            this.fontInitialized = true;
        }
    }

    public void paintCanvasInterior(Graphics g) {
        Rectangle bounds = this.getCanvasBounds();
        if (this.message == null) {
            if (this.m_image != null) {
                g.drawImage(this.m_image, 0, 0, bounds.width, bounds.height, (ImageObserver)((Object)this));
            }
        } else if (this.m_image != null) {
            g.drawImage(this.m_image, bounds.width - 20 + 1 - 100, 22, 100, 100, (ImageObserver)((Object)this));
            Dimension msgBounds = this.message.getPreferredSize();
            this.message.setBounds(20, 130, msgBounds.width, msgBounds.height);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            ((Component)((Object)this)).repaint();
            return false;
        }
        return true;
    }
}

