/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.net.asst.container.NetApplication;
import oracle.net.asst.container.NetHelp;
import oracle.net.common.NetGetEnv;

public class NetUtils {
    static NetHelp helpContext;
    static NetApplication application;
    static String imageDirString;
    public static final char SEP;

    public static final void setHelpContext(NetHelp help) {
        helpContext = help;
    }

    public static final NetHelp getHelpContext() {
        return helpContext;
    }

    public static final void setApplication(NetApplication app) {
        application = app;
    }

    public static final NetApplication getApplication() {
        return application;
    }

    public static String getImageDirectory() {
        if (imageDirString == null) {
            String dir = NetGetEnv.getOracleHome();
            int i = dir.length() - 1;
            while (i >= 0) {
                if (dir.charAt(i) != SEP) break;
                --i;
            }
            imageDirString = String.valueOf(dir.substring(0, i + 1)) + SEP + "network" + SEP + "tools" + SEP + "images" + SEP;
        }
        return imageDirString;
    }

    public static boolean isSameHost(String host1, String host2) throws UnknownHostException {
        try {
            String hostTwo;
            String hostOne;
            InetAddress nullHost;
            if (host1 == null) {
                nullHost = InetAddress.getLocalHost();
                hostOne = nullHost.getHostName();
            } else {
                hostOne = host1;
            }
            String host1Addr = InetAddress.getByName(hostOne).getHostAddress();
            if (host2 == null) {
                nullHost = InetAddress.getLocalHost();
                hostTwo = nullHost.getHostName();
            } else {
                hostTwo = host2;
            }
            String host2Addr = InetAddress.getByName(hostTwo).getHostAddress();
            return host1Addr.equals(host2Addr);
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                throw (UnknownHostException)e;
            }
            System.err.println(e);
            return false;
        }
    }

    static {
        imageDirString = null;
        SEP = File.separatorChar;
    }
}

