/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.container;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.InvalidErrorDialog;
import oracle.net.asst.container.RangeErrorDialog;

public class NetValidate {
    BufferedFrame frame;
    Toolkit toolkit;
    String os;

    public NetValidate(BufferedFrame fr) {
        this.frame = fr;
        this.toolkit = fr.getToolkit();
        this.os = System.getProperty("os.name");
    }

    public boolean validateNumber(LWTextField f, int low, int high) {
        int value;
        String s = f.getText();
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return value >= low && value <= high;
    }

    public void validateNumber(KeyEvent evt, String fieldName, int low, int high) {
        Component cmp = evt.getComponent();
        char ch = evt.getKeyChar();
        LWTextField f = (LWTextField)cmp;
        String s = f.getText();
        if (ch == '\b') {
            return;
        }
        if (Character.isDigit(ch)) {
            String valueStr = this.os.equals("Windows NT") || this.os.equals("Windows 95") ? new String(String.valueOf(s) + String.valueOf(ch)) : new String(s);
            int value = Integer.parseInt(valueStr);
            if (value >= low && value <= high) {
                return;
            }
            RangeErrorDialog rangeDialog = new RangeErrorDialog(this.frame, fieldName, low, high);
            Rectangle appSize = this.frame.getBounds();
            Dimension dlgSize = ((Component)((Object)rangeDialog)).getSize();
            ((Component)((Object)rangeDialog)).setLocation(appSize.x + (appSize.width - dlgSize.width) / 2, appSize.y + (appSize.height - dlgSize.height) / 2);
            ((Dialog)((Object)rangeDialog)).setModal(true);
            ((Dialog)((Object)rangeDialog)).show();
            if (this.os.equals("Windows NT") || this.os.equals("Windows 95")) {
                this.frame.toFront();
            }
        }
        if (this.os.equals("Windows NT") || this.os.equals("Windows 95")) {
            evt.setKeyChar('\u0000');
        } else {
            f.setText(s.substring(0, s.length() - 1));
        }
    }

    public void showDialog(String fieldName, int low, int high) {
        RangeErrorDialog rangeDialog = new RangeErrorDialog(this.frame, fieldName, low, high);
        Rectangle appSize = this.frame.getBounds();
        Dimension dlgSize = ((Component)((Object)rangeDialog)).getSize();
        ((Component)((Object)rangeDialog)).setLocation(appSize.x + (appSize.width - dlgSize.width) / 2, appSize.y + (appSize.height - dlgSize.height) / 2);
        ((Dialog)((Object)rangeDialog)).setModal(true);
        ((Dialog)((Object)rangeDialog)).show();
        if (this.os.equals("Windows NT") || this.os.equals("Windows 95")) {
            this.frame.toFront();
        }
    }

    public void showDialog(String fieldName) {
        InvalidErrorDialog rangeDialog = new InvalidErrorDialog(this.frame, fieldName);
        Rectangle appSize = this.frame.getBounds();
        Dimension dlgSize = ((Component)((Object)rangeDialog)).getSize();
        ((Component)((Object)rangeDialog)).setLocation(appSize.x + (appSize.width - dlgSize.width) / 2, appSize.y + (appSize.height - dlgSize.height) / 2);
        ((Dialog)((Object)rangeDialog)).setModal(true);
        ((Dialog)((Object)rangeDialog)).show();
        if (this.os.equals("Windows NT") || this.os.equals("Windows 95")) {
            this.frame.toFront();
        }
    }

    public boolean validateHostName(LWTextField f) {
        String s = f.getText();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '_' && ch != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validateName(LWTextField f) {
        return this.validateName(f.getText());
    }

    public boolean validateName(String s) {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

