/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.net.asst.container.NetOKDialog;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerAuthentication
extends EwtContainer
implements ListenerCache,
ItemListener,
KeyListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private NetStrings ns = ListenerGeneric.getNS();
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private boolean changed = false;
    private String authString;
    private String requiredString;
    private String notRequiredString;
    private String passwordString;
    private String confirmString;
    private LWLabel passwordLabel;
    private LWLabel confirmLabel;
    private LWCheckbox requiredBox;
    private LWCheckbox notRequiredBox;
    private LWCheckboxGroup logGroup = new LWCheckboxGroup();
    private int pwCount;
    private String[] pwArray;
    private EwtContainer passwordsPanel;
    private LWPasswordField passwordField;
    private LWPasswordField confirmField;

    public ListenerAuthentication() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        ((GridBagLayout)((Container)((Object)this)).getLayout()).setConstraints((Component)((Object)this), gbc);
        this.authString = new String(this.ns.getString("LCCAuthentication"));
        this.requiredString = new String(this.ns.getString("LCCPasswordRequired"));
        this.notRequiredString = new String(this.ns.getString("LCCPasswordNotRequired"));
        this.passwordString = new String(this.ns.getString("LCCPassword"));
        this.confirmString = new String(this.ns.getString("LCCConfirmPassword"));
        this.passwordLabel = new LWLabel(this.passwordString);
        this.confirmLabel = new LWLabel(this.confirmString);
        this.passwordField = new LWPasswordField("", 20);
        this.confirmField = new LWPasswordField("", 20);
        this.passwordField.addKeyListener(this);
        this.confirmField.addKeyListener(this);
        this.confirmField.setEditable(false);
        this.requiredBox = new LWCheckbox(this.requiredString, this.logGroup, false);
        this.notRequiredBox = new LWCheckbox(this.notRequiredString, this.logGroup, true);
        this.requiredBox.addItemListener((ItemListener)this);
        this.notRequiredBox.addItemListener((ItemListener)this);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.notRequiredBox, 0, 0, 1, 1, 15, 15, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.requiredBox, 0, 1, 1, 1, 0, 15, 0, 0);
        this.passwordsPanel = new EwtContainer();
        this.passwordsPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.passwordsPanel.setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)this.passwordsPanel, (Component)this.passwordLabel, 0, 0, 1, 1, 10, 0, 10, 0);
        ListenerGeneric.constrain((Container)this.passwordsPanel, (Component)this.passwordField, 1, 0, 1, 1, 10, 0, 10, 0);
        ListenerGeneric.constrain((Container)this.passwordsPanel, (Component)this.confirmLabel, 0, 1, 1, 1, 0, 0, 10, 0);
        ListenerGeneric.constrain((Container)this.passwordsPanel, (Component)this.confirmField, 1, 1, 1, 1, 0, 0, 10, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.passwordsPanel, 0, 1, 1, 1, 0, 10, 10, 10, 1);
        ListenerGeneric.constrain((Container)((Object)this), (Component)new LWLabel(" "), 0, 2, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public void addNotify() {
        super.addNotify();
        this.requiredBox.setBackground(this.requiredBox.getBackground());
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
        this.changed = true;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.requiredBox)) {
            this.passwordsPanel.setEnabled(true);
            this.passwordField.setEditable(true);
            this.confirmField.setEditable(true);
            this.passwordsPanel.repaint(0L);
        } else if (source.equals(this.notRequiredBox)) {
            this.passwordsPanel.setEnabled(false);
            this.passwordField.setEditable(false);
            this.confirmField.setEditable(false);
        }
        this.changed = true;
    }

    public void setListenerName(String s) {
        this.name = s;
    }

    public void set() {
        if (this.notRequiredBox.getState()) {
            this.nlpa.removeNLPListElement("PASSWORDS_" + this.name);
            this.changed = false;
            return;
        }
        try {
            String s = "(" + this.passwordField.getText();
            if (this.pwCount > 1) {
                int i = 1;
                while (i < this.pwCount) {
                    s = String.valueOf(s) + ", " + this.pwArray[i - 1];
                    ++i;
                }
            }
            s = String.valueOf(s) + ")";
            this.nlpa.addNLPListElement("PASSWORDS_" + this.name + "=" + s);
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("ListenerAuthentication.set: nlpa exception");
        }
        this.changed = false;
    }

    public void get() {
        NVPair nvp = this.nlpa.getNLPListElement("PASSWORDS_" + this.name);
        if (nvp != null) {
            if (nvp.getRHSType() == NVPair.RHS_LIST) {
                this.pwCount = nvp.getListSize();
                this.pwArray = new String[this.pwCount - 1];
                this.passwordField.setText(nvp.getListElement(0).getAtom());
                this.confirmField.setText(nvp.getListElement(0).getAtom());
                int i = 1;
                while (i < this.pwCount) {
                    this.pwArray[i - 1] = nvp.getListElement(i).getAtom();
                    ++i;
                }
            } else if (nvp.getRHSType() == NVPair.RHS_ATOM) {
                this.pwCount = 1;
                this.passwordField.setText(nvp.getAtom());
                this.confirmField.setText(nvp.getAtom());
            }
            this.requiredBox.setState(true);
            this.passwordsPanel.setEnabled(true);
            this.passwordField.setEditable(true);
            this.confirmField.setEditable(true);
        } else {
            this.requiredBox.setState(false);
            this.passwordsPanel.setEnabled(false);
            this.passwordField.setEditable(false);
            this.confirmField.setEditable(false);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        return this.notRequiredBox.getState() || this.passwordField.getText().length() > 0 && this.confirmField.getText().equals(this.passwordField.getText());
    }

    public void setFocus() {
        NetOKDialog dialog;
        if (this.passwordField.getText().length() == 0) {
            dialog = new NetOKDialog((BufferedFrame)ListenerGeneric.getApp().getFrame(), null, "nnaError", "LCCMustSpecifyPassword", null);
            this.passwordField.requestFocus();
        } else {
            dialog = new NetOKDialog((BufferedFrame)ListenerGeneric.getApp().getFrame(), null, "nnaError", "LCCPasswordsDontMatch", null);
            this.confirmField.requestFocus();
            this.confirmField.selectAll();
        }
        ((Dialog)((Object)dialog)).show();
    }
}

