/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerConfigure;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerNameDialog;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerComponent
extends NetComponent {
    NetStrings ns = ListenerGeneric.getNS();
    private final String TITLE = this.ns.getString("LCCListeners");
    private final String FILENAME = "listener.ora";
    private NLParamParser nlpa;
    private WebApplication app;
    private NetPanel lsnrPlacebo;
    private NetVector lsnrVector;
    private ListenerConfigure activeLsnr;
    private ListenerNameDialog dialog;
    private boolean changed = false;
    private boolean snmp_rw_exists = false;
    private final String[] ignoreArray = new String[]{"SSL_CIPHER_SUITES"};
    private final String[] paramArray = new String[]{"CONNECT_TIMEOUT_", "LOG_DIRECTORY_", "LOG_FILE_", "LOGGING_", "PASSWORDS_", "SAVE_CONFIG_ON_STOP_", "SID_LIST_", "STARTUP_WAIT_TIME_", "TRACE_DIRECTORY_", "TRACE_FILE_", "TRACE_LEVEL_", "USE_PLUG_AND_PLAY_", "SERVICE_LIST_"};

    public ListenerComponent(WebApplication w) {
        ListenerGeneric.setTrace();
        this.lsnrVector = new NetVector();
        this.app = w;
        ListenerGeneric.setApp(this.app);
        ListenerGeneric.setHelp(NetUtils.getHelpContext());
        this.lsnrPlacebo = new NetPanel(w, "LC_placebo.gif", this.ns.getString("LCCIntroMessage"));
    }

    public EwtContainer activateObject(Object o) {
        if (o != null && o instanceof ListenerConfigure) {
            this.activeLsnr = (ListenerConfigure)o;
            return (EwtContainer)o;
        }
        this.activeLsnr = null;
        return this.lsnrPlacebo;
    }

    public String toString() {
        return this.TITLE;
    }

    public NetVector getObjects(String s) {
        ListenerGeneric.devTrc("ListenerComponent::getObjects " + s);
        Enumeration enumeration = this.lsnrVector.elements();
        while (enumeration.hasMoreElements()) {
            ((ListenerConfigure)enumeration.nextElement()).finalizeListener();
        }
        this.lsnrVector.removeAllElements();
        try {
            this.nlpa = new NLParamParser(String.valueOf(s) + "listener.ora");
            ListenerGeneric.setNLP(this.nlpa);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("IOException");
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("NLException");
        }
        String[] nameArray = this.nlpa.getNLPAllNames();
        int i = 0;
        while (i < nameArray.length) {
            boolean match = false;
            int j = 0;
            while (j < this.paramArray.length) {
                if (nameArray[i].startsWith(this.paramArray[j])) {
                    match = true;
                    break;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < this.ignoreArray.length) {
                if (nameArray[i].startsWith(this.ignoreArray[j2])) {
                    match = true;
                    break;
                }
                ++j2;
            }
            if (!match) {
                this.loadListener(s, nameArray[i]);
            }
            ++i;
        }
        return this.lsnrVector;
    }

    public void loadListener(String dir, String s) {
        ListenerGeneric.devTrc("loading listener " + s);
        StringBuffer snmpInfo = new StringBuffer();
        NetValidate valid = new NetValidate((BufferedFrame)this.app.getFrame());
        if (!valid.validateName(s)) {
            ListenerGeneric.devTrc("Invalid listener name found in listener.ora.  Skipping.");
            return;
        }
        ListenerConfigure newLsnr = new ListenerConfigure(s);
        if (this.readSNMP(dir, s, snmpInfo)) {
            newLsnr.setSNMP(snmpInfo.toString());
        } else {
            newLsnr.disableSNMP();
        }
        this.lsnrVector.addElement(newLsnr);
    }

    public boolean saveObjects(String s) {
        boolean valid = true;
        ListenerGeneric.devTrc("ListenerComponent::saveObjects");
        int i = 0;
        while (i < this.lsnrVector.size()) {
            if (!((ListenerConfigure)this.lsnrVector.elementAt(i)).validateConfig()) {
                valid = false;
            }
            ++i;
        }
        if (!valid) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.lsnrVector.size()) {
            ((ListenerConfigure)this.lsnrVector.elementAt(i2)).set();
            if (((ListenerConfigure)this.lsnrVector.elementAt(i2)).snmpChanged()) {
                this.writeSNMP(s, ((ListenerConfigure)this.lsnrVector.elementAt(i2)).toString(), ((ListenerConfigure)this.lsnrVector.elementAt(i2)).getSNMP());
            }
            ++i2;
        }
        try {
            this.nlpa.saveNLParams(String.valueOf(s) + "listener.ora");
        }
        catch (IOException iOException) {
            System.out.println("failed");
            return false;
        }
        ListenerGeneric.devTrc("--saved--");
        this.changed = false;
        return true;
    }

    public boolean discardObjects() {
        ListenerGeneric.devTrc("ListenerComponent::discardObjects");
        Enumeration e = this.lsnrVector.elements();
        while (e.hasMoreElements()) {
            ((ListenerConfigure)e.nextElement()).finalizeListener();
        }
        this.lsnrVector.removeAllElements();
        this.nlpa.removeNLPAllElements();
        return true;
    }

    public boolean isChanged() {
        if (this.changed) {
            ListenerGeneric.devTrc("--changed--");
            return true;
        }
        int i = 0;
        while (i < this.lsnrVector.size()) {
            if (((ListenerConfigure)this.lsnrVector.elementAt(i)).isChanged()) {
                ListenerGeneric.devTrc("--changed--");
                return true;
            }
            ++i;
        }
        ListenerGeneric.devTrc("--not changed--");
        return false;
    }

    public boolean deactivateObject(Object o) {
        if (o != null) {
            return ((ListenerConfigure)o).validateConfig();
        }
        return true;
    }

    public Object createObject(Object o, String defDomain) {
        if (this.activeLsnr != null && !this.activeLsnr.validateConfig()) {
            return null;
        }
        ListenerGeneric.setDomain(defDomain);
        return this.createObject(o);
    }

    public Object createObject(Object o) {
        ListenerGeneric.devTrc("ListenerComponent::createObject");
        boolean done = false;
        BufferedFrame fr = (BufferedFrame)this.app.getFrame();
        Toolkit toolkit = fr.getToolkit();
        String defaultName = this.nextDefaultName();
        while (!done) {
            this.dialog = new ListenerNameDialog(this.app, defaultName);
            Dimension dim = toolkit.getScreenSize();
            Dimension dim1 = ((Component)((Object)this.dialog)).getSize();
            ((Component)((Object)this.dialog)).setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
            ((Dialog)((Object)this.dialog)).setModal(true);
            ((Dialog)((Object)this.dialog)).show();
            if (this.dialog.getName() == null) {
                return null;
            }
            NetValidate valid = new NetValidate((BufferedFrame)this.app.getFrame());
            if (!valid.validateName(this.dialog.getName()) || this.lsnrVector.findObjectByName(this.dialog.getName()) != null) {
                valid.showDialog(this.ns.getString("LCCListenerName"));
                defaultName = this.dialog.getName();
                continue;
            }
            done = true;
        }
        this.changed = true;
        ListenerConfigure newLsnr = new ListenerConfigure(this.dialog.getName());
        return newLsnr;
    }

    public boolean deleteObject(Object o) {
        ListenerGeneric.devTrc("ListenerComponent::deleteObject");
        ((ListenerConfigure)o).finalizeListener();
        ListenerGeneric.setAllowInvalid(true);
        boolean result = this.lsnrVector.removeElement(o);
        ListenerGeneric.setAllowInvalid(false);
        int i = 0;
        while (i < this.paramArray.length) {
            this.nlpa.removeNLPListElement(String.valueOf(this.paramArray[i]) + o.toString());
            ++i;
        }
        this.nlpa.removeNLPListElement(o.toString());
        this.changed = true;
        return result;
    }

    public boolean Comp_file_has_Comments() {
        return this.nlpa.fileHasComments();
    }

    private String nextDefaultName() {
        int count = this.lsnrVector.size();
        if (this.lsnrVector.findObjectByName("LISTENER") == null) {
            return "LISTENER";
        }
        int i = 1;
        while (i < count + 1) {
            if (this.lsnrVector.findObjectByName("LISTENER" + i) == null) {
                return "LISTENER" + i;
            }
            ++i;
        }
        return "LISTENER" + (count + 1);
    }

    private boolean readSNMP(String dir, String lsnr, StringBuffer outString) {
        int index;
        FileInputStream fis = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        String correctLine = null;
        try {
            String line;
            File f = new File(dir, "snmp_rw.ora");
            fis = new FileInputStream(f);
            is = new InputStreamReader(fis);
            br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                index = line.indexOf(61);
                if (index == -1 || !line.substring(0, index).trim().equalsIgnoreCase("SNMP.CONTACT." + lsnr)) continue;
                correctLine = line;
            }
            fis.close();
            is.close();
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        if (correctLine == null) {
            return false;
        }
        index = correctLine.indexOf(61);
        if (index == -1) {
            return false;
        }
        outString.append(correctLine.substring(index + 1).trim());
        this.snmp_rw_exists = true;
        return true;
    }

    private void writeSNMP(String dir, String lsnr, String info) {
        if (!this.snmp_rw_exists) {
            return;
        }
        ListenerGeneric.devTrc("would write: snmp.contact." + lsnr + "=" + info);
        Vector<String> linebuffer = new Vector<String>(100, 50);
        try {
            String line;
            File f = new File(dir, "snmp_rw.ora");
            FileInputStream fis = new FileInputStream(f);
            InputStreamReader is = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                int index = line.indexOf(61);
                if (index != -1 && line.substring(0, index).trim().equalsIgnoreCase("SNMP.CONTACT." + lsnr)) {
                    linebuffer.addElement("snmp.contact." + lsnr + "=" + info);
                    continue;
                }
                linebuffer.addElement(line);
            }
            fis.close();
            is.close();
            br.close();
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter os = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(os);
            int i = 0;
            while (i < linebuffer.size()) {
                bw.write((String)linebuffer.elementAt(i));
                bw.newLine();
                ++i;
            }
            bw.flush();
            fos.close();
            os.close();
            bw.close();
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("writeSNMP exception");
        }
    }

    public NLParamParser getNLPA() {
        return this.nlpa;
    }
}

