/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.net.asst.container.NetOKDialog;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetValidate;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerPrespawnDesc;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ListenerDBServicePage
extends EwtContainer
implements ItemListener,
ActionListener,
SpinBoxListener,
KeyListener {
    private int initialMax;
    private int totalPrespawns;
    private int totalPrespawnsBak;
    private int tcpPs;
    private int tcpTo;
    private int spxPs;
    private int spxTo;
    private int nmpPs;
    private int nmpTo;
    private int ipcPs;
    private int ipcTo;
    private boolean changed = false;
    private LWCheckbox usePrespawnsBox;
    private LWCheckbox dontUsePrespawnsBox;
    private LWCheckboxGroup usePrespawnsGroup;
    private LWButton configPrespawnsButton;
    private EwtContainer configPrespawnPanel;
    private EwtContainer prespawnPanel;
    private BufferedDialog configPrespawnDialog;
    private EwtContainer psButtonPanel;
    private LWButton psOkButton;
    private LWButton psCancelButton;
    private LWButton psHelpButton;
    private ListenerPrespawnDesc tcpDesc;
    private ListenerPrespawnDesc spxDesc;
    private ListenerPrespawnDesc nmpDesc;
    private ListenerPrespawnDesc ipcDesc;
    private LWLabel prespawnHintA;
    private LWLabel prespawnHintB;
    private LWLabel prespawnHintC;
    private LWTextField globalNameField;
    private LWTextField oraHomeField;
    private LWTextField sidField;
    private LWTextField prespawnMaxField;
    private LWLabel globalDBNameLabel;
    private LWLabel oraHomeLabel;
    private LWLabel sidLabel;
    private LWLabel noPrespawnsLabel;
    private LWLabel maxPrespawnLabel;
    private NetValidate netValidate;
    private LWTextField invalidField;
    private NetStrings ns = ListenerGeneric.getNS();
    private String name;
    private String usePrespawnsString;
    private String dontUsePrespawnsString;
    private String configPrespawnsString;
    private String prespawnMaxBak;
    private String psOkString;
    private String psCancelString;
    private String psHelpString;
    private String invalidString;
    private String prespawnHelpTopic = "TOPIClsnrPrespawnServers";
    private boolean dialogCancelled = false;

    public ListenerDBServicePage(NVPair nvp) {
        this.buildUI();
        this.buildPrespawnDialog();
        this.netValidate = new NetValidate((BufferedFrame)ListenerGeneric.getApp().getFrame());
        boolean atLeastOnePrespawnFound = false;
        if (nvp == null) {
            this.globalNameField.setText("Oracle8" + ListenerGeneric.getDomain());
            this.sidField.setText("ORCL");
            String os = System.getProperty("os.name");
            if (os.equals("Windows NT") || os.equals("Windows 95")) {
                this.oraHomeField.setText("");
            } else {
                this.oraHomeField.setText(ListenerGeneric.getOraHome());
            }
        } else {
            NVNavigator nav = new NVNavigator();
            NVPair tmpnvp = nav.findNVPair(nvp, "GLOBAL_DBNAME");
            this.globalNameField.setText(tmpnvp == null ? "" : tmpnvp.getAtom());
            tmpnvp = nav.findNVPair(nvp, "SID_NAME");
            this.sidField.setText(tmpnvp == null ? "" : tmpnvp.getAtom());
            tmpnvp = nav.findNVPair(nvp, "ORACLE_HOME");
            this.oraHomeField.setText(tmpnvp == null ? "" : tmpnvp.getAtom());
            tmpnvp = nav.findNVPair(nvp, "PRESPAWN_MAX");
            if (tmpnvp != null) {
                String prespawnMaxValue = tmpnvp.getAtom();
                tmpnvp = nav.findNVPair(nvp, "PRESPAWN_LIST");
                if (tmpnvp == null) {
                    NVPair descnvp = nav.findNVPair(nvp, "PRESPAWN_DESC");
                    NVPair protnvp = nav.findNVPair(descnvp, "PROTOCOL");
                    if (protnvp != null) {
                        NVPair psnvp = nav.findNVPair(descnvp, "POOL_SIZE");
                        NVPair tonvp = nav.findNVPair(descnvp, "TIMEOUT");
                        try {
                            this.setPrespawnFields(protnvp.getAtom(), psnvp == null ? "0" : psnvp.getAtom(), tonvp == null ? "0" : tonvp.getAtom());
                            atLeastOnePrespawnFound = true;
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e);
                        }
                    }
                } else {
                    int i = 0;
                    while (i < tmpnvp.getListSize()) {
                        NVPair descnvp = tmpnvp.getListElement(i);
                        NVPair protnvp = nav.findNVPair(descnvp, "PROTOCOL");
                        if (protnvp != null) {
                            NVPair psnvp = nav.findNVPair(descnvp, "POOL_SIZE");
                            NVPair tonvp = nav.findNVPair(descnvp, "TIMEOUT");
                            try {
                                this.setPrespawnFields(protnvp.getAtom(), psnvp == null ? "0" : psnvp.getAtom(), tonvp == null ? "0" : tonvp.getAtom());
                                atLeastOnePrespawnFound = true;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println(e);
                            }
                        }
                        ++i;
                    }
                }
                if (atLeastOnePrespawnFound) {
                    this.prespawnMaxField.setText(prespawnMaxValue);
                }
            }
        }
        this.usePrespawnsBox.setState(atLeastOnePrespawnFound);
        this.configPrespawnsButton.setEnabled(atLeastOnePrespawnFound);
        this.totalPrespawns = this.getPrespawnTotal();
        this.backupPrespawnConfig();
    }

    private void buildUI() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.globalDBNameLabel = new LWLabel(this.ns.getString("LCCGlobalDBName"));
        this.globalNameField = new LWTextField(25);
        this.oraHomeField = new LWTextField(25);
        this.sidField = new LWTextField(25);
        this.globalNameField.addKeyListener(this);
        this.oraHomeField.addKeyListener(this);
        this.sidField.addKeyListener(this);
        this.oraHomeLabel = new LWLabel(this.ns.getString("LCCOracleHomeDir"));
        this.sidLabel = new LWLabel(this.ns.getString("LCCSID"));
        this.usePrespawnsString = new String(this.ns.getString("LCCUsePrespawns"));
        this.dontUsePrespawnsString = new String(this.ns.getString("LCCDontUsePrespawns"));
        this.configPrespawnsString = new String(this.ns.getString("LCCConfigurePrespawns"));
        this.noPrespawnsLabel = new LWLabel(this.ns.getString("LCCPrespawnsNotAvailable"));
        this.usePrespawnsGroup = new LWCheckboxGroup();
        this.usePrespawnsBox = new LWCheckbox(this.usePrespawnsString, this.usePrespawnsGroup, false);
        this.usePrespawnsBox.addItemListener((ItemListener)this);
        this.dontUsePrespawnsBox = new LWCheckbox(this.dontUsePrespawnsString, this.usePrespawnsGroup, true);
        this.dontUsePrespawnsBox.addItemListener((ItemListener)this);
        this.configPrespawnPanel = new EwtContainer();
        this.configPrespawnPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.configPrespawnPanel.setLayout(new GridBagLayout());
        this.configPrespawnsButton = new LWButton(this.configPrespawnsString);
        this.configPrespawnsButton.addActionListener((ActionListener)this);
        ListenerGeneric.constrain((Container)this.configPrespawnPanel, (Component)this.configPrespawnsButton, 0, 0, 1, 1, 15, 10, 15, 10, 1);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.globalDBNameLabel, 0, 0, 1, 1, 10, 10, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.globalNameField, 1, 0, 1, 1, 10, 0, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.oraHomeLabel, 0, 1, 1, 1, 0, 10, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.oraHomeField, 1, 1, 1, 1, 0, 0, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.sidLabel, 0, 2, 1, 1, 0, 10, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.sidField, 1, 2, 1, 1, 0, 0, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.dontUsePrespawnsBox, 0, 3, 0, 1, 10, 15, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.usePrespawnsBox, 0, 4, 0, 1, 0, 15, 0, 10);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.configPrespawnPanel, 0, 4, 2, 1, 0, 10, 0, 10, 1);
        ListenerGeneric.constrain((Container)((Object)this), (Component)new LWLabel(" "), 0, 5, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    private void buildPrespawnDialog() {
        this.configPrespawnDialog = new BufferedDialog(ListenerGeneric.getApp().getFrame(), this.configPrespawnsString, false);
        this.maxPrespawnLabel = new LWLabel(this.ns.getString("LCCMaxPrespawns"));
        this.prespawnMaxField = new LWTextField(4);
        this.prespawnMaxField.addKeyListener(this);
        this.prespawnPanel = new EwtContainer();
        this.prespawnPanel.setLayout(new GridBagLayout());
        this.prespawnHintA = new LWLabel(this.ns.getString("LCCPrespawnHintA"));
        this.prespawnHintB = new LWLabel(this.ns.getString("LCCPrespawnHintB"));
        this.prespawnHintC = new LWLabel(this.ns.getString("LCCPrespawnHintC"));
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintA, 0, 0, 2, 1, 0, 10, 1.0, 0.0, 20, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintB, 0, 1, 2, 1, 0, 10, 1.0, 0.0, 0, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.prespawnHintC, 0, 2, 2, 1, 0, 10, 1.0, 0.0, 0, 10, 20, 0);
        if (ListenerGeneric.isTCPAllowed()) {
            this.tcpDesc = new ListenerPrespawnDesc("TCP", 0, 0);
            this.tcpDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCTCP")), 0, 3, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.tcpDesc), 1, 3, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isSPXAllowed()) {
            this.spxDesc = new ListenerPrespawnDesc("SPX", 0, 0);
            this.spxDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCSPX")), 0, 4, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.spxDesc), 1, 4, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isNMPAllowed()) {
            this.nmpDesc = new ListenerPrespawnDesc("NMP", 0, 0);
            this.nmpDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCNMP")), 0, 5, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 5, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.nmpDesc), 1, 5, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 5, 0);
        }
        if (ListenerGeneric.isIPCAllowed()) {
            this.ipcDesc = new ListenerPrespawnDesc("IPC", 0, 0);
            this.ipcDesc.setListener(this);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)new LWLabel(this.ns.getString("SNCIPC")), 0, 6, 1, 1, 0, 13, 1.0, 0.0, 0, 10, 10, 0);
            ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)((Object)this.ipcDesc), 1, 6, 1, 1, 0, 17, 1.0, 0.0, 0, 10, 10, 0);
        }
        EwtContainer maxPanel = new EwtContainer();
        maxPanel.setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)maxPanel, (Component)this.maxPrespawnLabel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 0, 0, 0, 0);
        ListenerGeneric.constrain((Container)maxPanel, (Component)this.prespawnMaxField, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 5, 0, 0);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)maxPanel, 0, 7, 2, 1, 0, 11, 1.0, 0.0, 10, 10, 10, 0);
        this.psOkString = new String(" " + this.ns.getString("LCCOK") + " ");
        this.psCancelString = new String(this.ns.getString("LCCCancel"));
        this.psHelpString = new String(this.ns.getString("LCCHelp"));
        this.psOkButton = new LWButton(this.psOkString);
        this.psCancelButton = new LWButton(this.psCancelString);
        this.psHelpButton = new LWButton(this.psHelpString);
        this.psOkButton.addActionListener((ActionListener)this);
        this.psCancelButton.addActionListener((ActionListener)this);
        this.psHelpButton.addActionListener((ActionListener)this);
        this.psButtonPanel = new EwtContainer();
        this.psButtonPanel.add((Component)this.psOkButton);
        this.psButtonPanel.add((Component)this.psCancelButton);
        this.psButtonPanel.add((Component)this.psHelpButton);
        ListenerGeneric.constrain((Container)this.prespawnPanel, (Component)this.psButtonPanel, 0, 8, 2, 1, 0, 15, 1.0, 1.0, 0, 0, 15, 0);
        this.configPrespawnDialog.add((Component)this.prespawnPanel, "Center");
        this.configPrespawnDialog.setSize(420, 360);
        Dimension dim = ListenerGeneric.getApp().getFrame().getToolkit().getScreenSize();
        Dimension dim1 = this.configPrespawnDialog.getSize();
        this.configPrespawnDialog.setLocation((dim.width - dim1.width) / 2, (dim.height - dim1.height) / 2);
    }

    public void addNotify() {
        super.addNotify();
        this.usePrespawnsBox.setBackground(this.usePrespawnsBox.getBackground());
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
        Object o = ke.getSource();
        char ch = ke.getKeyChar();
        this.changed = true;
        if (o == this.prespawnMaxField) {
            if (Character.isDigit(ch) || ch == '\b') {
                return;
            }
        } else if (o == this.sidField) {
            if (Character.isLetterOrDigit(ch) || ch == '\b' || ch == '_') {
                return;
            }
        } else {
            return;
        }
        ke.setKeyChar('\u0000');
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(this.configPrespawnsString)) {
            this.showPrespawnDialog();
        }
        if (cmd.equals(this.psOkString) && this.validatePrespawnDialog()) {
            this.dialogCancelled = false;
            this.configPrespawnDialog.dispose();
        }
        if (cmd.equals(this.psCancelString)) {
            this.dialogCancelled = true;
            this.configPrespawnDialog.dispose();
            this.restorePrespawnConfig();
        }
        if (cmd.equals(this.psHelpString)) {
            ListenerGeneric.getHelp().show(this.prespawnHelpTopic);
        }
    }

    private boolean validatePrespawnDialog() {
        int max = 0;
        int total = this.getPrespawnTotal();
        try {
            max = Integer.parseInt(this.prespawnMaxField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.prespawnMaxField.setText("");
        }
        if (max > 0 && total == 0 && !this.prespawnMaxField.getText().equals("")) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        if (total > 0 && !this.netValidate.validateNumber(this.prespawnMaxField, total, 999)) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        return true;
    }

    private void backupPrespawnConfig() {
        if (this.tcpDesc != null) {
            this.tcpPs = this.tcpDesc.getPoolSize();
            this.tcpTo = this.tcpDesc.getTimeout();
        }
        if (this.spxDesc != null) {
            this.spxPs = this.spxDesc.getPoolSize();
            this.spxTo = this.spxDesc.getTimeout();
        }
        if (this.nmpDesc != null) {
            this.nmpPs = this.nmpDesc.getPoolSize();
            this.nmpTo = this.nmpDesc.getTimeout();
        }
        if (this.ipcDesc != null) {
            this.ipcPs = this.ipcDesc.getPoolSize();
            this.ipcTo = this.ipcDesc.getTimeout();
        }
        this.prespawnMaxBak = this.prespawnMaxField.getText();
        this.totalPrespawnsBak = this.totalPrespawns;
    }

    private void restorePrespawnConfig() {
        if (this.tcpDesc != null) {
            this.tcpDesc.setFields(this.tcpPs, this.tcpTo);
        }
        if (this.spxDesc != null) {
            this.spxDesc.setFields(this.spxPs, this.spxTo);
        }
        if (this.nmpDesc != null) {
            this.nmpDesc.setFields(this.nmpPs, this.nmpTo);
        }
        if (this.ipcDesc != null) {
            this.ipcDesc.setFields(this.ipcPs, this.ipcTo);
        }
        this.prespawnMaxField.setText(this.prespawnMaxBak);
        this.totalPrespawns = this.totalPrespawnsBak;
    }

    public void itemStateChanged(ItemEvent e) {
        this.changed = true;
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.usePrespawnsBox) {
                this.configPrespawnsButton.setEnabled(true);
                this.showPrespawnDialog();
            } else {
                this.configPrespawnsButton.setEnabled(false);
            }
        }
    }

    public void spinBoxValueChanged(SpinBoxEvent e) {
        boolean bogus;
        int oldMax = 0;
        int newMax = 0;
        int oldTotal = this.totalPrespawns;
        this.changed = true;
        this.totalPrespawns = this.getPrespawnTotal();
        boolean incr = this.totalPrespawns > oldTotal;
        try {
            oldMax = Integer.parseInt(this.prespawnMaxField.getText());
            bogus = false;
        }
        catch (NumberFormatException numberFormatException) {
            bogus = true;
        }
        if (bogus) {
            newMax = this.totalPrespawns * 2;
        } else {
            if (oldTotal <= oldMax && incr) {
                newMax = oldMax + 2;
            }
            if (oldTotal > oldMax && incr) {
                newMax = this.totalPrespawns;
            }
            if (oldTotal >= oldMax && !incr) {
                newMax = this.totalPrespawns;
            }
            if (oldTotal < oldMax && !incr) {
                newMax = oldMax - 2;
            }
        }
        this.prespawnMaxField.setText(String.valueOf(newMax));
    }

    private void setPrespawnFields(String prot, String ps, String to) throws IllegalArgumentException {
        block10: {
            try {
                if (prot.equalsIgnoreCase("TCP")) {
                    if (this.tcpDesc != null) {
                        this.tcpDesc.setFields(ps, to);
                    }
                    break block10;
                }
                if (prot.equalsIgnoreCase("SPX")) {
                    if (this.spxDesc != null) {
                        this.spxDesc.setFields(ps, to);
                    }
                    break block10;
                }
                if (prot.equalsIgnoreCase("NMP")) {
                    if (this.nmpDesc != null) {
                        this.nmpDesc.setFields(ps, to);
                    }
                    break block10;
                }
                if (prot.equalsIgnoreCase("IPC")) {
                    if (this.ipcDesc != null) {
                        this.ipcDesc.setFields(ps, to);
                    }
                    break block10;
                }
                throw new IllegalArgumentException("Invalid protocol");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error setting prespawn description fields: " + e);
            }
        }
    }

    private int getPrespawnTotal() {
        int i = 0;
        if (this.tcpDesc != null) {
            i += this.tcpDesc.getPoolSize();
        }
        if (this.spxDesc != null) {
            i += this.spxDesc.getPoolSize();
        }
        if (this.nmpDesc != null) {
            i += this.nmpDesc.getPoolSize();
        }
        if (this.ipcDesc != null) {
            i += this.ipcDesc.getPoolSize();
        }
        return i;
    }

    public String toString() {
        String tmpOH = this.oraHomeField.getText();
        if (tmpOH.length() > 0 && tmpOH.charAt(tmpOH.length() - 1) == ListenerGeneric.getSeparator()) {
            tmpOH = tmpOH.substring(0, tmpOH.length() - 1);
        }
        String s = new String();
        s = String.valueOf(s) + "(SID_DESC=(GLOBAL_DBNAME=" + this.globalNameField.getText() + ")" + "(ORACLE_HOME=" + tmpOH + ")" + "(SID_NAME=" + this.sidField.getText() + ")";
        if (this.usePrespawnsBox.getState()) {
            s = String.valueOf(s) + "(PRESPAWN_MAX=" + this.prespawnMaxField.getText() + ")";
            s = String.valueOf(s) + "(PRESPAWN_LIST=";
            if (this.tcpDesc != null && this.tcpDesc.getPoolSize() > 0) {
                s = String.valueOf(s) + this.tcpDesc.toString();
            }
            if (this.spxDesc != null && this.spxDesc.getPoolSize() > 0) {
                s = String.valueOf(s) + this.spxDesc.toString();
            }
            if (this.nmpDesc != null && this.nmpDesc.getPoolSize() > 0) {
                s = String.valueOf(s) + this.nmpDesc.toString();
            }
            if (this.ipcDesc != null && this.ipcDesc.getPoolSize() > 0) {
                s = String.valueOf(s) + this.ipcDesc.toString();
            }
            s = String.valueOf(s) + ")";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public void setFocus() {
        if (this.invalidField == this.prespawnMaxField) {
            Object[] params = new String[]{"Prespawn Max", "", ""};
            NetOKDialog dialog = new NetOKDialog((BufferedFrame)ListenerGeneric.getApp().getFrame(), null, "CNTRangeErrorMsg", "LCCMaxPrespawnsHint", params);
            ((Dialog)((Object)dialog)).setModal(true);
            ((Dialog)((Object)dialog)).show();
            return;
        }
        this.netValidate.showDialog(this.invalidString);
        this.invalidField.requestFocus();
        this.invalidField.selectAll();
    }

    public boolean areDataValid() {
        if (this.globalNameField.getText().length() != 0 && !this.netValidate.validateHostName(this.globalNameField)) {
            this.invalidField = this.globalNameField;
            this.invalidString = this.globalDBNameLabel.getText();
            this.setFocus();
            return false;
        }
        if (!this.netValidate.validateName(this.sidField) || this.sidField.getText().length() == 0) {
            this.invalidField = this.sidField;
            this.invalidString = this.sidLabel.getText();
            this.setFocus();
            return false;
        }
        if (this.usePrespawnsBox.getState() && !this.validatePrespawnDialog()) {
            this.invalidField = this.prespawnMaxField;
            this.invalidString = this.maxPrespawnLabel.getText();
            this.setFocus();
            return false;
        }
        return true;
    }

    private void showPrespawnDialog() {
        this.backupPrespawnConfig();
        this.configPrespawnDialog.setModal(true);
        this.configPrespawnDialog.show();
    }

    public void setListenerName(String s) {
        this.name = s;
    }
}

