/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerDBServicePage;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.uniword.UniWordWrapper;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class ListenerDatabaseServices
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private String addString;
    private String removeString;
    private String helpString;
    private String databaseString;
    private TabPanel tp;
    private NetStrings ns = ListenerGeneric.getNS();
    private int dbCount;
    private boolean changed = false;
    private ListenerDBServicePage currDatabase;
    private LWLabel noDatabasesLabel;
    private EwtContainer noDatabasesPanel;
    private EwtContainer buttonPanel;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private final NVNavigator nav = new NVNavigator();
    private String dbHelpTopic = "TOPIClsnrDatabaseServices";

    public ListenerDatabaseServices() {
        ListenerGeneric.devTrc("entered ListenerDatabaseServices");
        this.databaseString = new String(this.ns.getString("LCCDatabase"));
        this.addString = new String(this.ns.getString("LCCAddDatabase"));
        this.removeString = new String(this.ns.getString("LCCRemoveDatabase"));
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.addButton = new LWButton(this.addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.addActionListener((ActionListener)this);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.buttonPanel = new EwtContainer();
        this.noDatabasesPanel = new EwtContainer();
        this.noDatabasesPanel.setLayout(new GridBagLayout());
        MultiLineLabel noDatabasesLabel = new MultiLineLabel(UniWordWrapper.getTextWrapper(), this.ns.getString("LCCNoDatabases"));
        noDatabasesLabel.setPreferredAspectRatio(10.0f);
        noDatabasesLabel.setAlignment(1);
        ListenerGeneric.constrain((Container)this.noDatabasesPanel, (Component)noDatabasesLabel, 2, 0, 0, 1, 1);
        ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.noDatabasesPanel, 0, 0);
        this.buttonPanel.add((Component)this.addButton);
        this.buttonPanel.add((Component)this.removeButton);
        this.buttonPanel.add((Component)this.helpButton);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.buttonPanel, 0, 1, 1, 1);
    }

    public void addDatabase(NVPair nvp) {
        TabPanel tmpPanel;
        if (this.tp == null) {
            tmpPanel = new TabPanel();
            tmpPanel.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.noDatabasesPanel);
        } else {
            tmpPanel = this.tp;
        }
        ListenerDBServicePage page = new ListenerDBServicePage(nvp);
        tmpPanel.addPage(String.valueOf(this.databaseString) + ++this.dbCount, (Component)((Object)page));
        tmpPanel.getPage(tmpPanel.getPageCount() - 1).setSelected(true);
        page.invalidate();
        ((Container)((Object)this)).validate();
        this.currDatabase = page;
        if (tmpPanel.getPageCount() == 1) {
            this.removeButton.setEnabled(true);
        }
        if (this.tp == null) {
            this.tp = tmpPanel;
        }
        ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.tp, 0, 0);
    }

    public void removeDatabase() {
        TabPanelPage page = this.tp.getSelectedPage();
        this.tp.removeTabPanelListener((TabPanelListener)this);
        this.tp.removePage(page);
        this.tp.addTabPanelListener((TabPanelListener)this);
        --this.dbCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currDatabase = null;
            ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.noDatabasesPanel, 0, 0);
        } else {
            this.currDatabase = (ListenerDBServicePage)((Object)this.tp.getSelectedPage().getContent());
            int i = 0;
            while (i < this.tp.getPageCount()) {
                this.tp.getPage(i).setLabel(String.valueOf(this.databaseString) + (i + 1));
                ++i;
            }
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        this.currDatabase = (ListenerDBServicePage)((Object)e.getPage().getContent());
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currDatabase != null && !this.currDatabase.areDataValid()) {
            ((Cancelable)e).cancel();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(this.addString)) {
            this.changed = true;
            if (this.currDatabase != null && !this.currDatabase.areDataValid()) {
                return;
            }
            this.addDatabase(null);
            return;
        }
        if (cmd.equals(this.removeString)) {
            this.changed = true;
            this.removeDatabase();
            return;
        }
        if (cmd.equals(this.helpString)) {
            ListenerGeneric.getHelp().showTopic(this.dbHelpTopic);
            return;
        }
    }

    public void setListenerName(String s) {
        this.name = s;
    }

    public void set() {
        NVPair nvp = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (this.tp == null) {
            if (!this.changed) {
                return;
            }
            nvp = this.stripDBsFromNVP(nvp);
        } else {
            String[] array = new String[this.tp.getPageCount()];
            int i = 0;
            while (i < this.tp.getPageCount()) {
                ListenerDBServicePage page = (ListenerDBServicePage)((Object)this.tp.getPage(i).getContent());
                array[i] = page.toString();
                if (page.isChanged()) {
                    page.setChanged(false);
                    this.changed = true;
                }
                ++i;
            }
            if (this.changed) {
                NVPair tmpnvp = this.stripDBsFromNVP(nvp);
                nvp = this.addDBsToNVP(tmpnvp, array);
            } else {
                return;
            }
        }
        try {
            if (nvp != null) {
                NVPair sidList = this.nav.findNVPair(nvp, "SID_LIST");
                if (sidList == null || sidList.getListSize() == 0) {
                    this.nlpa.removeNLPListElement("SID_LIST_" + this.name);
                } else {
                    this.nlpa.addNLPListElement(nvp.toString());
                }
            }
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("LDS set failed");
        }
        this.changed = false;
    }

    public void get() {
        NVPair nvp = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (nvp != null) {
            NVPair tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
            if (tmpnvp != null) {
                NVPair prognvp = this.nav.findNVPair(tmpnvp, "PROGRAM");
                if (prognvp == null) {
                    this.addDatabase(tmpnvp);
                }
            } else {
                tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
                if (tmpnvp != null) {
                    int i = 0;
                    while (i < tmpnvp.getListSize()) {
                        NVPair prognvp = this.nav.findNVPair(tmpnvp.getListElement(i), "PROGRAM");
                        if (prognvp == null) {
                            this.addDatabase(tmpnvp.getListElement(i));
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private NVPair addDBsToNVP(NVPair nvp, String[] array) {
        if (array.length == 0) {
            return nvp;
        }
        NVFactory factory = new NVFactory();
        NVPair tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
        if (tmpnvp != null) {
            nvp = factory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=" + tmpnvp.toString() + "))");
        }
        if ((tmpnvp = this.nav.findNVPair(nvp, "SID_LIST")) == null) {
            nvp = factory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=))");
        }
        tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
        int i = 0;
        while (i < array.length) {
            tmpnvp.addListElement(factory.createNVPair(array[i]));
            ++i;
        }
        return nvp;
    }

    private NVPair stripDBsFromNVP(NVPair nvp) {
        if (nvp != null) {
            NVPair tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
            if (tmpnvp != null) {
                if (this.nav.findNVPair(tmpnvp, "PROGRAM") == null) {
                    return null;
                }
                return nvp;
            }
            tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
            if (tmpnvp == null) {
                return null;
            }
            int i = 0;
            while (i < tmpnvp.getListSize()) {
                NVPair descnvp = tmpnvp.getListElement(i);
                if (this.nav.findNVPair(descnvp, "PROGRAM") == null) {
                    tmpnvp.removeListElement(i);
                    --i;
                }
                ++i;
            }
            return nvp.getListSize() > 0 ? nvp : null;
        }
        return null;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.tp == null) {
            return false;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            ListenerDBServicePage page = (ListenerDBServicePage)((Object)this.tp.getPage(i).getContent());
            if (page.isChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return true;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            if (!((ListenerDBServicePage)((Object)this.tp.getPage(i).getContent())).areDataValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFocus() {
    }
}

