/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerAuthentication;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneral;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerLoggingTracing;

public class ListenerGeneralParameters
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private TabPanel tp;
    private NetStrings ns = ListenerGeneric.getNS();
    private String[] tabNames = new String[]{this.ns.getString("LCCGeneral"), this.ns.getString("LCCLogTrace"), this.ns.getString("LCCAuthentication")};
    private ListenerCache[] displayPanel;
    private ListenerCache currPanel;
    private String helpString;
    private LWButton helpButton;
    private EwtContainer buttonDeck;
    private String generalHelpTopic = "TOPIClsnrGeneralParam";
    private String logTraceHelpTopic = "TOPIClsnrLoggingTracing";
    private String authHelpTopic = "TOPIClsnrAuth";
    private String currHelpTopic;

    public ListenerGeneralParameters() {
        ListenerGeneric.devTrc("entered ListenerGeneralParameters");
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.tp = new TabPanel();
        this.tp.setOrientation(0);
        this.tp.addTabPanelListener((TabPanelListener)this);
        ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.tp, 0, 0);
        this.buttonDeck = new EwtContainer();
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.helpButton = new LWButton(this.helpString);
        this.buttonDeck.add((Component)this.helpButton);
        this.helpButton.addActionListener((ActionListener)this);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.buttonDeck, 0, 1, 1, 1);
        this.displayPanel = new ListenerCache[this.tabNames.length];
        this.displayPanel[0] = new ListenerGeneral();
        this.displayPanel[1] = new ListenerLoggingTracing();
        this.displayPanel[2] = new ListenerAuthentication();
        int i = 0;
        while (i < this.tabNames.length) {
            this.tp.addPage(this.tabNames[i], (Component)((EwtContainer)this.displayPanel[i]));
            ++i;
        }
        this.currHelpTopic = this.generalHelpTopic;
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        this.currPanel = (ListenerCache)((Object)e.getPage().getContent());
        if (this.currPanel == this.displayPanel[0]) {
            this.currHelpTopic = this.generalHelpTopic;
        }
        if (this.currPanel == this.displayPanel[1]) {
            this.currHelpTopic = this.logTraceHelpTopic;
        }
        if (this.currPanel == this.displayPanel[2]) {
            this.currHelpTopic = this.authHelpTopic;
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currPanel != null && !this.currPanel.areDataValid()) {
            ((Cancelable)e).cancel();
            this.currPanel.setFocus();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(this.helpString)) {
            ListenerGeneric.getHelp().show(this.currHelpTopic);
            return;
        }
    }

    public void setListenerName(String s) {
        this.name = s;
        int i = 0;
        while (i < this.displayPanel.length) {
            this.displayPanel[i].setListenerName(s);
            ++i;
        }
    }

    public void set() {
        int i = 0;
        while (i < this.displayPanel.length) {
            this.displayPanel[i].set();
            ++i;
        }
    }

    public void get() {
        int i = 0;
        while (i < this.displayPanel.length) {
            this.displayPanel[i].get();
            ++i;
        }
    }

    public boolean isChanged() {
        int i = 0;
        while (i < this.displayPanel.length) {
            if (this.displayPanel[i].isChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean areDataValid() {
        int i = 0;
        while (i < this.displayPanel.length) {
            if (!this.displayPanel[i].areDataValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFocus() {
        this.currPanel.setFocus();
    }

    public void setSNMP(String s) {
        ((ListenerGeneral)this.displayPanel[0]).setSNMP(s);
    }

    public String getSNMP() {
        return ((ListenerGeneral)this.displayPanel[0]).getSNMP();
    }

    public void disableSNMP() {
        ((ListenerGeneral)this.displayPanel[0]).disableSNMP();
    }

    public boolean snmpChanged() {
        return ((ListenerGeneral)this.displayPanel[0]).snmpChanged();
    }
}

