/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.common.NetGetEnv;
import oracle.net.nl.NLParamParser;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerGeneric {
    private static NetProperties netProperty = null;
    private static boolean trace;
    private static boolean tcpOk;
    private static boolean spxOk;
    private static boolean nmpOk;
    private static boolean ipcOk;
    private static String oraHome;
    private static String domain;
    private static WebApplication app;
    private static NLParamParser nlpa;
    private static NetStrings ns;
    private static NetHelp help;
    private static boolean allowInvalid;

    public static void setTrace() {
        ListenerGeneric.devTrc("setTrace():");
        try {
            netProperty = new NetProperties();
            String s = netProperty.getProperty("ListenerTrace");
            if (s != null && s.equalsIgnoreCase("on")) {
                trace = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("ListenerGeneric:setTrace(): FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("ListenerGeneric:setTrace(): IOException");
        }
    }

    public static void devTrc(String s) {
        if (trace) {
            System.out.println(s);
        }
    }

    public static void setNLP(NLParamParser n) {
        nlpa = n;
    }

    public static NLParamParser getNLP() {
        return nlpa;
    }

    public static void setApp(WebApplication w) {
        app = w;
    }

    public static WebApplication getApp() {
        return app;
    }

    public static void setHelp(NetHelp h) {
        help = h;
    }

    public static NetHelp getHelp() {
        return help;
    }

    public static NetStrings getNS() {
        return ns;
    }

    public static void setAllowInvalid(boolean b) {
        allowInvalid = b;
    }

    public static boolean allowInvalid() {
        return allowInvalid;
    }

    public static boolean isTCPAllowed() {
        try {
            String s;
            if (netProperty == null) {
                netProperty = new NetProperties();
            }
            if ((s = netProperty.getProperty("TCP")) != null && s.equalsIgnoreCase("yes")) {
                tcpOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("ListenerGeneric:isTCPAllowed(): FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("ListenerGeneric:isTCPAllowed(): IOException");
        }
        return tcpOk;
    }

    public static boolean isSPXAllowed() {
        try {
            String s;
            if (netProperty == null) {
                netProperty = new NetProperties();
            }
            if ((s = netProperty.getProperty("SPX")) != null && s.equalsIgnoreCase("yes")) {
                spxOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("ListenerGeneric:isSPXAllowed(): FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("ListenerGeneric:isSPXAllowed(): IOException");
        }
        return tcpOk;
    }

    public static boolean isNMPAllowed() {
        try {
            String s;
            if (netProperty == null) {
                netProperty = new NetProperties();
            }
            if ((s = netProperty.getProperty("NMP")) != null && s.equalsIgnoreCase("yes")) {
                nmpOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("ListenerGeneric:isNMPAllowed(): FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("ListenerGeneric:isNMPAllowed(): IOException");
        }
        return nmpOk;
    }

    public static boolean isIPCAllowed() {
        try {
            String s;
            if (netProperty == null) {
                netProperty = new NetProperties();
            }
            if ((s = netProperty.getProperty("IPC")) != null && s.equalsIgnoreCase("yes")) {
                ipcOk = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ListenerGeneric.devTrc("ListenerGeneric:isIPCAllowed(): FileNotFoundException");
        }
        catch (IOException iOException) {
            ListenerGeneric.devTrc("ListenerGeneric:isIPCAllowed(): IOException");
        }
        return ipcOk;
    }

    public static String getOraHome() {
        char sep = ListenerGeneric.getSeparator();
        if (oraHome == null) {
            oraHome = NetGetEnv.getOracleHome();
            int i = oraHome.length() - 1;
            while (i >= 0) {
                if (oraHome.charAt(i) != sep) break;
                --i;
            }
            oraHome = String.valueOf(oraHome.substring(0, i + 1)) + sep;
        }
        return oraHome;
    }

    public static void setDomain(String s) {
        domain = "." + s;
    }

    public static String getDomain() {
        if (domain == null) {
            return "";
        }
        return domain;
    }

    public static String getHostName() {
        String hostname;
        try {
            InetAddress inetAddr = InetAddress.getLocalHost();
            hostname = inetAddr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            ListenerGeneric.devTrc("ListenerGeneric::getHostName: InetAddress exception");
            hostname = "localhost";
        }
        return hostname;
    }

    public static char getSeparator() {
        return File.separatorChar;
    }

    public static void setFillBoth(Container cont) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        ((GridBagLayout)cont.getLayout()).setConstraints(cont, c);
    }

    public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + left + bottom + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
        if (container.getPeer() != null) {
            container.getLayout().layoutContainer(container);
        }
        container.validate();
    }

    public static void constrainMainPanel(Container container, Component component, int grid_x, int grid_y) {
        ListenerGeneric.constrain(container, component, grid_x, grid_y, 1, 1, 1, 18, 100.0, 100.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height) {
        ListenerGeneric.constrain(container, component, grid_x, grid_y, grid_width, grid_height, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill) {
        ListenerGeneric.constrain(container, component, grid_x, grid_y, grid_width, grid_height, fill, 18, 0.0, 0.0, 0, 0, 0, 0);
    }

    public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int top, int left, int bottom, int right) {
        ListenerGeneric.constrain(container, component, grid_x, grid_y, grid_width, grid_height, 0, 18, 0.0, 0.0, top, left, bottom, right);
    }

    public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int top, int left, int bottom, int right, int fill) {
        ListenerGeneric.constrain(container, component, grid_x, grid_y, grid_width, grid_height, fill, 18, 0.0, 0.0, top, left, bottom, right);
    }

    static {
        domain = null;
        ns = new NetStrings();
        help = null;
    }
}

