/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.UIManager;
import oracle.ewt.alert.Alert;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetOKDialog;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.profile.NetAddr;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetPStack;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerListeningLocations
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private static Vector listenerList = new Vector();
    private static String dupListener;
    private static Hashtable protocolErrors;
    private static final NetStrings ns;
    private static final String addString;
    private static final String removeString;
    private static final String helpString;
    private static final String addressString;
    private static final String addLocationString;
    private static final String addrTitleString;
    private static final String presTitleString;
    private static final String defaultPStack = "(PROTOCOL_STACK=(PRESENTATION=TTC)(SESSION=NS))";
    private static final String locationHelpTopic = "TOPIClsnrLsnrLocations";
    private static final NVNavigator nav;
    private static final NVFactory factory;
    private final WebApplication app = ListenerGeneric.getApp();
    private TabPanel tp;
    private EwtContainer addrPanel;
    private MultiLineLabel addLocMessage;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private GridBagConstraints buttonGBC;
    private GridBagConstraints messageGBC;
    private GridBagConstraints tpGBC;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private String name;
    private int addrCount;
    private boolean changed = false;
    private EndpointPanel currEndpoint;
    private EndpointPanel invalid;

    public ListenerListeningLocations() {
        this.addButton = new LWButton(addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(helpString);
        this.helpButton.addActionListener((ActionListener)this);
        EwtContainer buttonPanel = new EwtContainer();
        buttonPanel.add((Component)this.addButton);
        buttonPanel.add((Component)this.removeButton);
        buttonPanel.add((Component)this.helpButton);
        this.addLocMessage = new MultiLineLabel(addLocationString);
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.messageGBC = new GridBagConstraints();
        this.messageGBC.gridx = 0;
        this.messageGBC.gridy = 1;
        this.messageGBC.gridwidth = 1;
        this.messageGBC.gridheight = 1;
        this.messageGBC.weightx = 1.0;
        this.messageGBC.weighty = 10.0;
        this.messageGBC.fill = 0;
        this.messageGBC.anchor = 10;
        ((Container)((Object)this)).add((Component)this.addLocMessage, this.messageGBC);
        this.tpGBC = (GridBagConstraints)this.messageGBC.clone();
        this.tpGBC.insets.bottom = 10;
        this.tpGBC.insets.top = 10;
        this.tpGBC.insets.right = 0;
        this.tpGBC.insets.left = 0;
        this.tpGBC.fill = 1;
        this.buttonGBC = (GridBagConstraints)this.messageGBC.clone();
        this.buttonGBC.gridy = 2;
        this.buttonGBC.weighty = 0.0;
        this.buttonGBC.anchor = 16;
        ((Container)((Object)this)).add((Component)buttonPanel, this.buttonGBC);
    }

    public void setListenerName(String s) {
        this.name = s;
    }

    public void set() {
        this.nlpa.removeNLPListElement(this.name);
        if (this.tp == null) {
            return;
        }
        try {
            if (this.tp.getPageCount() == 1) {
                EndpointPanel page = (EndpointPanel)((Object)this.tp.getPage(0).getContent());
                String addrString = "(DESCRIPTION=" + page.getAddr().toString() + page.getPStack().toString() + ")";
                this.nlpa.addNLPListElement(String.valueOf(this.name) + "=" + addrString);
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append("(DESCRIPTION_LIST=");
                int i = 0;
                while (i < this.tp.getPageCount()) {
                    EndpointPanel page = (EndpointPanel)((Object)this.tp.getPage(i).getContent());
                    buf.append("(DESCRIPTION=");
                    buf.append(page.getAddr().toString());
                    buf.append(page.getPStack().toString());
                    buf.append(")");
                    ++i;
                }
                buf.append(")");
                this.nlpa.addNLPListElement(String.valueOf(this.name) + "=" + buf.toString());
            }
        }
        catch (NLException e) {
            System.err.println(e);
        }
        this.changed = false;
    }

    public void get() {
        NVPair nvpListener = this.nlpa.getNLPListElement(this.name);
        if (nvpListener == null || nvpListener.getListSize() == 0) {
            this.changed = true;
            return;
        }
        NVPair nvp = nvpListener.getListElement(0);
        String pairName = nvp.getName().toUpperCase();
        if (pairName.equals("DESCRIPTION_LIST")) {
            this.parseDList(nvp, null);
        } else if (pairName.equals("DESCRIPTION")) {
            this.parseDList(nvpListener, null);
        } else if (pairName.equals("ADDRESS_LIST")) {
            this.parseAList(nvp, null);
        } else if (pairName.equals("ADDRESS")) {
            this.parseAList(nvpListener, null);
        }
    }

    public boolean isChanged() {
        if (this.changed || this.tp == null) {
            return true;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            if (((EndpointPanel)((Object)this.tp.getPage(i).getContent())).hasChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return false;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            EndpointPanel page = (EndpointPanel)((Object)this.tp.getPage(i).getContent());
            if (!page.areDataValid() || (dupListener = ListenerListeningLocations.findDuplicate(page)) != null) {
                this.invalid = page;
                return false;
            }
            ++i;
        }
        dupListener = null;
        this.invalid = null;
        return true;
    }

    public void setFocus() {
        if (this.tp == null) {
            NetOKDialog dialog = new NetOKDialog((BufferedFrame)ListenerGeneric.getApp().getFrame(), null, "nnaError", "LCCPleaseAddListeningLocation", null);
            ((Dialog)((Object)dialog)).show();
            this.addButton.requestFocus();
            return;
        }
        if (this.invalid != null) {
            this.tp.getSelectedPage().setVisible(true);
            this.invalid.setFocus();
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        TabPanelPage currentPage = e.getPage();
        if (currentPage != null) {
            this.currEndpoint = (EndpointPanel)((Object)currentPage.getContent());
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (!(this.currEndpoint == null || this.currEndpoint.areDataValid() && (dupListener = ListenerListeningLocations.findDuplicate(this.currEndpoint)) == null)) {
            ((Cancelable)e).cancel();
            this.currEndpoint.setFocus();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(addString)) {
            this.changed = true;
            this.newAddr(factory.createNVPair("(ADDRESS=(PROTOCOL=tcp)(HOST=" + ListenerGeneric.getHostName() + ")(PORT=" + (this.tp == null ? "1521" : "") + "))"), factory.createNVPair(defaultPStack));
            return;
        }
        if (cmd.equals(removeString)) {
            this.changed = true;
            this.removeAddr();
            return;
        }
        if (cmd.equals(helpString)) {
            ListenerGeneric.getHelp().showTopic(locationHelpTopic);
            return;
        }
    }

    private void newAddr(NVPair addrbp, NVPair stack) {
        this.changed = true;
        if (this.tp == null) {
            this.tp = new TabPanel();
            this.tp.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.addLocMessage);
            ((Container)((Object)this)).add((Component)this.tp, this.tpGBC);
        }
        if (!(ListenerGeneric.allowInvalid() || this.currEndpoint == null || this.currEndpoint.areDataValid() && (dupListener = ListenerListeningLocations.findDuplicate(this.currEndpoint)) == null)) {
            this.currEndpoint.setFocus();
            return;
        }
        EndpointPanel page = new EndpointPanel(addrbp, stack);
        page.setAppEnv(this.app);
        TabPanelPage tPage = this.tp.addPage(String.valueOf(addressString) + ++this.addrCount, (Component)((Object)page));
        if (ListenerGeneric.allowInvalid()) {
            tPage.setSelected(true);
        } else {
            ListenerGeneric.setAllowInvalid(true);
            tPage.setSelected(true);
            ListenerGeneric.setAllowInvalid(false);
        }
        ((Container)((Object)this)).validate();
        if (this.tp.getPageCount() >= 1) {
            this.removeButton.setEnabled(true);
        }
        this.currEndpoint = (EndpointPanel)((Object)this.tp.getSelectedPage().getContent());
    }

    private void removeAddr() {
        TabPanelPage page = this.tp.getSelectedPage();
        this.changed = true;
        ListenerGeneric.setAllowInvalid(true);
        this.tp.removePage(page);
        ListenerGeneric.setAllowInvalid(false);
        page = null;
        --this.addrCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currEndpoint = null;
            ((Container)((Object)this)).add((Component)this.addLocMessage, this.messageGBC);
            ((Container)((Object)this)).validate();
        } else {
            this.currEndpoint = (EndpointPanel)((Object)this.tp.getSelectedPage().getContent());
            int i = 0;
            while (i < this.tp.getPageCount()) {
                this.tp.getPage(i).setLabel(String.valueOf(addressString) + (i + 1));
                ++i;
            }
        }
    }

    private void parseDList(NVPair dList, NVPair pStack) {
        if (dList == null) {
            return;
        }
        NVPair localPStack = this.findPStack(dList);
        if (localPStack == null) {
            localPStack = pStack;
        }
        int listSize = dList.getListSize();
        int i = 0;
        while (i < listSize) {
            NVPair nvp = dList.getListElement(i);
            String name = nvp.getName().toUpperCase();
            if (name.equals("DESCRIPTION_LIST")) {
                this.parseDList(nvp, localPStack != null ? localPStack : pStack);
            }
            if (name.equals("DESCRIPTION") && nav.findNVPairRecurse(nvp, "ADDRESS") != null) {
                this.parseAList(nvp, localPStack != null ? localPStack : pStack);
            }
            ++i;
        }
    }

    private void parseAList(NVPair aList, NVPair pStack) {
        if (aList == null) {
            return;
        }
        NVPair localPStack = this.findPStack(aList);
        if (localPStack == null) {
            localPStack = pStack;
        }
        int listSize = aList.getListSize();
        NVPair addrp = null;
        int i = 0;
        while (i < listSize) {
            addrp = aList.getListElement(i);
            if (addrp.getName().toUpperCase().equals("ADDRESS_LIST")) {
                this.parseAList(addrp, localPStack != null ? localPStack : pStack);
            } else if (addrp.getName().toUpperCase().equals("ADDRESS")) {
                this.newAddr(addrp, localPStack != null ? localPStack : pStack);
            }
            ++i;
        }
    }

    private NVPair findPStack(NVPair parent) {
        NVPair stackp = null;
        NVPair pres = null;
        stackp = nav.findNVPair(parent, "PROTOCOL_STACK");
        if (stackp != null && nav.findNVPair(stackp, "SESSION") == null) {
            parent = stackp;
            stackp = null;
        }
        if (stackp == null && (pres = nav.findNVPair(parent, "PRESENTATION")) != null) {
            String name = pres.getAtom().toUpperCase();
            String newNVP = "(PROTOCOL_STACK=(PRESENTATION=" + name + ")(SESSION=";
            if (pres.equals("TTC")) {
                stackp = factory.createNVPair(String.valueOf(newNVP) + "NS))");
            } else if (pres.equals("GIOP")) {
                stackp = factory.createNVPair(String.valueOf(newNVP) + "RAW))");
            }
        }
        return stackp;
    }

    public static void registerListener(ListenerListeningLocations l) {
        listenerList.addElement(l);
    }

    public static void unregisterListener(ListenerListeningLocations l) {
        try {
            listenerList.removeElement(l);
        }
        catch (Exception exception) {}
    }

    private static String findDuplicate(EndpointPanel page) {
        Enumeration e = listenerList.elements();
        while (e.hasMoreElements()) {
            ListenerListeningLocations current = (ListenerListeningLocations)e.nextElement();
            if (current.tp == null) continue;
            int pages = current.tp.getPageCount();
            int i = 0;
            while (i < pages) {
                EndpointPanel aPage = (EndpointPanel)((Object)current.tp.getPage(i).getContent());
                if (aPage != page && page.addr.sameEndpoint(aPage.addr)) {
                    return current.name;
                }
                ++i;
            }
        }
        return null;
    }

    private static void showDuplicateError(EndpointPanel page) {
        String prot = page.addr.getProtocol().toUpperCase();
        Object[] params = new Object[]{dupListener != null ? dupListener : ""};
        String message = ns.getString((String)protocolErrors.get(prot), params);
        Alert alert = new Alert(ListenerGeneric.getApp().getFrame(), message, 0, 1);
        alert.runAlert();
        dupListener = null;
    }

    static {
        protocolErrors = new Hashtable(5);
        protocolErrors.put("TCP", "LCCDupErrorTCP");
        protocolErrors.put("TCPS", "LCCDupErrorTCPS");
        protocolErrors.put("IPC", "LCCDupErrorIPC");
        protocolErrors.put("SPX", "LCCDupErrorSPX");
        protocolErrors.put("NMP", "LCCDupErrorNMP");
        ns = new NetStrings();
        addString = ns.getString("LCCAddAddress");
        removeString = ns.getString("LCCRemoveAddress");
        helpString = ns.getString("LCCHelp");
        addressString = ns.getString("LCCAddress");
        addLocationString = ns.getString("LCCaddLocationMessage");
        addrTitleString = ns.getString("LCCaddrTitle");
        presTitleString = ns.getString("LCCpresTitle");
        nav = new NVNavigator();
        factory = new NVFactory();
    }

    public class EndpointPanel
    extends NetLayout {
        NetAddr addr;
        NetPStack pStack;
        private GridBagConstraints gbc;

        public EndpointPanel(NVPair addrPair, NVPair pStackPair) {
            ListenerListeningLocations.this = ListenerListeningLocations.this;
            this.addr = new NetAddr(addrPair);
            this.addr.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(15, 10, 10, 10), (String)addrTitleString));
            this.pStack = new NetPStack(pStackPair);
            this.pStack.setBorderPainter(UIManager.createGroupBoxPainter((Painter)new FixedBorderPainter(10, 10, 10, 10), (String)presTitleString));
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.gridheight = 1;
            this.gbc.gridwidth = 1;
            this.gbc.weighty = 1.0;
            this.gbc.weightx = 1.0;
            this.gbc.fill = 2;
            this.gbc.anchor = 10;
            ((Container)((Object)this)).add((Component)((Object)this.addr), this.gbc);
            this.gbc.gridy = 1;
            this.gbc.anchor = 10;
            ((Container)((Object)this)).add((Component)((Object)this.pStack), this.gbc);
            this.setBorderPainter((BorderPainter)new FixedBorderPainter(20, 40, 20, 40));
        }

        public NVPair getAddr() {
            return this.addr.getAddr();
        }

        public NVPair getPStack() {
            return this.pStack.getPStack();
        }

        public void setAppEnv(WebApplication w) {
            this.addr.setAppEnv(w);
            this.pStack.setAppEnv(w);
        }

        public void setFocus() {
            if (dupListener != null) {
                ListenerListeningLocations.showDuplicateError(this);
            } else {
                this.addr.setFocus();
            }
        }

        public boolean hasChanged() {
            return this.addr.hasChanged() || this.pStack.hasChanged();
        }

        public boolean areDataValid() {
            return this.addr.areDataValid();
        }
    }
}

