/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerLoggingTracing
extends EwtContainer
implements ListenerCache,
ItemListener,
ActionListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private NetStrings ns = ListenerGeneric.getNS();
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private LWCheckboxGroup logGroup = new LWCheckboxGroup();
    private LWCheckboxGroup traceGroup = new LWCheckboxGroup();
    private LWCheckbox logEnBox;
    private LWCheckbox logDisBox;
    private LWCheckbox traceEnBox;
    private LWCheckbox traceDisBox;
    private boolean changed;
    private LWTextField logFileField;
    private LWTextField traceFileField;
    private String logEnString;
    private String logDisString;
    private String traceEnString;
    private String traceDisString;
    private String browseString;
    private String userString;
    private String adminString;
    private String supportString;
    private String chooseLogString;
    private String chooseTraceString;
    private String[] hintArrayA;
    private String[] hintArrayB;
    private LWLabel logFileLabel;
    private LWLabel traceLevelLabel;
    private LWLabel traceLevelHintA;
    private LWLabel traceLevelHintB;
    private LWLabel traceFileLabel;
    private LWChoice traceLevelChoice;
    private LWButton logButton;
    private LWButton traceButton;
    private char sep;
    private String oraHome;
    private File logFileDef;
    private File traceFileDef;
    private EwtContainer logPanel;
    private EwtContainer tracePanel;

    public ListenerLoggingTracing() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.sep = ListenerGeneric.getSeparator();
        this.oraHome = ListenerGeneric.getOraHome();
        this.logDisString = new String(this.ns.getString("LCCLoggingDisabled"));
        this.logEnString = new String(this.ns.getString("LCCLoggingEnabled"));
        this.traceEnString = new String(this.ns.getString("LCCTracingEnabled"));
        this.traceDisString = new String(this.ns.getString("LCCTracingDisabled"));
        this.browseString = new String(this.ns.getString("LCCBrowse"));
        this.hintArrayA = new String[3];
        this.hintArrayB = new String[3];
        this.hintArrayA[0] = new String(this.ns.getString("LCCUserHintA"));
        this.hintArrayB[0] = new String(this.ns.getString("LCCUserHintB"));
        this.hintArrayA[1] = new String(this.ns.getString("LCCAdminHintA"));
        this.hintArrayB[1] = new String(this.ns.getString("LCCAdminHintB"));
        this.hintArrayA[2] = new String(this.ns.getString("LCCSupportHintA"));
        this.hintArrayB[2] = new String(this.ns.getString("LCCSupportHintB"));
        this.userString = new String(this.ns.getString("LCCUser"));
        this.adminString = new String(this.ns.getString("LCCAdmin"));
        this.supportString = new String(this.ns.getString("LCCSupport"));
        this.logDisBox = new LWCheckbox(this.logDisString, this.logGroup, false);
        this.logDisBox.addItemListener((ItemListener)this);
        this.logEnBox = new LWCheckbox(this.logEnString, this.logGroup, true);
        this.logEnBox.addItemListener((ItemListener)this);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.logDisBox, 0, 0, 1, 1, 5, 15, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.logEnBox, 0, 1, 1, 1, 0, 15, 0, 0);
        this.logFileLabel = new LWLabel(this.ns.getString("LCCLogFile"));
        this.logFileField = new LWTextField("", 30);
        this.logButton = new LWButton(this.browseString);
        this.logButton.addActionListener((ActionListener)this);
        this.chooseLogString = new String(this.ns.getString("LCCChooseLog"));
        this.logPanel = new EwtContainer();
        this.logPanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.logPanel.setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)this.logPanel, (Component)this.logFileLabel, 0, 0, 1, 1, 10, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.logPanel, (Component)this.logFileField, 1, 0, 1, 1, 10, 0, 0, 5, 1);
        ListenerGeneric.constrain((Container)this.logPanel, (Component)this.logButton, 0, 1, 2, 1, 0, 13, 1.0, 1.0, 5, 0, 10, 5);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.logPanel, 0, 1, 1, 1, 0, 10, 10, 10, 1);
        this.traceDisBox = new LWCheckbox(this.traceDisString, this.traceGroup, true);
        this.traceDisBox.addItemListener((ItemListener)this);
        this.traceEnBox = new LWCheckbox(this.traceEnString, this.traceGroup, false);
        this.traceEnBox.addItemListener((ItemListener)this);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.traceDisBox, 0, 2, 1, 1, 15, 15, 0, 0);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.traceEnBox, 0, 3, 1, 1, 0, 15, 0, 0);
        this.traceFileLabel = new LWLabel(this.ns.getString("LCCTraceFile"));
        this.traceLevelChoice = new LWChoice();
        this.traceLevelChoice.add(this.userString);
        this.traceLevelChoice.add(this.adminString);
        this.traceLevelChoice.add(this.supportString);
        this.traceLevelChoice.addItemListener((ItemListener)this);
        this.traceLevelLabel = new LWLabel(this.ns.getString("LCCTraceLevel"));
        this.traceLevelHintA = new LWLabel(this.hintArrayA[0]);
        this.traceLevelHintB = new LWLabel(this.hintArrayB[0]);
        this.traceButton = new LWButton(this.browseString);
        this.traceButton.addActionListener((ActionListener)this);
        this.chooseTraceString = new String(this.ns.getString("LCCChooseTrace"));
        this.traceFileField = new LWTextField("", 30);
        this.tracePanel = new EwtContainer();
        this.tracePanel.setBorder((Border)new GroupBoxBorder("", InsetFramePainter.getFramePainter(), 2));
        this.tracePanel.setLayout(new GridBagLayout());
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceLevelLabel, 0, 0, 1, 1, 10, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceLevelChoice, 1, 0, 1, 1, 10, 0, 0, 0);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceLevelHintA, 1, 1, 2, 1, 0, 0, 0, 0, 1);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceLevelHintB, 1, 2, 2, 1, 0, 0, 10, 0, 1);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceFileLabel, 0, 3, 1, 1, 10, 10, 0, 0);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceFileField, 1, 3, 1, 1, 10, 0, 0, 5, 1);
        ListenerGeneric.constrain((Container)this.tracePanel, (Component)this.traceButton, 0, 4, 2, 1, 0, 13, 1.0, 1.0, 5, 0, 10, 5);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.tracePanel, 0, 3, 1, 1, 0, 10, 10, 10, 1);
    }

    public void addNotify() {
        super.addNotify();
        this.traceEnBox.setBackground(this.traceEnBox.getBackground());
        this.logEnBox.setBackground(this.logEnBox.getBackground());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof LWButton) {
            if (((LWButton)source).equals(this.logButton)) {
                FileDialog dialog = new FileDialog(this.app.getFrame(), this.chooseLogString, 1);
                File file = new File(this.logFileField.getText());
                dialog.setFile(file.getName());
                dialog.setDirectory(file.getParent());
                dialog.show();
                if (dialog.getFile() != null) {
                    File newFile = new File(dialog.getDirectory(), dialog.getFile());
                    this.logFileField.setText(newFile.toString());
                }
            } else {
                FileDialog dialog = new FileDialog(this.app.getFrame(), this.chooseTraceString, 1);
                File file = new File(this.traceFileField.getText());
                dialog.setFile(file.getName());
                dialog.setDirectory(file.getParent());
                dialog.show();
                if (dialog.getFile() != null) {
                    File newFile = new File(dialog.getDirectory(), dialog.getFile());
                    this.traceFileField.setText(newFile.toString());
                }
            }
        } else {
            ListenerGeneric.devTrc("unknown actionPerformed");
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof LWChoice) {
            this.traceLevelHintA.setText(this.hintArrayA[((LWChoice)source).getSelectedIndex()]);
            this.traceLevelHintB.setText(this.hintArrayB[((LWChoice)source).getSelectedIndex()]);
            ((Container)((Object)this)).validate();
        } else if (source instanceof LWCheckbox) {
            if (((LWCheckbox)source).equals(this.logEnBox)) {
                this.enableLogPanel(true);
            } else if (((LWCheckbox)source).equals(this.logDisBox)) {
                this.enableLogPanel(false);
            } else if (((LWCheckbox)source).equals(this.traceEnBox)) {
                this.enableTracePanel(true);
            } else if (((LWCheckbox)source).equals(this.traceDisBox)) {
                this.enableTracePanel(false);
            }
        } else {
            ListenerGeneric.devTrc("other changed");
        }
    }

    private void enableLogPanel(boolean state) {
        this.logFileField.setEnabled(state);
        this.logFileField.setEditable(state);
        this.logButton.setEnabled(state);
        this.logFileField.repaint(0L);
    }

    private void enableTracePanel(boolean state) {
        this.traceFileField.setEnabled(state);
        this.traceFileField.setEditable(state);
        this.traceButton.setEnabled(state);
        this.traceLevelChoice.setEnabled(state);
        this.traceFileField.repaint(0L);
    }

    public void setListenerName(String s) {
        this.name = s;
        String netdir = "network";
        this.logFileDef = new File(String.valueOf(this.oraHome) + netdir + this.sep + "log" + this.sep + this.name + ".log");
        this.traceFileDef = new File(String.valueOf(this.oraHome) + netdir + this.sep + "trace" + this.sep + this.name + ".trc");
    }

    public void set() {
        try {
            File file;
            this.nlpa.removeNLPListElement("LOGGING_" + this.name);
            if (this.logGroup.getSelectedCheckbox().getLabel().equals(this.logDisString)) {
                this.nlpa.addNLPListElement("LOGGING_" + this.name + "=OFF");
            }
            this.nlpa.removeNLPListElement("LOG_DIRECTORY_" + this.name);
            this.nlpa.removeNLPListElement("LOG_FILE_" + this.name);
            String s = this.logFileField.getText();
            if (!s.equals(this.logFileDef.toString())) {
                ListenerGeneric.devTrc("adding non-default log dir/file");
                file = new File(s);
                this.nlpa.addNLPListElement("LOG_DIRECTORY_" + this.name + "=" + file.getParent());
                this.nlpa.addNLPListElement("LOG_FILE_" + this.name + "=" + file.getName());
            }
            this.nlpa.removeNLPListElement("TRACE_LEVEL_" + this.name);
            if (this.traceGroup.getSelectedCheckbox().getLabel().equals(this.traceEnString)) {
                String selected = this.traceLevelChoice.getSelectedItem();
                if (selected.equals(this.adminString)) {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=ADMIN");
                } else if (selected.equals(this.userString)) {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=USER");
                } else {
                    this.nlpa.addNLPListElement("TRACE_LEVEL_" + this.name + "=SUPPORT");
                }
            }
            this.nlpa.removeNLPListElement("TRACE_DIRECTORY_" + this.name);
            this.nlpa.removeNLPListElement("TRACE_FILE_" + this.name);
            s = this.traceFileField.getText();
            if (!s.equals(this.traceFileDef.toString())) {
                file = new File(s);
                this.nlpa.addNLPListElement("TRACE_DIRECTORY_" + this.name + "=" + file.getParent());
                this.nlpa.addNLPListElement("TRACE_FILE_" + this.name + "=" + file.getName());
            }
        }
        catch (NLException e) {
            System.err.println(e);
        }
        this.changed = false;
    }

    public void get() {
        NVPair nvpair = this.nlpa.getNLPListElement("LOGGING_" + this.name);
        if (nvpair != null && nvpair.getAtom() != null && nvpair.getAtom().equalsIgnoreCase("OFF")) {
            this.logDisBox.setState(true);
            this.enableLogPanel(false);
        } else {
            this.logEnBox.setState(true);
            this.enableLogPanel(true);
        }
        nvpair = this.nlpa.getNLPListElement("LOG_FILE_" + this.name);
        String filename = nvpair != null && nvpair.getAtom() != null ? nvpair.getAtom() : this.logFileDef.getName();
        nvpair = this.nlpa.getNLPListElement("LOG_DIRECTORY_" + this.name);
        String dir = nvpair != null && nvpair.getAtom() != null ? nvpair.getAtom() : this.logFileDef.getParent();
        File file = new File(dir, filename);
        this.logFileField.setText(file.toString());
        nvpair = this.nlpa.getNLPListElement("TRACE_LEVEL_" + this.name);
        if (nvpair != null && nvpair.getAtom() != null) {
            String s = nvpair.getAtom();
            this.traceEnBox.setState(true);
            this.enableTracePanel(true);
            if (s.equalsIgnoreCase("USER")) {
                this.traceLevelChoice.select(this.userString);
                this.traceLevelHintA.setText(this.hintArrayA[0]);
                this.traceLevelHintB.setText(this.hintArrayB[0]);
            } else if (s.equalsIgnoreCase("ADMIN")) {
                this.traceLevelChoice.select(this.adminString);
                this.traceLevelHintA.setText(this.hintArrayA[1]);
                this.traceLevelHintB.setText(this.hintArrayB[1]);
            } else if (s.equalsIgnoreCase("SUPPORT")) {
                this.traceLevelChoice.select(this.supportString);
                this.traceLevelHintA.setText(this.hintArrayA[2]);
                this.traceLevelHintB.setText(this.hintArrayB[2]);
            } else {
                this.traceDisBox.setState(true);
                this.enableTracePanel(false);
            }
        } else {
            this.traceDisBox.setState(true);
            this.enableTracePanel(false);
        }
        nvpair = this.nlpa.getNLPListElement("TRACE_FILE_" + this.name);
        filename = nvpair != null && nvpair.getAtom() != null ? nvpair.getAtom() : this.traceFileDef.getName();
        nvpair = this.nlpa.getNLPListElement("TRACE_DIRECTORY_" + this.name);
        dir = nvpair != null && nvpair.getAtom() != null ? nvpair.getAtom() : this.traceFileDef.getParent();
        file = new File(dir, filename);
        this.traceFileField.setText(file.toString());
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }
}

