/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.listener;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.listener.ListenerCache;
import oracle.net.asst.listener.ListenerGeneric;
import oracle.net.asst.listener.ListenerOtherServicePage;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class ListenerOtherServices
extends EwtContainer
implements ListenerCache,
TabPanelListener,
ActionListener {
    private String name;
    private WebApplication app = ListenerGeneric.getApp();
    private boolean changed = false;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton helpButton;
    private String addString;
    private String removeString;
    private String helpString;
    private String serviceString;
    private TabPanel tp;
    private int serviceCount;
    private NetStrings ns = ListenerGeneric.getNS();
    private EwtContainer buttonPanel;
    private EwtContainer noServicesPanel;
    private LWLabel noServicesLabel;
    private LWLabel noServicesHintLabel;
    private NLParamParser nlpa = ListenerGeneric.getNLP();
    private final NVNavigator nav = new NVNavigator();
    private String otherHelpTopic = "TOPIClsnrOtherServices";
    private ListenerOtherServicePage currService;

    public ListenerOtherServices() {
        ListenerGeneric.devTrc("entered ListenerOtherServices");
        this.serviceString = new String(this.ns.getString("LCCService"));
        this.addString = new String(this.ns.getString("LCCAddService"));
        this.removeString = new String(this.ns.getString("LCCRemoveService"));
        this.helpString = new String(this.ns.getString("LCCHelp"));
        this.addButton = new LWButton(this.addString);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.removeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.helpButton = new LWButton(this.helpString);
        this.helpButton.addActionListener((ActionListener)this);
        this.buttonPanel = new EwtContainer();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.noServicesPanel = new EwtContainer();
        this.noServicesPanel.setLayout(new GridBagLayout());
        this.noServicesLabel = new LWLabel(this.ns.getString("LCCNoServices"));
        this.noServicesHintLabel = new LWLabel(this.ns.getString("LCCNoServicesHint"));
        ListenerGeneric.constrain((Container)this.noServicesPanel, (Component)this.noServicesLabel, 0, 0, 1, 1);
        ListenerGeneric.constrain((Container)this.noServicesPanel, (Component)this.noServicesHintLabel, 0, 1, 1, 1);
        ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.noServicesPanel, 0, 0);
        this.buttonPanel.add((Component)this.addButton);
        this.buttonPanel.add((Component)this.removeButton);
        this.buttonPanel.add((Component)this.helpButton);
        ListenerGeneric.constrain((Container)((Object)this), (Component)this.buttonPanel, 0, 1, 1, 1);
    }

    public void addService(NVPair nvp) {
        TabPanel tmpPanel;
        if (this.tp == null) {
            tmpPanel = new TabPanel();
            tmpPanel.addTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.noServicesPanel);
        } else {
            tmpPanel = this.tp;
        }
        ListenerOtherServicePage page = new ListenerOtherServicePage(nvp);
        tmpPanel.addPage(String.valueOf(this.serviceString) + ++this.serviceCount, (Component)((Object)page));
        tmpPanel.getPage(tmpPanel.getPageCount() - 1).setSelected(true);
        page.invalidate();
        ((Container)((Object)this)).validate();
        this.currService = page;
        if (tmpPanel.getPageCount() == 1) {
            this.removeButton.setEnabled(true);
        }
        if (this.tp == null) {
            this.tp = tmpPanel;
        }
        ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.tp, 0, 0);
    }

    public void removeService() {
        TabPanelPage page = this.tp.getSelectedPage();
        this.tp.removeTabPanelListener((TabPanelListener)this);
        this.tp.removePage(page);
        this.tp.addTabPanelListener((TabPanelListener)this);
        --this.serviceCount;
        if (this.tp.getPageCount() == 0) {
            this.removeButton.setEnabled(false);
            this.tp.removeTabPanelListener((TabPanelListener)this);
            ((Container)((Object)this)).remove((Component)this.tp);
            this.tp = null;
            this.currService = null;
            ListenerGeneric.constrainMainPanel((Container)((Object)this), (Component)this.noServicesPanel, 0, 0);
        } else {
            this.currService = (ListenerOtherServicePage)((Object)this.tp.getSelectedPage().getContent());
            int i = 0;
            while (i < this.tp.getPageCount()) {
                this.tp.getPage(i).setLabel(String.valueOf(this.serviceString) + (i + 1));
                ++i;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(this.addString)) {
            this.changed = true;
            if (this.currService != null && !this.currService.areDataValid()) {
                return;
            }
            this.addService(null);
            return;
        }
        if (cmd.equals(this.removeString)) {
            this.changed = true;
            this.removeService();
            return;
        }
        if (cmd.equals(this.helpString)) {
            ListenerGeneric.getHelp().show(this.otherHelpTopic);
            return;
        }
    }

    public void tabPanelSelectionChanged(TabPanelEvent e) {
        this.currService = (ListenerOtherServicePage)((Object)e.getPage().getContent());
    }

    public void tabPanelSelectionChanging(TabPanelEvent e) {
        if (ListenerGeneric.allowInvalid()) {
            return;
        }
        if (this.currService != null && !this.currService.areDataValid()) {
            ((Cancelable)e).cancel();
        }
    }

    public void setListenerName(String s) {
        this.name = s;
    }

    public void set() {
        NVPair nvp = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (this.tp == null) {
            if (!this.changed) {
                return;
            }
            nvp = this.stripOtherFromNVP(nvp);
        } else {
            String[] array = new String[this.tp.getPageCount()];
            int i = 0;
            while (i < this.tp.getPageCount()) {
                ListenerOtherServicePage page = (ListenerOtherServicePage)((Object)this.tp.getPage(i).getContent());
                array[i] = page.toString();
                if (page.isChanged()) {
                    page.setChanged(false);
                    this.changed = true;
                }
                ++i;
            }
            if (this.changed) {
                NVPair tmpnvp = this.stripOtherFromNVP(nvp);
                nvp = this.addOtherToNVP(tmpnvp, array);
            } else {
                return;
            }
        }
        try {
            if (nvp != null) {
                NVPair sidList = this.nav.findNVPair(nvp, "SID_LIST");
                if (sidList == null || sidList.getListSize() == 0) {
                    this.nlpa.removeNLPListElement("SID_LIST_" + this.name);
                } else {
                    this.nlpa.addNLPListElement(nvp.toString());
                }
            }
        }
        catch (NLException nLException) {
            ListenerGeneric.devTrc("LOtherSvcs set failed");
        }
        this.changed = false;
    }

    public void get() {
        int i;
        NVPair prognvp;
        NVPair tmpnvp;
        NVPair nvp = this.nlpa.getNLPListElement("SID_LIST_" + this.name);
        if (nvp != null) {
            tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
            if (tmpnvp != null) {
                prognvp = this.nav.findNVPair(tmpnvp, "PROGRAM");
                if (prognvp != null) {
                    this.addService(tmpnvp);
                }
            } else {
                tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
                if (tmpnvp != null) {
                    i = 0;
                    while (i < tmpnvp.getListSize()) {
                        prognvp = this.nav.findNVPair(tmpnvp.getListElement(i), "PROGRAM");
                        if (prognvp != null) {
                            this.addService(tmpnvp.getListElement(i));
                        }
                        ++i;
                    }
                }
            }
        }
        if ((nvp = this.nlpa.getNLPListElement("SERVICE_LIST_" + this.name)) != null) {
            this.changed = true;
            tmpnvp = this.nav.findNVPair(nvp, "SERVICE_DESC");
            if (tmpnvp != null) {
                prognvp = this.nav.findNVPair(tmpnvp, "PROGRAM");
                if (prognvp != null) {
                    this.addService(tmpnvp);
                }
            } else {
                tmpnvp = this.nav.findNVPair(nvp, "SERVICE_LIST");
                if (tmpnvp != null) {
                    i = 0;
                    while (i < tmpnvp.getListSize()) {
                        prognvp = this.nav.findNVPair(tmpnvp.getListElement(i), "PROGRAM");
                        if (prognvp != null) {
                            this.addService(tmpnvp.getListElement(i));
                        }
                        ++i;
                    }
                }
            }
            this.nlpa.removeNLPListElement("SERVICE_LIST_" + this.name);
        }
    }

    private NVPair addOtherToNVP(NVPair nvp, String[] array) {
        if (array.length == 0) {
            return nvp;
        }
        NVFactory factory = new NVFactory();
        NVPair tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
        if (tmpnvp != null) {
            nvp = factory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=" + tmpnvp.toString() + "))");
        }
        if ((tmpnvp = this.nav.findNVPair(nvp, "SID_LIST")) == null) {
            nvp = factory.createNVPair("(SID_LIST_" + this.name + "=(SID_LIST=))");
        }
        tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
        int i = 0;
        while (i < array.length) {
            tmpnvp.addListElement(factory.createNVPair(array[i]));
            ++i;
        }
        return nvp;
    }

    private NVPair stripOtherFromNVP(NVPair nvp) {
        if (nvp != null) {
            NVPair tmpnvp = this.nav.findNVPair(nvp, "SID_DESC");
            if (tmpnvp != null) {
                if (this.nav.findNVPair(tmpnvp, "PROGRAM") != null) {
                    return null;
                }
                return nvp;
            }
            tmpnvp = this.nav.findNVPair(nvp, "SID_LIST");
            if (tmpnvp == null) {
                return null;
            }
            int i = 0;
            while (i < tmpnvp.getListSize()) {
                NVPair descnvp = tmpnvp.getListElement(i);
                if (this.nav.findNVPair(descnvp, "PROGRAM") != null) {
                    tmpnvp.removeListElement(i);
                    --i;
                }
                ++i;
            }
            return nvp.getListSize() > 0 ? nvp : null;
        }
        return null;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        if (this.tp == null) {
            return false;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            ListenerOtherServicePage page = (ListenerOtherServicePage)((Object)this.tp.getPage(i).getContent());
            if (page.isChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean areDataValid() {
        if (this.tp == null) {
            return true;
        }
        int i = 0;
        while (i < this.tp.getPageCount()) {
            if (!((ListenerOtherServicePage)((Object)this.tp.getPage(i).getContent())).areDataValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFocus() {
    }
}

