/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.TimePanel;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class Domain
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDomName"), "", "Name"}, {this.ns.getString("nnaMinTTl"), "86400", "MIN_TTL"}};
    private LWTextField[] itemText;
    private TimePanel ttlPanel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWLabel timel;
    private NVNavigator nvnav = new NVNavigator();
    private NVFactory nvfactory = new NVFactory();
    private int invalidIndex;
    private NVPair curnvDomain;
    private Insets panelInsets;

    public Domain() {
        NamesGeneric.debugTracing("Entering Domain");
        this.panelInsets = new Insets(5, 5, 5, 5);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.itemText = new LWTextField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            if (this.i == 1) {
                this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.fill = 0;
                this.gb.setConstraints((Component)this.l, this.gbc);
                ((Container)((Object)this)).add((Component)this.l);
                this.ttlPanel = new TimePanel(true, true, true);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.fill = 2;
                this.gbc.gridwidth = 0;
                this.gbc.weightx = 2.0;
                this.gb.setConstraints((Component)((Object)this.ttlPanel), this.gbc);
                ((Container)((Object)this)).add((Component)((Object)this.ttlPanel));
            } else {
                this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                this.gbc.fill = 0;
                this.gb.setConstraints((Component)this.l, this.gbc);
                ((Container)((Object)this)).add((Component)this.l);
                this.gbc.gridx = -1;
                this.gbc.gridwidth = 0;
                this.gbc.fill = 2;
                this.gbc.weightx = 3.0;
                this.itemText[this.i] = new LWTextField();
                this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
                ((Container)((Object)this)).add((Component)this.itemText[this.i]);
            }
            ++this.i;
        }
    }

    public Domain(NVPair nvDomain) {
        this();
        this.display(nvDomain);
        this.curnvDomain = nvDomain;
        NamesGeneric.debugTracing("Exitting Domain");
    }

    public void display(NVPair nvDomain) {
        NamesGeneric.debugTracing("Entering Domain:display");
        NVNavigator nvnav = new NVNavigator();
        if (nvDomain != null) {
            NamesGeneric.debugTracing("nvDomain=" + nvDomain.toString());
            this.i = 0;
            while (this.i < this.itemNames.length) {
                NVPair nvpair = nvnav.findNVPairRecurse(nvDomain, this.itemNames[this.i][2]);
                if (this.i == 1) {
                    if (nvpair != null) {
                        NamesGeneric.debugTracing("Domain:display:nvpairi=1=" + nvpair.toString());
                        this.ttlPanel.setTime(Integer.parseInt(nvpair.getAtom(), 10));
                    } else {
                        this.ttlPanel.setTime(Integer.parseInt(this.itemNames[this.i][1], 10));
                    }
                } else if (nvpair != null) {
                    this.itemText[this.i].setText(nvpair.getAtom());
                    NamesGeneric.debugTracing("Domain:display:nvpair=" + nvpair.toString());
                } else {
                    this.itemText[this.i].setText(this.itemNames[this.i][1]);
                }
                ++this.i;
            }
        }
        NamesGeneric.debugTracing("Exitting Domain:display");
    }

    public NVPair getDisplayedDomain() {
        NamesGeneric.debugTracing("Entering Domain:getDomain");
        NVPair newParam = this.nvfactory.createNVPair("(DOMAIN=)");
        int i = 0;
        while (i < this.itemNames.length) {
            String s1;
            if (i == 1) {
                int time = this.ttlPanel.getTimeInSec();
                s1 = String.valueOf(time);
            } else {
                s1 = this.itemText[i].getText();
            }
            String s = new String(this.itemNames[i][2]);
            if (s1.length() > 0) {
                newParam.addListElement(this.nvfactory.createNVPair("(" + s + "=" + s1 + ")"));
            } else if (i == 0) {
                newParam.addListElement(this.nvfactory.createNVPair("(Name=)"));
            }
            ++i;
        }
        this.curnvDomain = newParam;
        return newParam;
    }

    public NVPair getDomain() {
        return this.curnvDomain;
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering Domain:isDataValid");
        int i = 0;
        while (i < this.itemNames.length) {
            if (i == 1) {
                if (!NamesValidate.validateTimeField(this.ttlPanel, this.itemNames[i][0])) {
                    this.invalidIndex = i;
                    return false;
                }
                int time = this.ttlPanel.getTimeInSec();
            } else {
                String name = this.itemText[i].getText().trim();
                if (name != null && name.length() != 0 && !NamesValidate.validateText(this.itemText[i], this.itemNames[i][0])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void setDomainName(String name) {
        this.itemText[0].setText(name);
    }

    public void setMinTTL(String ttl) {
        int time;
        try {
            time = Integer.parseInt(ttl);
        }
        catch (NumberFormatException numberFormatException) {
            time = 0;
        }
        this.ttlPanel.setTime(time);
    }
}

