/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesAddress
extends EwtContainer
implements NamesCache,
ActionListener,
ItemListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaAddress"), "NS1", "names.addresses"}};
    private String addString = this.ns.getString("nnaAdd");
    private String removeString = this.ns.getString("nnaRemove");
    private String changeString = this.ns.getString("nnaChange");
    private LWTextField[] itemText;
    private LWList curList;
    private LWLabel l;
    private LWCheckbox cb;
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton changeButton;
    private EwtContainer buttonPanel;
    private EwtContainer outPanel;
    private GridBagConstraints gbc;
    private NetAddr addrPanel;
    private Vector addrVector = new Vector(3);
    private NLParamParser nlpa;
    private NVFactory nvfactory = new NVFactory();
    private int curaddrIndex;
    private boolean changeHuaKya;
    private boolean addressRemoved;

    public NamesAddress() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.outPanel = new EwtContainer();
        this.outPanel.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        NVPair nvAddr = this.nvfactory.createNVPair("(Address=(protocol=tcp))");
        this.addrPanel = new NetAddr(nvAddr);
        this.addrPanel.setAppEnv(NetUtils.getApplication());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.outPanel.add((Component)((Object)this.addrPanel), this.gbc);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout());
        this.addButton = new LWButton(this.addString);
        this.buttonPanel.add((Component)this.addButton);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        this.buttonPanel.add((Component)this.removeButton);
        this.removeButton.addActionListener((ActionListener)this);
        this.changeButton = new LWButton(this.changeString);
        this.buttonPanel.add((Component)this.changeButton);
        this.changeButton.addActionListener((ActionListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.outPanel.add((Component)this.buttonPanel, this.gbc);
        this.removeButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        this.curList = new LWList(5, false);
        this.curList.addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.outPanel.add((Component)this.curList, this.gbc);
        ((Container)((Object)this)).add((Component)this.outPanel, "Center");
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.nlpa = nlpaParam;
    }

    public void get() {
        this.curaddrIndex = 0;
        if (this.nlpa == null) {
            return;
        }
        int i = 0;
        while (i < this.itemNames.length) {
            this.curList.removeAll();
            this.addrVector.removeAllElements();
            NVPair nvAddr = this.nlpa.getNLPListElement(new String(this.itemNames[i][2]));
            if (nvAddr != null) {
                String addrType = (nvAddr = nvAddr.getListElement(0)).getName();
                if (addrType.equalsIgnoreCase("Address_list")) {
                    this.doAddrList(nvAddr);
                } else {
                    this.addAddrPanel(nvAddr);
                }
            } else if (this.nlpa.getNLPListElement("names.server_name") != null) {
                nvAddr = this.nvfactory.createNVPair("(Address=(protocol=tcp)(port=1575)(host=" + NamesGeneric.getLocalHost() + "))");
                this.addAddrPanel(nvAddr);
            }
            ++i;
        }
    }

    public void set() {
        NVPair newParam;
        NVNavigator nvnav = new NVNavigator();
        if (this.nlpa == null) {
            return;
        }
        int size = this.addrVector.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            newParam = this.nvfactory.createNVPair(this.addrVector.elementAt(0).toString());
        } else {
            newParam = this.nvfactory.createNVPair("(Address_List=)");
            int i = 0;
            while (i < this.addrVector.size()) {
                newParam.addListElement((NVPair)this.addrVector.elementAt(i));
                ++i;
            }
        }
        try {
            this.nlpa.addNLPListElement(String.valueOf(this.itemNames[0][2]) + "=" + newParam.toString());
        }
        catch (NLException nLException) {}
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof LWButton) {
            int i;
            if (e.getActionCommand().compareTo(this.addString) == 0) {
                if (!this.addrPanel.areDataValid()) {
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nvAddr = this.addrPanel.getAddr();
                if (nvAddr == null) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaAddressNull"));
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair newAddr = this.nvfactory.createNVPair(nvAddr.toString());
                if (this.checkDups(newAddr)) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaSameAddr"));
                    return;
                }
                this.addrVector.addElement(newAddr);
                this.curList.addItem(nvAddr.toString().toLowerCase());
                this.changeHuaKya = true;
            } else if (e.getActionCommand().compareTo(this.removeString) == 0) {
                int i2 = this.curList.getSelectedIndex();
                if (i2 >= 0) {
                    this.addressRemoved = true;
                    NVPair nvAddr = this.nvfactory.createNVPair(this.curList.getSelectedItem());
                    this.curList.remove(i2);
                    this.addrVector.removeElementAt(i2);
                    int temp = this.curList.getSelectedIndex();
                    if (temp > 0) {
                        this.curList.deselect(temp);
                    }
                    this.removeButton.setEnabled(false);
                    this.changeButton.setEnabled(false);
                    this.changeHuaKya = true;
                }
            } else if (e.getActionCommand().compareTo(this.changeString) == 0 && (i = this.curList.getSelectedIndex()) >= 0) {
                if (!this.addrPanel.areDataValid()) {
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair nvAddr = this.addrPanel.getAddr();
                if (nvAddr == null) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaAddressNull"));
                    this.addrPanel.setFocus();
                    return;
                }
                NVPair newAddr = this.nvfactory.createNVPair(nvAddr.toString());
                if (this.checkDups(newAddr)) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaSameAddr"));
                    return;
                }
                this.addrVector.removeElementAt(i);
                this.addrVector.insertElementAt(newAddr, i);
                this.curList.remove(i);
                this.curList.addItem(this.addrPanel.getAddr().toString().toLowerCase(), i);
                int temp = this.curList.getSelectedIndex();
                if (temp > 0) {
                    this.curList.deselect(temp);
                }
                this.changeButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.changeHuaKya = true;
            }
        }
    }

    private void doAddrList(NVPair nvAddr) {
        int i = 0;
        while (i < nvAddr.getListSize()) {
            this.addAddrPanel(nvAddr.getListElement(i));
            ++i;
        }
    }

    private void addAddrPanel(NVPair nvAddr) {
        this.addrVector.addElement(this.nvfactory.createNVPair(nvAddr.toString()));
        this.curList.addItem(nvAddr.toString().toLowerCase());
    }

    private void displayAddrPanel(NVPair nvAddr) {
        this.curList.addItem(nvAddr.toString());
    }

    public void itemStateChanged(ItemEvent e) {
        int stateChange = e.getStateChange();
        if (stateChange == 1) {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
            NVPair nvAddr = this.nvfactory.createNVPair(this.curList.getSelectedItem());
            this.addrPanel.display(nvAddr);
        }
    }

    public void setChangeHuaKya(boolean state) {
        this.changeHuaKya = state;
    }

    public boolean isDataValid() {
        if (this.addressRemoved && this.addrVector.size() == 0) {
            Frame frame = NetUtils.getApplication().getFrame();
            Alert a = new Alert(frame, this.ns.getString("nnaZeroAddressesError"), 0, 1);
            a.runAlert();
            return false;
        }
        return true;
    }

    public void setFocus() {
    }

    public boolean isChanged() {
        return this.changeHuaKya;
    }

    private boolean checkDups(NVPair nvaddr) {
        String address = nvaddr.toString();
        int i = 0;
        while (i < this.addrVector.size()) {
            if (address.equalsIgnoreCase(this.addrVector.elementAt(i).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

