/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.operate;

public class NamesAliases
extends EwtContainer
implements ItemListener,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaAliasName"), this.ns.getString("nnaCanonicalName")};
    private String[] cbNames = new String[]{this.ns.getString("nnaQuery"), this.ns.getString("nnaAdd"), this.ns.getString("nnaRemove")};
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWCheckbox[] cb;
    private LWCheckboxGroup cbg = new LWCheckboxGroup();
    private EwtContainer aliasPanel;
    private EwtContainer cbPanel;
    private EwtContainer dataPanel;
    private EwtContainer labelPanel;
    private EwtContainer outPanel;
    private EwtContainer opsPanel;
    private EwtContainer execButtonPanel;
    private operate m_oper;
    private LWButton execButton;

    public NamesAliases() {
        NamesGeneric.debugTracing("Entering NamesAliases:NamesAliases");
        this.m_oper = new operate();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.outPanel = new EwtContainer();
        this.outPanel.setLayout(this.gb);
        this.labelPanel = new EwtContainer();
        this.labelPanel.setLayout(new GridLayout(1, 1));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gb.setConstraints((Component)this.labelPanel, this.gbc);
        this.outPanel.add((Component)this.labelPanel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaOps"), InsetFramePainter.getFramePainter(), 2));
        this.outPanel.add((Component)this.opsPanel);
        this.aliasPanel = new EwtContainer();
        this.aliasPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.aliasPanel, this.gbc);
        this.aliasPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaAliases"), InsetFramePainter.getFramePainter(), 2));
        this.outPanel.add((Component)this.aliasPanel);
        this.l = new LWLabel(this.ns.getString("nnaAliaslabel1"), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.labelPanel.add((Component)this.l);
        this.itemText = new LWTextField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i;
            this.l = new LWLabel(new String(this.itemNames[this.i]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.aliasPanel.add((Component)this.l);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWTextField(20);
            this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
            this.aliasPanel.add((Component)this.itemText[this.i]);
            ++this.i;
        }
        this.cb = new LWCheckbox[this.cbNames.length];
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.cbPanel, this.gbc);
        this.opsPanel.add((Component)this.cbPanel);
        this.i = 0;
        while (this.i < this.cbNames.length) {
            this.cb[this.i] = new LWCheckbox(new String(this.cbNames[this.i]), this.cbg, false);
            this.cb[this.i].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.cb[this.i], this.gbc);
            this.cbPanel.add((Component)this.cb[this.i]);
            ++this.i;
        }
        this.execButtonPanel = new EwtContainer();
        this.execButtonPanel.setLayout(new FlowLayout(2));
        ++this.gbc.gridx;
        this.gb.setConstraints((Component)this.execButtonPanel, this.gbc);
        this.opsPanel.add((Component)this.execButtonPanel);
        this.execButton = new LWButton(this.ns.getString("nnaExec"));
        this.gb.setConstraints((Component)this.execButton, this.gbc);
        this.execButton.addActionListener((ActionListener)this);
        this.execButtonPanel.add((Component)this.execButton);
        ((Container)((Object)this)).add((Component)this.outPanel, "North");
        this.itemText[0].setEditable(true);
        this.itemText[1].setEditable(false);
        this.cb[0].setState(true);
        NamesGeneric.debugTracing("Exiting NamesAliases:NamesAliases");
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        NamesGeneric.debugTracing("Entering NamesAliases:itemStateChanged");
        this.itemText[0].requestFocus();
        if (source instanceof LWCheckbox) {
            String label = e.getItem().toString();
            if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setEditable(false);
                NetUtils.getApplication().showStatus("");
            }
            if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setText("");
                this.itemText[1].setEditable(true);
                NetUtils.getApplication().showStatus("");
            }
            if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setEditable(false);
                NetUtils.getApplication().showStatus("");
            }
        }
        NamesGeneric.debugTracing("Exiting NamesAliases:itemStateChanged");
    }

    public void PerformOp() {
        int argc;
        String[] argv = new String[3];
        int res = 4;
        boolean query = false;
        boolean dataChange = false;
        NamesGeneric.debugTracing("Entering NamesAliases:PerformOp");
        argv[0] = this.itemText[0].getText().trim();
        String label = this.cbg.getSelectedCheckbox().getLabel();
        if (argv[0].length() == 0) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaValidName"));
            return;
        }
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            argv[1] = "cname.smd";
            argc = 2;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQuerySent"));
            res = this.m_oper.query(argv, argc, (short)1);
            query = true;
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            argv[1] = "cname.smd";
            argv[2] = this.itemText[1].getText().trim();
            if (argv[2].length() == 0) {
                NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaInvCanonNm"));
                return;
            }
            argc = 1;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatCrName"));
            res = this.m_oper.createName(argv, argc, (short)1);
            if (res == 0) {
                argc = 3;
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddSent"));
                res = this.m_oper.addData(argv, argc, (short)1);
                if (res == 0) {
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddSuc"));
                    dataChange = true;
                } else if (res == 2) {
                    NetUtils.getApplication().showStatus("nnaStatAddWarn");
                    dataChange = true;
                } else {
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddFail"));
                }
            }
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            argc = 1;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemSent"));
            res = this.m_oper.deleteName(argv, argc, (short)1);
            if (res == 0 || res == 2) {
                dataChange = true;
                this.itemText[0].setText("");
                this.itemText[1].setText("");
            }
        }
        if (res > 3) {
            return;
        }
        switch (res) {
            case 0: 
            case 2: {
                if (dataChange) {
                    dataChange = false;
                    argv[1] = "cname.smd";
                    argc = 2;
                    NetUtils.getApplication().showStatus(String.valueOf(this.ns.getString("nnaStatQueryNm")) + argv[0]);
                    int qres = this.m_oper.query(argv, argc, (short)2);
                    if (qres == 0 || qres == 2) {
                        query = true;
                        this.itemText[1].setText("");
                    } else {
                        NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQueryFail"));
                        break;
                    }
                }
                if (!query) break;
                query = false;
                String answer = this.m_oper.returnResp();
                int start = answer.indexOf("Syntax is");
                if (start > 0) {
                    int end = answer.indexOf("\n", start += 18);
                    this.itemText[1].setText(answer.substring(start, end));
                }
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpCompl"));
                break;
            }
            default: {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpCompl"));
            }
        }
        NamesGeneric.debugTracing("Exiting NamesAliases:PerformOp");
    }

    public void actionPerformed(ActionEvent e) {
        NamesGeneric.debugTracing("Entering NamesAliases:actionPerformed");
        Object source = e.getSource();
        String okString = this.ns.getString("nnaOk");
        String execStr = this.ns.getString("nnaExec");
        if (source instanceof LWButton && e.getActionCommand().compareTo(execStr) == 0) {
            this.PerformOp();
        }
        NamesGeneric.debugTracing("Exiting NamesAliases:actionPerformed");
    }

    public void showProperStatus() {
        String label = this.cbg.getSelectedCheckbox().getLabel();
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            NetUtils.getApplication().showStatus("");
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            NetUtils.getApplication().showStatus("");
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            NetUtils.getApplication().showStatus("");
        }
    }
}

