/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.cache;

public class NamesCacheOps
extends EwtContainer
implements ItemListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaFlushCache"), this.ns.getString("nnaReload"), this.ns.getString("nnaNextCacheCkp"), this.ns.getString("nnaNextCacheDump")};
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel secondsLabel;
    private LWLabel noteLabel;
    private LWTextField textField;
    private LWCheckbox[] cacheCb;
    private LWCheckbox[] timeCb;
    private LWCheckboxGroup cacheGroup;
    private LWCheckboxGroup timeGroup;
    private EwtContainer cachePanel;
    private EwtContainer opsPanel;
    private EwtContainer timePanel;
    private Insets panelInsets;
    private cache m_cache;

    public NamesCacheOps() {
        NamesGeneric.debugTracing("Entering class:NamesCacheOps");
        this.m_cache = new cache();
        this.panelInsets = new Insets(4, 4, 4, 4);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.sharedBorderPixel = new MarginBorder(4, 4, 4, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.cachePanel = new EwtContainer();
        this.cachePanel.setLayout(this.gb);
        this.noteLabel = new LWLabel(this.ns.getString("nnaZeroWaitLabel"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.noteLabel, this.gbc);
        this.cachePanel.add((Component)this.noteLabel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaCacheOps"), InsetFramePainter.getFramePainter(), 2));
        this.cachePanel.add((Component)this.opsPanel);
        this.timePanel = new EwtContainer();
        this.timePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.timePanel, this.gbc);
        this.timePanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaPerformOp"), InsetFramePainter.getFramePainter(), 2));
        this.cachePanel.add((Component)this.timePanel);
        this.gbc.ipadx = 10;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.cacheGroup = new LWCheckboxGroup();
        this.cacheCb = new LWCheckbox[this.itemNames.length];
        int i = 0;
        while (i < this.itemNames.length) {
            this.gbc.gridx = -1;
            ++this.gbc.gridy;
            this.cacheCb[i] = new LWCheckbox(new String(this.itemNames[i]), this.cacheGroup, false);
            this.cacheCb[i].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.cacheCb[i], this.gbc);
            this.opsPanel.add((Component)this.cacheCb[i]);
            ++i;
        }
        this.gbc.insets = this.panelInsets;
        this.timeGroup = new LWCheckboxGroup();
        this.timeCb = new LWCheckbox[2];
        this.timeCb[0] = new LWCheckbox(this.ns.getString("nnaImmediately"), this.timeGroup, false);
        this.timeCb[0].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gb.setConstraints((Component)this.timeCb[0], this.gbc);
        this.timePanel.add((Component)this.timeCb[0]);
        this.timeCb[1] = new LWCheckbox(this.ns.getString("nnaWait"), this.timeGroup, false);
        this.timeCb[1].addItemListener((ItemListener)this);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.timeCb[1], this.gbc);
        this.timePanel.add((Component)this.timeCb[1]);
        this.gbc.ipadx = 0;
        this.gbc.weightx = 5.0;
        ++this.gbc.gridx;
        this.gbc.gridwidth = -1;
        this.gbc.fill = 2;
        this.textField = new LWTextField(12);
        this.gb.setConstraints((Component)this.textField, this.gbc);
        this.timePanel.add((Component)this.textField);
        this.textField.setEditable(false);
        this.gbc.gridx = -1;
        this.gbc.gridwidth = 0;
        this.secondsLabel = new LWLabel(this.ns.getString("nnaSeconds"));
        this.gb.setConstraints((Component)this.secondsLabel, this.gbc);
        this.timePanel.add((Component)this.secondsLabel);
        this.secondsLabel.setEnabled(false);
        ((Container)((Object)this)).add((Component)this.cachePanel, "North");
        NamesGeneric.debugTracing("Exiting class:NamesCacheOps");
    }

    public void LoadFirstTime() {
    }

    public void PerformOp() {
        String waitTime;
        int res = -1;
        String[] argv = new String[1];
        int argc = 0;
        NamesGeneric.debugTracing("Entering PerformOp:NamesCacheOps");
        LWCheckbox cb = this.cacheGroup.getSelectedCheckbox();
        if (cb == null) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaNullSelection"));
            return;
        }
        String label = cb.getLabel();
        if (this.timeGroup.getSelectedCheckbox().getLabel().compareTo(this.ns.getString("nnaWait")) == 0) {
            waitTime = this.textField.getText();
            try {
                int intTime = Integer.parseInt(waitTime, 10);
            }
            catch (NumberFormatException numberFormatException) {
                waitTime = null;
                NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaWaitMustBeNumber"));
                return;
            }
            argv[0] = waitTime;
            argc = 1;
        } else {
            waitTime = null;
        }
        if (label.compareTo(this.ns.getString("nnaFlushCache")) == 0) {
            if (waitTime == null) {
                res = this.m_cache.flushCache();
                if (res == 0) {
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerCacheFlushed"));
                }
            } else {
                res = this.m_cache.flushCache(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaFlushingCache")) + this.m_cache.returnResp();
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        } else if (label.compareTo(this.ns.getString("nnaReload")) == 0) {
            if (waitTime == null) {
                res = this.m_cache.setReload();
                if (res == 0) {
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaReloadComplete"));
                }
            } else {
                res = this.m_cache.setReload(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaReloading")) + this.m_cache.returnResp();
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        } else if (label.compareTo(this.ns.getString("nnaNextCacheCkp")) == 0) {
            res = this.m_cache.setNextCacheCkp(argv, argc);
            if (res == 0) {
                String message = String.valueOf(this.ns.getString("nnaCkpingCache")) + this.m_cache.returnResp();
                NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
            }
        } else {
            res = this.m_cache.setNextCacheDump(argv, argc);
            if (res == 0) {
                String message = String.valueOf(this.ns.getString("nnaDumpingCache")) + this.m_cache.returnResp();
                NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
            }
        }
        NamesGeneric.debugTracing("Exiting PerformOp:NamesCacheOps");
    }

    public void LoadIntoScreen() {
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        NamesGeneric.debugTracing("Entering itemStateChanged:NamesCacheOps");
        if (source instanceof LWCheckbox) {
            String cbLabel = e.getItem().toString();
            if (cbLabel.compareTo(this.ns.getString("nnaImmediately")) == 0) {
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            } else if (cbLabel.compareTo(this.ns.getString("nnaWait")) == 0) {
                this.textField.setEditable(true);
                this.secondsLabel.setEnabled(true);
            } else if (cbLabel.compareTo(this.ns.getString("nnaNextCacheCkp")) == 0) {
                this.timeCb[1].setState(true);
                this.timeCb[0].setEnabled(false);
                this.textField.setEditable(true);
                this.secondsLabel.setEnabled(true);
            } else if (cbLabel.compareTo(this.ns.getString("nnaNextCacheDump")) == 0) {
                this.timeCb[1].setState(true);
                this.timeCb[0].setEnabled(false);
                this.textField.setEditable(true);
                this.secondsLabel.setEnabled(true);
            } else {
                this.timeCb[0].setEnabled(true);
                this.timeCb[0].setState(true);
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            }
        }
        NamesGeneric.debugTracing("Exiting itemStateChanged:NamesCacheOps");
    }

    public void clearPanel() {
    }
}

