/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.net.asst.component.NetComponent;
import oracle.net.asst.component.NetObjectMenu;
import oracle.net.asst.component.NetObjectToolbar;
import oracle.net.asst.component.NetVector;
import oracle.net.asst.container.NetApplication;
import oracle.net.asst.container.NetPanel;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesAdmin;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.SdnsDialog;
import oracle.net.asst.names.control;
import oracle.net.asst.names.nnccj;
import oracle.net.asst.nameswizard.NamesWizardMain;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NamesComponent
extends NetComponent
implements ActionListener {
    private static String currSrvr;
    NetStrings ns = new NetStrings();
    private final String TITLE = this.ns.getString("nnaNS");
    private final String FILENAME = "names.ora";
    private NetVector objectVector;
    private NamesAdmin namesAdmin;
    private String dirName;
    private boolean isAlivef;
    private Vector sdnsLines;
    private Vector addrVector;
    private NetVector toolbarVect;
    private NetVector menuVect;
    private control m_control;
    private nnccj m_nnccj;
    private NamesAdmin m_namesadm;
    private String sdns_filename;
    private String names_filename;
    private EwtContainer nsPanel;
    private String Name_namesora;
    private String Addr_namesora;
    private String default_name = "onames_" + NamesGeneric.getLocalHost();
    private String oraNames;
    private String default_addr = "(address=(host=" + NamesGeneric.getLocalHost() + ")(protocol=tcp)(port=1575))";
    private SdnsDialog dialog;
    private final NVNavigator nvnav = new NVNavigator();
    private final NVFactory nvfact = new NVFactory();

    public NamesComponent() {
        try {
            NetProperties netProp = new NetProperties();
            NamesGeneric.setDebug(netProp.getProperty("NamesTrace"));
        }
        catch (Exception e) {
            NamesGeneric.debugTracing("io exception " + e.getMessage());
        }
        NamesGeneric.debugTracing("Entering class:NamesComponent");
        NamesGeneric.setAppFrame((BufferedFrame)NetUtils.getApplication().getFrame());
        this.toolbarVect = new NetVector();
        this.toolbarVect.addElement(new NetObjectToolbar(this.ns.getString("CNTDelete"), null, false));
        this.menuVect = new NetVector();
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTTools"), this.ns.getString("nnaDiscNS"), true));
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTTools"), this.ns.getString("nnaReloadNS"), true));
        this.menuVect.addElement(new NetObjectMenu(this.ns.getString("CNTEdit"), this.ns.getString("CNTDelete"), false));
        NamesGeneric.debugTracing("Exiting NamesComponent:NamesComponent");
    }

    public NamesComponent(WebApplication w) {
        this();
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:NamesComponent");
        this.nsPanel = new NetPanel(w, "NS_placebo.gif", this.ns.getString("nnaIntroMessage"));
    }

    public NetVector getObjects(String directory) {
        File names_ora;
        this.addrVector = new Vector();
        this.objectVector = new NetVector();
        NamesGeneric.debugTracing("Entering NamesComponent:getObjects");
        NamesGeneric.debugTracing("The directory = " + directory);
        this.dirName = new String(directory);
        this.names_filename = String.valueOf(directory) + "names.ora";
        this.oraNames = NamesGeneric.getOraNames();
        NamesGeneric.debugTracing("dir is " + this.oraNames);
        this.sdns_filename = NamesGeneric.OS.startsWith("Windows") ? String.valueOf(this.oraNames) + "sdns.ora" : String.valueOf(this.oraNames) + ".sdns.ora";
        NamesGeneric.debugTracing("sdns file is " + this.sdns_filename);
        this.sdnsLines = new Vector();
        try {
            this.readOraFile(this.sdns_filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            NamesGeneric.debugTracing(".sdns.ora file is not present");
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("io exception");
        }
        if (this.sdnsLines != null && this.sdnsLines.size() > 0) {
            this.addrVector = new Vector(this.sdnsLines.size());
            int i = 1;
            while (i < this.sdnsLines.size()) {
                String line = (String)this.sdnsLines.elementAt(i);
                int index = line.indexOf(61);
                if (index == -1) {
                    NamesGeneric.debugTracing(".sdns.ora is corrupted");
                    String message = this.ns.getString("nnaSdnsCorrupt");
                    NamesDialog.popUp(this.ns.getString("nnaError"), message);
                } else {
                    String name = line.substring(0, index).trim();
                    String addr = line.substring(index + 1).trim();
                    this.objectVector.addElement(name);
                    this.addrVector.addElement(addr);
                }
                ++i;
            }
        }
        if ((names_ora = new File(this.names_filename)).exists()) {
            NamesGeneric.debugTracing("names.ora exists");
            try {
                NLParamParser nlpa = null;
                NVPair nvpair = null;
                try {
                    nlpa = new NLParamParser(this.names_filename);
                }
                catch (Throwable e) {
                    NamesGeneric.debugTracing("message" + e.getMessage());
                }
                nvpair = nlpa.getNLPListElement("names.server_name");
                if (nvpair != null) {
                    this.Name_namesora = nvpair.getAtom();
                }
                if ((nvpair = nlpa.getNLPListElement("names.addresses")) != null) {
                    NVPair nvaddr = this.nvnav.findNVPairRecurse(nvpair, "address");
                    this.Addr_namesora = nvaddr.toString();
                }
                NamesGeneric.debugTracing("name from nvpair " + this.Name_namesora);
                NamesGeneric.debugTracing("addr from nvpair " + this.Addr_namesora);
            }
            catch (Exception exception) {
                NamesGeneric.debugTracing("names.ora file is not present");
            }
            if (this.Name_namesora == null) {
                this.Name_namesora = this.default_name;
            }
            if (this.Addr_namesora == null) {
                this.Addr_namesora = this.default_addr;
            }
            if (!this.addrPresent(this.Addr_namesora)) {
                this.addrVector.addElement(this.Addr_namesora);
                this.objectVector.addElement(this.Name_namesora);
            }
        }
        if (this.isAlivef) {
            this.m_namesadm.activate(String.valueOf(directory) + "names.ora");
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:getObjects");
        return this.objectVector;
    }

    public boolean saveObjects(String directory) {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:saveObjects");
        if (this.m_namesadm != null) {
            return this.m_namesadm.save(String.valueOf(directory) + "names.ora");
        }
        return true;
    }

    public NetVector getComponentMenus() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:getComponentMenus");
        return this.menuVect;
    }

    public NetVector getComponentToolbar() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:getComponentToolbars");
        return this.toolbarVect;
    }

    public int getObjectIndex(String obj) {
        NamesGeneric.debugTracing("Entering NamesComponent:getObjectIndex");
        NamesGeneric.debugTracing("size " + this.objectVector.size() + "str " + obj);
        int i = 0;
        while (i < this.objectVector.size()) {
            NamesGeneric.debugTracing("objvec " + i + (String)this.objectVector.elementAt(i));
            if (((String)this.objectVector.elementAt(i)).compareTo(obj) == 0) {
                return i;
            }
            ++i;
        }
        NamesGeneric.debugTracing("getobjindex failed");
        NamesGeneric.debugTracing("Exiting NamesComponent:getObjectIndex");
        return -1;
    }

    public Object createObject(Object objectName) {
        NamesGeneric.debugTracing("Entering NamesComponent:createObject");
        try {
            File names_ora = new File(this.names_filename);
            if (!names_ora.exists()) {
                Cursor defCursor = Cursor.getDefaultCursor();
                NamesGeneric.appFrame.setCursor(new Cursor(3));
                NamesWizardMain m_theWizard = new NamesWizardMain(NamesGeneric.appFrame, this.dirName);
                m_theWizard.go();
                NamesGeneric.appFrame.setCursor(defCursor);
                if (NamesGeneric.OS.startsWith("Windows")) {
                    NamesGeneric.appFrame.toFront();
                }
                if (!m_theWizard.getWizardFinishState()) {
                    return null;
                }
                this.default_name = m_theWizard.getServerName();
                this.default_addr = m_theWizard.getServerAddress();
                this.objectVector.addElement(this.default_name);
                this.addrVector.addElement(this.default_addr);
                Object[] objArray = new Object[]{this.default_name, this.ns.getString("nnaConfigure")};
                NamesDialog.popUp(this.ns.getString("nnaNSCreated"), this.ns.getString("nnaNSCreatedText", objArray));
                NamesGeneric.setNewServerConfig(true);
                return this.default_name;
            }
            NamesDialog.popUp(this.ns.getString("nnaNSExists"), this.ns.getString("nnaNSExists"));
        }
        catch (Exception e) {
            NamesGeneric.debugTracing("createObject error " + e.getMessage());
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:createObject");
        return null;
    }

    public boolean deactivateObject(Object objectName) {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:deactivateObject");
        if (this.isAlivef) {
            return this.m_namesadm.validateConfig();
        }
        return true;
    }

    public boolean discardObjects() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:discardObjects");
        if (this.isAlivef) {
            return this.m_namesadm.discard();
        }
        return true;
    }

    public boolean deleteObject(Object objectName) {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:deleteObject");
        return true;
    }

    public String toString() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:toString");
        return this.TITLE;
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exiting NamesComponent:isChanged");
        if (this.isAlivef) {
            return this.m_namesadm.isChanged();
        }
        return false;
    }

    public EwtContainer activateObject(Object objectName) {
        int index;
        String addr;
        NVPair host;
        NamesGeneric.debugTracing("Entering NamesComponent:activateObject");
        NetApplication theApp = NetUtils.getApplication();
        BufferedFrame theAppFrame = (BufferedFrame)theApp.getFrame();
        if (objectName == null) {
            NamesGeneric.debugTracing("activateObject: null objectname");
            theApp.showStatus("");
            theAppFrame.setCursor(Cursor.getDefaultCursor());
            if (this.addrVector.size() == 0) {
                Object[] objArray = new Object[]{this.ns.getString("CNTTools"), this.ns.getString("nnaDiscNS")};
                NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaNoNSMessage", objArray));
            }
            return this.nsPanel;
        }
        theAppFrame.setCursor(new Cursor(3));
        theApp.showStatus(this.ns.getString("nnaHoldOn"));
        if (this.m_namesadm == null) {
            if (this.m_nnccj == null) {
                this.m_nnccj = new nnccj(0);
            }
            if (this.m_control == null) {
                this.m_control = new control();
            }
            try {
                this.m_namesadm = new NamesAdmin();
            }
            catch (Throwable e) {
                NamesGeneric.debugTracing("error initializing names object: " + e);
                return this.nsPanel;
            }
        }
        addr = (host = this.nvnav.findNVPairRecurse(this.nvfact.createNVPair(addr = (String)this.addrVector.elementAt(index = this.getObjectIndex(objectName.toString().trim()))), "host")) != null ? host.getAtom() : "_INVALID_HOST_NAME_";
        try {
            String[] argv = new String[1];
            index = this.getObjectIndex(objectName.toString().trim());
            argv[0] = (String)this.addrVector.elementAt(index);
            nnccj.setServerAddress(argv[0]);
            this.m_control.setServer(argv, 1, (short)3);
            this.m_namesadm.enableConfigure(NamesGeneric.isSameHost(addr, null));
            currSrvr = (String)this.addrVector.elementAt(index);
            if (this.m_control.pingServer(argv, 1, (short)3) == 0) {
                this.m_namesadm.refreshAllScreens();
            } else {
                this.m_namesadm.clearScreens();
            }
        }
        catch (Throwable e) {
            System.err.println("activateObject: problem" + e);
            return this.nsPanel;
        }
        this.isAlivef = true;
        this.m_namesadm.activate(String.valueOf(this.dirName) + "names.ora");
        if (NamesGeneric.newServerConfig) {
            this.m_namesadm.showConfigPanel();
            NamesGeneric.setNewServerConfig(false);
        } else {
            this.m_namesadm.setPreviousPanel();
        }
        theApp.showStatus("");
        theAppFrame.setCursor(Cursor.getDefaultCursor());
        return this.m_namesadm;
    }

    public boolean executeComponentMenu(String menuName) {
        BufferedFrame theAppFrame = NamesGeneric.appFrame;
        NamesGeneric.debugTracing("Entering NamesComponent:executeComponentMenu");
        NamesGeneric.debugTracing("menu " + menuName + "selected");
        if (this.m_nnccj == null) {
            this.m_nnccj = new nnccj(0);
        }
        if (this.m_control == null) {
            this.m_control = new control();
        }
        if (menuName.compareTo(this.ns.getString("nnaDiscNS")) == 0) {
            this.m_control.reorderNS(null, 0, (short)1);
            try {
                this.readOraFile(this.sdns_filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                NamesGeneric.debugTracing("no well known nameserver running");
                this.dialog = new SdnsDialog(theAppFrame, this.ns.getString("nnaNSDisc"), this);
                this.dialog.dlgShow();
            }
            catch (IOException iOException) {
                NamesGeneric.debugTracing("io exception");
                System.exit(1);
            }
            this.addrVector = new Vector(this.sdnsLines.size());
            boolean addedServer = false;
            int i = 1;
            while (i < this.sdnsLines.size()) {
                String line = (String)this.sdnsLines.elementAt(i);
                int index = line.indexOf(61);
                if (index == -1) {
                    NamesGeneric.debugTracing(".sdns.ora is corrupted");
                    System.exit(1);
                }
                String name = line.substring(0, index).trim();
                String addr = line.substring(index + 1).trim();
                NamesGeneric.debugTracing("NAME:" + name);
                NamesGeneric.debugTracing("ADDRESS:" + addr);
                if (!this.addrPresent(addr)) {
                    this.objectVector.addElement(name);
                    this.addrVector.addElement(addr);
                    addedServer = true;
                }
                ++i;
            }
            if (addedServer) {
                NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerDiscovered"));
            } else {
                NamesGeneric.debugTracing("no additional nameservers found");
                this.dialog = new SdnsDialog(theAppFrame, this.ns.getString("nnaNSDisc"), this);
                this.dialog.dlgShow();
            }
        } else {
            NamesGeneric.debugTracing("reloading nameservers...");
            String[] server_list = new String[this.addrVector.size()];
            int ind = 0;
            while (ind < this.addrVector.size()) {
                server_list[ind] = new String((String)this.addrVector.elementAt(ind));
                server_list[ind] = server_list[ind].trim();
                ++ind;
            }
            this.m_control.reloadNS(server_list, server_list.length);
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:executeComponentMenu");
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        NamesGeneric.debugTracing("Entering NamesComponent:actionPerformed");
        if (source instanceof LWButton) {
            if (e.getActionCommand().compareTo(okString) == 0) {
                if (!this.dialog.isAddressValid()) {
                    return;
                }
                String address = this.dialog.getAddress();
                String[] argv = new String[]{address};
                this.m_control.reorderNS(argv, 1, (short)1);
                File sdnsFile = new File(this.sdns_filename);
                if (!sdnsFile.exists() && (sdnsFile = new File(String.valueOf(this.oraNames) + "sdns.ora")).exists()) {
                    this.sdns_filename = String.valueOf(this.oraNames) + "sdns.ora";
                }
                try {
                    this.readOraFile(this.sdns_filename);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object[] objArray = new Object[]{this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate")};
                    NamesGeneric.debugTracing("Wrong nameserver address");
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaCreateServer", objArray));
                }
                catch (IOException iOException) {
                    NamesGeneric.debugTracing("io exception");
                    System.exit(1);
                }
                this.dialog.dispose();
                this.addrVector = new Vector(this.sdnsLines.size());
                int i = 1;
                while (i < this.sdnsLines.size()) {
                    String line = (String)this.sdnsLines.elementAt(i);
                    int index = line.indexOf(61);
                    if (index == -1) {
                        NamesGeneric.debugTracing(".sdns.ora is corrupted");
                        System.exit(1);
                    }
                    String name = line.substring(0, index).trim();
                    String addr = line.substring(index + 1).trim();
                    NamesGeneric.debugTracing("NAME:" + name);
                    NamesGeneric.debugTracing("ADDRESS:" + addr);
                    if (!this.addrPresent(addr)) {
                        this.objectVector.addElement(name);
                        this.addrVector.addElement(addr);
                    }
                    ++i;
                }
                if (this.sdnsLines.size() > 1) {
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerDiscovered"));
                }
            }
            if (e.getActionCommand().compareTo(cancelString) == 0) {
                Object[] objArray = new Object[]{this.ns.getString("CNTEdit"), this.ns.getString("CNTCreate")};
                NamesGeneric.debugTracing("You may have to create NS objects");
                this.dialog.dispose();
                NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaCreateServer", objArray));
            }
        }
        NamesGeneric.debugTracing("Exiting NamesComponent:actionPerformed");
    }

    public boolean Comp_file_has_Comments() {
        return this.m_namesadm.fileHasComments();
    }

    public boolean addrSame(String addr1, String addr2) {
        NVPair nvAddr1 = this.nvfact.createNVPair(addr1);
        NVPair nvAddr2 = this.nvfact.createNVPair(addr2);
        try {
            NVPair nvProto1 = this.nvnav.findNVPair(nvAddr1, "protocol");
            NVPair nvProto2 = this.nvnav.findNVPair(nvAddr2, "protocol");
            if (!nvProto1.getAtom().equalsIgnoreCase(nvProto2.getAtom())) {
                return false;
            }
            if (nvProto1.getAtom().equalsIgnoreCase("tcp")) {
                NVPair nvPort1 = this.nvnav.findNVPair(nvAddr1, "port");
                NVPair nvHost1 = this.nvnav.findNVPair(nvAddr1, "host");
                NVPair nvPort2 = this.nvnav.findNVPair(nvAddr2, "port");
                NVPair nvHost2 = this.nvnav.findNVPair(nvAddr2, "host");
                if (nvPort1.getAtom().equalsIgnoreCase(nvPort2.getAtom()) && NamesGeneric.isSameHost(nvHost1.getAtom(), nvHost2.getAtom())) {
                    return true;
                }
            } else if (nvProto1.getAtom().equalsIgnoreCase("ipc")) {
                NVPair nvKey1 = this.nvnav.findNVPair(nvAddr1, "key");
                NVPair nvKey2 = this.nvnav.findNVPair(nvAddr2, "key");
                if (nvKey1.getAtom().equalsIgnoreCase(nvKey2.getAtom())) {
                    return true;
                }
            } else if (nvProto1.getAtom().equalsIgnoreCase("spx")) {
                NVPair nvSvc1 = this.nvnav.findNVPair(nvAddr1, "service");
                NVPair nvSvc2 = this.nvnav.findNVPair(nvAddr2, "service");
                if (nvSvc1.getAtom().equalsIgnoreCase(nvSvc2.getAtom())) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public boolean addrPresent(String addr) {
        int index = 0;
        while (index < this.addrVector.size()) {
            NVPair sdnsAddr = this.nvfact.createNVPair((String)this.addrVector.elementAt(index));
            sdnsAddr = this.nvnav.findNVPairRecurse(sdnsAddr, "address");
            NamesGeneric.debugTracing("sdnsAddr is " + sdnsAddr.toString());
            if (this.addrSame(addr, sdnsAddr.toString())) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void writeOraFile(String name, String addr) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        OutputStreamWriter os = null;
        BufferedWriter bw = null;
        NamesGeneric.debugTracing("Entering NamesComponent:writeOraFile");
        File names_file = new File(this.names_filename);
        try {
            names_file.delete();
        }
        catch (Exception e) {
            System.err.println("Error in deleting old names.ora" + e.getMessage());
        }
        try {
            try {
                fos = new FileOutputStream(this.names_filename);
                os = new OutputStreamWriter(fos);
                bw = new BufferedWriter(os);
                String nameLine = "names.server_name=" + name;
                String addrLine = "names.addresses=" + addr;
                bw.write(nameLine, 0, nameLine.length());
                bw.newLine();
                bw.write(addrLine, 0, addrLine.length());
                bw.newLine();
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                if (os != null) {
                    os.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
            if (os != null) {
                os.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        catch (Exception exception) {}
        NamesGeneric.debugTracing("Exiting NamesComponent:writeOraFile");
    }

    private void readOraFile(String filename) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        NamesGeneric.debugTracing("Entering NamesComponent:readOraFile");
        try {
            try {
                String newline;
                fis = new FileInputStream(filename);
                is = new InputStreamReader(fis);
                br = new BufferedReader(is);
                while ((newline = br.readLine()) != null) {
                    if (filename.compareTo(this.sdns_filename) == 0) {
                        this.sdnsLines.addElement(newline);
                        continue;
                    }
                    if (filename.compareTo(this.names_filename) == 0) {
                        NLParamParser nlpa = null;
                        NVPair nvpair = null;
                        try {
                            nlpa = new NLParamParser(filename);
                        }
                        catch (Throwable e) {
                            NamesGeneric.debugTracing("message" + e.getMessage());
                        }
                        nvpair = nlpa.getNLPListElement("names.server_name");
                        if (nvpair != null) {
                            this.Name_namesora = nvpair.getAtom();
                        }
                        if ((nvpair = nlpa.getNLPListElement("names.addresses")) != null) {
                            this.Addr_namesora = nvpair.getAtom();
                        }
                        break;
                    }
                    NamesGeneric.debugTracing("Error in filename");
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (is != null) {
                    is.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (Exception exception) {}
        NamesGeneric.debugTracing("Exiting NamesComponent:readOraFile");
    }
}

