/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesAddress;
import oracle.net.asst.names.NamesAdvanced;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDomains;
import oracle.net.asst.names.NamesGeneral;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesRegion;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;

public class NamesConfigure
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[] panelNames = new String[]{this.ns.getString("nnaGeneral"), this.ns.getString("nnaAddress"), this.ns.getString("nnaDomains"), this.ns.getString("nnaDatabase"), this.ns.getString("nnaAdvanced")};
    private NamesCache[] panels;
    private MarginBorder sharedBorderPixel;
    private TabPanel tp;
    private TabPanelPage[] tpp;
    private int i;
    private NLParamParser nlpa;

    public NamesConfigure() {
        NamesGeneric.debugTracing("Entering NamesConfigure");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.tp = new TabPanel();
        this.tp.setOrientation(0);
        ((Container)((Object)this)).add("Center", (Component)this.tp);
        this.panels = new NamesCache[this.panelNames.length];
        this.tpp = new TabPanelPage[this.panelNames.length];
        this.panels[0] = new NamesGeneral();
        NamesGeneric.debugTracing("general");
        this.panels[1] = new NamesAddress();
        NamesGeneric.debugTracing("addr");
        this.panels[2] = new NamesDomains();
        NamesGeneric.debugTracing("domain");
        this.panels[3] = new NamesRegion();
        NamesGeneric.debugTracing("region");
        this.panels[4] = new NamesAdvanced();
        NamesGeneric.debugTracing("adv");
        this.i = 0;
        while (this.i < this.panelNames.length) {
            this.tpp[this.i] = this.tp.addPage(new String(" " + this.panelNames[this.i] + " "), (Component)((EwtContainer)this.panels[this.i]));
            ++this.i;
        }
    }

    public NamesConfigure(String filename) throws IOException, NLException {
        this();
        this.activate(filename);
        NamesGeneric.debugTracing("Exitting NamesConfigure");
    }

    public void activate(String filename) {
        NamesGeneric.debugTracing("Entering NamesConfigure:activate");
        try {
            this.nlpa = new NLParamParser(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("IO problem.../n");
        }
        catch (NLException nLException) {
            NamesGeneric.debugTracing("NL.../n");
        }
        catch (Exception e) {
            NamesGeneric.debugTracing("message" + e.getMessage());
            System.exit(1);
        }
        int i = 0;
        while (i < this.panelNames.length) {
            this.panels[i].setNLP(this.nlpa);
            ++i;
        }
        i = 0;
        while (i < this.panelNames.length) {
            this.panels[i].get();
            ++i;
        }
        NamesGeneric.debugTracing("Exitting NamesConfigure:activate");
    }

    public boolean discard() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:discard");
        int i = 0;
        while (i < this.panelNames.length) {
            this.panels[i].get();
            ++i;
        }
        return true;
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:isChanged");
        int i = 0;
        while (i < this.panelNames.length) {
            if (this.panels[i].isChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean validateConfig() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:validateConfig...");
        int i = 0;
        while (i < this.panelNames.length) {
            if (!this.panels[i].isDataValid()) {
                this.tpp[i].setSelected(true);
                this.panels[i].setFocus();
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean save(String fileName) {
        NamesGeneric.debugTracing("Entering NamesConfigure:save");
        if (!this.validateConfig()) {
            return false;
        }
        int i = 0;
        while (i < this.panelNames.length) {
            this.panels[i].set();
            ++i;
        }
        try {
            this.nlpa.saveNLParams(fileName);
        }
        catch (IOException iOException) {
            NamesGeneric.debugTracing("Saving Problem");
            return false;
        }
        ((NamesAddress)this.panels[1]).setChangeHuaKya(false);
        ((NamesDomains)this.panels[2]).setChangeHuaKya(false);
        ((NamesRegion)this.panels[3]).setChangeHuaKya(false);
        ((NamesAdvanced)this.panels[4]).setChangeHuaKya(false);
        return true;
    }

    public int getCurrTab_index() {
        NamesGeneric.debugTracing("Entering/Exitting NamesConfigure:getCurrTab_index");
        return this.tp.getIndexOf(this.tp.getSelectedPage());
    }

    public NamesCache getCurrTab() {
        NamesGeneric.debugTracing("Entering NamesConfigure:getCurrTab");
        int index = this.tp.getIndexOf(this.tp.getSelectedPage());
        return this.panels[index];
    }

    public boolean fileHasComments() {
        return this.nlpa.fileHasComments();
    }
}

