/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.control;
import oracle.net.asst.names.nnccj;

public class NamesControl
extends EwtContainer
implements ItemListener {
    NetStrings ns = new NetStrings();
    private String[] topItems = new String[]{this.ns.getString("nnaServerOps"), this.ns.getString("nnaStatsOps")};
    private String[] serverOps = new String[]{this.ns.getString("nnaStart"), this.ns.getString("nnaShutdown"), this.ns.getString("nnaRestart")};
    private String[] statsOps = new String[]{this.ns.getString("nnaLogStats"), this.ns.getString("nnaResetStats")};
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel secondsLabel;
    private LWLabel noteLabel;
    private LWTextField textField;
    private LWCheckbox[] topCb;
    private LWCheckbox[] serverCb;
    private LWCheckbox[] statsCb;
    private LWCheckbox[] timeCb;
    private LWCheckboxGroup topGroup;
    private LWCheckboxGroup serverGroup;
    private LWCheckboxGroup statsGroup;
    private LWCheckboxGroup timeGroup;
    private EwtContainer controlPanel;
    private EwtContainer opsPanel;
    private EwtContainer timePanel;
    private Insets panelInsets;
    private Insets indentedInsets;
    private control m_control;
    public static boolean serverUp;
    private boolean initialized;
    private boolean componentShownOnce;
    private short errorVerbosity = 1;

    public NamesControl() {
        NamesGeneric.debugTracing("Entering class:NamesControl");
        serverUp = nnccj.serverSet;
        this.m_control = new control();
        this.panelInsets = new Insets(2, 4, 2, 4);
        this.indentedInsets = new Insets(2, 30, 2, 4);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.sharedBorderPixel = new MarginBorder(4, 4, 4, 4);
        this.setBorder((Border)this.sharedBorderPixel);
        this.controlPanel = new EwtContainer();
        this.controlPanel.setLayout(this.gb);
        this.noteLabel = new LWLabel(this.ns.getString("nnaZeroWaitLabel"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.noteLabel, this.gbc);
        this.controlPanel.add((Component)this.noteLabel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaOperation"), InsetFramePainter.getFramePainter(), 2));
        this.controlPanel.add((Component)this.opsPanel);
        this.timePanel = new EwtContainer();
        this.timePanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.timePanel, this.gbc);
        this.timePanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaPerformOp"), InsetFramePainter.getFramePainter(), 2));
        this.controlPanel.add((Component)this.timePanel);
        this.gbc.ipadx = 10;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.topCb = new LWCheckbox[this.topItems.length];
        this.topGroup = new LWCheckboxGroup();
        this.topCb[0] = new LWCheckbox(new String(this.topItems[0]), this.topGroup, false);
        this.topCb[0].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.topCb[0], this.gbc);
        this.opsPanel.add((Component)this.topCb[0]);
        this.serverGroup = new LWCheckboxGroup();
        this.serverCb = new LWCheckbox[this.serverOps.length];
        this.gbc.insets = this.indentedInsets;
        int i = 0;
        while (i < this.serverOps.length) {
            this.gbc.gridx = -1;
            ++this.gbc.gridy;
            this.serverCb[i] = new LWCheckbox(new String(this.serverOps[i]), this.serverGroup, false);
            this.serverCb[i].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.serverCb[i], this.gbc);
            this.opsPanel.add((Component)this.serverCb[i]);
            ++i;
        }
        this.gbc.insets = this.panelInsets;
        this.topCb[1] = new LWCheckbox(new String(this.topItems[1]), this.topGroup, false);
        this.topCb[1].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.topCb[1], this.gbc);
        this.opsPanel.add((Component)this.topCb[1]);
        this.statsGroup = new LWCheckboxGroup();
        this.statsCb = new LWCheckbox[this.statsOps.length];
        this.gbc.insets = this.indentedInsets;
        int i2 = 0;
        while (i2 < this.statsOps.length) {
            this.gbc.gridx = 0;
            this.gbc.insets = this.indentedInsets;
            ++this.gbc.gridy;
            this.statsCb[i2] = new LWCheckbox(new String(this.statsOps[i2]), this.statsGroup, false);
            this.statsCb[i2].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.statsCb[i2], this.gbc);
            this.opsPanel.add((Component)this.statsCb[i2]);
            ++i2;
        }
        this.gbc.insets = this.panelInsets;
        this.gbc.ipadx = 10;
        this.timeGroup = new LWCheckboxGroup();
        this.timeCb = new LWCheckbox[2];
        this.timeCb[0] = new LWCheckbox(this.ns.getString("nnaImmediately"), this.timeGroup, false);
        this.timeCb[0].addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gb.setConstraints((Component)this.timeCb[0], this.gbc);
        this.timePanel.add((Component)this.timeCb[0]);
        this.timeCb[0].setEnabled(false);
        this.timeCb[1] = new LWCheckbox(this.ns.getString("nnaWait"), this.timeGroup, false);
        this.timeCb[1].addItemListener((ItemListener)this);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.timeCb[1], this.gbc);
        this.timePanel.add((Component)this.timeCb[1]);
        this.timeCb[1].setEnabled(false);
        this.textField = new LWTextField(12);
        this.gbc.ipadx = 0;
        this.gbc.fill = 2;
        this.gbc.weightx = 5.0;
        ++this.gbc.gridx;
        this.gbc.gridwidth = -1;
        this.gb.setConstraints((Component)this.textField, this.gbc);
        this.timePanel.add((Component)this.textField);
        this.textField.setEditable(false);
        this.gbc.gridx = -1;
        this.gbc.gridwidth = 0;
        this.secondsLabel = new LWLabel(this.ns.getString("nnaSeconds"));
        this.gb.setConstraints((Component)this.secondsLabel, this.gbc);
        this.timePanel.add((Component)this.secondsLabel);
        this.secondsLabel.setEnabled(false);
        if (serverUp) {
            this.setServerUp();
        } else {
            this.setServerDown();
        }
        ((Container)((Object)this)).add((Component)this.controlPanel, "North");
        NamesGeneric.debugTracing("Exiting class:NamesControl");
        ((Component)((Object)this)).addComponentListener(new 1());
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesControl");
        if (this.initialized) {
            return;
        }
        this.LoadIntoScreen();
        this.initialized = true;
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesControl");
    }

    public void PerformOp() {
        String waitTime;
        int res = -1;
        String[] argv = new String[1];
        int argc = 0;
        NamesGeneric.debugTracing("Entering PerformOp:NamesControl");
        LWCheckbox selectedCb = this.topGroup.getSelectedCheckbox();
        if (selectedCb == null) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaNullSelection"));
            return;
        }
        String label = selectedCb.getLabel();
        if ((selectedCb = label.compareTo(this.topItems[0]) == 0 ? this.serverGroup.getSelectedCheckbox() : this.statsGroup.getSelectedCheckbox()) == null) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaNullSelection"));
            return;
        }
        label = selectedCb.getLabel();
        if (this.timeGroup.getSelectedCheckbox().getLabel().compareTo(this.ns.getString("nnaWait")) == 0) {
            waitTime = this.textField.getText();
            try {
                int intTime = Integer.parseInt(waitTime, 10);
            }
            catch (NumberFormatException numberFormatException) {
                waitTime = null;
                NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaWaitMustBeNumber"));
                return;
            }
            argv[0] = waitTime;
            argc = 1;
        } else {
            waitTime = null;
        }
        if (label.compareTo(this.serverOps[0]) == 0) {
            res = this.m_control.startServer(null, 0);
            if (res == 0) {
                serverUp = true;
                NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerStartSucc"));
                this.setServerUp();
                nnccj.serverSet = true;
            }
        } else if (label.compareTo(this.serverOps[1]) == 0) {
            if (waitTime == null) {
                res = this.m_control.stopServer();
                if (res == 0) {
                    serverUp = false;
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerStop"));
                    this.setServerDown();
                    nnccj.serverSet = false;
                }
            } else {
                res = this.m_control.stopServer(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaServerStopping")) + this.m_control.returnResp();
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        } else if (label.compareTo(this.serverOps[2]) == 0) {
            if (waitTime == null) {
                res = this.m_control.setRestart();
                if (res == 0) {
                    serverUp = true;
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerRestartSucc"));
                }
            } else {
                res = this.m_control.setRestart(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaServerRestarting")) + this.m_control.returnResp();
                    serverUp = true;
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        } else if (label.compareTo(this.statsOps[0]) == 0) {
            if (waitTime == null) {
                res = this.m_control.logStats();
                if (res == 0) {
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaServerStatsLogged"));
                }
            } else {
                res = this.m_control.setLogStats(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaLoggingStats")) + this.m_control.returnResp();
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        } else if (label.compareTo(this.statsOps[1]) == 0) {
            if (waitTime == null) {
                res = this.m_control.resetStats();
                if (res == 0) {
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaStatsReset"));
                }
            } else {
                res = this.m_control.setResetStats(argv, argc);
                if (res == 0) {
                    String message = String.valueOf(this.ns.getString("nnaResetingStats")) + this.m_control.returnResp();
                    NamesDialog.popUp(this.ns.getString("nnaMessage"), message);
                }
            }
        }
        NamesGeneric.debugTracing("Exiting PerformOp:NamesControl");
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesControl");
        if (this.initialized) {
            int argc;
            String[] argv = new String[]{nnccj.getServerAddress()};
            int res = this.m_control.pingServer(argv, argc = argv[0] == null ? 0 : 1, this.errorVerbosity);
            if (res == 0) {
                serverUp = true;
                nnccj.serverSet = true;
                this.m_control.setServer(argv, argc);
            } else {
                serverUp = false;
                nnccj.serverSet = false;
            }
        }
        if (serverUp) {
            this.setServerUp();
        } else {
            this.setServerDown();
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesControl");
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        NamesGeneric.debugTracing("Entering itemStateChanged:NamesControl");
        if (source instanceof LWCheckbox) {
            int i;
            String cbLabel = e.getItem().toString();
            if (cbLabel.compareTo(this.ns.getString("nnaServerOps")) == 0) {
                this.serverCb[0].setEnabled(!serverUp);
                i = 1;
                while (i < this.serverOps.length) {
                    this.serverCb[i].setEnabled(serverUp);
                    ++i;
                }
                this.statsGroup.setSelectedCheckbox(null);
                i = 0;
                while (i < this.statsOps.length) {
                    this.statsCb[i].setEnabled(false);
                    ++i;
                }
                if (this.serverGroup.getSelectedCheckbox() == null) {
                    this.timeGroup.setSelectedCheckbox(null);
                    this.timeCb[0].setEnabled(false);
                    this.timeCb[1].setEnabled(false);
                    this.textField.setEditable(false);
                    this.secondsLabel.setEnabled(false);
                }
            }
            if (cbLabel.compareTo(this.ns.getString("nnaStatsOps")) == 0) {
                i = 0;
                while (i < this.statsOps.length) {
                    this.statsCb[i].setEnabled(true);
                    ++i;
                }
                this.serverGroup.setSelectedCheckbox(null);
                i = 0;
                while (i < this.serverOps.length) {
                    this.serverCb[i].setEnabled(false);
                    ++i;
                }
                if (this.statsGroup.getSelectedCheckbox() == null) {
                    this.timeGroup.setSelectedCheckbox(null);
                    this.timeCb[0].setEnabled(false);
                    this.timeCb[1].setEnabled(false);
                    this.textField.setEditable(false);
                    this.secondsLabel.setEnabled(false);
                }
            } else if (cbLabel.compareTo(this.ns.getString("nnaStart")) == 0) {
                if (cbLabel.compareTo(this.ns.getString("nnaStart")) == 0) {
                    this.timeCb[1].setEnabled(false);
                } else {
                    this.timeCb[1].setEnabled(true);
                }
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            } else if (cbLabel.compareTo(this.ns.getString("nnaImmediately")) == 0) {
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            } else if (cbLabel.compareTo(this.ns.getString("nnaWait")) == 0) {
                this.textField.setEditable(true);
                this.secondsLabel.setEnabled(true);
            } else if (cbLabel.compareTo(this.ns.getString("nnaShutdown")) == 0 || cbLabel.compareTo(this.ns.getString("nnaRestart")) == 0 || cbLabel.compareTo(this.ns.getString("nnaLogStats")) == 0 || cbLabel.compareTo(this.ns.getString("nnaResetStats")) == 0) {
                this.timeCb[0].setEnabled(true);
                this.timeCb[1].setEnabled(true);
                this.timeCb[0].setState(true);
                this.textField.setEditable(false);
                this.secondsLabel.setEnabled(false);
            }
        }
        NamesGeneric.debugTracing("Exiting itemStateChanged:NamesControl");
    }

    public void setServerUp() {
        NamesGeneric.debugTracing("Entering setServerUp:NamesControl");
        this.topCb[0].setState(true);
        this.topCb[1].setEnabled(true);
        this.serverGroup.setSelectedCheckbox(null);
        this.statsGroup.setSelectedCheckbox(null);
        this.serverCb[0].setEnabled(false);
        int i = 1;
        while (i < this.serverOps.length) {
            this.serverCb[i].setEnabled(true);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.statsOps.length) {
            this.statsCb[i2].setEnabled(false);
            ++i2;
        }
        this.timeGroup.setSelectedCheckbox(null);
        this.timeCb[0].setEnabled(false);
        this.timeCb[1].setEnabled(false);
        this.textField.setEditable(false);
        this.secondsLabel.setEnabled(false);
        NamesGeneric.debugTracing("Exiting setServerUp:NamesControl");
    }

    public void setServerDown() {
        NamesGeneric.debugTracing("Entering setServerDown:NamesControl");
        this.topCb[0].setEnabled(true);
        this.topCb[0].setState(true);
        this.topCb[1].setEnabled(false);
        this.serverCb[0].setEnabled(true);
        this.serverCb[0].setState(true);
        int i = 1;
        while (i < this.serverOps.length) {
            this.serverCb[i].setEnabled(false);
            ++i;
        }
        this.statsGroup.setSelectedCheckbox(null);
        int i2 = 0;
        while (i2 < this.statsOps.length) {
            this.statsCb[i2].setEnabled(false);
            ++i2;
        }
        this.timeCb[0].setEnabled(true);
        this.timeCb[0].setState(true);
        this.timeCb[1].setEnabled(false);
        this.textField.setEditable(false);
        this.secondsLabel.setEnabled(false);
        NamesGeneric.debugTracing("Exiting setServerDown:NamesControl");
    }

    public void clearPanel() {
        NamesGeneric.debugTracing("Entering clearPanel:NamesControl");
        serverUp = false;
        nnccj.serverSet = false;
        this.setServerDown();
        NamesGeneric.debugTracing("Exiting clearPanel:NamesControl");
    }

    static /* synthetic */ control access$2(NamesControl $0) {
        return $0.m_control;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            if (!NamesControl.this.componentShownOnce && nnccj.getServerAddress() != null) {
                short temp = NamesControl.this.errorVerbosity;
                NamesControl.this.errorVerbosity = (short)3;
                if (!NamesControl.this.initialized) {
                    NamesControl.this.LoadFirstTime();
                } else {
                    NamesControl.this.LoadIntoScreen();
                }
                NamesControl.this.componentShownOnce = true;
                NamesControl.this.errorVerbosity = temp;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

