/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDBQualifier;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.operate;

public class NamesDBLink
extends EwtContainer
implements ActionListener,
ItemListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaDBLinkName"), this.ns.getString("nnaUser"), this.ns.getString("nnaPassword")};
    private String[] cbNames = new String[]{this.ns.getString("nnaQuery"), this.ns.getString("nnaAdd"), this.ns.getString("nnaRemove")};
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private CardLayout cardLayout;
    private LWLabel l;
    private LWButton createQualifier;
    private LWButton removeQualifier;
    private LWButton linkButton;
    private LWButton qualButton;
    private String viewStr = "View Qualifier";
    private LWCheckbox[] cb;
    private LWCheckboxGroup cbg = new LWCheckboxGroup();
    private EwtContainer DBLinkPanel;
    private EwtContainer textPanel;
    private EwtContainer buttonPanel;
    private EwtContainer listPanel;
    private EwtContainer cbPanel;
    private EwtContainer labelPanel;
    private EwtContainer outPanel;
    private EwtContainer cardPanel;
    private EwtContainer opsPanel;
    private EwtContainer execButtonPanel;
    private EwtContainer qualButtonPanel;
    private LWList qualList;
    private Qvector qvec;
    private int qual_arr_size;
    private NamesDBQualifier dq;
    private NamesDialog msgDialog;
    private operate m_oper;
    private static String emptyStr = "                                ";
    private static final int StrSize = 21;
    private boolean nameCreated = false;
    private boolean goAhead = true;
    private boolean msgDlgUp = false;
    private boolean dbQualUp = false;
    private String execStr = this.ns.getString("nnaExec");
    private LWButton execButton;
    private String linkStr = this.ns.getString("nnaDBlinks");
    private String qualStr = this.ns.getString("nnaDBquals");
    private String os = System.getProperty("os.name");

    public NamesDBLink() {
        NamesGeneric.debugTracing("Entering NamesDBLink:NamesDBLink");
        this.m_oper = new operate();
        this.qvec = new Qvector();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.outPanel = new EwtContainer();
        this.outPanel.setLayout(this.gb);
        this.labelPanel = new EwtContainer();
        this.labelPanel.setLayout(new GridLayout(2, 1));
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.labelPanel, this.gbc);
        this.outPanel.add((Component)this.labelPanel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaOps"), InsetFramePainter.getFramePainter(), 2));
        this.outPanel.add((Component)this.opsPanel);
        this.cardLayout = new CardLayout();
        this.cardPanel = new EwtContainer();
        this.cardPanel.setLayout(this.cardLayout);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.cardPanel, this.gbc);
        this.outPanel.add((Component)this.cardPanel);
        this.DBLinkPanel = new EwtContainer();
        this.DBLinkPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.DBLinkPanel, this.gbc);
        this.DBLinkPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaDBLink"), InsetFramePainter.getFramePainter(), 2));
        this.cardPanel.add("DBLinkPanel", (Component)this.DBLinkPanel);
        this.listPanel = new EwtContainer();
        this.listPanel.setLayout(this.gb);
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.listPanel, this.gbc);
        this.listPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaDBquals"), InsetFramePainter.getFramePainter(), 2));
        this.cardPanel.add("listPanel", (Component)this.listPanel);
        this.l = new LWLabel(this.ns.getString("nnaDBLinklabel1"), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.labelPanel.add((Component)this.l);
        this.l = new LWLabel(this.ns.getString("nnaDBLinklabel2"), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.labelPanel.add((Component)this.l);
        this.buttonPanel = new EwtContainer();
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.gb.setConstraints((Component)this.buttonPanel, this.gbc);
        this.linkButton = new LWButton(this.linkStr);
        this.createQualifier = new LWButton(this.ns.getString("nnaCreateQualifier"));
        this.removeQualifier = new LWButton(this.ns.getString("nnaRemoveQualifier"));
        this.linkButton.addActionListener((ActionListener)this);
        this.createQualifier.addActionListener((ActionListener)this);
        this.removeQualifier.addActionListener((ActionListener)this);
        this.buttonPanel.add((Component)this.linkButton);
        this.buttonPanel.add((Component)this.createQualifier);
        this.buttonPanel.add((Component)this.removeQualifier);
        this.qualList = new LWList(8, false);
        this.listPanel.setLayout(new BorderLayout());
        this.l = new LWLabel(new String(this.ns.getString("nnaDBLinklabel3")), 1);
        this.listPanel.add("North", (Component)this.l);
        this.listPanel.add("Center", (Component)this.qualList);
        this.listPanel.add("South", (Component)this.buttonPanel);
        this.textPanel = new EwtContainer();
        this.textPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.textPanel, this.gbc);
        this.DBLinkPanel.add((Component)this.textPanel);
        this.qualButtonPanel = new EwtContainer();
        this.qualButtonPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.qualButtonPanel, this.gbc);
        this.DBLinkPanel.add((Component)this.qualButtonPanel);
        this.itemText = new LWTextField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i;
            this.l = new LWLabel(new String(this.itemNames[this.i]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.textPanel.add((Component)this.l);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWTextField(15);
            this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
            this.textPanel.add((Component)this.itemText[this.i]);
            ++this.i;
        }
        this.qualButton = new LWButton(this.qualStr);
        this.qualButton.addActionListener((ActionListener)this);
        this.qualButtonPanel.add((Component)this.qualButton);
        this.cb = new LWCheckbox[this.cbNames.length];
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.cbPanel, this.gbc);
        this.opsPanel.add((Component)this.cbPanel);
        this.i = 0;
        while (this.i < this.cbNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2 * this.i + 1;
            this.cb[this.i] = new LWCheckbox(new String(this.cbNames[this.i]), this.cbg, false);
            this.cb[this.i].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.cb[this.i], this.gbc);
            this.cbPanel.add((Component)this.cb[this.i]);
            ++this.i;
        }
        this.execButtonPanel = new EwtContainer();
        this.execButtonPanel.setLayout(new FlowLayout(2));
        ++this.gbc.gridx;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.execButtonPanel, this.gbc);
        this.opsPanel.add((Component)this.execButtonPanel);
        this.execButton = new LWButton(this.ns.getString("nnaExec"));
        this.gb.setConstraints((Component)this.execButton, this.gbc);
        this.execButton.addActionListener((ActionListener)this);
        this.execButtonPanel.add((Component)this.execButton);
        ((Container)((Object)this)).add((Component)this.outPanel, "North");
        this.createQualifier.setEnabled(false);
        this.removeQualifier.setEnabled(false);
        this.cb[0].setState(true);
        this.itemText[1].setEditable(false);
        this.itemText[2].setEditable(false);
        this.cardLayout.show((Container)this.cardPanel, "DBLinkPanel");
        NamesGeneric.debugTracing("Exiting NamesDBLink:NamesDBLink");
    }

    public void actionPerformed(ActionEvent e) {
        NamesGeneric.debugTracing("Entering NamesDBLink:actionPerformed");
        Object source = e.getSource();
        String crString = this.ns.getString("nnaCreateQualifier");
        String remString = this.ns.getString("nnaRemoveQualifier");
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        BufferedFrame f = new BufferedFrame(this.ns.getString("nnaDbQual"));
        if (source instanceof LWButton) {
            ((LWButton)e.getSource()).setEnabled(false);
            if (e.getActionCommand().compareTo(crString) == 0) {
                this.dq = new NamesDBQualifier(f, this.ns.getString("nnaDbQual"), this);
                this.dbQualUp = true;
                this.dq.dlgShow();
            } else if (e.getActionCommand().compareTo(remString) == 0) {
                String qual = this.qualList.getSelectedItem();
                if (qual != null) {
                    this.qvec.Remove(qual);
                    this.qualList.delItem(this.qualList.getSelectedIndex());
                }
            } else if (e.getActionCommand().compareTo(okString) == 0) {
                if (this.dbQualUp) {
                    String qual = this.dq.getQualifier();
                    this.qvec.Add(qual);
                    this.qualList.addItem(qual);
                    ((Component)((Object)this.dq)).setVisible(false);
                    this.dq.dispose();
                    this.dbQualUp = false;
                } else if (this.msgDlgUp) {
                    this.goAhead = true;
                    ((Component)((Object)this.msgDialog)).setVisible(false);
                    this.msgDlgUp = false;
                    this.msgDialog.dispose();
                    NamesGeneric.appFrame.requestFocus();
                }
            } else if (e.getActionCommand().compareTo(cancelString) == 0) {
                if (this.dbQualUp) {
                    ((Component)((Object)this.dq)).setVisible(false);
                    this.dq.dispose();
                    this.dbQualUp = false;
                } else if (this.msgDlgUp) {
                    this.goAhead = false;
                    ((Component)((Object)this.msgDialog)).setVisible(false);
                    this.msgDlgUp = false;
                    this.msgDialog.dispose();
                    NamesGeneric.appFrame.requestFocus();
                }
            }
            if (e.getActionCommand().compareTo(this.execStr) == 0) {
                this.PerformOp();
            }
            if (e.getActionCommand().compareTo(this.qualStr) == 0) {
                this.cardLayout.show((Container)this.cardPanel, "listPanel");
            }
            if (e.getActionCommand().compareTo(this.linkStr) == 0) {
                this.cardLayout.show((Container)this.cardPanel, "DBLinkPanel");
            }
            ((LWButton)e.getSource()).setEnabled(true);
        }
        NamesGeneric.debugTracing("Exiting NamesDBLink:actionPerformed");
    }

    public void PerformOp() {
        int argc;
        NamesGeneric.debugTracing("Entering NamesDBLink:PerformOp");
        String[] argv = new String[3];
        int res = 4;
        boolean query = false;
        boolean dataChange = false;
        String label = this.cbg.getSelectedCheckbox().getLabel();
        argv[0] = this.itemText[0].getText().trim();
        if (argv[0].length() == 0) {
            this.popUpDlg(this.ns.getString("nnaValidName"), 1);
            return;
        }
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            argv[1] = "*";
            argc = 2;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQuerySent"));
            res = this.m_oper.query(argv, argc, (short)1);
            query = true;
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            this.nameCreated = false;
            res = this.m_oper.createName(argv, 1, (short)2);
            if (res == 0) {
                this.nameCreated = true;
            }
            argv[1] = "DL.RDBMS.OMD";
            argv[2] = "(DBLINK=(USER=" + this.itemText[1].getText().trim() + ")" + "(PASSWORD=" + this.itemText[2].getText().trim() + ")" + "(CONNECT=" + this.itemText[0].getText().trim() + "))";
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddSent"));
            res = this.m_oper.addData(argv, 3, (short)1);
            if (res == 0) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddSuc"));
                dataChange = true;
            } else if (res == 2) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddWarn"));
                dataChange = true;
            } else {
                this.popUpDlg(this.ns.getString("nnaDBLCrFail"), 1);
                if (this.nameCreated) {
                    this.m_oper.deleteName(argv, 1, (short)2);
                    this.nameCreated = false;
                }
                return;
            }
            argv[1] = "DLCR.RDBMS.OMD";
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddQual"));
            int j = 0;
            while (j < this.qvec.size()) {
                String tmp_str = new String((String)this.qvec.elementAt(j));
                tmp_str = tmp_str.substring(15, 29);
                tmp_str = tmp_str.trim();
                argv[2] = "(CREDENTIAL=(USER=" + tmp_str + ")";
                tmp_str = new String((String)this.qvec.elementAt(j));
                tmp_str = tmp_str.substring(30, 45);
                tmp_str = tmp_str.trim();
                argv[2] = String.valueOf(argv[2]) + "(PASSWORD=" + tmp_str + ")";
                tmp_str = new String((String)this.qvec.elementAt(j));
                tmp_str = tmp_str.substring(0, 14);
                tmp_str = tmp_str.trim();
                argv[2] = String.valueOf(argv[2]) + "(QUALIFIER=" + tmp_str + "))";
                res = this.m_oper.addData(argv, 3, (short)1);
                if (res != 0) {
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddWarn"));
                }
                ++j;
            }
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            this.goAhead = false;
            this.popUpDlg(this.ns.getString("nnaDBLDelete"), 2);
            if (!this.goAhead) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatDelAbort"));
                return;
            }
            argc = 1;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemSent"));
            res = this.m_oper.deleteName(argv, argc, (short)1);
            if (res == 0 || res == 2) {
                if (res == 0) {
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpSuc"));
                } else {
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemWarn"));
                }
                this.qualList.removeAll();
                this.qvec.removeAllElements();
            }
        }
        if (res > 3) {
            return;
        }
        switch (res) {
            case 0: 
            case 2: {
                String password;
                String user;
                if (dataChange) {
                    dataChange = false;
                    argv[1] = "*";
                    argc = 2;
                    NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQueryCurr"));
                    int qres = this.m_oper.query(argv, argc, (short)2);
                    if (qres != 0 && qres != 2) break;
                    query = true;
                }
                if (!query) break;
                query = false;
                this.qualList.removeAll();
                this.qvec.removeAllElements();
                String answer = this.m_oper.returnResp();
                int start = 0;
                int end = 0;
                int next = 0;
                next = answer.indexOf("DL.RDBMS.OMD");
                if (next >= 0) {
                    start = answer.indexOf("USER", next);
                    end = answer.indexOf(41, start += 5);
                    user = answer.substring(start, end);
                    this.itemText[1].setText(user);
                    user = "";
                    start = answer.indexOf("PASSWORD", end);
                    end = answer.indexOf(41, start += 9);
                    password = answer.substring(start, end);
                    this.itemText[2].setText(password);
                    password = "";
                }
                while ((next = answer.indexOf("DLCR.RDBMS.OMD", end)) > 0) {
                    String listItem = "";
                    start = answer.indexOf("USER", next);
                    end = answer.indexOf(41, start += 5);
                    user = answer.substring(start, end);
                    start = answer.indexOf("PASSWORD", end);
                    end = answer.indexOf(41, start += 9);
                    password = answer.substring(start, end);
                    start = answer.indexOf("QUALI", end);
                    end = answer.indexOf(41, start += 10);
                    String qual = answer.substring(start, end);
                    listItem = String.valueOf(qual) + new String(emptyStr.substring(0, 21 - qual.length())) + user + new String(emptyStr.substring(0, 21 - user.length())) + password + new String(emptyStr.substring(0, 21 - password.length()));
                    this.qualList.addItem(listItem);
                }
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpCompl"));
                break;
            }
            default: {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpCompl"));
            }
        }
        NamesGeneric.debugTracing("Exiting NamesDBLink:PerformOp");
    }

    public void itemStateChanged(ItemEvent e) {
        NamesGeneric.debugTracing("Entering NamesDBLink:itemStateChanged");
        Object source = e.getSource();
        this.itemText[0].requestFocus();
        if (source instanceof LWCheckbox) {
            String label = e.getItem().toString();
            if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setEditable(false);
                this.itemText[2].setEditable(false);
                this.qualList.removeAll();
                this.qvec.removeAllElements();
                this.createQualifier.setEnabled(false);
                this.removeQualifier.setEnabled(false);
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQueryDBQ"));
            }
            if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setEditable(true);
                this.itemText[2].setEditable(true);
                this.qualList.removeAll();
                this.qvec.removeAllElements();
                this.createQualifier.setEnabled(true);
                this.removeQualifier.setEnabled(true);
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddExist"));
            }
            if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
                this.itemText[0].setEditable(true);
                this.itemText[1].setEditable(false);
                this.itemText[2].setEditable(false);
                this.createQualifier.setEnabled(false);
                this.removeQualifier.setEnabled(true);
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemDBL"));
            }
        }
        NamesGeneric.debugTracing("Exiting NamesDBLink:itemStateChanged");
    }

    private void popUpDlg(String message, int buttons) {
        NamesGeneric.debugTracing("Entering NamesDBLink:popUpDlg");
        this.msgDialog = new NamesDialog(NamesGeneric.appFrame, this.ns.getString("nnaError"), this, message, buttons);
        this.msgDlgUp = true;
        this.msgDialog.dlgShow();
        NamesGeneric.debugTracing("Exiting NamesDBLink:popUpDlg");
    }

    public void showProperStatus() {
        String label = this.cbg.getSelectedCheckbox().getLabel();
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQueryDBQ"));
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddExist"));
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemDBL"));
        }
    }

    public class Qvector
    extends Vector {
        public Qvector() {
            super(5, 1);
            NamesDBLink.this = NamesDBLink.this;
            NamesGeneric.debugTracing("Entering/Exiting Qvector:Qvector");
        }

        public void Remove(String s) {
            NamesGeneric.debugTracing("Entering Qvector:Remove");
            int j = 0;
            while (j < this.size()) {
                if (((String)this.elementAt(j)).compareTo(s) == 0) {
                    this.removeElementAt(j);
                    return;
                }
                ++j;
            }
        }

        public void Add(String s) {
            NamesGeneric.debugTracing("Entering Qvector:Add");
            int j = 0;
            while (j < this.size()) {
                if (((String)this.elementAt(j)).compareTo(s) == 0) {
                    return;
                }
                ++j;
            }
            this.addElement(s);
        }
    }
}

