/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.Domain;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesDomains
extends EwtContainer
implements NamesCache,
ActionListener,
ItemListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDomains"), "NS1", "names.domains"}};
    private String addString = this.ns.getString("nnaAdd");
    private String removeString = this.ns.getString("nnaRemove");
    private String changeString = this.ns.getString("nnaChange");
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWList curList;
    private LWLabel l;
    private LWCheckbox cb;
    private NLParamParser nlpa;
    private Domain domainPanel;
    private NVFactory nvfactory = new NVFactory();
    private Vector domainVector = new Vector(3);
    private LWButton addButton;
    private LWButton removeButton;
    private LWButton changeButton;
    private boolean defaultf;
    private boolean changeHuaKya = false;

    public NamesDomains() {
        NamesGeneric.debugTracing("Entering NamesDomains");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 1;
        this.gbc.anchor = 11;
        NVPair nvDomain = this.nvfactory.createNVPair("(Domain=(Min_ttl=86400))");
        this.domainPanel = new Domain(nvDomain);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.25;
        this.gbc.gridwidth = 3;
        this.gbc.insets.bottom = 0;
        this.gb.setConstraints((Component)((Object)this.domainPanel), this.gbc);
        ((Container)((Object)this)).add((Component)((Object)this.domainPanel));
        this.gbc.insets.bottom = 5;
        this.addButton = new LWButton(this.addString);
        this.gbc.weighty = 0.25;
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weightx = 0.25;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.gb.setConstraints((Component)this.addButton, this.gbc);
        ((Container)((Object)this)).add((Component)this.addButton);
        this.addButton.addActionListener((ActionListener)this);
        this.removeButton = new LWButton(this.removeString);
        ++this.gbc.gridx;
        this.gb.setConstraints((Component)this.removeButton, this.gbc);
        ((Container)((Object)this)).add((Component)this.removeButton);
        this.removeButton.addActionListener((ActionListener)this);
        this.changeButton = new LWButton(this.changeString);
        ++this.gbc.gridx;
        this.gb.setConstraints((Component)this.changeButton, this.gbc);
        ((Container)((Object)this)).add((Component)this.changeButton);
        this.changeButton.addActionListener((ActionListener)this);
        this.removeButton.setEnabled(false);
        this.changeButton.setEnabled(false);
        this.curList = new LWList(5, false);
        this.curList.addItemListener((ItemListener)this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.5;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 1;
        this.gb.setConstraints((Component)this.curList, this.gbc);
        ((Container)((Object)this)).add((Component)this.curList);
        this.defaultf = true;
        NamesGeneric.debugTracing("Exitting NamesDomains");
    }

    public void setNLP(NLParamParser nlpaParam) {
        NamesGeneric.debugTracing("Entering NamesDomains:setNLP");
        this.nlpa = nlpaParam;
        NamesGeneric.debugTracing("Exitting NamesDomains:setNLP");
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesDomains:get");
        int i = 0;
        while (i < this.itemNames.length) {
            NVPair nvDomain = this.nlpa.getNLPListElement(new String(this.itemNames[i][2]));
            this.domainVector.removeAllElements();
            this.curList.removeAll();
            if (nvDomain != null) {
                this.defaultf = false;
                String domainType = (nvDomain = nvDomain.getListElement(0)).getName();
                if (domainType.equalsIgnoreCase("Domain_list")) {
                    this.doDomainList(nvDomain);
                } else {
                    this.addDomainPanel(nvDomain);
                }
            } else {
                nvDomain = this.nvfactory.createNVPair("(Domain=(name=)(min_ttl=86400))");
                this.addDomainPanel(nvDomain);
            }
            ++i;
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:get");
    }

    public void set() {
        NVPair newParam;
        NamesGeneric.debugTracing("Entering NamesDomains:set");
        NVNavigator nvnav = new NVNavigator();
        if (this.domainVector.size() > 1) {
            newParam = this.nvfactory.createNVPair("(Domain_List=)");
            int i = 0;
            while (i < this.domainVector.size()) {
                newParam.addListElement((NVPair)this.domainVector.elementAt(i));
                ++i;
            }
        } else {
            newParam = this.nvfactory.createNVPair(this.domainVector.elementAt(0).toString());
        }
        if (this.defaultf) {
            NamesGeneric.debugTracing("Defaultf is true ");
            if (this.domainVector.size() == 1) {
                NVPair nvDomain = (NVPair)this.domainVector.firstElement();
                if (nvDomain != null) {
                    NamesGeneric.debugTracing("defaultf = true" + nvDomain.toString());
                }
                NVPair nvName = nvnav.findNVPair(nvDomain, "Name");
                NVPair nvMinTTL = nvnav.findNVPair(nvDomain, "Min_TTL");
                if (nvName == null || nvMinTTL == null) {
                    this.defaultf = false;
                    NamesGeneric.debugTracing("name or minttl = null");
                } else {
                    NamesGeneric.debugTracing("nvname" + nvName.toString());
                    NamesGeneric.debugTracing("nvMinTTL" + nvMinTTL.toString());
                    if (nvName.getAtom() != null || !nvMinTTL.getAtom().equalsIgnoreCase("86400")) {
                        this.defaultf = false;
                        NamesGeneric.debugTracing("Name !=  root or MinTTL != 86400");
                    }
                }
            } else {
                this.defaultf = false;
            }
        }
        if (this.domainVector.size() != 0 && !this.defaultf) {
            try {
                this.nlpa.addNLPListElement(String.valueOf(this.itemNames[0][2]) + "=" + newParam.toString());
            }
            catch (NLException nLException) {}
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:set");
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesDomains:isDataValid");
        return this.domainPanel.isDataValid();
    }

    public void setFocus() {
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering/Exiting isChanged:NamesDomains");
        return this.changeHuaKya;
    }

    public void actionPerformed(ActionEvent e) {
        NamesGeneric.debugTracing("Entering NamesDomains:actionPerformed");
        Object source = e.getSource();
        if (source instanceof LWButton) {
            if (e.getActionCommand().compareTo(this.addString) == 0) {
                if (!this.domainPanel.isDataValid()) {
                    return;
                }
                NVPair nvDomain = this.domainPanel.getDisplayedDomain();
                NVPair newDomain = this.nvfactory.createNVPair(nvDomain.toString());
                if (this.checkDups(newDomain)) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaSameDomain"));
                    return;
                }
                this.domainVector.addElement(newDomain);
                this.curList.addItem(nvDomain.toString().toLowerCase());
                this.changeHuaKya = true;
            } else if (e.getActionCommand().compareTo(this.removeString) == 0) {
                int i = this.curList.getSelectedIndex();
                if (i >= 0) {
                    NVPair nvDomain = this.nvfactory.createNVPair(this.curList.getSelectedItem());
                    this.curList.remove(i);
                    this.domainVector.removeElementAt(i);
                    int temp = this.curList.getSelectedIndex();
                    if (temp > 0) {
                        this.curList.deselect(temp);
                    }
                    this.removeButton.setEnabled(false);
                    this.changeButton.setEnabled(false);
                    this.changeHuaKya = true;
                }
            } else if (e.getActionCommand().compareTo(this.changeString) == 0) {
                if (!this.domainPanel.isDataValid()) {
                    return;
                }
                int i = this.curList.getSelectedIndex();
                if (i >= 0) {
                    NVPair nvDomain = this.domainPanel.getDisplayedDomain();
                    NVPair newDomain = this.nvfactory.createNVPair(nvDomain.toString());
                    if (this.checkDups(newDomain)) {
                        NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaSameDomain"));
                        return;
                    }
                    this.domainVector.removeElementAt(i);
                    this.domainVector.insertElementAt(newDomain, i);
                    this.curList.remove(i);
                    this.curList.addItem(newDomain.toString().toLowerCase(), i);
                    int temp = this.curList.getSelectedIndex();
                    if (temp > 0) {
                        this.curList.deselect(temp);
                    }
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                    this.changeHuaKya = true;
                }
            }
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:actionPerformed");
    }

    private void doDomainList(NVPair nvDomain) {
        NamesGeneric.debugTracing("Entering NamesDomains:doDomainList");
        int i = 0;
        while (i < nvDomain.getListSize()) {
            this.addDomainPanel(nvDomain.getListElement(i));
            ++i;
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:doDomainList");
    }

    private void addDomainPanel(NVPair nvDomain) {
        NamesGeneric.debugTracing("Entering NamesDomains:addDomainPanel");
        this.domainVector.addElement(this.nvfactory.createNVPair(nvDomain.toString()));
        this.curList.addItem(nvDomain.toString().toLowerCase());
        NamesGeneric.debugTracing("Exitting NamesDomains:addDomainPanel");
    }

    private void displaydomainPanel(NVPair nvDomain) {
        NamesGeneric.debugTracing("Entering NamesDomains:displaydomainPanel");
        this.curList.addItem(nvDomain.toString());
        NamesGeneric.debugTracing("Exitting NamesDomains:displaydomainPanel");
    }

    public void itemStateChanged(ItemEvent e) {
        NamesGeneric.debugTracing("Entering NamesDomains:itemStateChanged");
        int stateChange = e.getStateChange();
        if (stateChange == 1) {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
            NVPair nvDomain = this.nvfactory.createNVPair(this.curList.getSelectedItem());
            this.domainPanel.display(nvDomain);
        }
        NamesGeneric.debugTracing("Exitting NamesDomains:itemStateChanged");
    }

    public void setChangeHuaKya(boolean state) {
        this.changeHuaKya = state;
    }

    private boolean checkDups(NVPair nvdomain) {
        NamesGeneric.debugTracing("Entering NamesAddress:checkDups");
        String domain = nvdomain.toString();
        int i = 0;
        while (i < this.domainVector.size()) {
            if (domain.equalsIgnoreCase(this.domainVector.elementAt(i).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector getDomainList() {
        return this.domainVector;
    }

    public void setDomains(Vector vector) {
        this.domainVector = vector;
        int i = 0;
        while (i < this.domainVector.size()) {
            this.curList.addItem(this.domainVector.elementAt(i).toString());
            ++i;
        }
    }

    public void setDomain(NVPair domain) {
        this.domainPanel.display(domain);
    }

    public void setDomainName(String name) {
        this.domainPanel.setDomainName(name);
    }

    public void setMinTTL(String ttl) {
        this.domainPanel.setMinTTL(ttl);
    }
}

