/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesPasswd;
import oracle.net.asst.names.NamesValidate;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NamesGeneral
extends EwtContainer
implements NamesCache,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaNameCol"), "onames", "names.server_name"}, {this.ns.getString("nnaPassword"), "", "names.password"}};
    private EwtContainer generalPanel;
    private LWButton changePasswd;
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWCheckbox cb;
    private NLParamParser nlpa;
    private NamesPasswd passwdDialog;
    private String defaultName;
    private int invalidIndex;
    private boolean passwdUp = false;
    private String latestPasswd;

    public NamesGeneral() {
        NamesGeneric.debugTracing("Entering NamesGeneral");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(10, 5, 5, 5);
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(10, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.generalPanel = new EwtContainer();
        this.generalPanel.setLayout(this.gb);
        this.itemText = new LWTextField[this.itemNames.length];
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2 * this.i + 1;
            this.l = new LWLabel(new String(this.itemNames[this.i][0]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.generalPanel.add((Component)this.l);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWTextField(15);
            this.gb.setConstraints((Component)this.itemText[this.i], this.gbc);
            this.generalPanel.add((Component)this.itemText[this.i]);
            ++this.i;
        }
        this.itemText[0].setEditable(false);
        this.itemText[1].setEditable(false);
        ++this.gbc.gridx;
        this.changePasswd = new LWButton(this.ns.getString("nnaChangePasswd"));
        this.gb.setConstraints((Component)this.changePasswd, this.gbc);
        this.changePasswd.addActionListener((ActionListener)this);
        this.generalPanel.add((Component)this.changePasswd);
        ((Container)((Object)this)).add((Component)this.generalPanel, "North");
        this.invalidIndex = 0;
        NamesGeneric.debugTracing("Exiting NamesGeneral");
    }

    public void setNLP(NLParamParser nlpaParam) {
        NamesGeneric.debugTracing("Entering NamesGeneral:setNLP");
        this.nlpa = nlpaParam;
        NamesGeneric.debugTracing("Exitting NamesGeneral:setNLP");
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesGeneral:get");
        this.defaultName = "onames_" + NamesGeneric.getLocalHost();
        int i = 0;
        while (i < this.itemNames.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(new String(this.itemNames[i][2]));
            if (nvpair != null) {
                if (i == 0) {
                    this.itemText[i].setText(nvpair.getAtom());
                } else {
                    this.latestPasswd = nvpair.getAtom();
                    char[] pwdVal = new char[this.latestPasswd.length()];
                    int j = 0;
                    while (j < pwdVal.length) {
                        pwdVal[j] = 42;
                        ++j;
                    }
                    this.itemText[1].setText(String.valueOf(pwdVal));
                }
            } else if (i == 0) {
                this.itemText[i].setText(this.defaultName);
            } else {
                this.itemText[i].setText(this.itemNames[i][1]);
                this.latestPasswd = this.itemNames[i][1];
            }
            ++i;
        }
        this.itemText[0].transferFocus();
        NamesGeneric.debugTracing("Exitting NamesGeneral:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesGeneral:set");
        int i = 0;
        while (i < this.itemNames.length) {
            String s1 = this.itemText[i].getText();
            if (i == 1) {
                s1 = this.latestPasswd;
            }
            if (s1.compareTo(this.itemNames[i][1]) != 0 && (i != 0 || s1.compareTo(this.defaultName) != 0) && s1.length() > 0) {
                String s = new String(this.itemNames[i][2]);
                try {
                    this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                }
                catch (NLException nLException) {}
            }
            ++i;
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:set");
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesGeneral:isDataValid");
        if (!NamesValidate.validateText(this.itemText[0], this.itemNames[0][0])) {
            this.invalidIndex = 0;
            this.setFocus();
            return false;
        }
        return true;
    }

    public void setFocus() {
        this.itemText[this.invalidIndex].requestFocus();
        this.itemText[this.invalidIndex].selectAll();
    }

    public boolean isChanged() {
        NamesGeneric.debugTracing("Entering NamesGeneral:isChanged");
        this.defaultName = "onames_" + NamesGeneric.getLocalHost();
        int i = 0;
        while (i < this.itemNames.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(new String(this.itemNames[i][2]));
            if (nvpair != null) {
                if (i == 0 ? !this.itemText[i].getText().equalsIgnoreCase(nvpair.getAtom()) : !this.latestPasswd.equalsIgnoreCase(nvpair.getAtom())) {
                    return true;
                }
            } else if (i == 0) {
                if (!this.itemText[i].getText().equalsIgnoreCase(this.defaultName)) {
                    return true;
                }
            } else {
                if (this.latestPasswd.length() == 0) {
                    return false;
                }
                if (!this.latestPasswd.equalsIgnoreCase(this.itemNames[i][1])) {
                    return true;
                }
            }
            ++i;
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:isChanged");
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        NamesGeneric.debugTracing("Entering NamesGeneral:actionPerformed");
        Object source = e.getSource();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        String changePasswd = this.ns.getString("nnaChangePasswd");
        String os = System.getProperty("os.name");
        if (source instanceof LWButton) {
            if (e.getActionCommand().compareTo(changePasswd) == 0) {
                this.passwdDialog = new NamesPasswd(NamesGeneric.appFrame, this, this.latestPasswd);
                this.passwdUp = true;
                this.passwdDialog.dlgShow();
            } else if (e.getActionCommand().compareTo(okString) == 0) {
                int result;
                if (this.passwdUp && (result = this.passwdDialog.checkNewPasswd()) == 0) {
                    this.latestPasswd = this.passwdDialog.getNewPasswd();
                    char[] pwdVal = new char[this.latestPasswd.length()];
                    int i = 0;
                    while (i < pwdVal.length) {
                        pwdVal[i] = 42;
                        ++i;
                    }
                    this.itemText[1].setText(String.valueOf(pwdVal));
                    ((Component)((Object)this.passwdDialog)).setVisible(false);
                    this.passwdDialog.dispose();
                    this.passwdUp = false;
                }
            } else if (e.getActionCommand().compareTo(cancelString) == 0) {
                ((Component)((Object)this.passwdDialog)).setVisible(false);
                this.passwdDialog.dispose();
                this.passwdUp = false;
            }
        }
        NamesGeneric.debugTracing("Exitting NamesGeneral:actionPerformed");
    }
}

