/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.io.File;
import java.net.InetAddress;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.net.common.NetGetEnv;

public class NamesGeneric {
    public static final String FileSeparator = File.separator;
    public static final char FileSeparatorChar = File.separatorChar;
    public static final String LineSeparator = "\n";
    public static final String OS = System.getProperty("os.name");
    public static boolean newServerConfig;
    public static BufferedFrame appFrame;
    private static boolean DEBUG_ON;
    private static String OraHome;
    private static String OraNames;

    public static void setDebug(String str) {
        if (str == null) {
            DEBUG_ON = false;
            return;
        }
        DEBUG_ON = (str = str.toLowerCase()).compareTo("on") == 0 || str.compareTo("true") == 0 || str.compareTo("yes") == 0;
    }

    public static void debugTracing(String msg) {
        if (DEBUG_ON) {
            System.out.println(msg);
        }
    }

    public static String getOraHome() {
        if (OraHome == null) {
            OraHome = String.valueOf(NamesGeneric.formatDirectoryString(NetGetEnv.getOracleHome())) + "network" + FileSeparator;
        }
        return OraHome;
    }

    public static String getOraNames() {
        if (OraNames == null) {
            String oraHome = NamesGeneric.getOraHome();
            OraNames = String.valueOf(oraHome) + "names" + FileSeparator;
            return OraNames;
        }
        return OraNames;
    }

    public static String getLocalHost() {
        String lhost_name = null;
        try {
            InetAddress lhost = InetAddress.getLocalHost();
            lhost_name = lhost.getHostName();
            return lhost_name;
        }
        catch (Throwable e) {
            NamesGeneric.debugTracing("getLocalHost error: " + e.getMessage());
            return "onames";
        }
    }

    public static boolean isSameHost(String host1, String host2) {
        NamesGeneric.debugTracing("Entering NamesComponent:sameHost");
        try {
            String hostTwo;
            String hostOne;
            InetAddress nullHost;
            if (host1 == null) {
                nullHost = InetAddress.getLocalHost();
                hostOne = nullHost.getHostName();
            } else {
                hostOne = host1;
            }
            String host1Addr = InetAddress.getByName(hostOne).getHostAddress();
            if (host2 == null) {
                nullHost = InetAddress.getLocalHost();
                hostTwo = nullHost.getHostName();
            } else {
                hostTwo = host2;
            }
            NamesGeneric.debugTracing("sameHost() comparing using hosts: " + hostOne + " and " + hostTwo);
            String host2Addr = InetAddress.getByName(hostTwo).getHostAddress();
            return host1Addr.equals(host2Addr);
        }
        catch (Exception e) {
            NamesGeneric.debugTracing("samehost excep " + e.getMessage());
            return false;
        }
    }

    public static boolean isWKNS() {
        int j = 0;
        while (j < 4) {
            if (NamesGeneric.isSameHost("oranamesrvr" + j, null)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static void setAppFrame(BufferedFrame frame) {
        appFrame = frame;
    }

    public static void setNewServerConfig(boolean state) {
        newServerConfig = state;
    }

    public static String formatDirectoryString(String dir) {
        int i = dir.length() - 1;
        while (i >= 0) {
            if (dir.charAt(i) != FileSeparatorChar) break;
            --i;
        }
        return String.valueOf(dir.substring(0, i + 1)) + FileSeparator;
    }

    static {
        DEBUG_ON = true;
    }
}

