/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.logTrace;
import oracle.net.asst.names.nnccj;

public class NamesLogging
extends EwtContainer {
    NetStrings ns = new NetStrings();
    private String[] logItems = new String[]{this.ns.getString("nnaLogDir"), this.ns.getString("nnaLogFile")};
    private String[] traceItems = new String[]{this.ns.getString("nnaTracelevel"), this.ns.getString("nnaTraceDir"), this.ns.getString("nnaTracefile")};
    private String[] traceLevel = new String[]{this.ns.getString("nnaOFF"), this.ns.getString("nnaUSER"), this.ns.getString("nnaADMIN"), this.ns.getString("nnaDEV")};
    private static final int OFF = 0;
    private static final int USER = 4;
    private static final int ADMIN = 6;
    private static final int DEV = 15;
    private LWTextField[] logText;
    private LWTextField[] traceText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer mainPanel;
    private EwtContainer logPanel;
    private EwtContainer tracePanel;
    private EwtContainer choicePanel;
    private LWChoice levelChoice;
    private Insets panelInsets;
    private boolean initialized;
    private logTrace m_logTrace;

    public NamesLogging() {
        NamesGeneric.debugTracing("Entering class:NamesLogging");
        this.m_logTrace = new logTrace();
        this.panelInsets = new Insets(5, 5, 5, 5);
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = this.panelInsets;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.mainPanel = new EwtContainer();
        this.mainPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.mainPanel, this.gbc);
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.logPanel = new EwtContainer();
        this.logPanel.setLayout(this.gb);
        this.logPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaLogging"), InsetFramePainter.getFramePainter(), 2));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.logPanel, this.gbc);
        this.mainPanel.add((Component)this.logPanel);
        this.tracePanel = new EwtContainer();
        this.tracePanel.setLayout(this.gb);
        this.tracePanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaTracing"), InsetFramePainter.getFramePainter(), 2));
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.tracePanel, this.gbc);
        this.mainPanel.add((Component)this.tracePanel);
        this.logText = new LWTextField[this.logItems.length];
        this.i = 0;
        while (this.i < this.logItems.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = this.i;
            this.l = new LWLabel(new String(this.logItems[this.i]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.logPanel.add((Component)this.l);
            this.gbc.gridx = -1;
            this.logText[this.i] = new LWTextField(20);
            this.gb.setConstraints((Component)this.logText[this.i], this.gbc);
            this.logPanel.add((Component)this.logText[this.i]);
            ++this.i;
        }
        this.traceText = new LWTextField[this.traceItems.length - 1];
        this.i = 0;
        while (this.i < this.traceItems.length) {
            int j;
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.l = new LWLabel(new String(this.traceItems[this.i]), 1);
            this.gb.setConstraints((Component)this.l, this.gbc);
            this.tracePanel.add((Component)this.l);
            ++this.gbc.gridx;
            if (this.i == 0) {
                this.levelChoice = new LWChoice();
                j = 0;
                while (j < this.traceLevel.length) {
                    this.levelChoice.addItem(this.traceLevel[j]);
                    ++j;
                }
                this.gbc.insets = new Insets(5, 5, 0, 5);
                this.gb.setConstraints((Component)this.levelChoice, this.gbc);
                this.tracePanel.add((Component)this.levelChoice);
                this.gbc.insets = this.panelInsets;
            } else {
                j = this.i - 1;
                this.traceText[j] = new LWTextField(20);
                this.gb.setConstraints((Component)this.traceText[j], this.gbc);
                this.tracePanel.add((Component)this.traceText[j]);
            }
            ++this.i;
        }
        ((Container)((Object)this)).add((Component)this.mainPanel, "North");
        this.logText[0].setEditable(false);
        this.traceText[0].setEditable(false);
        NamesGeneric.debugTracing("Exiting class:NamesLogging");
    }

    public String getLogDir() throws Exception {
        NamesGeneric.debugTracing("Entering getLogDir:NamesLogging");
        int logdir = this.m_logTrace.getLogDir();
        if (logdir != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public String getLogFile() throws Exception {
        NamesGeneric.debugTracing("Entering getLogFile:NamesLogging");
        int logFile = this.m_logTrace.getLogFile();
        if (logFile != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesLogging");
        try {
            this.logText[0].setText(this.getLogDir());
            this.logText[1].setText(this.getLogFile());
            this.levelChoice.select(new String(this.traceLevel[this.getTraceLevel()]));
            this.traceText[0].setText(this.getTraceDir());
            this.traceText[1].setText(this.getTraceFile());
        }
        catch (Exception exception) {
            this.clearPanel();
            return;
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesLogging");
    }

    public int getTraceLevel() throws Exception {
        NamesGeneric.debugTracing("Entering getTraceLevel:NamesLogging");
        int result = this.m_logTrace.getTraceLevel();
        if (result != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        int trace_level = Integer.parseInt(this.m_logTrace.returnResp());
        if (trace_level < 4) {
            return 0;
        }
        if (trace_level < 6) {
            return 1;
        }
        if (trace_level < 15) {
            return 2;
        }
        return 3;
    }

    public String getTraceDir() throws Exception {
        NamesGeneric.debugTracing("Entering getTraceDir:NamesLogging");
        int trcdir = this.m_logTrace.getTraceDir();
        if (trcdir != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public String getTraceFile() throws Exception {
        NamesGeneric.debugTracing("Entering getTraceFile:NamesLogging");
        int trcFile = this.m_logTrace.getTraceFile();
        if (trcFile != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesLogging");
        if (this.initialized) {
            return;
        }
        if (!nnccj.serverSet) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaNameServerUnreachable"));
        } else {
            this.initialized = true;
            this.LoadIntoScreen();
        }
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesLogging");
    }

    public String setTraceLevel() throws Exception {
        NamesGeneric.debugTracing("Entering setTraceLevel:NamesLogging");
        String[] argv = new String[]{new String(this.levelChoice.getSelectedItem())};
        int trcLevel = this.m_logTrace.setTraceLevel(argv, 1);
        if (trcLevel != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public String setTraceFile() throws Exception {
        String[] argv = new String[]{this.traceText[1].getText()};
        NamesGeneric.debugTracing("Entering setTraceFile:NamesLogging");
        int trcFile = this.m_logTrace.setTraceFile(argv, 1);
        if (trcFile != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public String setLogFile() throws Exception {
        String[] argv = new String[]{this.logText[1].getText()};
        int logFile = this.m_logTrace.setLogFile(argv, 1);
        NamesGeneric.debugTracing("Entering setLogFile:NamesLogging");
        if (logFile != 0) {
            throw new Exception(this.m_logTrace.returnError());
        }
        return this.m_logTrace.returnResp();
    }

    public void StoreFromScreen() {
        NamesGeneric.debugTracing("Entering StoreFromScreen:NamesLogging");
        if (!NamesValidate.validateText(this.logText[1], this.logItems[1])) {
            return;
        }
        if (!NamesValidate.validateText(this.traceText[1], this.traceItems[2])) {
            return;
        }
        try {
            this.setLogFile();
            this.setTraceLevel();
            this.setTraceFile();
        }
        catch (Exception exception) {
            this.clearPanel();
            return;
        }
        this.m_logTrace.saveConfig();
        NamesGeneric.debugTracing("Exiting StoreFromScreen:NamesLogging");
    }

    public void clearPanel() {
        this.logText[0].setText("");
        this.logText[1].setText("");
        this.levelChoice.select(this.traceLevel[0]);
        this.traceText[0].setText("");
        this.traceText[1].setText("");
    }
}

