/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.monitor;
import oracle.net.asst.names.nnccj;

public class NamesMonitor
extends EwtContainer
implements ItemListener {
    NetStrings ns = new NetStrings();
    private String[] topItems = new String[]{this.ns.getString("nnaServer"), this.ns.getString("nnaStats"), this.ns.getString("nnaSchedOps")};
    private String[] scheduleItems = new String[]{this.ns.getString("nnaServer"), this.ns.getString("nnaStats"), this.ns.getString("nnaCache")};
    private String[] itemNames = new String[]{this.ns.getString("nnaServerName"), this.ns.getString("nnaVersion"), this.ns.getString("nnaRunningTime"), this.ns.getString("nnaRequestrecv"), this.ns.getString("nnaRequestforw"), this.ns.getString("nnaForeigncache"), this.ns.getString("nnaRegionFail"), this.ns.getString("nnaNextShutTime"), this.ns.getString("nnaNextRestartTime"), this.ns.getString("nnaNextStatsLogTime"), this.ns.getString("nnaNextStatsResetTime"), this.ns.getString("nnaNextFlush"), this.ns.getString("nnaNextReload"), this.ns.getString("nnaNextCkp"), this.ns.getString("nnaNextDump")};
    private final short statsItems = (short)3;
    private final short serverSchedItems = (short)7;
    private final short statsSchedItems = (short)9;
    private final short cacheItems = (short)11;
    private LWTextField[] itemText;
    private MarginBorder sharedBorderPixel;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer runPanel;
    private EwtContainer textPanel;
    private EwtContainer cbPanel;
    private EwtContainer srvrSchedPanel;
    private EwtContainer statsSchedPanel;
    private EwtContainer cacheSchedulePanel;
    private EwtContainer cardPanel;
    private EwtContainer serverPanel;
    private EwtContainer statsPanel;
    private LWCheckboxGroup topGroup;
    private LWCheckboxGroup scheduleGroup;
    private LWCheckbox[] topCb;
    private LWCheckbox[] scheduleCb;
    private Insets zeroInsets;
    private CardLayout cardLayout;
    private boolean initialized;
    private monitor m_monitor;

    public NamesMonitor() {
        NamesGeneric.debugTracing("Entering class:NamesMontior");
        this.m_monitor = new monitor();
        this.zeroInsets = new Insets(0, 4, 0, 4);
        this.cardLayout = new CardLayout();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gbc.insets = this.zeroInsets;
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(2, 2, 2, 2);
        this.setBorder((Border)this.sharedBorderPixel);
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = this.zeroInsets;
        this.gb.setConstraints((Component)this.cbPanel, this.gbc);
        this.cbPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaInfoAbout"), InsetFramePainter.getFramePainter(), 2));
        this.cardPanel = new EwtContainer();
        this.cardPanel.setLayout(this.cardLayout);
        ++this.gbc.gridy;
        this.gbc.insets = this.zeroInsets;
        this.gb.setConstraints((Component)this.cardPanel, this.gbc);
        this.cardPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaInfo"), InsetFramePainter.getFramePainter(), 2));
        this.gbc.ipadx = 10;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(2, 4, 2, 4);
        this.topCb = new LWCheckbox[this.topItems.length];
        this.topGroup = new LWCheckboxGroup();
        int i = 0;
        while (i < this.topItems.length) {
            this.topCb[i] = new LWCheckbox(this.topItems[i], this.topGroup, false);
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gb.setConstraints((Component)this.topCb[i], this.gbc);
            this.topCb[i].addItemListener((ItemListener)this);
            this.cbPanel.add((Component)this.topCb[i]);
            ++i;
        }
        this.gbc.insets = new Insets(1, 30, 1, 1);
        this.scheduleCb = new LWCheckbox[this.scheduleItems.length];
        this.scheduleGroup = new LWCheckboxGroup();
        int i2 = 0;
        while (i2 < this.scheduleItems.length) {
            this.scheduleCb[i2] = new LWCheckbox(this.scheduleItems[i2], this.scheduleGroup, false);
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gb.setConstraints((Component)this.scheduleCb[i2], this.gbc);
            this.scheduleCb[i2].addItemListener((ItemListener)this);
            this.cbPanel.add((Component)this.scheduleCb[i2]);
            this.scheduleCb[i2].setEnabled(false);
            ++i2;
        }
        this.gbc.ipadx = 0;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = this.zeroInsets;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.serverPanel = new EwtContainer();
        this.serverPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.serverPanel, this.gbc);
        this.cardPanel.add((Component)this.serverPanel, "serverPanel");
        this.statsPanel = new EwtContainer();
        this.statsPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.statsPanel, this.gbc);
        this.cardPanel.add((Component)this.statsPanel, "statsPanel");
        this.srvrSchedPanel = new EwtContainer();
        this.srvrSchedPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.srvrSchedPanel, this.gbc);
        this.cardPanel.add((Component)this.srvrSchedPanel, "srvrSchedPanel");
        this.statsSchedPanel = new EwtContainer();
        this.statsSchedPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.statsSchedPanel, this.gbc);
        this.cardPanel.add((Component)this.statsSchedPanel, "statsSchedPanel");
        this.cacheSchedulePanel = new EwtContainer();
        this.cacheSchedulePanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.cacheSchedulePanel, this.gbc);
        this.cardPanel.add((Component)this.cacheSchedulePanel, "cachePanel");
        this.textPanel = new EwtContainer();
        this.textPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(4, 4, 0, 4);
        this.gb.setConstraints((Component)this.textPanel, this.gbc);
        this.serverPanel.add((Component)this.textPanel);
        this.runPanel = new EwtContainer();
        this.runPanel.setLayout(new FlowLayout(0));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 4, 4, 4);
        this.gb.setConstraints((Component)this.runPanel, this.gbc);
        this.serverPanel.add((Component)this.runPanel);
        this.gbc.insets = new Insets(4, 4, 4, 4);
        this.itemText = new LWTextField[this.itemNames.length];
        int i3 = 0;
        while (i3 < this.itemNames.length) {
            if (this.itemNames[i3].compareTo(this.ns.getString("nnaRunningTime")) == 0) {
                this.l = new LWLabel(new String(this.itemNames[i3]), 1);
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gb.setConstraints((Component)this.l, this.gbc);
                this.textPanel.add((Component)this.l);
                this.itemText[i3] = new LWTextField(50);
                this.gbc.gridx = 0;
                this.gbc.gridy = 0;
                this.gb.setConstraints((Component)this.itemText[i3], this.gbc);
                this.runPanel.add((Component)this.itemText[i3]);
                this.itemText[i3].setEditable(false);
            } else {
                this.gbc.gridx = 0;
                ++this.gbc.gridy;
                this.gbc.gridwidth = -1;
                this.gbc.weightx = 0.0;
                this.gbc.weighty = i3 == 9 || i3 == 7 ? 0.0 : 10.0;
                this.l = new LWLabel(new String(this.itemNames[i3]), 1);
                this.gb.setConstraints((Component)this.l, this.gbc);
                this.gbc.gridx = -1;
                this.gbc.gridwidth = 0;
                this.gbc.weightx = 10.0;
                this.itemText[i3] = new LWTextField();
                this.gb.setConstraints((Component)this.itemText[i3], this.gbc);
                if (i3 < 3) {
                    this.textPanel.add((Component)this.l);
                    this.textPanel.add((Component)this.itemText[i3]);
                } else if (i3 < 7) {
                    this.statsPanel.add((Component)this.l);
                    this.statsPanel.add((Component)this.itemText[i3]);
                } else if (i3 < 9) {
                    this.srvrSchedPanel.add((Component)this.l);
                    this.srvrSchedPanel.add((Component)this.itemText[i3]);
                } else if (i3 < 11) {
                    this.statsSchedPanel.add((Component)this.l);
                    this.statsSchedPanel.add((Component)this.itemText[i3]);
                } else {
                    this.cacheSchedulePanel.add((Component)this.l);
                    this.cacheSchedulePanel.add((Component)this.itemText[i3]);
                }
                this.itemText[i3].setEditable(false);
            }
            ++i3;
        }
        ((Container)((Object)this)).add((Component)this.cbPanel, "North");
        ((Container)((Object)this)).add((Component)this.cardPanel, "Center");
        this.topGroup.setSelectedCheckbox(this.topCb[0]);
        this.cardLayout.show((Container)this.cardPanel, "serverPanel");
        NamesGeneric.debugTracing("Exiting class:NamesMonitor");
    }

    public void LoadFirstTime() {
        NamesGeneric.debugTracing("Entering LoadFirstTime:NamesMonitor");
        if (this.initialized) {
            return;
        }
        if (!nnccj.serverSet) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaNameServerUnreachable"));
        } else {
            this.LoadIntoScreen();
            this.initialized = true;
        }
        NamesGeneric.debugTracing("Exiting LoadFirstTime:NamesMonitor");
    }

    public void LoadIntoScreen() {
        NamesGeneric.debugTracing("Entering LoadIntoScreen:NamesMonitor");
        short messages = this.initialized ? (short)1 : 3;
        int result = this.m_monitor.getMonitorInfo(messages);
        if (result == 0) {
            String result_str = this.m_monitor.returnMonitorInfo();
            int i = 0;
            while (i < this.itemNames.length) {
                int newline = result_str.indexOf("\n");
                if (this.itemNames[i].compareTo(this.ns.getString("nnaVersion")) == 0) {
                    char[] version = new char[20];
                    String banner = result_str.substring(0, newline);
                    int j = 0;
                    int index = 0;
                    while (!Character.isDigit(banner.charAt(index))) {
                        ++index;
                    }
                    char ch = banner.charAt(index);
                    while (Character.isDigit(ch) || ch == '.') {
                        version[j++] = ch;
                        ch = banner.charAt(++index);
                    }
                    this.itemText[i].setText(new String(version));
                } else {
                    this.itemText[i].setText(result_str.substring(0, newline));
                }
                result_str = result_str.substring(newline + 1);
                ++i;
            }
        } else {
            this.clearPanel();
        }
        NamesGeneric.debugTracing("Exiting LoadIntoScreen:NamesMonitor");
    }

    public void clearPanel() {
        NamesGeneric.debugTracing("Entering clearPanel:NamesMonitor");
        int i = 0;
        while (i < this.itemNames.length) {
            this.itemText[i].setText("");
            ++i;
        }
        NamesGeneric.debugTracing("Exiting clearPanel:NamesMonitor");
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        NamesGeneric.debugTracing("Entering itemStateChanged:NamesMonitor");
        if (source instanceof LWCheckbox) {
            String topLabel = this.topGroup.getSelectedCheckbox().getLabel();
            String label = e.getItem().toString();
            if (topLabel.compareTo(this.ns.getString("nnaServer")) == 0) {
                this.scheduleGroup.setSelectedCheckbox(null);
                int i = 0;
                while (i < this.scheduleItems.length) {
                    this.scheduleCb[i].setEnabled(false);
                    ++i;
                }
                this.cardLayout.show((Container)this.cardPanel, "serverPanel");
            } else if (topLabel.compareTo(this.ns.getString("nnaStats")) == 0) {
                this.scheduleGroup.setSelectedCheckbox(null);
                int i = 0;
                while (i < this.scheduleItems.length) {
                    this.scheduleCb[i].setEnabled(false);
                    ++i;
                }
                this.cardLayout.show((Container)this.cardPanel, "statsPanel");
            } else {
                int i = 0;
                while (i < this.scheduleItems.length) {
                    this.scheduleCb[i].setEnabled(true);
                    ++i;
                }
                if (label.compareTo(this.ns.getString("nnaServer")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "srvrSchedPanel");
                } else if (label.compareTo(this.ns.getString("nnaStats")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "statsSchedPanel");
                } else if (label.compareTo(this.ns.getString("nnaCache")) == 0) {
                    this.cardLayout.show((Container)this.cardPanel, "cachePanel");
                }
            }
        }
        NamesGeneric.debugTracing("Exiting itemStateChanged:NamesMonitor");
    }
}

