/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.names.RepConversion;
import oracle.net.asst.names.WorkBench;

public class NamesPasswd
extends BufferedDialog
implements ActionListener {
    public static final short SUCCESS = 0;
    public static final short FAIL = 1;
    private static final char PASSWD_CHAR = '*';
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaOldPasswd"), this.ns.getString("nnaNewPasswd"), this.ns.getString("nnaConfirm")};
    private NamesDialog msgDialog;
    private BufferedFrame frame;
    private EwtContainer textPanel;
    private LWPasswordField[] itemText;
    private LWLabel l;
    private LWButton ok;
    private LWButton cancel;
    private EwtContainer buttonPanel1;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private String passWord;
    private String passwd;
    private WorkBench wb;
    private boolean msgDlgUp = false;
    private int i;

    public NamesPasswd(BufferedFrame parent, ActionListener lsnr, String cryptPass) {
        super((Frame)parent, "Change Password", true);
        this.frame = parent;
        this.wb = new WorkBench();
        this.passwd = new String(RepConversion.nibbles2bArray(cryptPass.getBytes()));
        this.setLayout(new BorderLayout());
        EwtContainer topPanel = new EwtContainer();
        topPanel.setLayout(new BorderLayout());
        topPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        ((Container)((Object)this)).add((Component)topPanel, "Center");
        this.textPanel = new EwtContainer();
        this.textPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)this.textPanel, "North");
        this.gbc = new GridBagConstraints();
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets.bottom = 5;
        this.gbc.fill = 2;
        this.gbc.anchor = 10;
        this.itemText = new LWPasswordField[this.itemNames.length];
        this.i = 0;
        while (this.i < this.itemNames.length) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2 * this.i + 1;
            this.l = new LWLabel(new String(this.itemNames[this.i]), 1);
            this.textPanel.add((Component)this.l, this.gbc);
            ++this.gbc.gridx;
            this.itemText[this.i] = new LWPasswordField(20);
            if (this.i == this.i - 1) {
                this.gbc.insets.bottom = 10;
            }
            this.textPanel.add((Component)this.itemText[this.i], this.gbc);
            ++this.i;
        }
        this.itemText[0].requestFocus();
        this.buttonPanel1 = new EwtContainer();
        this.buttonPanel1.setLayout(new FlowLayout(2));
        topPanel.add((Component)this.buttonPanel1, "South");
        this.ok = new LWButton(this.ns.getString("nnaOk"));
        this.ok.addActionListener(lsnr);
        this.ok.setLeftmost(true);
        this.buttonPanel1.add((Component)this.ok);
        this.cancel = new LWButton(this.ns.getString("nnaCancel"));
        this.cancel.addActionListener(lsnr);
        this.cancel.setRightmost(true);
        this.buttonPanel1.add((Component)this.cancel);
        ((Window)((Object)this)).pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        if (source instanceof LWButton && e.getActionCommand().compareTo(okString) == 0 && this.msgDlgUp) {
            ((Component)((Object)this.msgDialog)).setVisible(false);
            this.msgDialog.dispose();
            this.msgDlgUp = false;
            this.frame.requestFocus();
        }
    }

    public String getNewPasswd() {
        byte[] passBytes = this.wb.normO("arb", this.passWord);
        byte[] nibbles = new byte[passBytes.length * 2 + 1];
        RepConversion.bArray2nibbles(passBytes, nibbles);
        return new String(nibbles);
    }

    public void dlgShow() {
        Dimension frameSize = ((Component)((Object)this)).getParent().getSize();
        Dimension mySize = ((Component)((Object)this)).getSize();
        Point frameLocation = ((Component)((Object)this)).getParent().getLocation();
        int x = frameLocation.x + (frameSize.width - mySize.width) / 2;
        int y = frameLocation.y + (frameSize.height - mySize.height) / 2;
        ((Component)((Object)this)).setBounds(x, y, mySize.width, mySize.height);
        ((Dialog)((Object)this)).show();
        if (NamesGeneric.OS.equals("Windows NT") || NamesGeneric.OS.equals("Windows 95")) {
            this.frame.toFront();
        }
    }

    private boolean confirmPasswd(String pwd) {
        if (this.passwd.length() == 0) {
            return pwd.length() == 0;
        }
        String encrypt = new String(this.wb.normO("arb", pwd));
        return this.passwd.compareTo(encrypt) == 0;
    }

    public int checkNewPasswd() {
        String oldPasswd = this.itemText[0].getText();
        String pass1 = this.itemText[1].getText();
        String pass2 = this.itemText[2].getText();
        if (!this.confirmPasswd(oldPasswd)) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaIncorrectPasswd"));
            this.reStart(0);
            return 1;
        }
        if (!NamesValidate.validateText((LWTextField)this.itemText[1], this.ns.getString("nnaPassword"))) {
            this.reStart(1);
            return 1;
        }
        if (pass1.compareTo(pass2) == 0) {
            this.passWord = pass1;
            return 0;
        }
        NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaReconfirm"));
        this.reStart(2);
        return 1;
    }

    private void reStart(int startPoint) {
        this.i = startPoint;
        while (this.i < this.itemNames.length) {
            this.itemText[this.i].setText("");
            ++this.i;
        }
        this.itemText[startPoint].requestFocus();
        this.itemText[startPoint].selectAll();
    }
}

