/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.Description;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesAdvRegion;
import oracle.net.asst.names.NamesCache;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.NamesValidate;
import oracle.net.asst.servicename.AddressListPanel;
import oracle.net.asst.servicename.DBPanel;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesRegion
extends EwtContainer
implements NamesCache,
ItemListener,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[] cbNames = new String[]{this.ns.getString("nnaNoRegionDb"), this.ns.getString("nnaRegionDb")};
    private String[][] itemNames = new String[][]{{this.ns.getString("nnaDescription"), "junk", "DESCRIPTION"}, {this.ns.getString("nnaUser"), "names", "USERID"}, {this.ns.getString("nnaPassword"), null, "PASSWORD"}, {this.ns.getString("nnaRegionName"), "LOCAL_REGION", "NAME"}, {this.ns.getString("nnaRefresh"), "86400", "REFRESH"}, {this.ns.getString("nnaRetry"), "60", "RETRY"}, {this.ns.getString("nnaExpire"), "600", "EXPIRE"}};
    private String regionString = "names.admin_region";
    private String versionString = "(VERSION=134230016)";
    private String[] optValues = new String[this.itemNames.length - 3];
    private static final short addrPanelIndex = 0;
    private static final short usrItemIndex = 1;
    private static final short passwdItemIndex = 2;
    private static final short timeItemsBegin = 4;
    private static final short regionNameIndex = 3;
    private LWTextField[] itemText;
    private LWLabel l;
    private LWCheckbox[] cb;
    private LWCheckboxGroup cbg = new LWCheckboxGroup();
    private EwtContainer cbPanel;
    private EwtContainer descPanel;
    private EwtContainer buttonPanel;
    private EwtContainer usrPanel;
    private EwtContainer outPanel;
    private LWButton moreButton;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private AddressListPanel addrPanel;
    private DBPanel condataPanel;
    private Description desc;
    private NamesAdvRegion advDialog;
    private int i;
    private int j;
    private boolean presentf;
    private int invalidIndex;
    private boolean changeHuaKya = false;
    private NLParamParser nlpa;
    private NVFactory nvfactory = new NVFactory();

    public NamesRegion() {
        NamesGeneric.debugTracing("Entering NamesRegion");
        try {
            this.desc = new Description(this.nvfactory.createNVPair("(Description=(Address_List=(Address=(protocol=tcp)))(Connect_data=(SID=oracle)(SRVR=dedicated)))"));
        }
        catch (CreateAddressException e) {
            NamesGeneric.debugTracing(e.toString());
            throw new IllegalArgumentException();
        }
        this.optValues[0] = new String(this.itemNames[3][1]);
        this.optValues[1] = new String(this.itemNames[4][1]);
        this.optValues[2] = new String(this.itemNames[5][1]);
        this.optValues[3] = new String(this.itemNames[6][1]);
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(new FlowLayout(0));
        this.cb = new LWCheckbox[2];
        this.itemText = new LWTextField[3];
        this.cb[0] = new LWCheckbox(new String(this.cbNames[0]), this.cbg, false);
        this.cb[0].addItemListener((ItemListener)this);
        this.cbPanel.add((Component)this.cb[0]);
        this.cb[1] = new LWCheckbox(new String(this.cbNames[1]), this.cbg, false);
        this.cb[1].addItemListener((ItemListener)this);
        this.cbPanel.add((Component)this.cb[1]);
        this.descPanel = new EwtContainer();
        this.descPanel.setLayout(this.gb);
        this.descPanel.setBorder((Border)new MarginBorder(0, 5, 0, 5));
        EwtContainer framePanel = new EwtContainer();
        framePanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaDatabase"), InsetFramePainter.getFramePainter(), 2, (Border)new MarginBorder(5, 10, 5, 10)));
        framePanel.setLayout(new BorderLayout(0, 3));
        this.addrPanel = new AddressListPanel(this.desc.getAddressList(), NetUtils.getApplication());
        this.condataPanel = new DBPanel(this.desc, NetUtils.getApplication());
        framePanel.add((Component)((Object)this.addrPanel), "Center");
        framePanel.add((Component)((Object)this.condataPanel), "South");
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.descPanel.add((Component)framePanel, this.gbc);
        this.usrPanel = new EwtContainer();
        this.usrPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaAdditional"), InsetFramePainter.getFramePainter(), 2, (Border)new MarginBorder(5, 10, 5, 10)));
        this.usrPanel.setLayout(this.gb);
        ++this.gbc.gridy;
        this.gbc.insets.top = 3;
        this.descPanel.add((Component)this.usrPanel, this.gbc);
        this.l = new LWLabel(new String(this.itemNames[1][0]), 1);
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.weighty = 0.0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.fill = 0;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.usrPanel.add((Component)this.l, this.gbc);
        this.itemText[1] = new LWTextField(12);
        ++this.gbc.gridx;
        this.gbc.anchor = 17;
        this.usrPanel.add((Component)this.itemText[1], this.gbc);
        this.l = new LWLabel(new String(this.itemNames[2][0]), 1);
        ++this.gbc.gridx;
        this.gbc.anchor = 13;
        this.usrPanel.add((Component)this.l, this.gbc);
        this.itemText[2] = new LWTextField(12);
        ++this.gbc.gridx;
        this.gbc.anchor = 17;
        this.usrPanel.add((Component)this.itemText[2], this.gbc);
        this.moreButton = new LWButton(this.ns.getString("nnaOptional"));
        this.moreButton.setLeftmost(true);
        this.moreButton.setRightmost(true);
        this.moreButton.addActionListener((ActionListener)this);
        ++this.gbc.gridx;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.gbc.insets.top = 0;
        this.gbc.insets.right = 0;
        this.usrPanel.add((Component)this.moreButton, this.gbc);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        ((Container)((Object)this)).add((Component)this.cbPanel, "North");
        ((Container)((Object)this)).add((Component)this.descPanel, "Center");
        this.presentf = false;
        this.invalidIndex = 0;
        NamesGeneric.debugTracing("Exitting NamesRegion");
    }

    public void setNLP(NLParamParser nlpaParam) {
        NamesGeneric.debugTracing("Entering NamesRegion:setNLP");
        this.nlpa = nlpaParam;
        NamesGeneric.debugTracing("Exitting NamesRegion:setNLP");
    }

    public void get() {
        NamesGeneric.debugTracing("Entering NamesRegion:get");
        NVNavigator nvnav = new NVNavigator();
        NVPair nvRegion = this.nlpa.getNLPListElement(new String(this.regionString));
        if (nvRegion != null) {
            this.presentf = true;
            this.cb[0].setState(false);
            this.cb[1].setState(true);
            this.moreButton.setEnabled(true);
            nvRegion = nvnav.findNVPair(nvRegion, "Region");
            if (nvRegion != null) {
                NamesGeneric.debugTracing("region1" + nvRegion.toString());
                int i = 0;
                while (i < this.itemNames.length) {
                    NVPair nvpair = nvnav.findNVPair(nvRegion, this.itemNames[i][2]);
                    if (nvpair != null) {
                        NamesGeneric.debugTracing("region2" + nvpair.toString());
                        if (i < 4) {
                            if (i == 0) {
                                try {
                                    this.desc = new Description(nvpair);
                                }
                                catch (CreateAddressException e) {
                                    NamesGeneric.debugTracing(e.toString());
                                    throw new IllegalArgumentException();
                                }
                                NamesGeneric.debugTracing("region3" + this.desc.getAddressList().toNVString());
                            } else if (i == 3) {
                                this.optValues[0] = nvpair.getAtom();
                            } else {
                                this.itemText[i].setText(nvpair.getAtom());
                            }
                        } else {
                            int j = i - 4 + 1;
                            this.optValues[j] = nvpair.getAtom();
                        }
                    } else {
                        NamesGeneric.debugTracing("NUll");
                    }
                    ++i;
                }
            }
        } else {
            this.cb[0].setState(true);
            this.cb[1].setState(false);
            this.toggleEditable(false);
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:get");
    }

    public void set() {
        NamesGeneric.debugTracing("Entering NamesRegion:set");
        NVPair newParam = this.nvfactory.createNVPair("(REGION=)");
        if (!this.cb[1].getState()) {
            this.nlpa.removeNLPListElement("names.admin_region");
            return;
        }
        int i = 0;
        while (i < this.itemNames.length) {
            if (i == 0) {
                this.addrPanel.saveAddressInfo();
                this.condataPanel.saveAddressInfo();
                newParam.addListElement(this.nvfactory.createNVPair(this.desc.toNVString()));
            } else {
                String s1;
                if (i < 4) {
                    if (i == 3) {
                        s1 = "";
                        if (this.optValues[0] != null) {
                            s1 = this.optValues[0];
                        }
                    } else {
                        s1 = this.itemText[i].getText();
                    }
                } else {
                    int j = i - 4 + 1;
                    s1 = "";
                    if (this.optValues[j] != null) {
                        s1 = this.optValues[j];
                    }
                }
                String s = new String(this.itemNames[i][2]);
                newParam.addListElement(this.nvfactory.createNVPair("(" + s + "=" + s1 + ")"));
                this.presentf = true;
            }
            ++i;
        }
        if (this.presentf || this.cb[1].getState()) {
            newParam.addListElement(this.nvfactory.createNVPair(this.versionString));
            try {
                this.nlpa.addNLPListElement(String.valueOf(this.regionString) + "=" + newParam.toString());
            }
            catch (NLException nLException) {}
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:set");
    }

    public void setFocus() {
        if (this.invalidIndex != 0 && this.invalidIndex < 4) {
            this.itemText[this.invalidIndex].requestFocus();
            this.itemText[this.invalidIndex].selectAll();
        }
    }

    public boolean isDataValid() {
        NamesGeneric.debugTracing("Entering NamesRegion:isDataValid");
        if (!this.cb[1].getState()) {
            return true;
        }
        int i = 0;
        while (i < this.itemNames.length) {
            if (i == 0) {
                if (!this.addrPanel.isValidPage()) {
                    this.invalidIndex = i;
                    return false;
                }
                if (!this.condataPanel.isValidPage()) {
                    this.invalidIndex = i;
                    return false;
                }
            } else if (i < 4) {
                if (i == 1 && !NamesValidate.validateText(this.itemText[i], this.itemNames[i][0])) {
                    this.invalidIndex = i;
                    this.setFocus();
                    return false;
                }
            } else {
                int j = i - 4;
                if (this.optValues[j] == null) {
                    this.invalidIndex = i;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isChanged() {
        NVNavigator nvnav = new NVNavigator();
        NamesGeneric.debugTracing("Entering NamesRegion:isChanged");
        if (this.changeHuaKya) {
            return true;
        }
        NVPair nvRegion = this.nlpa.getNLPListElement(new String(this.regionString));
        if (nvRegion != null && this.cb[0].getState() || nvRegion == null && this.cb[1].getState()) {
            this.changeHuaKya = true;
            return true;
        }
        if (nvRegion != null && (nvRegion = nvnav.findNVPair(nvRegion, "Region")) != null) {
            int i = 0;
            while (i < 3) {
                if (i == 0) {
                    if (this.changeHuaKya) {
                        return this.changeHuaKya;
                    }
                    this.changeHuaKya = this.condataPanel.isChanged();
                    if (this.changeHuaKya) {
                        return this.changeHuaKya;
                    }
                } else {
                    NVPair nvPair = nvnav.findNVPair(nvRegion, this.itemNames[i][2]);
                    if (nvPair != null) {
                        if (this.itemNames[i][0].compareTo(this.ns.getString("nnaPassword")) == 0 && (nvPair.getAtom() == null || nvPair.getAtom().length() == 0)) {
                            if (this.itemText[i].getText() != null && this.itemText[i].getText().length() != 0) {
                                this.changeHuaKya = true;
                                return this.changeHuaKya;
                            }
                        } else if (!this.itemText[i].getText().equalsIgnoreCase(nvPair.getAtom())) {
                            this.changeHuaKya = true;
                            return this.changeHuaKya;
                        }
                    } else if (!this.itemText[i].getText().equalsIgnoreCase(this.itemNames[i][1])) {
                        this.changeHuaKya = true;
                        return this.changeHuaKya;
                    }
                }
                ++i;
            }
        }
        return this.changeHuaKya;
    }

    public void itemStateChanged(ItemEvent e) {
        NamesGeneric.debugTracing("Entering NamesRegion:itemStateChanged");
        String label = e.getItem().toString();
        if (label.compareTo(this.ns.getString("nnaNoRegionDb")) == 0) {
            this.toggleEditable(false);
        } else if (label.compareTo(this.ns.getString("nnaRegionDb")) == 0) {
            this.toggleEditable(true);
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:itemStateChanged");
    }

    public void actionPerformed(ActionEvent e) {
        NamesGeneric.debugTracing("Entering NamesRegion:actionPerformed");
        Object source = e.getSource();
        String command = e.getActionCommand();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        BufferedFrame frame = NamesGeneric.appFrame;
        String os = System.getProperty("os.name");
        if (source instanceof LWButton) {
            if (command.compareTo(this.ns.getString("nnaOptional")) == 0) {
                this.advDialog = new NamesAdvRegion(frame, this.ns.getString("nnaAdvRegion"), this, this.optValues);
                this.advDialog.dlgShow();
            } else if (command.compareTo(okString) == 0) {
                boolean result = this.advDialog.checkOptValues();
                if (result) {
                    this.advDialog.getOptValues(this.optValues);
                    ((Component)((Object)this.advDialog)).setVisible(false);
                    this.advDialog.dispose();
                    frame.requestFocus();
                    if (!this.changeHuaKya) {
                        this.changeHuaKya = this.advDialog.isDialogChanged(this.nlpa);
                    }
                }
            } else if (command.compareTo(cancelString) == 0) {
                ((Component)((Object)this.advDialog)).setVisible(false);
                this.advDialog.dispose();
                frame.requestFocus();
            }
        }
        NamesGeneric.debugTracing("Exitting NamesRegion:actionPerformed");
    }

    public void setChangeHuaKya(boolean state) {
        this.changeHuaKya = state;
    }

    private void toggleEditable(boolean state) {
        this.addrPanel.setEnabled(state);
        this.condataPanel.setEnabled(state);
        Component[] kids = this.usrPanel.getComponents();
        int i = 0;
        while (i < kids.length) {
            kids[i].setEnabled(state);
            ++i;
        }
    }
}

