/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.asst.addrbook.Description;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.operate;
import oracle.net.asst.servicename.AddressListPanel;
import oracle.net.asst.servicename.DBPanel;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class NamesServices
extends EwtContainer
implements ItemListener,
ActionListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaServiceName")};
    private String[] cbNames = new String[]{this.ns.getString("nnaQuery"), this.ns.getString("nnaAdd"), this.ns.getString("nnaRemove"), this.ns.getString("nnaLoad")};
    private String loadName = this.ns.getString("nnaFile");
    private LWTextField[] cbText;
    private LWTextField itemText;
    private LWTextField loadText;
    private MarginBorder sharedBorderPixel;
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private LWCheckbox[] cb;
    private LWCheckboxGroup cbg = new LWCheckboxGroup();
    private EwtContainer listPanel;
    private EwtContainer cbPanel;
    private EwtContainer descPanel;
    private EwtContainer labelPanel;
    private EwtContainer outPanel;
    private EwtContainer cardPanel;
    private EwtContainer namePanel;
    private EwtContainer loadPanel;
    private EwtContainer execButtonPanel;
    private EwtContainer opsPanel;
    private EwtContainer dataPanel;
    private EwtContainer outerCardPanel;
    private LWList addrList;
    private LWButton execButton;
    private LWButton browse;
    private CardLayout cardLayout;
    private CardLayout outerCardLayout;
    private FlowLayout leftFlowLayout;
    private operate m_oper = new operate();
    private NamesDialog BufferedDialog;
    private BufferedFrame theAppFrame;
    private String fileName = "";
    private NVPair nvAddr;
    private AddressListPanel addrPanel;
    private Description desc;
    private DBPanel condataPanel;
    private NVFactory nvfactory = new NVFactory();

    public NamesServices() {
        NamesGeneric.debugTracing("Entering NamesServices:NamesServices");
        try {
            this.desc = new Description(this.nvfactory.createNVPair("(Description=(Address_List=(Address=(protocol=tcp)))(Connect_data=(SID=oracle)(SRVR=dedicated)))"));
        }
        catch (CreateAddressException e) {
            NamesGeneric.debugTracing(e.toString());
            throw new IllegalArgumentException();
        }
        this.theAppFrame = (BufferedFrame)NetUtils.getApplication().getFrame();
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.fill = 2;
        this.sharedBorderPixel = new MarginBorder(0, 0, 0, 0);
        this.setBorder((Border)this.sharedBorderPixel);
        this.outPanel = new EwtContainer();
        this.outPanel.setLayout(this.gb);
        this.labelPanel = new EwtContainer();
        this.labelPanel.setLayout(new GridLayout(2, 1));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gb.setConstraints((Component)this.labelPanel, this.gbc);
        this.outPanel.add((Component)this.labelPanel);
        this.opsPanel = new EwtContainer();
        this.opsPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.opsPanel, this.gbc);
        this.opsPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaOps"), InsetFramePainter.getFramePainter(), 2));
        this.outPanel.add((Component)this.opsPanel);
        this.outerCardLayout = new CardLayout();
        this.outerCardPanel = new EwtContainer();
        this.outerCardPanel.setLayout(this.outerCardLayout);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.outerCardPanel, this.gbc);
        this.outPanel.add((Component)this.outerCardPanel);
        this.dataPanel = new EwtContainer();
        this.dataPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.dataPanel, this.gbc);
        this.dataPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaData"), InsetFramePainter.getFramePainter(), 2));
        this.outerCardPanel.add("dataPanel", (Component)this.dataPanel);
        this.loadPanel = new EwtContainer();
        this.loadPanel.setLayout(new FlowLayout(0, 20, 5));
        this.gb.setConstraints((Component)this.loadPanel, this.gbc);
        this.loadPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaLoadTns"), InsetFramePainter.getFramePainter(), 2));
        this.outerCardPanel.add("loadPanel", (Component)this.loadPanel);
        this.leftFlowLayout = new FlowLayout(0);
        this.namePanel = new EwtContainer();
        this.namePanel.setLayout(this.leftFlowLayout);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.namePanel, this.gbc);
        this.dataPanel.add((Component)this.namePanel);
        this.l = new LWLabel(new String(this.itemNames[0]), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.namePanel.add((Component)this.l);
        ++this.gbc.gridx;
        this.itemText = new LWTextField(20);
        this.gb.setConstraints((Component)this.itemText, this.gbc);
        this.namePanel.add((Component)this.itemText);
        this.cardLayout = new CardLayout();
        this.cardPanel = new EwtContainer();
        this.cardPanel.setLayout(this.cardLayout);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gb.setConstraints((Component)this.cardPanel, this.gbc);
        this.dataPanel.add((Component)this.cardPanel);
        this.descPanel = new EwtContainer();
        this.descPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.descPanel, this.gbc);
        this.descPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 10, 10, 10));
        ++this.gbc.gridy;
        this.addrPanel = new AddressListPanel(this.desc.getAddressList(), NetUtils.getApplication());
        this.descPanel.add((Component)((Object)this.addrPanel), this.gbc);
        this.condataPanel = new DBPanel(this.desc, NetUtils.getApplication());
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets.top = 10;
        this.gb.setConstraints((Component)((Object)this.condataPanel), this.gbc);
        this.gbc.insets.top = 0;
        this.descPanel.add((Component)((Object)this.condataPanel));
        this.cardPanel.add("descPanel", (Component)this.descPanel);
        this.listPanel = new EwtContainer();
        this.listPanel.setLayout(this.gb);
        this.gbc.gridx = 0;
        this.gbc.fill = 1;
        this.gb.setConstraints((Component)this.listPanel, this.gbc);
        this.listPanel.setBorder((Border)new GroupBoxBorder(this.ns.getString("nnaAddresses"), InsetFramePainter.getFramePainter(), 2));
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.addrList = new LWList();
        this.listPanel.add((Component)this.addrList, this.gbc);
        this.cardPanel.add("listPanel", (Component)this.listPanel);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.l = new LWLabel(new String(this.loadName), 1);
        this.gb.setConstraints((Component)this.l, this.gbc);
        this.loadPanel.add((Component)this.l);
        ++this.gbc.gridx;
        this.loadText = new LWTextField(20);
        this.gb.setConstraints((Component)this.loadText, this.gbc);
        this.loadPanel.add((Component)this.loadText);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.browse = new LWButton(this.ns.getString("nnaBrowse"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gb.setConstraints((Component)this.browse, this.gbc);
        this.browse.addActionListener((ActionListener)this);
        this.loadPanel.add((Component)this.browse);
        this.cb = new LWCheckbox[this.cbNames.length];
        this.cbPanel = new EwtContainer();
        this.cbPanel.setLayout(this.leftFlowLayout);
        this.gbc.gridx = 0;
        this.gb.setConstraints((Component)this.cbPanel, this.gbc);
        this.opsPanel.add((Component)this.cbPanel);
        this.i = 0;
        while (this.i < this.cbNames.length) {
            this.cb[this.i] = new LWCheckbox(new String(this.cbNames[this.i]), this.cbg, false);
            this.cb[this.i].addItemListener((ItemListener)this);
            this.gb.setConstraints((Component)this.cb[this.i], this.gbc);
            this.cbPanel.add((Component)this.cb[this.i]);
            ++this.i;
        }
        this.execButtonPanel = new EwtContainer();
        this.execButtonPanel.setLayout(new FlowLayout(2));
        ++this.gbc.gridx;
        this.gb.setConstraints((Component)this.execButtonPanel, this.gbc);
        this.opsPanel.add((Component)this.execButtonPanel);
        this.execButton = new LWButton(this.ns.getString("nnaExec"));
        this.gb.setConstraints((Component)this.execButton, this.gbc);
        this.execButton.addActionListener((ActionListener)this);
        this.execButtonPanel.add((Component)this.execButton);
        ((Container)((Object)this)).add((Component)this.outPanel, "North");
        this.cb[0].setState(true);
        this.itemText.setEditable(true);
        this.outerCardLayout.show((Container)this.outerCardPanel, "dataPanel");
        this.cardLayout.show((Container)this.cardPanel, "listPanel");
        NamesGeneric.debugTracing("Exiting NamesServices:NamesServices");
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        NamesGeneric.debugTracing("Entering NamesServices:itemStateChanged");
        this.itemText.requestFocus();
        if (source instanceof LWCheckbox) {
            String outString = null;
            String cardString = null;
            String mesg = null;
            String label = e.getItem().toString();
            if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
                this.itemText.setEditable(true);
                outString = "dataPanel";
                cardString = "listPanel";
                mesg = "nnaServStatus1";
            }
            if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
                this.itemText.setEditable(true);
                outString = "dataPanel";
                cardString = "descPanel";
                mesg = "nnaServStatus2";
            }
            if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
                this.itemText.setEditable(true);
                outString = "dataPanel";
                cardString = "listPanel";
                mesg = "nnaServStatus3";
            }
            if (label.compareTo(this.ns.getString("nnaLoad")) == 0) {
                outString = "loadPanel";
                cardString = "loadPanel";
                mesg = "nnaLoadTnsMsg";
            }
            if (cardString.equals("listPanel")) {
                this.listPanel.remove((Component)this.addrList);
                this.listPanel.add((Component)this.addrList);
                this.listPanel.validate();
            }
            this.outerCardLayout.show((Container)this.outerCardPanel, outString);
            this.cardLayout.show((Container)this.cardPanel, cardString);
            NetUtils.getApplication().showStatus(this.ns.getString(mesg));
        }
        NamesGeneric.debugTracing("Exiting NamesServices:itemStateChanged");
    }

    public void PerformOp() {
        String addrVal;
        int argc;
        String[] argv = new String[5];
        int res = 4;
        boolean query = false;
        boolean dataChange = false;
        NamesGeneric.debugTracing("Entering NamesServices:PerformOp");
        String label = this.cbg.getSelectedCheckbox().getLabel();
        if (label.compareTo(this.ns.getString("nnaLoad")) == 0) {
            if (this.fileName == null || this.fileName.length() == 0) {
                argv[0] = this.loadText.getText().trim();
                if (argv[0] == null || argv[0].length() == 0) {
                    NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaNullTns"));
                    return;
                }
            } else {
                argv[0] = this.fileName;
            }
            NamesGeneric.debugTracing(argv[0]);
            int argc2 = 1;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaLoading"));
            res = this.m_oper.loadTnsFile(argv, argc2);
            if (res == 0) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaLoadSucc"));
                this.loadText.setText("");
            } else if (res == 2) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaLoadWarn"));
            } else {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaLoadErr"));
            }
            String answer = this.m_oper.returnResp();
            String message = answer.equals("0") ? this.ns.getString("nnaNoItemsLoaded") : String.valueOf(this.ns.getString("nnaItemsLoaded")) + answer;
            NamesDialog.popUp(this.ns.getString("nnaError"), message);
            return;
        }
        argv[0] = this.itemText.getText().trim();
        if (argv[0] == null || argv[0].length() == 0) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaValidName"));
            return;
        }
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            argv[1] = "a.smd";
            argc = 2;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQuerySent"));
            res = this.m_oper.query(argv, argc, (short)1);
            query = true;
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            if (!this.addrPanel.isValidPage()) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpFail"));
                return;
            }
            this.addrPanel.saveAddressInfo();
            if (!this.condataPanel.isValidPage()) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpFail"));
                return;
            }
            this.condataPanel.saveAddressInfo();
            addrVal = this.desc.toNVString();
            if (addrVal != null) {
                NamesGeneric.debugTracing("Desc is " + addrVal);
            }
            NamesGeneric.debugTracing("Name is " + argv[0]);
            if (addrVal.length() == 0) {
                NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaAddressNull"));
                return;
            }
            argv[1] = addrVal.startsWith("-d") ? addrVal : "-d" + addrVal;
            argc = 2;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatAddSent"));
            res = this.m_oper.register(argv, argc, (short)1);
            if (res == 0) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus6"));
                dataChange = true;
            } else if (res == 2) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus7"));
                dataChange = true;
            } else {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus8"));
            }
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            int select = this.addrList.getSelectedIndex();
            if (select < 0) {
                NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaValidAddrSel"));
                return;
            }
            addrVal = this.addrList.getItem(select).trim();
            argv[1] = addrVal.startsWith("-d") ? addrVal : "-d" + addrVal;
            argc = 2;
            NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemSent"));
            res = this.m_oper.unregister(argv, argc, (short)1);
            if (res == 0) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpSuc"));
                dataChange = true;
            } else if (res == 2) {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatRemWarn"));
                dataChange = true;
            } else {
                NetUtils.getApplication().showStatus(this.ns.getString("nnaServRemFail"));
            }
        }
        if (res > 3) {
            return;
        }
        switch (res) {
            case 0: 
            case 2: {
                int start;
                if (dataChange) {
                    dataChange = false;
                    argv[1] = "a.smd";
                    argc = 2;
                    NetUtils.getApplication().showStatus(String.valueOf(this.ns.getString("nnaStatQueryNm")) + argv[0]);
                    int qres = this.m_oper.query(argv, argc, (short)2);
                    if (qres == 0 || qres == 2) {
                        query = true;
                    } else {
                        NetUtils.getApplication().showStatus(this.ns.getString("nnaStatQueryFail"));
                        break;
                    }
                }
                if (!query) break;
                query = false;
                this.addrList.removeAll();
                String answer = this.m_oper.returnResp();
                int next = 0;
                addrVal = "";
                while ((start = answer.indexOf("...", next)) > 0) {
                    int end = answer.indexOf("\n", start);
                    addrVal = answer.substring(start + 3, end);
                    this.addrList.addItem(addrVal);
                    next = end;
                }
                NetUtils.getApplication().showStatus(this.ns.getString("nnaStatOpCompl"));
                break;
            }
            default: {
                NetUtils.getApplication().showStatus("nnaStatOpCompl");
            }
        }
        NamesGeneric.debugTracing("Exiting NamesServices:PerformOp");
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String okString = this.ns.getString("nnaOk");
        String execString = this.ns.getString("nnaExec");
        String browseString = this.ns.getString("nnaBrowse");
        NamesGeneric.debugTracing("Entering NamesServices:actionPerformed");
        if (source instanceof LWButton) {
            if (e.getActionCommand().compareTo(okString) == 0) {
                ((Component)((Object)this.BufferedDialog)).setVisible(false);
                this.BufferedDialog.dispose();
                this.theAppFrame.requestFocus();
            }
            if (e.getActionCommand().compareTo(execString) == 0) {
                this.PerformOp();
            }
            if (e.getActionCommand().compareTo(browseString) == 0) {
                this.fileName = "";
                FileDialog fileDlg = new FileDialog((Frame)this.theAppFrame, "", 0);
                Dimension frameSize = fileDlg.getParent().getSize();
                Dimension mySize = fileDlg.getSize();
                fileDlg.setDirectory(String.valueOf(NamesGeneric.getOraHome()) + "admin" + NamesGeneric.FileSeparator);
                Point frameLocation = fileDlg.getParent().getLocation();
                int x = frameLocation.x + (frameSize.width - mySize.width) / 2;
                int y = frameLocation.y + (frameSize.height - mySize.height) / 2;
                ((Component)fileDlg).setBounds(x, y, mySize.width, mySize.height);
                fileDlg.setModal(true);
                fileDlg.show();
                if (NamesGeneric.OS.equals("Windows NT") || NamesGeneric.OS.equals("Windows 95")) {
                    this.theAppFrame.toFront();
                }
                String dir = fileDlg.getDirectory();
                String file = fileDlg.getFile();
                this.fileName = dir == null || dir.length() == 0 ? file : String.valueOf(dir) + file;
                if (file != null && file.length() != 0) {
                    this.loadText.setText(this.fileName);
                }
            }
        }
        NamesGeneric.debugTracing("Exiting NamesServices:actionPerformed");
    }

    public void showProperStatus() {
        String label = this.cbg.getSelectedCheckbox().getLabel();
        if (label.compareTo(this.ns.getString("nnaQuery")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus1"));
        } else if (label.compareTo(this.ns.getString("nnaAdd")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus2"));
        } else if (label.compareTo(this.ns.getString("nnaRemove")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaServStatus3"));
        } else if (label.compareTo(this.ns.getString("nnaLoad")) == 0) {
            NetUtils.getApplication().showStatus(this.ns.getString("nnaLoadTnsMsg"));
        }
    }
}

