/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.TimePanel;

public class NamesValidate {
    public static boolean validateNumerical(LWTextField textField, String paramName) {
        int high;
        int intValue;
        int index = 0;
        NetStrings ns = new NetStrings();
        String value = textField.getText().trim();
        String[][] myMib = new String[][]{{ns.getString("nnaMaxOpenConn"), "nnaMaxOpenConnNull", "nnaMaxOpenConnNumber", "nnaMaxOpenConnRange", "3", "64"}, {ns.getString("nnaMsgPoolSize"), "nnaMsgPoolSizeNull", "nnaMsgPoolSizeNumber", "nnaMsgPoolSizeRange", "3", "256"}, {ns.getString("nnaMaxReforw"), "nnaMaxReforwNull", "nnaMaxReforwNumber", "nnaMaxReforwRange", "1", "15"}};
        NamesGeneric.debugTracing("Entering validateNumerical:NamesValidate");
        int i = 0;
        while (i < myMib.length) {
            if (paramName.compareTo(myMib[i][0]) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (i == myMib.length) {
            return true;
        }
        if (value.length() == 0) {
            NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][1]));
            return false;
        }
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][2]));
            return false;
        }
        int low = myMib[index][4].length() == 0 ? Integer.MIN_VALUE : Integer.parseInt(myMib[index][4], 10);
        int n = high = myMib[index][5].length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(myMib[index][5], 10);
        if (intValue < low || intValue > high) {
            NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][3]));
            return false;
        }
        return true;
    }

    public static boolean validateText(LWTextField textField, String paramName) {
        String value = textField.getText().trim();
        char[] charArray = value.toCharArray();
        NetStrings ns = new NetStrings();
        int index = 0;
        String[][] myMib = new String[][]{{ns.getString("nnaName"), "_-.", "nnaNameNull", "nnaInvalidCharInName"}, {ns.getString("nnaPassword"), "_-!@#$%^&*.?/", "nnaPasswordNull", "nnaInvalidCharInPassword"}, {ns.getString("nnaAddress"), "_-.", "nnaAddressNull", "nnaInvalidCharInAddress"}, {ns.getString("nnaDomName"), "_-.@", "nnaDomainsNull", "nnaInvalidCharInDomain"}, {ns.getString("nnaRegionName"), "_-.", "nnaRegionNameNull", "nnaInvalidCharInRegionName"}, {ns.getString("nnaUser"), "_-$", "nnaUserNull", "nnaInvalidCharInUser"}, {ns.getString("nnaSID"), "_-", "nnaSIDNull", "nnaInvalidCharInSID"}, {ns.getString("nnaNameCol"), "_-.", "nnaNameColNull", "nnaInvalidCharInNameCol"}, {ns.getString("nnaLogFile"), "_.:" + NamesGeneric.FileSeparator, "nnaLogFileNull", "nnaInvalidCharInLogFile"}, {ns.getString("nnaTracefile"), "_.:" + NamesGeneric.FileSeparator, "nnaTraceFileNull", "nnaInvalidCharInTraceFile"}, {ns.getString("nnaCkpCch"), "_.:" + NamesGeneric.FileSeparator, "nnaCkpCchNull", "nnaInvalidCharInCkpCch"}, {ns.getString("nnaCkpCfg"), "_.:" + NamesGeneric.FileSeparator, "nnaCkpCfgNull", "nnaInvalidCharInCkpCfg"}, {ns.getString("nnaCkpReg"), "_.:" + NamesGeneric.FileSeparator, "nnaCkpRegNull", "nnaInvalidCharInCkpReg"}, {ns.getString("nnaLogDir"), "_.:" + NamesGeneric.FileSeparator, "nnaLogDirNull", "nnaInvalidCharInLogDir"}, {ns.getString("nnaTraceDir"), "_.:" + NamesGeneric.FileSeparator, "nnaTraceDirNull", "nnaInvalidCharInTraceDir"}};
        NamesGeneric.debugTracing("Entering validateText:NamesValidate");
        int i = 0;
        while (i < myMib.length) {
            if (myMib[i][0].compareTo(paramName) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (i == myMib.length) {
            return true;
        }
        if (value == null || value.length() == 0) {
            NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][2]));
            return false;
        }
        i = 0;
        while (i < charArray.length) {
            char ch = charArray[i];
            if (!Character.isLetterOrDigit(ch) && myMib[index][1].indexOf(ch) < 0) {
                NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][3]));
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateTimeField(TimePanel tp, String paramName) {
        int time = tp.getTimeInSec();
        int index = 0;
        NetStrings ns = new NetStrings();
        String[][] myMib = new String[][]{{ns.getString("nnaAutoRefreshExp"), "60", "1209600", "nnaAutoRefreshExpMin", "nnaAutoRefreshExpMax", "no"}, {ns.getString("nnaAutoRefreshRetry"), "60", "3600", "nnaAutoRefreshRetryMin", "nnaAutoRefreshRetryMax", "no"}, {ns.getString("nnaRefresh"), "10", "", "nnaRefreshMin", "", "no"}, {ns.getString("nnaRetry"), "60", "3600", "nnaRetryMin", "nnaRetryMax", "yes"}, {ns.getString("nnaExpire"), "0", "1209600", "nnaExpireMin", "nnaExpireMax", "yes"}, {ns.getString("nnaMinTTl"), "0", "1209600", "nnaMinTTlMin", "nnaMinTTlMax", "yes"}, {ns.getString("nnaStatsResetInterval"), "10", "", "nnaStatsResetMin", "", "yes"}, {ns.getString("nnaStatsLogInterval"), "10", "", "nnaStatsLogMin", "", "yes"}, {ns.getString("nnaCacheCheckInterval"), "10", "", "nnaCacheCkpMin", "", "yes"}};
        NamesGeneric.debugTracing("Entering validateTimeField:NamesValidate");
        int i = 0;
        while (i < myMib.length) {
            if (myMib[i][0].compareTo(paramName) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (i == myMib.length) {
            return true;
        }
        if (time < 0) {
            String message = "";
            if (myMib[index][3].length() != 0) {
                message = String.valueOf(ns.getString(myMib[index][3])) + " ";
            }
            if (myMib[index][4].length() != 0) {
                message = String.valueOf(message) + ns.getString(myMib[index][4]);
            }
            NamesDialog.popUp(ns.getString("nnaMessage"), message);
            return false;
        }
        if (myMib[index][1].length() != 0) {
            if (time == 0) {
                if (myMib[index][5].compareTo("no") == 0) {
                    NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][3]));
                    return false;
                }
            } else if (time < Integer.parseInt(myMib[index][1])) {
                NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][3]));
                return false;
            }
        }
        if (myMib[index][2].length() != 0 && time > Integer.parseInt(myMib[index][2])) {
            NamesDialog.popUp(ns.getString("nnaError"), ns.getString(myMib[index][4]));
            return false;
        }
        return true;
    }
}

