/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesComponent;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class SdnsDialog
extends BufferedDialog {
    NetStrings ns = new NetStrings();
    private int i;
    private GridBagConstraints gbc;
    private GridBagLayout gb;
    private LWLabel l;
    private EwtContainer topPanel;
    private EwtContainer AddrPanel;
    private NetAddr address;
    private NVPair nvAddr;
    private NVFactory nvfactory = new NVFactory();
    private LWButton ok;
    private LWButton cancel;
    private String okString;
    private String cancelString;
    private EwtContainer buttonPanel1;

    public SdnsDialog(BufferedFrame parent, String title, NamesComponent lsnr) {
        super((Frame)parent, title, true);
        NamesGeneric.debugTracing("Entering SdnsDialog:SdnsDialog");
        this.topPanel = new EwtContainer();
        this.topPanel.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        this.topPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.topPanel, "Center");
        TextWrapper Textwrap = WordWrapper.getTextWrapper();
        MultiLineLabel welcome_label = new MultiLineLabel(Textwrap, this.ns.getString("nnaEnterNSText"));
        welcome_label.setAlignment(1);
        this.topPanel.add((Component)welcome_label, "North");
        this.AddrPanel = new EwtContainer();
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.fill = 2;
        this.AddrPanel.setLayout(this.gb);
        this.topPanel.add((Component)this.AddrPanel, "Center");
        this.nvAddr = this.nvfactory.createNVPair("(Address=(protocol=tcp))");
        this.address = new NetAddr(this.nvAddr);
        this.address.setAppEnv(NetUtils.getApplication());
        this.gb.setConstraints((Component)((Object)this.address), this.gbc);
        this.AddrPanel.add((Component)((Object)this.address));
        this.buttonPanel1 = new EwtContainer();
        this.buttonPanel1.setLayout(new FlowLayout(0));
        this.okString = this.ns.getString("nnaOk");
        this.cancelString = this.ns.getString("nnaCancel");
        this.ok = new LWButton(this.okString);
        this.cancel = new LWButton(this.cancelString);
        this.ok.setActionCommand(this.okString);
        this.ok.addActionListener((ActionListener)lsnr);
        this.cancel.setActionCommand(this.cancelString);
        this.cancel.addActionListener((ActionListener)lsnr);
        this.buttonPanel1.add((Component)this.ok);
        this.buttonPanel1.add((Component)this.cancel);
        this.topPanel.add((Component)this.buttonPanel1, "South");
        ((Window)((Object)this)).pack();
        NamesGeneric.debugTracing("Exiting SdnsDialog:SdnsDialog");
    }

    public String getAddress() {
        NamesGeneric.debugTracing("Entering/Exiting SdnsDialog:getAddress");
        return this.nvAddr.toString();
    }

    public boolean isAddressValid() {
        if (!this.address.areDataValid()) {
            NamesGeneric.debugTracing("Invalid address from Sdns dialog box.");
            return false;
        }
        this.nvAddr = this.address.getAddr();
        if (this.nvAddr == null) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaAddressNull"));
            return false;
        }
        return true;
    }

    public void dlgShow() {
        Dimension frameSize = ((Component)((Object)this)).getParent().getSize();
        Dimension mySize = ((Component)((Object)this)).getSize();
        BufferedFrame frame = NamesGeneric.appFrame;
        Point frameLocation = ((Component)((Object)this)).getParent().getLocation();
        int x = frameLocation.x + (frameSize.width - mySize.width) / 2;
        int y = frameLocation.y + (frameSize.height - mySize.height) / 2;
        ((Component)((Object)this)).setBounds(x, y, mySize.width, mySize.height);
        ((Dialog)((Object)this)).show();
        if (NamesGeneric.OS.equals("Windows NT") || NamesGeneric.OS.equals("Windows 95")) {
            frame.toFront();
        }
    }
}

