/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.names;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;

public class TimePanel
extends EwtContainer
implements FocusListener {
    NetStrings ns = new NetStrings();
    private String[] itemNames = new String[]{this.ns.getString("nnaDays"), this.ns.getString("nnaHours"), this.ns.getString("nnaMinutes"), this.ns.getString("nnaSeconds")};
    private LWTextField[] itemText;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private int startIndex;
    private int totalItems;

    public TimePanel(boolean putLabels, boolean putDays, boolean putSecs) {
        NamesGeneric.debugTracing("Entering class:TimePanel");
        this.gb = new GridBagLayout();
        ((Container)((Object)this)).setLayout(this.gb);
        this.gbc = new GridBagConstraints();
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 10;
        this.gbc.fill = 0;
        this.startIndex = putDays ? 0 : 1;
        this.totalItems = putSecs ? this.itemNames.length - this.startIndex : this.itemNames.length - this.startIndex - 1;
        this.itemText = new LWTextField[this.totalItems];
        int i = 0;
        while (i < this.totalItems) {
            int indexOfItem = i + this.startIndex;
            this.itemText[i] = this.itemNames[indexOfItem].compareTo(this.ns.getString("nnaDays")) == 0 ? new LWTextField(3) : new LWTextField(2);
            this.itemText[i].addFocusListener(this);
            this.gbc.weightx = 1.0;
            ++this.gbc.gridx;
            if (!putLabels) {
                if (i == 0) {
                    this.gbc.insets.right = 4;
                    this.gbc.insets.left = 0;
                } else if (i == this.totalItems - 1) {
                    this.gbc.insets.right = 0;
                    this.gbc.insets.left = 4;
                } else {
                    this.gbc.insets.right = 4;
                    this.gbc.insets.left = 4;
                }
            }
            this.gbc.insets.right = 1;
            this.gbc.insets.left = 2;
            this.gb.setConstraints((Component)this.itemText[i], this.gbc);
            ((Container)((Object)this)).add((Component)this.itemText[i]);
            if (putLabels) {
                LWLabel label = new LWLabel(this.itemNames[indexOfItem], 1);
                this.gbc.weightx = 0.25;
                ++this.gbc.gridx;
                this.gbc.insets.right = 0;
                this.gbc.insets.left = 0;
                this.gb.setConstraints((Component)label, this.gbc);
                ((Container)((Object)this)).add((Component)label);
            }
            ++i;
        }
        NamesGeneric.debugTracing("Exiting class:TimePanel");
    }

    public void focusLost(FocusEvent e) {
        NamesGeneric.debugTracing("Entering focuLost:TimePanel");
        if (e.isTemporary()) {
            return;
        }
        int i = 0;
        while (i < this.totalItems) {
            if (e.getComponent() == this.itemText[i]) {
                int result = 0;
                String str = this.itemText[i].getText();
                if (str.compareTo("") != 0) {
                    try {
                        result = Integer.parseInt(str);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.itemText[i].requestFocus();
                        this.itemText[i].selectAll();
                        return;
                    }
                }
                this.itemText[i].setText("0");
                break;
            }
            ++i;
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void setTime(int time) {
        int[] timeArray = new int[4];
        NamesGeneric.debugTracing("Entering setTime:TimePanel");
        int temp = time;
        timeArray[3] = temp % 60;
        timeArray[2] = (temp /= 60) % 60;
        timeArray[1] = (temp /= 60) % 24;
        timeArray[0] = temp / 24;
        int i = 0;
        while (i < this.totalItems) {
            this.itemText[i].setText(String.valueOf(timeArray[i + this.startIndex]));
            ++i;
        }
        NamesGeneric.debugTracing("Exiting setTime:TimePanel");
    }

    public void setTime(String time) {
        int[] timeArray = new int[4];
        NamesGeneric.debugTracing("Entering setTime:TimePanel");
        try {
            int index = time.indexOf("day");
            if (index != -1) {
                timeArray[0] = Integer.parseInt(time.substring(0, index - 1));
                time = timeArray[0] > 1 ? time.substring(index + 5) : time.substring(index + 4);
            } else {
                timeArray[0] = 0;
            }
            index = time.indexOf("hour");
            if (index != -1) {
                timeArray[1] = Integer.parseInt(time.substring(0, index - 1));
                time = timeArray[1] > 1 ? time.substring(index + 6) : time.substring(index + 5);
            } else {
                timeArray[1] = 0;
            }
            index = time.indexOf("minute");
            if (index != -1) {
                timeArray[2] = Integer.parseInt(time.substring(0, index - 1));
                time = timeArray[2] > 1 ? time.substring(index + 8) : time.substring(index + 7);
            } else {
                timeArray[2] = 0;
            }
            index = time.indexOf("second");
            timeArray[3] = index != -1 ? Integer.parseInt(time.substring(0, index - 1)) : 0;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        int i = 0;
        while (i < this.totalItems) {
            this.itemText[i].setText(String.valueOf(timeArray[i + this.startIndex]));
            ++i;
        }
        NamesGeneric.debugTracing("Exiting setTime:TimePanel");
    }

    public int getTimeInSec() {
        int result = 0;
        int i = 0;
        String message = this.ns.getString("nnaTimeInvalid");
        NamesGeneric.debugTracing("Entering getTimeInSec:TimePanel");
        try {
            String time;
            if (this.startIndex == 0) {
                time = this.itemText[i++].getText();
                result += Integer.parseInt(time) * 24;
            }
            while (i < this.totalItems) {
                time = this.itemText[i].getText();
                if (time.compareTo("") != 0) {
                    result += Integer.parseInt(time);
                } else {
                    this.itemText[i].setText("0");
                }
                if (i < this.itemNames.length - 1) {
                    result *= 60;
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            NamesDialog.popUp(this.ns.getString("nnaError"), message);
            this.itemText[i].requestFocus();
            return -1;
        }
        NamesGeneric.debugTracing("Exiting getTimeInSec:TimePanel");
        return result;
    }

    public void setTimeEditable(boolean state) {
        NamesGeneric.debugTracing("Entering setTimeEditable:TimePanel");
        int i = 0;
        while (i < this.totalItems) {
            this.itemText[i].setEditable(state);
            ++i;
        }
        NamesGeneric.debugTracing("Exiting setTimeEditable:TimePanel");
    }

    public void clearTimeFields() {
        NamesGeneric.debugTracing("Entering clearTimeFields:TimePanel");
        int i = 0;
        while (i < this.totalItems) {
            this.itemText[i].setText("");
            ++i;
        }
        NamesGeneric.debugTracing("Exiting clearTimeFields:TimePanel");
    }
}

