/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.nameswizard.BasicWizardPanel;
import oracle.net.asst.nameswizard.DomainsDialog;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.nameswizard.NamesWizardMain;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class DomainList
extends BasicWizardPanel
implements NamesWizardInterface,
ActionListener {
    private EwtContainer domainPanel;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private MultiLineLabel multiLabel;
    private TextWrapper Textwrap = WordWrapper.getTextWrapper();
    private NetStrings ns = new NetStrings();
    private LWButton listButton;
    private Vector domainVector;
    private DomainsDialog domains;

    public DomainList() {
        NamesGeneric.debugTracing("Entering init:DomainList");
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.domainPanel = new EwtContainer();
        this.domainPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.domainPanel, this.gbc);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaDomListMsg"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weighty = 0.25;
        this.gbc.weightx = 1.0;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.domainPanel.add((Component)this.multiLabel);
        this.gbc.weightx = 0.0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 0;
        this.listButton = new LWButton(this.ns.getString("nnaAddMoreDomains"));
        this.gb.setConstraints((Component)this.listButton, this.gbc);
        this.domainPanel.add((Component)this.listButton);
        this.listButton.addActionListener((ActionListener)this);
        this.domainVector = new Vector();
        this.setImage("images/NamesWiz.gif");
        this.setInteractiveArea((Component)this.domainPanel);
        NamesGeneric.debugTracing("Exiting init:DomainList");
    }

    public String getPageData() {
        NVPair domainData;
        NVFactory nvf = new NVFactory();
        if (this.domainVector == null) {
            return null;
        }
        if (this.domainVector.size() == 1) {
            domainData = nvf.createNVPair(this.domainVector.elementAt(0).toString());
        } else {
            domainData = nvf.createNVPair("(Domain_List=)");
            int i = 0;
            while (i < this.domainVector.size()) {
                domainData.addListElement((NVPair)this.domainVector.elementAt(i));
                ++i;
            }
        }
        return domainData.toString();
    }

    public boolean isPageValid() {
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        String addString = this.ns.getString("nnaAddMoreDomains");
        if (source instanceof LWButton) {
            if (evt.getActionCommand().compareTo(addString) == 0) {
                this.domains = new DomainsDialog(NamesGeneric.appFrame, this, this.domainVector);
                this.domains.dlgShow();
                this.domainVector = this.domains.getDomainList();
            } else if (evt.getActionCommand().compareTo(okString) == 0) {
                if (this.domains != null) {
                    ((Component)((Object)this.domains)).setVisible(false);
                    this.domains.dispose();
                }
                NamesWizardMain.setDomains(this.domainVector);
            } else if (evt.getActionCommand().compareTo(cancelString) == 0 && this.domains != null) {
                ((Component)((Object)this.domains)).setVisible(false);
                this.domains.dispose();
            }
        }
    }

    public void setDomains(Vector vector) {
        this.domainVector = vector;
    }
}

