/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import oracle.ewt.event.Cancelable;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.Wizard;
import oracle.ewt.wizard.WizardDialog;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardValidateListener;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.nnccj;
import oracle.net.asst.nameswizard.DBAddress;
import oracle.net.asst.nameswizard.DBPasswordPanel;
import oracle.net.asst.nameswizard.DiscoverNS;
import oracle.net.asst.nameswizard.DomainHint;
import oracle.net.asst.nameswizard.DomainList;
import oracle.net.asst.nameswizard.DomainName;
import oracle.net.asst.nameswizard.FinalPanel;
import oracle.net.asst.nameswizard.FirstNSDecision;
import oracle.net.asst.nameswizard.FirstPanel;
import oracle.net.asst.nameswizard.MinTTL;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.nameswizard.RegionDBDecision;
import oracle.net.asst.nameswizard.RegionDBInfo;
import oracle.net.asst.nameswizard.RegionInfo;
import oracle.net.asst.nameswizard.RootRegionDecision;
import oracle.net.asst.nameswizard.SIDPanel;
import oracle.net.asst.nameswizard.ServerAddress;
import oracle.net.asst.nameswizard.ServerName;
import oracle.net.asst.nameswizard.UserPanel;
import oracle.net.asst.nameswizard.WKNSAddress;
import oracle.net.asst.nameswizard.WizardInfo;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class NamesWizardMain
implements ActionListener,
WizardListener,
WizardValidateListener {
    private static final int WIZARD_WIDTH = 520;
    private static final int WIZARD_HEIGHT = 364;
    private NetStrings ns = new NetStrings();
    private BufferedFrame namesWizardFrame;
    private static Vector domainVector = new Vector();
    private boolean regionDBUsed = false;
    private boolean serverInRootRegion = false;
    private boolean discoveredNS = false;
    private nnccj m_nnccj = new nnccj(0);
    private Wizard m_namesWizard;
    private WizardDialog m_namesDialog;
    public boolean wizardFinishState = false;
    public String serverName;
    public String serverAddress;
    private FirstPanel m_firstPanel;
    private ServerName m_serverNamePanel;
    private WizardInfo m_wizardInfoPanel;
    private ServerAddress m_serverAddress;
    private RegionInfo m_regionInfoPanel;
    private RegionDBDecision m_regionDBDecision;
    private RegionDBInfo m_regionDBInfo;
    private DBAddress m_dbAddressPanel;
    private SIDPanel m_SIDPanel;
    private UserPanel m_userPanel;
    private DBPasswordPanel m_dbPassword;
    private RootRegionDecision m_rootDecision;
    private FirstNSDecision m_firstNSDecision;
    private DomainName m_domainName;
    private MinTTL m_minttlPanel;
    private FinalPanel m_finalPanel;
    private DomainList m_domainList;
    private DomainHint m_domainHint;
    private WKNSAddress m_wknsAddress;
    private DiscoverNS m_discoverNS;
    private WizardPage m_serverNamePage;
    private WizardPage m_regionDBDecisionPage;
    private WizardPage m_SIDPage;
    private WizardPage m_userPage;
    private WizardPage m_dbPasswordPage;
    private WizardPage m_regionInfoPage;
    private WizardPage m_rootDecisionPage;
    private WizardPage m_firstNSDecisionPage;
    private WizardPage m_firstPage;
    private WizardPage m_finalPanelPage;
    private WizardPage m_domainListPage;
    private WizardPage m_domainNamePage;
    private WizardPage m_minttlPage;
    private WizardPage m_serverAddressPage;
    private WizardPage m_domainHintPage;
    private WizardPage m_dbAddressPage;
    private WizardPage m_wknsAddressPage;
    private WizardPage m_discoverNSPage;
    private WizardPage m_regionDBInfoPage;
    private WizardPage m_wizardInfoPage;
    private String filename;

    public NamesWizardMain(BufferedFrame frame, String directory) {
        NamesGeneric.debugTracing("Entering init:NamesWizardMain");
        this.namesWizardFrame = frame;
        this.filename = String.valueOf(directory) + "names.ora";
        this.m_namesWizard = new Wizard();
        NamesGeneric.setAppFrame(this.namesWizardFrame);
        this.createWizardPanels();
        this.initialPanelSetup();
        this.m_namesWizard.addWizardListener((WizardListener)this);
        this.m_namesWizard.setMustFinish(true);
        this.m_namesWizard.setHelpAvailable(false);
        this.m_namesWizard.setCanApply(false);
        NamesGeneric.debugTracing("Exiting init:NamesWizardMain");
    }

    public void go() {
        this.m_namesDialog = new WizardDialog((BaseWizard)this.m_namesWizard, (Frame)this.namesWizardFrame, true);
        this.m_namesDialog.setTitle(this.ns.getString("nnaNamesWizard"));
        this.m_namesDialog.setResizable(false);
        Dimension scrDim = this.namesWizardFrame.getToolkit().getScreenSize();
        this.m_namesDialog.setBounds((scrDim.width - 520) / 2, (scrDim.height - 364) / 2, 520, 364);
        this.m_namesDialog.setPreferredSize(520, 364);
        try {
            NamesGeneric.debugTracing("Running the wizard");
            this.m_namesDialog.runDialog();
        }
        catch (IllegalStateException e) {
            System.err.println("NamesWizardMain.go(): " + e);
            return;
        }
    }

    public void wizardValidatePage(WizardEvent wzEvent) {
        WizardPage wPage = wzEvent.getPage();
        NamesWizardInterface panel = this.getWizardPage(wPage);
        NamesGeneric.debugTracing("Current page: " + wPage.toString());
        if (!panel.isPageValid()) {
            NamesGeneric.debugTracing("Cancelling page " + wPage.toString());
            ((Cancelable)wzEvent).cancel();
        }
        if (wPage == this.m_regionDBDecisionPage) {
            this.regionDBUsed = this.getBooleanValue(this.m_regionDBDecision.getPageData());
            this.useRegionDBPages(this.regionDBUsed);
        } else if (wPage == this.m_rootDecisionPage) {
            this.serverInRootRegion = this.getBooleanValue(this.m_rootDecision.getPageData());
            this.nsInRootRegion(this.serverInRootRegion);
        } else if (wPage == this.m_firstNSDecisionPage) {
            this.firstNSInRegion(this.getBooleanValue(this.m_firstNSDecision.getPageData()));
        } else if (wPage == this.m_discoverNSPage) {
            if (!this.discoveredNS) {
                this.discoveredNS = this.getBooleanValue(this.m_discoverNS.getPageData());
            }
            this.m_wknsAddressPage.setEnabled(!this.discoveredNS);
            this.m_wknsAddressPage.setVisible(!this.discoveredNS);
        } else if (wPage == this.m_wknsAddressPage) {
            NamesGeneric.debugTracing("Discovery on the address page.");
            this.discoveredNS = this.m_wknsAddress.discoveredNS;
            if (this.discoveredNS) {
                this.m_discoverNSPage.setEnabled(false);
                this.m_discoverNSPage.setVisible(false);
            }
        }
    }

    public void wizardApplyState(WizardEvent wzEvent) {
    }

    public void wizardCanceled(WizardEvent wzEvent) {
        this.m_namesDialog.setVisible(false);
        this.m_namesDialog.dispose();
    }

    public void wizardFinished(WizardEvent wzEvent) {
        NLParamParser nlpa = null;
        NVFactory nvf = new NVFactory();
        NamesGeneric.debugTracing("Will start saving now.");
        try {
            nlpa = new NLParamParser(this.filename);
            this.serverName = this.m_serverNamePanel.getPageData();
            nlpa.addNLPListElement("names.server_name=" + this.serverName);
            this.serverAddress = this.m_serverAddress.getPageData();
            nlpa.addNLPListElement("names.addresses=" + this.serverAddress);
            if (this.regionDBUsed) {
                NamesGeneric.debugTracing("Region DB used.");
                NVPair region = nvf.createNVPair("(REGION=)");
                NVPair description = nvf.createNVPair("(DESCRIPTION=)");
                NVPair connectData = nvf.createNVPair("(CONNECT_DATA=)");
                NVPair address = nvf.createNVPair(this.m_dbAddressPanel.getPageData());
                NVPair sid = nvf.createNVPair("(SID=" + this.m_SIDPanel.getPageData() + ")");
                NVPair server = nvf.createNVPair("(Server=Dedicated)");
                connectData.addListElement(sid);
                connectData.addListElement(server);
                description.addListElement(address);
                description.addListElement(connectData);
                NVPair user = nvf.createNVPair("(USERID=" + this.m_userPanel.getPageData() + ")");
                NVPair password = nvf.createNVPair("(PASSWORD=" + this.m_dbPassword.getPageData() + ")");
                region.addListElement(description);
                region.addListElement(user);
                region.addListElement(password);
                region.addListElement(nvf.createNVPair("(NAME=LOCAL_REGION)"));
                region.addListElement(nvf.createNVPair("(REFRESH=86400)"));
                region.addListElement(nvf.createNVPair("(RETRY=60)"));
                region.addListElement(nvf.createNVPair("(EXPIRE=600)"));
                region.addListElement(nvf.createNVPair("(VERSION=134230016)"));
                nlpa.addNLPListElement("names.admin_region=" + region.toString());
            }
            if (!this.serverInRootRegion) {
                NamesGeneric.debugTracing("Server in root region.");
                nlpa.addNLPListElement("names.domains=" + this.m_domainList.getPageData());
                nlpa.addNLPListElement("names.domain_hints=" + this.m_domainHint.getPageData());
            }
            nlpa.saveNLParams(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            NamesGeneric.debugTracing("IO exception: " + e.toString());
        }
        catch (NLException e) {
            NamesGeneric.debugTracing("NL exception:" + e.toString());
        }
        catch (Exception e) {
            NamesGeneric.debugTracing("general exception:" + e.toString());
        }
        NamesGeneric.debugTracing("Wizard save end");
        this.wizardFinishState = true;
        this.m_namesDialog.setVisible(false);
        this.m_namesDialog.dispose();
    }

    public void wizardSelectionChanged(WizardEvent wzEvent) {
        WizardPage wPage = wzEvent.getPage();
        if (wPage == this.m_domainNamePage) {
            this.m_domainName.setDomainName(this.getFirstDomainName());
        } else if (wPage == this.m_minttlPage) {
            this.m_minttlPanel.setMinTTL(this.getFirstDomainTTL());
        } else if (wPage == this.m_domainListPage) {
            NVFactory nvf = new NVFactory();
            NVPair firstDomain = nvf.createNVPair("(DOMAIN=)");
            NVPair name = nvf.createNVPair("(Name=" + this.m_domainName.getPageData() + ")");
            NVPair ttl = nvf.createNVPair("(MIN_TTL=" + this.m_minttlPanel.getPageData() + ")");
            firstDomain.addListElement(name);
            firstDomain.addListElement(ttl);
            if (domainVector != null && domainVector.size() > 0) {
                domainVector.removeElementAt(0);
            }
            domainVector.insertElementAt(firstDomain, 0);
            this.m_domainList.setDomains(domainVector);
        } else if (wPage == this.m_rootDecisionPage && this.discoveredNS) {
            this.m_discoverNSPage.setEnabled(false);
            this.m_discoverNSPage.setVisible(false);
            this.m_wknsAddressPage.setEnabled(false);
            this.m_wknsAddressPage.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        String command = event.getActionCommand();
    }

    private void createWizardPanels() {
        NamesGeneric.debugTracing("Creating wizard pages");
        this.m_firstPanel = new FirstPanel();
        this.m_firstPage = new WizardPage((Component)((Object)this.m_firstPanel), this.ns.getString("nnaFirstPanel"));
        this.m_namesWizard.addPage(this.m_firstPage);
        this.m_firstPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_wizardInfoPanel = new WizardInfo();
        this.m_wizardInfoPage = new WizardPage((Component)((Object)this.m_wizardInfoPanel), this.ns.getString("nnaWizardInfo"));
        this.m_namesWizard.addPage(this.m_wizardInfoPage);
        this.m_wizardInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_serverNamePanel = new ServerName();
        this.m_serverNamePage = new WizardPage((Component)((Object)this.m_serverNamePanel), this.ns.getString("nnaServerNamePage"));
        this.m_namesWizard.addPage(this.m_serverNamePage);
        this.m_serverNamePage.addWizardValidateListener((WizardValidateListener)this);
        this.m_serverAddress = new ServerAddress();
        this.m_serverAddressPage = new WizardPage((Component)((Object)this.m_serverAddress), this.ns.getString("nnaServerAddr"));
        this.m_namesWizard.addPage(this.m_serverAddressPage);
        this.m_serverAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionInfoPanel = new RegionInfo();
        this.m_regionInfoPage = new WizardPage((Component)((Object)this.m_regionInfoPanel), this.ns.getString("nnaRegionInfo"));
        this.m_namesWizard.addPage(this.m_regionInfoPage);
        this.m_regionInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionDBDecision = new RegionDBDecision();
        this.m_regionDBDecisionPage = new WizardPage((Component)((Object)this.m_regionDBDecision), this.ns.getString("nnaUseRDB"));
        this.m_namesWizard.addPage(this.m_regionDBDecisionPage);
        this.m_regionDBDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_regionDBInfo = new RegionDBInfo();
        this.m_regionDBInfoPage = new WizardPage((Component)((Object)this.m_regionDBInfo), this.ns.getString("nnaRegionDBInfo"));
        this.m_namesWizard.addPage(this.m_regionDBInfoPage);
        this.m_regionDBInfoPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_dbAddressPanel = new DBAddress();
        this.m_dbAddressPage = new WizardPage((Component)((Object)this.m_dbAddressPanel), this.ns.getString("nnaDBAddress"));
        this.m_namesWizard.addPage(this.m_dbAddressPage);
        this.m_dbAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_SIDPanel = new SIDPanel();
        this.m_SIDPage = new WizardPage((Component)((Object)this.m_SIDPanel), this.ns.getString("nnaDBSID"));
        this.m_namesWizard.addPage(this.m_SIDPage);
        this.m_SIDPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_userPanel = new UserPanel();
        this.m_userPage = new WizardPage((Component)((Object)this.m_userPanel), this.ns.getString("nnaDBUser"));
        this.m_namesWizard.addPage(this.m_userPage);
        this.m_userPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_dbPassword = new DBPasswordPanel();
        this.m_dbPasswordPage = new WizardPage((Component)((Object)this.m_dbPassword), this.ns.getString("nnaDBPassword"));
        this.m_namesWizard.addPage(this.m_dbPasswordPage);
        this.m_dbPasswordPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_firstNSDecision = new FirstNSDecision();
        this.m_firstNSDecisionPage = new WizardPage((Component)((Object)this.m_firstNSDecision), this.ns.getString("nnaFirstNS"));
        this.m_namesWizard.addPage(this.m_firstNSDecisionPage);
        this.m_firstNSDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_discoverNS = new DiscoverNS();
        this.m_discoverNSPage = new WizardPage((Component)((Object)this.m_discoverNS), this.ns.getString("nnaDiscoverNS"));
        this.m_namesWizard.addPage(this.m_discoverNSPage);
        this.m_discoverNSPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_wknsAddress = new WKNSAddress();
        this.m_wknsAddressPage = new WizardPage((Component)((Object)this.m_wknsAddress), this.ns.getString("nnaWKNSAddress"));
        this.m_namesWizard.addPage(this.m_wknsAddressPage);
        this.m_wknsAddressPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_rootDecision = new RootRegionDecision();
        this.m_rootDecisionPage = new WizardPage((Component)((Object)this.m_rootDecision), this.ns.getString("nnaRootRegion"));
        this.m_namesWizard.addPage(this.m_rootDecisionPage);
        this.m_rootDecisionPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainName = new DomainName();
        this.m_domainNamePage = new WizardPage((Component)((Object)this.m_domainName), this.ns.getString("nnaDomName"));
        this.m_namesWizard.addPage(this.m_domainNamePage);
        this.m_domainNamePage.addWizardValidateListener((WizardValidateListener)this);
        this.m_minttlPanel = new MinTTL();
        this.m_minttlPage = new WizardPage((Component)((Object)this.m_minttlPanel), this.ns.getString("nnaMinTTl"));
        this.m_namesWizard.addPage(this.m_minttlPage);
        this.m_minttlPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainList = new DomainList();
        this.m_domainListPage = new WizardPage((Component)((Object)this.m_domainList), this.ns.getString("nnaDomainList"));
        this.m_namesWizard.addPage(this.m_domainListPage);
        this.m_domainListPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_domainHint = new DomainHint();
        this.m_domainHintPage = new WizardPage((Component)((Object)this.m_domainHint), this.ns.getString("nnaDomainHint"));
        this.m_namesWizard.addPage(this.m_domainHintPage);
        this.m_domainHintPage.addWizardValidateListener((WizardValidateListener)this);
        this.m_finalPanel = new FinalPanel();
        this.m_finalPanelPage = new WizardPage((Component)((Object)this.m_finalPanel), this.ns.getString("nnaFinalPanel"));
        this.m_namesWizard.addPage(this.m_finalPanelPage);
        this.m_finalPanelPage.addWizardValidateListener((WizardValidateListener)this);
        NamesGeneric.debugTracing("Wizard page creation complete");
    }

    private void initialPanelSetup() {
        NamesGeneric.debugTracing("Initial setup");
        this.m_firstPage.setEnabled(true);
        this.m_firstPage.setVisible(true);
        this.m_wizardInfoPage.setEnabled(true);
        this.m_wizardInfoPage.setVisible(true);
        this.m_serverNamePage.setEnabled(true);
        this.m_serverNamePage.setVisible(true);
        this.m_serverAddressPage.setEnabled(true);
        this.m_serverAddressPage.setVisible(true);
        this.m_regionInfoPage.setEnabled(true);
        this.m_regionInfoPage.setVisible(true);
        this.m_regionDBDecisionPage.setEnabled(true);
        this.m_regionDBDecisionPage.setVisible(true);
        this.m_regionDBInfoPage.setEnabled(false);
        this.m_regionDBInfoPage.setVisible(false);
        this.m_dbAddressPage.setEnabled(false);
        this.m_dbAddressPage.setVisible(false);
        this.m_SIDPage.setEnabled(false);
        this.m_SIDPage.setVisible(false);
        this.m_userPage.setEnabled(false);
        this.m_userPage.setVisible(false);
        this.m_dbPasswordPage.setEnabled(false);
        this.m_dbPasswordPage.setVisible(false);
        this.m_rootDecisionPage.setEnabled(false);
        this.m_rootDecisionPage.setVisible(false);
        this.m_firstNSDecisionPage.setEnabled(false);
        this.m_firstNSDecisionPage.setVisible(false);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
        this.m_finalPanelPage.setEnabled(true);
        this.m_finalPanelPage.setVisible(true);
        NamesGeneric.debugTracing("Initial setup end");
    }

    private NamesWizardInterface getWizardPage(WizardPage page) {
        if (page == this.m_firstPage) {
            return this.m_firstPanel;
        }
        if (page == this.m_wizardInfoPage) {
            return this.m_wizardInfoPanel;
        }
        if (page == this.m_serverNamePage) {
            return this.m_serverNamePanel;
        }
        if (page == this.m_serverAddressPage) {
            return this.m_serverAddress;
        }
        if (page == this.m_regionInfoPage) {
            return this.m_regionInfoPanel;
        }
        if (page == this.m_regionDBDecisionPage) {
            return this.m_regionDBDecision;
        }
        if (page == this.m_SIDPage) {
            return this.m_SIDPanel;
        }
        if (page == this.m_userPage) {
            return this.m_userPanel;
        }
        if (page == this.m_dbPasswordPage) {
            return this.m_dbPassword;
        }
        if (page == this.m_rootDecisionPage) {
            return this.m_rootDecision;
        }
        if (page == this.m_firstNSDecisionPage) {
            return this.m_firstNSDecision;
        }
        if (page == this.m_domainListPage) {
            return this.m_domainList;
        }
        if (page == this.m_domainNamePage) {
            return this.m_domainName;
        }
        if (page == this.m_minttlPage) {
            return this.m_minttlPanel;
        }
        if (page == this.m_domainHintPage) {
            return this.m_domainHint;
        }
        if (page == this.m_regionDBInfoPage) {
            return this.m_regionDBInfo;
        }
        if (page == this.m_dbAddressPage) {
            return this.m_dbAddressPanel;
        }
        if (page == this.m_wknsAddressPage) {
            return this.m_wknsAddress;
        }
        if (page == this.m_discoverNSPage) {
            return this.m_discoverNS;
        }
        if (page == this.m_finalPanelPage) {
            return this.m_finalPanel;
        }
        return null;
    }

    private void useRegionDBPages(boolean use) {
        NamesGeneric.debugTracing("Setting for regionDBPages: " + use);
        this.m_regionDBInfoPage.setEnabled(use);
        this.m_regionDBInfoPage.setVisible(use);
        this.m_dbAddressPage.setEnabled(use);
        this.m_dbAddressPage.setVisible(use);
        this.m_SIDPage.setEnabled(use);
        this.m_SIDPage.setVisible(use);
        this.m_userPage.setEnabled(use);
        this.m_userPage.setVisible(use);
        this.m_dbPasswordPage.setEnabled(use);
        this.m_dbPasswordPage.setVisible(use);
        this.m_rootDecisionPage.setEnabled(use);
        this.m_rootDecisionPage.setVisible(use);
        this.m_firstNSDecisionPage.setEnabled(!use);
        this.m_firstNSDecisionPage.setVisible(!use);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
    }

    private void nsInRootRegion(boolean state) {
        NamesGeneric.debugTracing("Setting for nsInRootRegion: " + state);
        this.m_discoverNSPage.setEnabled(false);
        this.m_discoverNSPage.setVisible(false);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(!state);
        this.m_domainNamePage.setVisible(!state);
        this.m_minttlPage.setEnabled(!state);
        this.m_minttlPage.setVisible(!state);
        this.m_domainListPage.setEnabled(!state);
        this.m_domainListPage.setVisible(!state);
        this.m_domainHintPage.setEnabled(!state);
        this.m_domainHintPage.setVisible(!state);
    }

    private void firstNSInRegion(boolean state) {
        NamesGeneric.debugTracing("Setting for firstNSInRegion: " + state);
        this.m_rootDecisionPage.setEnabled(true);
        this.m_rootDecisionPage.setVisible(true);
        this.m_discoverNSPage.setEnabled(!state);
        this.m_discoverNSPage.setVisible(!state);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
    }

    private void serverIsWK(boolean state) {
        NamesGeneric.debugTracing("Setting for serverIsWK: " + state);
        if (this.discoveredNS) {
            this.m_discoverNSPage.setEnabled(false);
            this.m_discoverNSPage.setVisible(false);
        } else {
            this.m_discoverNSPage.setEnabled(!state);
            this.m_discoverNSPage.setVisible(!state);
        }
        this.m_rootDecisionPage.setEnabled(!state);
        this.m_rootDecisionPage.setVisible(!state);
        this.m_wknsAddressPage.setEnabled(false);
        this.m_wknsAddressPage.setVisible(false);
        this.m_domainNamePage.setEnabled(false);
        this.m_domainNamePage.setVisible(false);
        this.m_minttlPage.setEnabled(false);
        this.m_minttlPage.setVisible(false);
        this.m_domainListPage.setEnabled(false);
        this.m_domainListPage.setVisible(false);
        this.m_domainHintPage.setEnabled(false);
        this.m_domainHintPage.setVisible(false);
    }

    public static void setDomains(Vector vector) {
        domainVector = vector;
    }

    private String getFirstDomainName() {
        if (domainVector == null || domainVector.size() == 0) {
            return null;
        }
        NVNavigator navigator = new NVNavigator();
        NVPair firstDomain = navigator.findNVPairRecurse((NVPair)domainVector.elementAt(0), "Name");
        return firstDomain.getAtom();
    }

    private String getFirstDomainTTL() {
        if (domainVector == null || domainVector.size() == 0) {
            return "86400";
        }
        NVNavigator navigator = new NVNavigator();
        NVPair firstDomain = navigator.findNVPairRecurse((NVPair)domainVector.elementAt(0), "MIN_TTL");
        return firstDomain.getAtom();
    }

    private boolean getBooleanValue(String value) {
        return Boolean.valueOf(value);
    }

    public boolean getWizardFinishState() {
        return this.wizardFinishState;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

