/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.nameswizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.names.NamesDialog;
import oracle.net.asst.names.NamesGeneric;
import oracle.net.asst.names.control;
import oracle.net.asst.nameswizard.BasicWizardPanel;
import oracle.net.asst.nameswizard.NamesWizardInterface;
import oracle.net.asst.profile.NetAddr;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class WKNSAddress
extends BasicWizardPanel
implements NamesWizardInterface,
ActionListener {
    private EwtContainer contentPanel;
    private NetAddr addrPanel;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private MultiLineLabel multiLabel;
    private TextWrapper Textwrap = WordWrapper.getTextWrapper();
    private NetStrings ns = new NetStrings();
    private NVFactory nvf = new NVFactory();
    private NVPair address;
    private NamesDialog dialog;
    private boolean goAhead = true;
    public boolean discoveredNS = false;

    public WKNSAddress() {
        NamesGeneric.debugTracing("Entering init:WKNSAddress");
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets.left = 10;
        this.gbc.fill = 2;
        this.gbc.anchor = 11;
        this.contentPanel = new EwtContainer();
        this.contentPanel.setLayout(this.gb);
        this.gb.setConstraints((Component)this.contentPanel, this.gbc);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaWKNSAddressMsg1"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weighty = 0.5;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        try {
            this.multiLabel = new MultiLineLabel(this.Textwrap, this.ns.getString("nnaWKNSAddressMsg2"));
            this.multiLabel.setAlignment(1);
            this.multiLabel.setWrapWidth(350);
        }
        catch (NullPointerException nullPointerException) {}
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.weighty = 1.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 2;
        this.gb.setConstraints((Component)this.multiLabel, this.gbc);
        this.contentPanel.add((Component)this.multiLabel);
        this.address = this.nvf.createNVPair("(Address=(protocol=tcp))");
        this.addrPanel = new NetAddr(this.address);
        this.addrPanel.setAppEnv(NetUtils.getApplication());
        ++this.gbc.gridy;
        this.gbc.weighty = 0.05;
        this.gbc.gridwidth = 1;
        this.gb.setConstraints((Component)((Object)this.addrPanel), this.gbc);
        this.contentPanel.add((Component)((Object)this.addrPanel));
        this.setImage("images/NamesWiz.gif");
        this.setInteractiveArea((Component)this.contentPanel);
        NamesGeneric.debugTracing("Exiting init:WKNSAddress");
    }

    public String getPageData() {
        return this.address.toString();
    }

    public boolean isPageValid() {
        if (!this.addrPanel.areDataValid()) {
            return false;
        }
        this.address = this.addrPanel.getAddr();
        if (this.address == null) {
            NamesDialog.popUp(this.ns.getString("nnaError"), this.ns.getString("nnaAddressNull"));
            return false;
        }
        if (!this.discoveredNS) {
            Cursor defCursor = Cursor.getDefaultCursor();
            ((Component)((Object)this)).setCursor(new Cursor(3));
            control m_control = new control();
            String[] argv = new String[]{this.address.toString()};
            m_control.reorderNS(argv, 1, (short)3);
            File sdnsFile = new File(String.valueOf(NamesGeneric.getOraNames()) + ".sdns.ora");
            this.discoveredNS = sdnsFile.exists() ? true : (sdnsFile = new File(String.valueOf(NamesGeneric.getOraNames()) + "sdns.ora")).exists();
            if (!this.discoveredNS) {
                this.dialog = new NamesDialog(NamesGeneric.appFrame, this.ns.getString("nnaMessage"), this, this.ns.getString("nnaDiscoveryFailed"), 2);
                this.dialog.dlgShow();
            } else {
                NamesDialog.popUp(this.ns.getString("nnaMessage"), this.ns.getString("nnaDiscoveredNS"));
            }
            ((Component)((Object)this)).setCursor(defCursor);
        }
        if (this.discoveredNS) {
            return true;
        }
        return this.goAhead;
    }

    public void actionPerformed(ActionEvent action) {
        NamesGeneric.debugTracing("Entering actionPerformed for wknsAddress.");
        Object source = action.getSource();
        String command = action.getActionCommand();
        String okString = this.ns.getString("nnaOk");
        String cancelString = this.ns.getString("nnaCancel");
        if (source instanceof LWButton) {
            if (command.compareTo(okString) == 0) {
                ((Component)((Object)this.dialog)).setVisible(false);
                this.dialog.dispose();
                this.goAhead = true;
            }
            if (command.compareTo(cancelString) == 0) {
                ((Component)((Object)this.dialog)).setVisible(false);
                this.dialog.dispose();
                this.goAhead = false;
            }
        }
        NamesGeneric.debugTracing("Exiting actionPerformed for wknsAddress.");
    }
}

