/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NativeName
extends NetLayout
implements ProfileCache,
NetButtonListener,
KeyListener {
    private static final String[] NATIVE_NAMING_GROUP_LABELS = new String[]{"PFCexternalBorderLabel1", "PFCexternalBorderLabel2", "PFCexternalBorderLabel3"};
    private static final String[] NATIVE_NAMING_ADAPTERS_LABELS = new String[]{"PFCdcePrefix", "PFCndsNameContext", "PFCnisMetaMap"};
    private static final String[] NATIVE_NAMING_ADAPTERS = new String[]{"names.dce.prefix", "names.nds.name_context", "names.nis.meta_map"};
    private static final String[] NATIVE_NAMING_DEFAULTS = new String[]{"/.:/subsys/oracle/names", "", ""};
    private static final String[] NET_NAT_NM_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_NATIVE_NAME_HELP_TOPIC = "TOPICprofNamingNative";
    private EwtContainer[] panel;
    private LWTextField[] textField;
    private NLParamParser nlpa;
    private String[] netNatNmButton;
    private int invalidField;

    public NativeName() {
        this.setBorder((Border)new MarginBorder(25, 25, 25, 25));
        this.netNatNmButton = new String[NET_NAT_NM_BUTTONS.length];
        int i = 0;
        while (i < NET_NAT_NM_BUTTONS.length) {
            this.netNatNmButton[i] = this.netStrings.getString(NET_NAT_NM_BUTTONS[i]);
            ++i;
        }
        this.panel = new EwtContainer[NATIVE_NAMING_ADAPTERS.length];
        this.textField = new LWTextField[NATIVE_NAMING_ADAPTERS.length];
        i = 0;
        while (i < NATIVE_NAMING_ADAPTERS.length) {
            GroupBoxBorder groupBorder = new GroupBoxBorder(this.netStrings.getString(NATIVE_NAMING_GROUP_LABELS[i]), InsetFramePainter.getFramePainter(), 2);
            this.panel[i] = new EwtContainer();
            this.panel[i].setLayout(new GridBagLayout());
            this.panel[i].setBorder((Border)groupBorder);
            this.constrain((Container)this.panel[i], (Component)new LWLabel(this.netStrings.getString(NATIVE_NAMING_ADAPTERS_LABELS[i])), 0, 1, 1, 1, 2, 17, 0.0, 0.0, 5, 10, 10, 10);
            this.textField[i] = new LWTextField(NATIVE_NAMING_DEFAULTS[i], 30 - NATIVE_NAMING_ADAPTERS[i].length());
            this.textField[i].addKeyListener(this);
            this.constrain((Container)this.panel[i], (Component)this.textField[i], 1, 1, 1, 1, 2, 13, 1.0, 0.0, 5, 10, 10, 10);
            this.constrain((Container)((Object)this), (Component)this.panel[i], 0, i, 1, 1, 2, 18, 1.0, 0.0, 5, 0, 5, 0);
            ++i;
        }
        this.constrain((Container)((Object)this), (Component)new LWLabel(""), 0, i, 1, 1, 3, 10, 1.0, 1.0, 0, 0, 0, 0);
    }

    public NativeName(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NativeName: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NativeName: cacheIt():");
        int i = 0;
        while (i < NATIVE_NAMING_ADAPTERS.length) {
            String s = this.textField[i].getText();
            if (s.compareTo(NATIVE_NAMING_DEFAULTS[i]) != 0) {
                try {
                    this.nlpa.addNLPListElement(String.valueOf(NATIVE_NAMING_ADAPTERS[i]) + "=" + s);
                }
                catch (NLException nLException) {}
            } else {
                this.nlpa.removeNLPListElement(NATIVE_NAMING_ADAPTERS[i]);
            }
            ++i;
        }
    }

    public void discard() {
        this.devTrc("NativeName: discard():");
        int i = 0;
        while (i < NATIVE_NAMING_ADAPTERS.length) {
            this.textField[i].setText("");
            ++i;
        }
    }

    public void refresh() {
        this.devTrc("NativeName: refresh():");
        int i = 0;
        while (i < NATIVE_NAMING_ADAPTERS.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(NATIVE_NAMING_ADAPTERS[i]);
            if (nvpair != null) {
                this.textField[i].setText(nvpair.getAtom());
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NativeName: refresh():");
        int i = 0;
        while (i < NATIVE_NAMING_ADAPTERS.length) {
            NVPair nvpair = this.nlpa.getNLPListElement(NATIVE_NAMING_ADAPTERS[i]);
            if (nvpair != null) {
                if (!this.textField[i].getText().equalsIgnoreCase(nvpair.getAtom())) {
                    rc = true;
                    break;
                }
            } else if (!this.textField[i].getText().equalsIgnoreCase(NATIVE_NAMING_DEFAULTS[i])) {
                rc = true;
                break;
            }
            ++i;
        }
        return rc;
    }

    public boolean areDataValid() {
        this.devTrc("NativeName: areDataValid():");
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NativeName: createNetButton()");
        NetButton netButton = new NetButton(this.netNatNmButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NativeName: buttonPushed()");
        if (label.equalsIgnoreCase(this.netNatNmButton[0])) {
            this.devTrc("NetLog: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofNamingNative");
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        LWTextField f = (LWTextField)evt.getComponent();
        String s = f.getText();
        char ch = evt.getKeyChar();
        if (ch == '\b') {
            return;
        }
        if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '_' && ch != '.' && ch != '/' && ch != ':' && ch != '\\') {
            evt.setKeyChar('\u0000');
        }
    }
}

