/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.ewt.EwtContainer;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.net.asst.container.NetProperties;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.profile.NetIPCAddr;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.NetNMPAddr;
import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.asst.profile.NetSPXAddr;
import oracle.net.asst.profile.NetTCPAddr;
import oracle.net.asst.profile.NetTCPSAddr;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.sysman.emSDK.client.appContainer.WebApplication;

public class NetAddr
extends NetLayout
implements ItemListener {
    private static final String PROTOCOL_LABEL = "PFCaddrProtocolLabel";
    private static final NetStrings ns = new NetStrings();
    private static NetProperties netprop;
    private LWChoice protoChoice;
    private EwtContainer protoDisplay;
    private CardLayout protoCardLayout;
    private NetProtocolAddr[] protocolPanels;
    private boolean[] enabledProtocols;
    private int currentProto;
    private boolean editable = true;
    private boolean changed;
    private static final String[] SUPPORTED_PROTOCOL;
    private static final String[] PROTOCOL_NAMES;

    public NetAddr() {
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(8, 8, 8, 8));
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        ((Container)((Object)this)).add((Component)new LWLabel(ns.getString(PROTOCOL_LABEL)), gbc);
        this.protoChoice = new LWChoice();
        this.protoChoice.addItemListener((ItemListener)this);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 3;
        gbc.fill = 2;
        gbc.anchor = 17;
        ((Container)((Object)this)).add((Component)this.protoChoice, gbc);
        this.protoDisplay = new EwtContainer();
        this.protoCardLayout = new CardLayout();
        this.protoDisplay.setLayout(this.protoCardLayout);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.gridwidth = 2;
        gbc.insets.left = 0;
        ((Container)((Object)this)).add((Component)this.protoDisplay, gbc);
        if (netprop == null) {
            try {
                netprop = new NetProperties();
            }
            catch (FileNotFoundException e1) {
                System.err.println(e1);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.protocolPanels = new NetProtocolAddr[SUPPORTED_PROTOCOL.length];
        this.enabledProtocols = new boolean[SUPPORTED_PROTOCOL.length];
        int i = 0;
        while (i < this.enabledProtocols.length) {
            this.enabledProtocols[i] = false;
            ++i;
        }
        boolean aProtocolWasEnabled = false;
        int i2 = 0;
        while (i2 < SUPPORTED_PROTOCOL.length) {
            String s = netprop.getProperty(SUPPORTED_PROTOCOL[i2]);
            if (s != null && s.equalsIgnoreCase("yes")) {
                aProtocolWasEnabled = true;
                this.enableProtocol(i2);
            }
            ++i2;
        }
        if (!aProtocolWasEnabled) {
            this.enableProtocol(0);
        }
        int i3 = 0;
        while (i3 < SUPPORTED_PROTOCOL.length) {
            if (this.enabledProtocols[i3]) {
                this.currentProto = i3;
                break;
            }
            ++i3;
        }
        this.displayAddrPanel(SUPPORTED_PROTOCOL[this.currentProto]);
    }

    public NetAddr(NVPair address) {
        this();
        if (address != null) {
            this.display(address);
        }
    }

    public void display(NVPair address) {
        int aIndex;
        if (address == null) {
            return;
        }
        try {
            aIndex = this.chooseAddr(address);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
            return;
        }
        if (!this.enabledProtocols[aIndex]) {
            this.enableProtocol(aIndex);
        }
        this.currentProto = aIndex;
        int i = 0;
        while (i < this.protocolPanels.length) {
            if (this.enabledProtocols[i] && this.protocolPanels[i].getProtocol() == SUPPORTED_PROTOCOL[this.currentProto]) {
                this.protocolPanels[i].setAddr(address);
            }
            ++i;
        }
        this.displayAddrPanel(SUPPORTED_PROTOCOL[this.currentProto]);
    }

    private void displayAddrPanel(String protocol) {
        int i = 0;
        while (i < SUPPORTED_PROTOCOL.length) {
            if (protocol == SUPPORTED_PROTOCOL[i] && this.enabledProtocols[i]) {
                this.protoCardLayout.show((Container)this.protoDisplay, protocol);
                this.protoChoice.select(protocol);
            }
            ++i;
        }
    }

    public NVPair getAddr() {
        return this.protocolPanels[this.currentProto].getAddr();
    }

    public String getProtocol() {
        return this.protocolPanels[this.currentProto].getProtocol().toUpperCase();
    }

    public boolean areDataValid() {
        return this.protocolPanels[this.currentProto].areDataValid();
    }

    public void setFocus() {
        this.protocolPanels[this.currentProto].setFocus();
    }

    public void setAppEnv(WebApplication w) {
        int i = 0;
        while (i < this.protocolPanels.length) {
            if (this.protocolPanels[i] != null) {
                this.protocolPanels[i].setAppEnv(w);
            }
            ++i;
        }
    }

    public synchronized void setEditable(boolean b) {
        this.editable = b;
        this.protoChoice.setEnabled(b);
        int i = 0;
        while (i < this.protocolPanels.length) {
            if (this.enabledProtocols[i]) {
                this.protocolPanels[i].setEditable(b);
            }
            ++i;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void discard() {
        int i = 0;
        while (i < this.protocolPanels.length) {
            if (this.enabledProtocols[i]) {
                this.protocolPanels[i].discard();
            }
            ++i;
        }
    }

    public boolean hasChanged() {
        int i = 0;
        while (i < this.protocolPanels.length) {
            if (this.enabledProtocols[i] && this.protocolPanels[i].hasChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean sameEndpoint(NetAddr other) {
        return this.protocolPanels[this.currentProto].sameEndpoint(other.protocolPanels[other.currentProto]);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof LWChoice) {
            if (this.editable) {
                String protName = e.getItem().toString();
                int i = 0;
                while (i < PROTOCOL_NAMES.length) {
                    if (protName == PROTOCOL_NAMES[i]) break;
                    ++i;
                }
                this.displayAddrPanel(SUPPORTED_PROTOCOL[i]);
                this.currentProto = i;
            } else {
                this.protoChoice.select(this.currentProto);
            }
        }
    }

    private NetProtocolAddr createAddr(String protocol) {
        if (protocol.equalsIgnoreCase("tcp")) {
            return new NetTCPAddr();
        }
        if (protocol.equalsIgnoreCase("tcps")) {
            return new NetTCPSAddr();
        }
        if (protocol.equalsIgnoreCase("spx")) {
            return new NetSPXAddr();
        }
        if (protocol.equalsIgnoreCase("ipc")) {
            return new NetIPCAddr();
        }
        if (protocol.equalsIgnoreCase("nmp")) {
            return new NetNMPAddr();
        }
        throw new IllegalStateException("Unable to create protocol address panel of specified type. TYPE: " + protocol);
    }

    private int chooseAddr(String protocol) throws IllegalArgumentException {
        int i = 0;
        while (i < SUPPORTED_PROTOCOL.length) {
            if (protocol.equalsIgnoreCase(SUPPORTED_PROTOCOL[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Protocol: " + protocol + " is invalid.");
    }

    private int chooseAddr(NVPair address) throws IllegalArgumentException {
        NVNavigator nvnav = new NVNavigator();
        NVPair nvpair = nvnav.findNVPair(address, "protocol");
        String protocol = nvpair.getAtom();
        return this.chooseAddr(protocol);
    }

    private void enableProtocol(int index) {
        this.protoChoice.addItem(PROTOCOL_NAMES[index]);
        this.enabledProtocols[index] = true;
        this.protocolPanels[index] = this.createAddr(SUPPORTED_PROTOCOL[index]);
        this.protoDisplay.add(SUPPORTED_PROTOCOL[index], (Component)((Object)this.protocolPanels[index]));
    }

    static {
        SUPPORTED_PROTOCOL = new String[]{"TCP", "TCPS", "SPX", "IPC", "NMP"};
        PROTOCOL_NAMES = new String[]{ns.getString("PFCprotNameTCP"), ns.getString("PFCprotNameTCPS"), ns.getString("PFCprotNameSPX"), ns.getString("PFCprotNameIPC"), ns.getString("PFCprotNameNMP")};
    }
}

