/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import oracle.net.asst.profile.NetProtocolAddr;
import oracle.net.nl.NVPair;

public class NetIPCAddr
extends NetProtocolAddr {
    public static final String IPC_PROTOCOL = "IPC";
    public static final String IPC_ADDR_FORMAT = "(ADDRESS=(PROTOCOL=IPC))";
    private static final String[] IPC_ADDR_PARAM = new String[]{"KEY"};
    private static final String[] IPC_ADDR_PARAM_LABEL = new String[]{"PFCaddrKeyLabel"};

    public NetIPCAddr() {
        super(IPC_PROTOCOL, IPC_ADDR_FORMAT, IPC_ADDR_PARAM, IPC_ADDR_PARAM_LABEL);
    }

    public NetIPCAddr(NVPair protoAddr) {
        this();
        this.setAddr(protoAddr);
    }

    public String getProtocol() {
        return IPC_PROTOCOL;
    }

    public boolean areDataValid() {
        String val = this.addrParamText[0].getText();
        if (val == null || val.equals("") || val.indexOf(32) != -1) {
            this.invalidField = 0;
            return false;
        }
        return true;
    }

    public boolean sameEndpoint(NetProtocolAddr other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NetIPCAddr)) {
            return false;
        }
        String thisKey = this.addrParamText[0].getText().toUpperCase();
        String thatKey = ((NetIPCAddr)other).addrParamText[0].getText().toUpperCase();
        return thisKey.equalsIgnoreCase(thatKey);
    }
}

