/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.profile;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.GroupBoxBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.graphics.frame.InsetFramePainter;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.net.asst.container.NetHelp;
import oracle.net.asst.container.NetStrings;
import oracle.net.asst.container.NetUtils;
import oracle.net.asst.profile.NetButton;
import oracle.net.asst.profile.NetButtonListener;
import oracle.net.asst.profile.NetLayout;
import oracle.net.asst.profile.ProfileCache;
import oracle.net.nl.NLException;
import oracle.net.nl.NLParamParser;
import oracle.net.nl.NVPair;

public class NetLog
extends NetLayout
implements ProfileCache,
NetButtonListener {
    private static final String[] USER_TYPE = new String[]{"client", "server"};
    private static final String[] USER_LABEL = new String[]{"PFCclientLabel", "PFCserverLabel"};
    private static final String[] LOG_PARAM = new String[]{"log_directory", "log_file"};
    private static final String[] LOG_PARAM_LABEL = new String[]{"PFClogDirectory", "PFClogFile"};
    private static final String[] NET_LOG_BUTTONS = new String[]{"PFChelp"};
    private final NetStrings netStrings = new NetStrings();
    private final String NET_LOG_HELP_TOPIC = "TOPICprofGeneralLogging";
    private MarginBorder sharedBorderPixel;
    private LWTextField[] logParam;
    private EwtContainer[] fieldPanel;
    private NLParamParser nlpa;
    private String[] netLogButton = new String[NET_LOG_BUTTONS.length];

    public NetLog() {
        int i = 0;
        while (i < NET_LOG_BUTTONS.length) {
            this.netLogButton[i] = this.netStrings.getString(NET_LOG_BUTTONS[i]);
            ++i;
        }
        this.sharedBorderPixel = new MarginBorder(5, 5, 5, 5);
        this.setBorder((Border)this.sharedBorderPixel);
        this.fieldPanel = new EwtContainer[USER_TYPE.length];
        this.logParam = new LWTextField[LOG_PARAM.length * USER_TYPE.length];
        int j = 0;
        while (j < USER_TYPE.length) {
            GroupBoxBorder groupBorder = new GroupBoxBorder(this.netStrings.getString(USER_LABEL[j]), InsetFramePainter.getFramePainter(), 2);
            this.fieldPanel[j] = new EwtContainer();
            this.fieldPanel[j].setLayout(new GridBagLayout());
            this.fieldPanel[j].setBorder((Border)groupBorder);
            this.constrain((Container)((Object)this), (Component)this.fieldPanel[j], 0, j, 1, 1, 5, 5, 5, 5);
            int k = j * USER_TYPE.length;
            i = 0;
            while (i < LOG_PARAM.length) {
                if (j <= 0 || i <= 0) {
                    this.constrain((Container)this.fieldPanel[j], (Component)new LWLabel(this.netStrings.getString(LOG_PARAM_LABEL[i]), 1), 0, i + 1, 1, 1, 0, 10, 5, 8);
                    this.logParam[k + i] = new LWTextField(20);
                    this.constrain((Container)this.fieldPanel[j], (Component)this.logParam[k + i], 1, i + 1, 1, 1, 0, 10, 5, 8);
                }
                ++i;
            }
            ++j;
        }
    }

    public NetLog(NLParamParser nlpaParam) {
        this();
        this.setNLP(nlpaParam);
    }

    public void setNLP(NLParamParser nlpaParam) {
        this.devTrc("NetLog: setNLP():");
        this.nlpa = nlpaParam;
    }

    public void cacheIt() {
        this.devTrc("NetLog: cacheIt():");
        int j = 0;
        while (j < USER_TYPE.length) {
            int k = j * USER_TYPE.length;
            int i = 0;
            while (i < LOG_PARAM.length) {
                if (j <= 0 || i <= 0) {
                    String s = new String(String.valueOf(LOG_PARAM[i]) + "_" + USER_TYPE[j]);
                    String s1 = this.logParam[k + i].getText();
                    if (s1.length() > 0) {
                        this.devTrc("NetLog: cacheIt():" + s1 + " " + s);
                        try {
                            this.nlpa.addNLPListElement(String.valueOf(s) + "=" + s1);
                        }
                        catch (NLException nLException) {}
                    } else {
                        this.nlpa.removeNLPListElement(s);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void discard() {
        this.devTrc("NetLog: discard():");
        int j = 0;
        while (j < USER_TYPE.length) {
            int k = j * USER_TYPE.length;
            int i = 0;
            while (i < LOG_PARAM.length) {
                if (j != 0 || i <= 0) {
                    this.logParam[k + i].setText("");
                }
                ++i;
            }
            ++j;
        }
    }

    public void refresh() {
        this.devTrc("NetLog: refresh():");
        int j = 0;
        while (j < USER_TYPE.length) {
            int k = j * USER_TYPE.length;
            int i = 0;
            while (i < LOG_PARAM.length) {
                NVPair nvpair;
                if ((j <= 0 || i <= 0) && (nvpair = this.nlpa.getNLPListElement(new String(String.valueOf(LOG_PARAM[i]) + "_" + USER_TYPE[j]))) != null) {
                    this.logParam[k + i].setText(nvpair.getAtom());
                }
                ++i;
            }
            ++j;
        }
    }

    public boolean hasChanged() {
        boolean rc = false;
        this.devTrc("NetLog: hasChanged():");
        int i = 0;
        int j = 0;
        while (j < USER_TYPE.length) {
            int k = j * USER_TYPE.length;
            i = 0;
            while (i < LOG_PARAM.length) {
                if (j <= 0 || i <= 0) {
                    NVPair nvpair = this.nlpa.getNLPListElement(new String(String.valueOf(LOG_PARAM[i]) + "_" + USER_TYPE[j]));
                    if (nvpair != null) {
                        if (!this.logParam[k + i].getText().equalsIgnoreCase(nvpair.getAtom())) {
                            rc = true;
                            break;
                        }
                    } else if (this.logParam[k + i].getText().length() > 0) {
                        rc = true;
                        break;
                    }
                }
                ++i;
            }
            if (rc) break;
            ++j;
        }
        this.devTrc("NetLog: hasChanged(): " + j + " " + i + " " + rc);
        return rc;
    }

    public boolean areDataValid() {
        return true;
    }

    public void setFocus() {
    }

    public NetButton createNetButton() {
        this.devTrc("NetLog: createNetButton()");
        NetButton netButton = new NetButton(this.netLogButton);
        netButton.addNetButtonListener(this);
        return netButton;
    }

    public void buttonPushed(String label) {
        this.devTrc("NetLog: buttonPushed()");
        if (label.equalsIgnoreCase(this.netLogButton[0])) {
            this.devTrc("NetLog: buttonPushed(): do help.");
            NetHelp netHelp = NetUtils.getHelpContext();
            netHelp.show("TOPICprofGeneralLogging");
        }
    }
}

